/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import kl.ssl.gmvpn.AbstractTlsServer;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsCredentialedDecryptor;
import kl.ssl.gmvpn.TlsCredentialedSigner;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCrypto;

public abstract class DefaultTlsServer
extends AbstractTlsServer {
    public static String SIGN_CERT_PRIVATE_KEY_ALIAS = "sig";
    public static String ENC_CERT_PRIVATE_KEY_ALIAS = "enc";
    public static String SIGN_CERT_ALIAS = "sig";
    public static String ENC_CERT_ALIAS = "enc";
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{57363, 57369, 57370};

    @Override
    public ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.GMVPNv11.downTo(ProtocolVersion.GMVPNv11);
    }

    public DefaultTlsServer(TlsCrypto crypto) {
        super(crypto);
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.context.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 1: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

