/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kl.ssl.gmvpn.AbstractTlsContext;
import kl.ssl.gmvpn.ByteQueue;
import kl.ssl.gmvpn.ByteQueueInputStream;
import kl.ssl.gmvpn.ByteQueueOutputStream;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.MaxFragmentLength;
import kl.ssl.gmvpn.RecordPreview;
import kl.ssl.gmvpn.RecordStream;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.SessionParameters;
import kl.ssl.gmvpn.SupplementalDataEntry;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsExtensionsUtils;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsFatalAlertReceived;
import kl.ssl.gmvpn.TlsInputStream;
import kl.ssl.gmvpn.TlsKeyExchange;
import kl.ssl.gmvpn.TlsNoCloseNotifyException;
import kl.ssl.gmvpn.TlsOutputStream;
import kl.ssl.gmvpn.TlsPeer;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public abstract class TlsProtocol {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf((int)65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf((int)35);
    protected static final Integer EXT_SPAInfo = Integers.valueOf((int)65278);
    protected static final Integer EXT_ClientIp = Integers.valueOf((int)65277);
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO = 2;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 3;
    protected static final short CS_SERVER_CERTIFICATE = 4;
    protected static final short CS_CERTIFICATE_STATUS = 5;
    protected static final short CS_SERVER_KEY_EXCHANGE = 6;
    protected static final short CS_CERTIFICATE_REQUEST = 7;
    protected static final short CS_SERVER_HELLO_DONE = 8;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 9;
    protected static final short CS_CLIENT_CERTIFICATE = 10;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 11;
    protected static final short CS_CERTIFICATE_VERIFY = 12;
    protected static final short CS_CLIENT_FINISHED = 13;
    protected static final short CS_SERVER_SESSION_TICKET = 14;
    protected static final short CS_SERVER_FINISHED = 15;
    protected static final short CS_END = 16;
    protected static final short ADS_MODE_1_Nsub1 = 0;
    protected static final short ADS_MODE_0_N = 1;
    protected static final short ADS_MODE_0_N_FIRSTONLY = 2;
    private ByteQueue applicationDataQueue = new ByteQueue(0);
    private ByteQueue alertQueue = new ByteQueue(2);
    private ByteQueue handshakeQueue = new ByteQueue(0);
    RecordStream recordStream;
    private TlsInputStream tlsInputStream = null;
    private TlsOutputStream tlsOutputStream = null;
    private volatile boolean closed = false;
    private volatile boolean failedWithError = false;
    private volatile boolean appDataReady = false;
    private volatile boolean appDataSplitEnabled = true;
    private volatile boolean resumableHandshake = false;
    private volatile int appDataSplitMode = 0;
    protected TlsSession tlsSession = null;
    protected SessionParameters sessionParameters = null;
    protected int[] offeredCipherSuites = null;
    protected Hashtable clientExtensions = null;
    protected Hashtable serverExtensions = null;
    protected short connection_state = 0;
    protected boolean resumedSession = false;
    protected boolean receivedChangeCipherSpec = false;
    protected boolean allowCertificateStatus = false;
    protected boolean expectSessionTicket = false;
    protected boolean blocking;
    protected ByteQueueInputStream inputBuffers;
    protected ByteQueueOutputStream outputBuffer;

    protected TlsProtocol() {
        this.blocking = false;
        this.inputBuffers = new ByteQueueInputStream();
        this.outputBuffer = new ByteQueueOutputStream();
        this.recordStream = new RecordStream(this, this.inputBuffers, this.outputBuffer);
    }

    protected TlsProtocol(InputStream input, OutputStream output) {
        this.blocking = true;
        this.recordStream = new RecordStream(this, input, output);
    }

    public void resumeHandshake() throws IOException {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use resumeHandshake() in non-blocking mode!");
        }
        if (!this.isHandshaking()) {
            throw new IllegalStateException("No handshake in progress");
        }
        this.blockForHandshake();
    }

    protected void closeConnection() throws IOException {
        this.recordStream.close();
    }

    protected abstract TlsContext getContext();

    abstract AbstractTlsContext getContextAdmin();

    protected abstract TlsPeer getPeer();

    protected int getRenegotiationPolicy() {
        return 0;
    }

    protected void handleAlertMessage(short alertLevel, short alertDescription) throws IOException {
        this.getPeer().notifyAlertReceived(alertLevel, alertDescription);
        if (alertLevel != 1) {
            this.handleFailure();
            throw new TlsFatalAlertReceived(alertDescription);
        }
        this.handleAlertWarningMessage(alertDescription);
    }

    protected void handleAlertWarningMessage(short alertDescription) throws IOException {
        switch (alertDescription) {
            case 0: {
                if (!this.appDataReady) {
                    throw new TlsFatalAlert(40);
                }
                this.handleClose(false);
                break;
            }
            case 41: {
                throw new TlsFatalAlert(10);
            }
            case 100: {
                throw new TlsFatalAlert(40);
            }
        }
    }

    protected void handleChangeCipherSpecMessage() throws IOException {
    }

    protected void handleClose(boolean user_canceled) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (user_canceled && !this.appDataReady) {
                this.raiseAlertWarning((short)90, "User canceled handshake");
            }
            this.raiseAlertWarning((short)0, "Connection closed");
            if (this.connection_state != 16) {
                this.cleanupHandshake();
            }
            this.closeConnection();
        }
    }

    protected void handleException(short alertDescription, String message, Throwable e) throws IOException {
        if ((this.appDataReady || this.isResumableHandshake()) && e instanceof InterruptedIOException) {
            return;
        }
        if (!this.closed) {
            this.raiseAlertFatal(alertDescription, message, e);
            this.handleFailure();
        }
    }

    protected void handleFailure() throws IOException {
        this.closed = true;
        this.failedWithError = true;
        this.invalidateSession();
        if (this.connection_state != 16) {
            this.cleanupHandshake();
        }
        this.closeConnection();
    }

    protected abstract void handleHandshakeMessage(short var1, ByteArrayInputStream var2) throws IOException;

    protected boolean handleRenegotiation() throws IOException {
        switch (this.getRenegotiationPolicy()) {
            case 2: {
                this.beginHandshake(true);
                return true;
            }
            case 1: {
                return false;
            }
        }
        this.refuseRenegotiation();
        return false;
    }

    protected void applyMaxFragmentLengthExtension() throws IOException {
        short maxFragmentLength = this.getContext().getSecurityParametersHandshake().getMaxFragmentLength();
        if (maxFragmentLength >= 0) {
            if (!MaxFragmentLength.isValid(maxFragmentLength)) {
                throw new TlsFatalAlert(80);
            }
            int plainTextLimit = 1 << 8 + maxFragmentLength;
            this.recordStream.setPlaintextLimit(plainTextLimit);
        }
    }

    protected void checkReceivedChangeCipherSpec(boolean expected) throws IOException {
        if (expected != this.receivedChangeCipherSpec) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void blockForHandshake() throws IOException {
        while (this.connection_state != 16) {
            if (this.isClosed()) {
                throw new TlsFatalAlert(80);
            }
            this.safeReadRecord();
        }
    }

    protected void beginHandshake(boolean renegotiation) throws IOException {
        this.connection_state = 0;
        AbstractTlsContext context = this.getContextAdmin();
        TlsPeer peer = this.getPeer();
        context.handshakeBeginning(peer);
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        if (renegotiation != securityParameters.renegotiating) {
            throw new TlsFatalAlert(80);
        }
    }

    protected void cleanupHandshake() {
        SecurityParameters securityParameters = this.getContext().getSecurityParameters();
        if (null != securityParameters) {
            securityParameters.clear();
        }
        this.tlsSession = null;
        this.sessionParameters = null;
        this.offeredCipherSuites = null;
        this.clientExtensions = null;
        this.serverExtensions = null;
        this.resumedSession = false;
        this.receivedChangeCipherSpec = false;
        this.allowCertificateStatus = false;
        this.expectSessionTicket = false;
    }

    protected void completeHandshake() throws IOException {
        try {
            this.connection_state = (short)16;
            this.alertQueue.shrink();
            this.handshakeQueue.shrink();
            this.recordStream.finaliseHandshake();
            boolean bl = this.appDataSplitEnabled = !TlsUtils.isTLSv11(this.getContext());
            if (!this.appDataReady) {
                this.appDataReady = true;
                if (this.blocking) {
                    this.tlsInputStream = new TlsInputStream(this);
                    this.tlsOutputStream = new TlsOutputStream(this);
                }
            }
            if (this.sessionParameters == null) {
                SecurityParameters securityParameters = this.getContext().getSecurityParametersHandshake();
                this.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(this.getContext().getCrypto().adoptSecret(securityParameters.getMasterSecret())).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setServerExtensions(this.serverExtensions).setSessionTicket(securityParameters.ticket, securityParameters.ticket_expire_time).build();
                this.tlsSession = this.tlsSession == null ? TlsUtils.importSession(null, this.sessionParameters) : TlsUtils.importSession(this.tlsSession.getSessionID(), this.sessionParameters);
            }
            this.getContextAdmin().handshakeComplete(this.getPeer(), this.tlsSession);
        }
        finally {
            this.cleanupHandshake();
        }
    }

    protected void processRecord(short protocol, byte[] buf, int off, int len) throws IOException {
        switch (protocol) {
            case 21: {
                this.alertQueue.addData(buf, off, len);
                this.processAlertQueue();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    throw new TlsFatalAlert(10);
                }
                this.applicationDataQueue.addData(buf, off, len);
                this.processApplicationDataQueue();
                break;
            }
            case 20: {
                this.processChangeCipherSpec(buf, off, len);
                break;
            }
            case 22: {
                if (this.handshakeQueue.available() > 0) {
                    this.handshakeQueue.addData(buf, off, len);
                    this.processHandshakeQueue(this.handshakeQueue);
                    break;
                }
                ByteQueue tmpQueue = new ByteQueue(buf, off, len);
                this.processHandshakeQueue(tmpQueue);
                int remaining = tmpQueue.available();
                if (remaining <= 0) break;
                this.handshakeQueue.addData(buf, off + len - remaining, remaining);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    private void processHandshakeQueue(ByteQueue queue) throws IOException {
        while (queue.available() >= 4) {
            byte[] beginning = new byte[4];
            queue.read(beginning, 0, 4, 0);
            short type = TlsUtils.readUint8(beginning, 0);
            int length = TlsUtils.readUint24(beginning, 1);
            int totalLength = 4 + length;
            if (queue.available() < totalLength) break;
            if (0 != type) {
                if (20 == type) {
                    this.checkReceivedChangeCipherSpec(true);
                    TlsContext ctx = this.getContext();
                    SecurityParameters securityParameters = ctx.getSecurityParametersHandshake();
                    if (securityParameters.getMasterSecret() != null) {
                        securityParameters.peerVerifyData = this.createVerifyData(!ctx.isServer());
                    }
                } else {
                    this.checkReceivedChangeCipherSpec(false);
                }
                queue.copyTo(this.recordStream.getHandshakeHashUpdater(), totalLength);
            }
            queue.removeData(4);
            ByteArrayInputStream buf = queue.readFrom(length);
            this.handleHandshakeMessage(type, buf);
        }
    }

    private void processApplicationDataQueue() {
    }

    private void processAlertQueue() throws IOException {
        while (this.alertQueue.available() >= 2) {
            byte[] alert = this.alertQueue.removeData(2, 0);
            short alertLevel = alert[0];
            short alertDescription = alert[1];
            this.handleAlertMessage(alertLevel, alertDescription);
        }
    }

    private void processChangeCipherSpec(byte[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            short message = TlsUtils.readUint8(buf, off + i);
            if (message != 1) {
                throw new TlsFatalAlert(50);
            }
            if (this.receivedChangeCipherSpec || this.alertQueue.available() > 0 || this.handshakeQueue.available() > 0) {
                throw new TlsFatalAlert(10);
            }
            this.recordStream.receivedReadCipherSpec();
            this.receivedChangeCipherSpec = true;
            this.handleChangeCipherSpecMessage();
        }
    }

    public int applicationDataAvailable() {
        return this.applicationDataQueue.available();
    }

    public int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        while (this.applicationDataQueue.available() == 0) {
            if (this.closed) {
                if (this.failedWithError) {
                    throw new IOException("Cannot read application data on failed TLS connection");
                }
                return -1;
            }
            if (!this.appDataReady) {
                throw new IllegalStateException("Cannot read application data until initial handshake completed.");
            }
            this.safeReadRecord();
        }
        len = Math.min(len, this.applicationDataQueue.available());
        this.applicationDataQueue.removeData(buf, offset, len, 0);
        return len;
    }

    protected RecordPreview safePreviewRecordHeader(byte[] recordHeader) throws IOException {
        try {
            return this.recordStream.previewRecordHeader(recordHeader, this.appDataReady);
        }
        catch (TlsFatalAlert e) {
            this.handleException(e.getAlertDescription(), "Failed to read record", e);
            throw e;
        }
        catch (IOException e) {
            this.handleException((short)80, "Failed to read record", e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleException((short)80, "Failed to read record", e);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    protected void safeReadRecord() throws IOException {
        try {
            if (this.recordStream.readRecord()) {
                return;
            }
            if (!this.appDataReady) {
                throw new TlsFatalAlert(40);
            }
        }
        catch (TlsFatalAlertReceived e) {
            throw e;
        }
        catch (TlsFatalAlert e) {
            this.handleException(e.getAlertDescription(), "Failed to read record", e);
            throw e;
        }
        catch (IOException e) {
            this.handleException((short)80, "Failed to read record", e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleException((short)80, "Failed to read record", e);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        this.handleFailure();
        throw new TlsNoCloseNotifyException();
    }

    protected boolean safeReadFullRecord(byte[] input, int inputOff, int inputLen) throws IOException {
        try {
            return this.recordStream.readFullRecord(input, inputOff, inputLen);
        }
        catch (TlsFatalAlert e) {
            this.handleException(e.getAlertDescription(), "Failed to process record", e);
            throw e;
        }
        catch (IOException e) {
            this.handleException((short)80, "Failed to process record", e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleException((short)80, "Failed to process record", e);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    protected void safeWriteRecord(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.recordStream.writeRecord(type, buf, offset, len);
        }
        catch (TlsFatalAlert e) {
            this.handleException(e.getAlertDescription(), "Failed to write record", e);
            throw e;
        }
        catch (IOException e) {
            this.handleException((short)80, "Failed to write record", e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleException((short)80, "Failed to write record", e);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    public void writeApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write application data on closed/failed TLS connection");
        }
        if (!this.appDataReady) {
            throw new IllegalStateException("Cannot write application data until initial handshake completed.");
        }
        while (len > 0) {
            if (this.appDataSplitEnabled) {
                switch (this.getAppDataSplitMode()) {
                    case 2: {
                        this.appDataSplitEnabled = false;
                    }
                    case 1: {
                        this.safeWriteRecord((short)23, TlsUtils.EMPTY_BYTES, 0, 0);
                        break;
                    }
                    default: {
                        this.safeWriteRecord((short)23, buf, offset, 1);
                        ++offset;
                        --len;
                    }
                }
            }
            if (len <= 0) continue;
            int toWrite = Math.min(len, this.recordStream.getPlaintextLimit());
            this.safeWriteRecord((short)23, buf, offset, toWrite);
            offset += toWrite;
            len -= toWrite;
        }
    }

    public int getAppDataSplitMode() {
        return this.appDataSplitMode;
    }

    public void setAppDataSplitMode(int appDataSplitMode) {
        if (appDataSplitMode < 0 || appDataSplitMode > 2) {
            throw new IllegalArgumentException("Illegal appDataSplitMode mode: " + appDataSplitMode);
        }
        this.appDataSplitMode = appDataSplitMode;
    }

    public boolean isResumableHandshake() {
        return this.resumableHandshake;
    }

    public void setResumableHandshake(boolean resumableHandshake) {
        this.resumableHandshake = resumableHandshake;
    }

    protected void writeHandshakeMessage(byte[] buf, int off, int len) throws IOException {
        int toWrite;
        if (len < 4) {
            throw new TlsFatalAlert(80);
        }
        short type = TlsUtils.readUint8(buf, off);
        if (type != 0) {
            this.recordStream.getHandshakeHashUpdater().write(buf, off, len);
        }
        int total = 0;
        do {
            toWrite = Math.min(len - total, this.recordStream.getPlaintextLimit());
            this.safeWriteRecord((short)22, buf, off + total, toWrite);
        } while ((total += toWrite) < len);
    }

    public OutputStream getOutputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use OutputStream in non-blocking mode! Use offerOutput() instead.");
        }
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use InputStream in non-blocking mode! Use offerInput() instead.");
        }
        return this.tlsInputStream;
    }

    public void closeInput() throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use closeInput() in blocking mode!");
        }
        if (this.closed) {
            return;
        }
        if (this.inputBuffers.available() > 0) {
            throw new EOFException();
        }
        if (!this.appDataReady) {
            throw new TlsFatalAlert(40);
        }
        throw new TlsNoCloseNotifyException();
    }

    public RecordPreview previewInputRecord(byte[] recordHeader) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewInputRecord() in blocking mode!");
        }
        if (this.inputBuffers.available() != 0) {
            throw new IllegalStateException("Can only use previewInputRecord() for record-aligned input.");
        }
        if (this.closed) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        return this.safePreviewRecordHeader(recordHeader);
    }

    public RecordPreview previewOutputRecord(int applicationDataSize) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use previewOutputRecord() in blocking mode!");
        }
        if (this.outputBuffer.getBuffer().available() != 0) {
            throw new IllegalStateException("Can only use previewOutputRecord() for record-aligned output.");
        }
        if (this.closed) {
            throw new IOException("Connection is closed, cannot produce any more output");
        }
        if (applicationDataSize < 1) {
            return new RecordPreview(0, 0);
        }
        if (this.appDataSplitEnabled) {
            switch (this.getAppDataSplitMode()) {
                case 1: 
                case 2: {
                    RecordPreview a = this.recordStream.previewOutputRecord(0);
                    RecordPreview b = this.recordStream.previewOutputRecord(applicationDataSize);
                    return RecordPreview.combine(a, b);
                }
            }
            RecordPreview a = this.recordStream.previewOutputRecord(1);
            if (applicationDataSize > 1) {
                RecordPreview b = this.recordStream.previewOutputRecord(applicationDataSize - 1);
                a = RecordPreview.combine(a, b);
            }
            return a;
        }
        return this.recordStream.previewOutputRecord(applicationDataSize);
    }

    public void offerInput(byte[] input) throws IOException {
        this.offerInput(input, 0, input.length);
    }

    public void offerInput(byte[] input, int inputOff, int inputLen) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerInput() in blocking mode! Use getInputStream() instead.");
        }
        if (this.closed) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        if (this.inputBuffers.available() == 0 && this.safeReadFullRecord(input, inputOff, inputLen)) {
            if (this.closed && this.connection_state != 16) {
                throw new TlsFatalAlert(80);
            }
            return;
        }
        this.inputBuffers.addBytes(input, inputOff, inputLen);
        while (this.inputBuffers.available() >= 5) {
            byte[] recordHeader = new byte[5];
            if (5 != this.inputBuffers.peek(recordHeader)) {
                throw new TlsFatalAlert(80);
            }
            RecordPreview preview = this.safePreviewRecordHeader(recordHeader);
            if (this.inputBuffers.available() < preview.getRecordSize()) break;
            this.safeReadRecord();
            if (!this.closed) continue;
            if (this.connection_state == 16) break;
            throw new TlsFatalAlert(80);
        }
    }

    public int getApplicationDataLimit() {
        return this.recordStream.getPlaintextLimit();
    }

    public int getAvailableInputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableInputBytes() in blocking mode! Use getInputStream().available() instead.");
        }
        return this.applicationDataAvailable();
    }

    public int readInput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        if ((length = Math.min(length, this.applicationDataQueue.available())) < 1) {
            return 0;
        }
        this.applicationDataQueue.removeData(buffer, offset, length, 0);
        return length;
    }

    public int getAvailableOutputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableOutputBytes() in blocking mode! Use getOutputStream() instead.");
        }
        return this.outputBuffer.getBuffer().available();
    }

    public int readOutput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int bytesToRead = Math.min(this.getAvailableOutputBytes(), length);
        this.outputBuffer.getBuffer().removeData(buffer, offset, bytesToRead, 0);
        return bytesToRead;
    }

    protected void invalidateSession() {
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
            this.tlsSession = null;
        }
    }

    protected void processFinishedMessage(ByteArrayInputStream buf) throws IOException {
        TlsContext ctx = this.getContext();
        SecurityParameters securityParameters = ctx.getSecurityParametersHandshake();
        byte[] expected_verify_data = securityParameters.getPeerVerifyData();
        if (expected_verify_data == null) {
            throw new TlsFatalAlert(80);
        }
        if (ctx.isServer() ^ this.resumedSession && !this.resumedSession) {
            securityParameters.tlsUnique = expected_verify_data;
        }
        byte[] verify_data = TlsUtils.readFully(expected_verify_data.length, (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        if (!Arrays.constantTimeAreEqual((byte[])expected_verify_data, (byte[])verify_data)) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void raiseAlertFatal(short alertDescription, String message, Throwable cause) throws IOException {
        this.getPeer().notifyAlertRaised((short)2, alertDescription, message, cause);
        byte[] alert = new byte[]{2, (byte)alertDescription};
        try {
            this.recordStream.writeRecord((short)21, alert, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void raiseAlertWarning(short alertDescription, String message) throws IOException {
        this.getPeer().notifyAlertRaised((short)1, alertDescription, message, null);
        byte[] alert = new byte[]{1, (byte)alertDescription};
        this.safeWriteRecord((short)21, alert, 0, 2);
    }

    protected void sendCertificateMessage(Certificate certificate, OutputStream endPointHash) throws IOException {
        TlsContext context = this.getContext();
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        HandshakeMessage message = new HandshakeMessage(11);
        certificate.encode(context, message, endPointHash);
        message.writeToRecordStream();
        securityParameters.localCertificate = certificate;
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] message = new byte[]{1};
        this.safeWriteRecord((short)20, message, 0, message.length);
        this.recordStream.sentWriteCipherSpec();
    }

    protected void sendFinishedMessage() throws IOException {
        TlsContext ctx = this.getContext();
        SecurityParameters securityParameters = ctx.getSecurityParametersHandshake();
        securityParameters.localVerifyData = this.createVerifyData(ctx.isServer());
        byte[] verify_data = securityParameters.localVerifyData;
        if (!ctx.isServer() ^ this.resumedSession && !this.resumedSession) {
            securityParameters.tlsUnique = verify_data;
        }
        HandshakeMessage message = new HandshakeMessage(20, verify_data.length);
        message.write(verify_data);
        message.writeToRecordStream();
    }

    protected void sendSupplementalDataMessage(Vector supplementalData) throws IOException {
        HandshakeMessage message = new HandshakeMessage(23);
        TlsProtocol.writeSupplementalData(message, supplementalData);
        message.writeToRecordStream();
    }

    protected byte[] createVerifyData(boolean isServer) {
        return TlsUtils.calculateTLSVerifyData(this.getContext(), this.recordStream.getHandshakeHash(), isServer);
    }

    public void close() throws IOException {
        this.handleClose(true);
    }

    public void flush() throws IOException {
        this.recordStream.flush();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isHandshaking() {
        return !this.isClosed() && null != this.getContext().getSecurityParametersHandshake();
    }

    protected short processMaxFragmentLengthExtension(Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        short maxFragmentLength = TlsExtensionsUtils.getMaxFragmentLengthExtension(serverExtensions);
        if (maxFragmentLength >= 0 && (!MaxFragmentLength.isValid(maxFragmentLength) || !this.resumedSession && maxFragmentLength != TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions))) {
            throw new TlsFatalAlert(alertDescription);
        }
        return maxFragmentLength;
    }

    protected void refuseRenegotiation() throws IOException {
        this.raiseAlertWarning((short)100, "Renegotiation not supported");
    }

    protected static void assertEmpty(ByteArrayInputStream buf) throws IOException {
        if (buf.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(boolean useGMTUnixTime, TlsContext context) {
        byte[] result = context.getNonceGenerator().generateNonce(32);
        if (useGMTUnixTime) {
            TlsUtils.writeGMTUnixTime(result, 0);
        }
        return result;
    }

    protected static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        return TlsUtils.encodeOpaque8(renegotiated_connection);
    }

    protected static void establishMasterSecret(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        TlsSecret preMasterSecret = keyExchange.generatePreMasterSecret();
        if (preMasterSecret == null) {
            throw new TlsFatalAlert(80);
        }
        try {
            context.getSecurityParametersHandshake().masterSecret = TlsUtils.calculateMasterSecret(context, preMasterSecret);
        }
        finally {
            preMasterSecret.destroy();
        }
    }

    protected static Hashtable readExtensions(ByteArrayInputStream input) throws IOException {
        if (input.available() < 1) {
            return null;
        }
        byte[] extBytes = TlsUtils.readOpaque16(input);
        TlsProtocol.assertEmpty(input);
        return TlsProtocol.readExtensionsData(extBytes);
    }

    protected static Hashtable readExtensionsData(byte[] extBytes) throws IOException {
        Hashtable<Integer, byte[]> extensions = new Hashtable<Integer, byte[]>();
        if (extBytes.length > 0) {
            ByteArrayInputStream buf = new ByteArrayInputStream(extBytes);
            do {
                byte[] extension_data;
                Integer extension_type;
                if (null == extensions.put(extension_type = Integers.valueOf((int)TlsUtils.readUint16(buf)), extension_data = TlsUtils.readOpaque16(buf))) continue;
                throw new TlsFatalAlert(47);
            } while (buf.available() > 0);
        }
        return extensions;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream input) throws IOException {
        byte[] supp_data = TlsUtils.readOpaque24(input, 1);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(supp_data);
        Vector<SupplementalDataEntry> supplementalData = new Vector<SupplementalDataEntry>();
        while (buf.available() > 0) {
            int supp_data_type = TlsUtils.readUint16(buf);
            byte[] data = TlsUtils.readOpaque16(buf);
            supplementalData.addElement(new SupplementalDataEntry(supp_data_type, data));
        }
        return supplementalData;
    }

    protected static TlsCredentials validateCredentials(TlsCredentials credentials) throws IOException {
        return credentials;
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions) throws IOException {
        if (null == extensions || extensions.isEmpty()) {
            return;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsProtocol.writeSelectedExtensions(buf, extensions, true);
        TlsProtocol.writeSelectedExtensions(buf, extensions, false);
        byte[] extBytes = buf.toByteArray();
        TlsUtils.writeOpaque16(extBytes, output);
    }

    protected static void writeSelectedExtensions(OutputStream output, Hashtable extensions, boolean selectEmpty) throws IOException {
        Enumeration keys = extensions.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            int extension_type = key;
            byte[] extension_data = (byte[])extensions.get(key);
            if (selectEmpty != (extension_data.length == 0)) continue;
            TlsUtils.checkUint16(extension_type);
            TlsUtils.writeUint16(extension_type, output);
            TlsUtils.writeOpaque16(extension_data, output);
        }
    }

    protected static void writeSupplementalData(OutputStream output, Vector supplementalData) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        for (int i = 0; i < supplementalData.size(); ++i) {
            SupplementalDataEntry entry = (SupplementalDataEntry)supplementalData.elementAt(i);
            int supp_data_type = entry.getDataType();
            TlsUtils.checkUint16(supp_data_type);
            TlsUtils.writeUint16(supp_data_type, buf);
            TlsUtils.writeOpaque16(entry.getData(), buf);
        }
        byte[] supp_data = buf.toByteArray();
        TlsUtils.writeOpaque24(supp_data, output);
    }

    protected static int getPRFAlgorithm(TlsContext context, int cipherSuite) throws IOException {
        boolean isTLSv13 = TlsUtils.isTLSv13(context);
        boolean isTLSv12 = !isTLSv13 && TlsUtils.isTLSv12(context);
        switch (cipherSuite) {
            case 57363: 
            case 57369: 
            case 57370: {
                return 1;
            }
        }
        return 1;
    }

    class HandshakeMessage
    extends ByteArrayOutputStream {
        HandshakeMessage(short handshakeType) throws IOException {
            this(handshakeType, 60);
        }

        HandshakeMessage(short handshakeType, int length) throws IOException {
            super(length + 4);
            TlsUtils.writeUint8(handshakeType, (OutputStream)this);
            this.count += 3;
        }

        void writeToRecordStream() throws IOException {
            int length = this.count - 4;
            TlsUtils.checkUint24(length);
            TlsUtils.writeUint24(length, this.buf, 1);
            TlsProtocol.this.writeHandshakeMessage(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

