/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsCredentialedSignerAndDecryptor;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsSecret;
import kl.ssl.gmvpn.crypto.TlsSigner;
import kl.ssl.gmvpn.crypto.TlsStreamSigner;
import kl.ssl.gmvpn.crypto.impl.TlsImplUtils;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsRSASigner;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsSM2Signer;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class BcDefaultTlsCredentialedSignerAndDecryptor
implements TlsCredentialedSignerAndDecryptor {
    protected BcTlsCrypto crypto;
    protected TlsCryptoParameters cryptoParams;
    protected Certificate certificate;
    protected AsymmetricKeyParameter[] privateKey;
    protected TlsSigner signer;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    public BcDefaultTlsCredentialedSignerAndDecryptor(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter[] privateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey[0] == null) {
            throw new IllegalArgumentException("'sigprivateKey' cannot be null");
        }
        if (!privateKey[0].isPrivate()) {
            throw new IllegalArgumentException("'sigprivateKey' must be private");
        }
        if (privateKey[1] == null) {
            throw new IllegalArgumentException("'encprivateKey' cannot be null");
        }
        if (!privateKey[1].isPrivate()) {
            throw new IllegalArgumentException("'encprivateKey' must be private");
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signer = BcDefaultTlsCredentialedSignerAndDecryptor.makeSigner(crypto, privateKey[0], certificate, signatureAndHashAlgorithm);
        this.cryptoParams = cryptoParams;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        return this.safeDecryptPreMasterSecret(cryptoParams, (ECPrivateKeyParameters)this.privateKey[1], ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, ECPrivateKeyParameters sm2ServerPrivateKey, byte[] encryptedPreMasterSecret) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion clientVersion = cryptoParams.getClientVersion();
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)sm2ServerPrivateKey);
        byte[] tmp = null;
        try {
            tmp = sm2Engine.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.crypto.createSecret(tmp);
    }

    private static TlsSigner makeSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner signer;
        if (privateKey instanceof RSAKeyParameters) {
            signer = new BcTlsRSASigner(crypto, (RSAKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            signer = new BcTlsSM2Signer(crypto, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    @Override
    public byte[] generateRawSignature(byte[] hash) throws IOException {
        return this.signer.generateRawSignature(this.getEffectiveAlgorithm(), hash);
    }

    @Override
    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    @Override
    public TlsStreamSigner getStreamSigner() throws IOException {
        return this.signer.getStreamSigner(this.getEffectiveAlgorithm());
    }

    protected SignatureAndHashAlgorithm getEffectiveAlgorithm() {
        SignatureAndHashAlgorithm algorithm = null;
        if (TlsImplUtils.isTLSv12(this.cryptoParams) && (algorithm = this.getSignatureAndHashAlgorithm()) == null) {
            throw new IllegalStateException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        return algorithm;
    }
}

