/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import java.util.Base64;

public final class DataKey {
    private static final long ONE_DAY = 86400000L;
    private final long createTime;
    private final byte[] cipherKey;
    private final String ciphertext;
    private final byte[] plainKey;
    private final String cmkId;
    private String dataKeyId;

    public DataKey(byte[] cipherKey, byte[] plainKey, String cmkId) {
        this.cipherKey = cipherKey;
        this.plainKey = plainKey;
        this.ciphertext = null != cipherKey ? Base64.getEncoder().encodeToString(cipherKey) : null;
        this.cmkId = cmkId;
        this.createTime = System.currentTimeMillis();
    }

    public DataKey(byte[] cipherKey, String ciphertext, byte[] plainKey, String cmkId) {
        this.cipherKey = cipherKey;
        this.plainKey = plainKey;
        this.ciphertext = ciphertext;
        this.cmkId = cmkId;
        this.createTime = System.currentTimeMillis();
    }

    public byte[] getCipherKey() {
        return this.cipherKey;
    }

    public String getDataKeyId() {
        return this.dataKeyId;
    }

    public void setDataKeyId(String dataKeyId) {
        this.dataKeyId = dataKeyId;
    }

    public String getCiphertext() {
        return this.ciphertext;
    }

    public byte[] getPlainKey() {
        return this.plainKey;
    }

    public String getCmkId() {
        return this.cmkId;
    }

    boolean isInvalid() {
        long current = System.currentTimeMillis();
        return current - this.createTime > 86400000L;
    }
}

