/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.actor;

import com.koal.kms.sdk.ed.KmsSdkException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractDecryptor {
    public abstract String getTransformation();

    public String getAlgorithm() {
        String transformation = this.getTransformation();
        String[] splitTransformation = transformation.split("/");
        if (splitTransformation.length < 1) {
            throw new IllegalArgumentException("Illegal transformation,could not find algorithm in transformation :" + this.getTransformation());
        }
        return splitTransformation[0];
    }

    public byte[] decrypt(byte[] key, byte[] iv, byte[] cipher) throws InvalidKeyException, InvalidAlgorithmParameterException, KmsSdkException {
        try {
            Cipher _cipher = Cipher.getInstance(this.getTransformation());
            _cipher.init(2, (Key)new SecretKeySpec(key, this.getAlgorithm()), new IvParameterSpec(iv));
            return _cipher.doFinal(cipher);
        }
        catch (NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new KmsSdkException("Catch an error when decrypt:", e);
        }
    }
}

