/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift;

import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.thrift.constants.LoadBalance;
import com.koal.kms.sdk.ed.thrift.constants.ServiceLevel;
import com.koal.kms.sdk.ed.thrift.exception.ValidationException;
import com.koal.kms.sdk.ed.thrift.failover.ConnectionValidator;
import com.koal.kms.sdk.ed.thrift.failover.FailoverStrategy;
import com.koal.kms.sdk.ed.thrift.loadbalance.ClientSelector;
import com.koal.kms.sdk.ed.thrift.pool.ThriftServer;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreator;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreatorSslGm;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreatorSslRsa;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreatorTcp;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftClient {
    private static final int DEFAULT_CONN_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private String servers;
    private LoadBalance loadBalance;
    private ConnectionValidator validator;
    private GenericKeyedObjectPoolConfig<TTransport> poolConfig;
    private FailoverStrategy<ThriftServer> failoverStrategy;
    private TransportCreator transportCreator;
    private int connTimeout;
    private String backupServers;
    private ServiceLevel serviceLevel;
    private ClientSelector clientSelector;

    public ThriftClient servers(String servers) {
        this.servers = servers;
        return this;
    }

    public ThriftClient loadBalance(int loadBalance) {
        this.loadBalance = LoadBalance.getByValue(loadBalance);
        return this;
    }

    public ThriftClient connectionValidator(ConnectionValidator validator) {
        this.validator = validator;
        return this;
    }

    public ThriftClient poolConfig(GenericKeyedObjectPoolConfig<TTransport> poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public ThriftClient failoverStrategy(FailoverStrategy<ThriftServer> failoverStrategy) {
        this.failoverStrategy = failoverStrategy;
        return this;
    }

    public ThriftClient transportCreator(KmsClientConfig kmsClientConfig) {
        this.transportCreator = kmsClientConfig.useTLS() ? (kmsClientConfig.useRsa() ? new TransportCreatorSslRsa(kmsClientConfig) : new TransportCreatorSslGm(kmsClientConfig)) : new TransportCreatorTcp();
        return this;
    }

    public ThriftClient connTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    public ThriftClient backupServers(String backupServers) {
        this.backupServers = backupServers;
        return this;
    }

    public ThriftClient serviceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    public ThriftClient start() {
        this.checkAndInit();
        this.clientSelector = new ClientSelector(this.servers, this.loadBalance, this.validator, this.poolConfig, this.failoverStrategy, this.transportCreator, this.backupServers, this.serviceLevel);
        return this;
    }

    public <X extends TServiceClient> X iface(Class<X> ifaceClass) {
        X client = null;
        while (client == null) {
            try {
                client = this.clientSelector.iface(ifaceClass);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof TTransportException) continue;
                throw e;
            }
        }
        return client;
    }

    public <X extends TServiceClient> X iface(Class<X> ifaceClass, String key) {
        return this.clientSelector.iface(ifaceClass, key);
    }

    public List<ThriftServer> getAvailableServers() {
        return this.clientSelector.getAvailableServers();
    }

    public void close() {
        this.clientSelector.close();
    }

    private void checkAndInit() {
        if (this.servers == null || StringUtils.isEmpty(this.servers)) {
            throw new ValidationException("servers can not be null or empty.");
        }
        if (!this.checkLoadBalance()) {
            this.loadBalance = LoadBalance.RANDOM;
        }
        if (this.validator == null) {
            this.validator = TTransport::isOpen;
        }
        if (this.poolConfig == null) {
            this.poolConfig = new GenericKeyedObjectPoolConfig();
        }
        if (this.failoverStrategy == null) {
            this.failoverStrategy = new FailoverStrategy();
        }
        if (this.connTimeout == 0) {
            this.connTimeout = DEFAULT_CONN_TIMEOUT;
        }
        if (!this.checkServiceLevel()) {
            this.serviceLevel = ServiceLevel.NOT_EMPTY;
        }
    }

    private boolean checkLoadBalance() {
        return this.loadBalance == LoadBalance.RANDOM || this.loadBalance == LoadBalance.ROUND_ROBIN || this.loadBalance == LoadBalance.WEIGHT || this.loadBalance == LoadBalance.HASH;
    }

    private boolean checkServiceLevel() {
        return this.serviceLevel == ServiceLevel.SERVERS_ONLY || this.serviceLevel == ServiceLevel.ALL_SERVERS || this.serviceLevel == ServiceLevel.NOT_EMPTY;
    }
}

