/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.utils;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;

public class ThriftClientUtil {
    private static final ConcurrentMap<Class<?>, Set<String>> interfaceMethodCache = new ConcurrentHashMap();

    public static int randomNextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static Set<String> getInterfaceMethodNames(Class<?> ifaceClass) {
        Class<?>[] interfaces;
        if (interfaceMethodCache.containsKey(ifaceClass)) {
            return (Set)interfaceMethodCache.get(ifaceClass);
        }
        HashSet methodName = Sets.newHashSet();
        for (Class<?> class1 : interfaces = ifaceClass.getInterfaces()) {
            Method[] methods;
            for (Method method : methods = class1.getMethods()) {
                methodName.add(method.getName());
            }
        }
        interfaceMethodCache.putIfAbsent(ifaceClass, methodName);
        return methodName;
    }

    public static final int chooseWithWeight(int[] weights) {
        int count = weights.length;
        int sum = 0;
        for (int i = 0; i < count; ++i) {
            sum += weights[i];
        }
        int random = ThreadLocalRandom.current().nextInt(sum);
        while (random + weights[count - 1] < sum) {
            sum -= weights[--count];
        }
        return count - 1;
    }
}

