/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsPeer;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.TlsNonceGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Times;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private TlsCrypto crypto;
    private int connectionEnd;
    private TlsNonceGenerator nonceGenerator;
    private SecurityParameters securityParametersHandshake = null;
    private SecurityParameters securityParametersConnection = null;
    private ProtocolVersion[] clientSupportedVersions = null;
    private ProtocolVersion clientVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private static TlsNonceGenerator createNonceGenerator(TlsCrypto crypto, int connectionEnd) {
        byte[] additionalSeedMaterial = new byte[16];
        Pack.longToBigEndian((long)AbstractTlsContext.nextCounterValue(), (byte[])additionalSeedMaterial, (int)0);
        Pack.longToBigEndian((long)Times.nanoTime(), (byte[])additionalSeedMaterial, (int)8);
        additionalSeedMaterial[0] = (byte)connectionEnd;
        return crypto.createNonceGenerator(additionalSeedMaterial);
    }

    AbstractTlsContext(TlsCrypto crypto, int connectionEnd) {
        this.crypto = crypto;
        this.connectionEnd = connectionEnd;
        this.nonceGenerator = AbstractTlsContext.createNonceGenerator(crypto, connectionEnd);
    }

    synchronized void handshakeBeginning(TlsPeer peer) throws IOException {
        if (null != this.securityParametersHandshake) {
            throw new TlsFatalAlert(80);
        }
        this.securityParametersHandshake = new SecurityParameters();
        this.securityParametersHandshake.entity = this.connectionEnd;
        if (null != this.securityParametersConnection) {
            this.securityParametersHandshake.renegotiating = true;
            this.securityParametersHandshake.secureRenegotiation = this.securityParametersConnection.isSecureRenegotiation();
            this.securityParametersHandshake.negotiatedVersion = this.securityParametersConnection.getNegotiatedVersion();
        }
        peer.notifyHandshakeBeginning();
    }

    synchronized void handshakeComplete(TlsPeer peer, TlsSession session) throws IOException {
        if (null == this.securityParametersHandshake) {
            throw new TlsFatalAlert(80);
        }
        this.session = session;
        this.securityParametersConnection = this.securityParametersHandshake;
        peer.notifyHandshakeComplete();
        this.securityParametersHandshake = null;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public TlsNonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    @Override
    public synchronized SecurityParameters getSecurityParameters() {
        return null != this.securityParametersHandshake ? this.securityParametersHandshake : this.securityParametersConnection;
    }

    @Override
    public synchronized SecurityParameters getSecurityParametersConnection() {
        return this.securityParametersConnection;
    }

    @Override
    public synchronized SecurityParameters getSecurityParametersHandshake() {
        return this.securityParametersHandshake;
    }

    @Override
    public ProtocolVersion[] getClientSupportedVersions() {
        return this.clientSupportedVersions;
    }

    public void setClientSupportedVersions(ProtocolVersion[] clientSupportedVersions) {
        this.clientSupportedVersions = clientSupportedVersions;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.getSecurityParameters().getNegotiatedVersion();
    }

    @Override
    public TlsSession getResumableSession() {
        TlsSession session = this.getSession();
        if (session == null || !session.isResumable()) {
            return null;
        }
        return session;
    }

    @Override
    public TlsSession getSession() {
        return this.session;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public byte[] exportChannelBinding(int channelBinding) {
        SecurityParameters sp = this.getSecurityParametersConnection();
        if (null == sp) {
            throw new IllegalStateException("Export of channel bindings unavailable before handshake completion");
        }
        switch (channelBinding) {
            case 0: {
                byte[] tlsServerEndPoint = sp.getTLSServerEndPoint();
                return tlsServerEndPoint.length < 1 ? null : Arrays.clone((byte[])tlsServerEndPoint);
            }
            case 1: {
                return Arrays.clone((byte[])sp.getTLSUnique());
            }
        }
        throw new UnsupportedOperationException();
    }
}

