/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import com.ghca.kms.thrift.api.DecSymParam;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class SymmetricDecryptRequest
implements TBase<SymmetricDecryptRequest, _Fields>,
Serializable,
Cloneable,
Comparable<SymmetricDecryptRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("SymmetricDecryptRequest");
    private static final TField ACCESS_TOKEN_FIELD_DESC = new TField("accessToken", 11, 1);
    private static final TField KEY_ID_FIELD_DESC = new TField("keyId", 11, 2);
    private static final TField CIPHER_DATA_FIELD_DESC = new TField("cipherData", 11, 3);
    private static final TField PARAM_FIELD_DESC = new TField("param", 12, 4);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new SymmetricDecryptRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new SymmetricDecryptRequestTupleSchemeFactory();
    @Nullable
    public String accessToken;
    @Nullable
    public String keyId;
    @Nullable
    public ByteBuffer cipherData;
    @Nullable
    public DecSymParam param;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public SymmetricDecryptRequest() {
    }

    public SymmetricDecryptRequest(String accessToken, String keyId, ByteBuffer cipherData, DecSymParam param) {
        this();
        this.accessToken = accessToken;
        this.keyId = keyId;
        this.cipherData = TBaseHelper.copyBinary(cipherData);
        this.param = param;
    }

    public SymmetricDecryptRequest(SymmetricDecryptRequest other) {
        if (other.isSetAccessToken()) {
            this.accessToken = other.accessToken;
        }
        if (other.isSetKeyId()) {
            this.keyId = other.keyId;
        }
        if (other.isSetCipherData()) {
            this.cipherData = TBaseHelper.copyBinary(other.cipherData);
        }
        if (other.isSetParam()) {
            this.param = new DecSymParam(other.param);
        }
    }

    @Override
    public SymmetricDecryptRequest deepCopy() {
        return new SymmetricDecryptRequest(this);
    }

    @Override
    public void clear() {
        this.accessToken = null;
        this.keyId = null;
        this.cipherData = null;
        this.param = null;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public SymmetricDecryptRequest setAccessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public void unsetAccessToken() {
        this.accessToken = null;
    }

    public boolean isSetAccessToken() {
        return this.accessToken != null;
    }

    public void setAccessTokenIsSet(boolean value) {
        if (!value) {
            this.accessToken = null;
        }
    }

    @Nullable
    public String getKeyId() {
        return this.keyId;
    }

    public SymmetricDecryptRequest setKeyId(@Nullable String keyId) {
        this.keyId = keyId;
        return this;
    }

    public void unsetKeyId() {
        this.keyId = null;
    }

    public boolean isSetKeyId() {
        return this.keyId != null;
    }

    public void setKeyIdIsSet(boolean value) {
        if (!value) {
            this.keyId = null;
        }
    }

    public byte[] getCipherData() {
        this.setCipherData(TBaseHelper.rightSize(this.cipherData));
        return this.cipherData == null ? null : this.cipherData.array();
    }

    public ByteBuffer bufferForCipherData() {
        return TBaseHelper.copyBinary(this.cipherData);
    }

    public SymmetricDecryptRequest setCipherData(byte[] cipherData) {
        this.cipherData = cipherData == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])cipherData.clone());
        return this;
    }

    public SymmetricDecryptRequest setCipherData(@Nullable ByteBuffer cipherData) {
        this.cipherData = TBaseHelper.copyBinary(cipherData);
        return this;
    }

    public void unsetCipherData() {
        this.cipherData = null;
    }

    public boolean isSetCipherData() {
        return this.cipherData != null;
    }

    public void setCipherDataIsSet(boolean value) {
        if (!value) {
            this.cipherData = null;
        }
    }

    @Nullable
    public DecSymParam getParam() {
        return this.param;
    }

    public SymmetricDecryptRequest setParam(@Nullable DecSymParam param) {
        this.param = param;
        return this;
    }

    public void unsetParam() {
        this.param = null;
    }

    public boolean isSetParam() {
        return this.param != null;
    }

    public void setParamIsSet(boolean value) {
        if (!value) {
            this.param = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case ACCESS_TOKEN: {
                if (value == null) {
                    this.unsetAccessToken();
                    break;
                }
                this.setAccessToken((String)value);
                break;
            }
            case KEY_ID: {
                if (value == null) {
                    this.unsetKeyId();
                    break;
                }
                this.setKeyId((String)value);
                break;
            }
            case CIPHER_DATA: {
                if (value == null) {
                    this.unsetCipherData();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setCipherData((byte[])value);
                    break;
                }
                this.setCipherData((ByteBuffer)value);
                break;
            }
            case PARAM: {
                if (value == null) {
                    this.unsetParam();
                    break;
                }
                this.setParam((DecSymParam)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ACCESS_TOKEN: {
                return this.getAccessToken();
            }
            case KEY_ID: {
                return this.getKeyId();
            }
            case CIPHER_DATA: {
                return this.getCipherData();
            }
            case PARAM: {
                return this.getParam();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ACCESS_TOKEN: {
                return this.isSetAccessToken();
            }
            case KEY_ID: {
                return this.isSetKeyId();
            }
            case CIPHER_DATA: {
                return this.isSetCipherData();
            }
            case PARAM: {
                return this.isSetParam();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof SymmetricDecryptRequest) {
            return this.equals((SymmetricDecryptRequest)that);
        }
        return false;
    }

    public boolean equals(SymmetricDecryptRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_accessToken = this.isSetAccessToken();
        boolean that_present_accessToken = that.isSetAccessToken();
        if (this_present_accessToken || that_present_accessToken) {
            if (!this_present_accessToken || !that_present_accessToken) {
                return false;
            }
            if (!this.accessToken.equals(that.accessToken)) {
                return false;
            }
        }
        boolean this_present_keyId = this.isSetKeyId();
        boolean that_present_keyId = that.isSetKeyId();
        if (this_present_keyId || that_present_keyId) {
            if (!this_present_keyId || !that_present_keyId) {
                return false;
            }
            if (!this.keyId.equals(that.keyId)) {
                return false;
            }
        }
        boolean this_present_cipherData = this.isSetCipherData();
        boolean that_present_cipherData = that.isSetCipherData();
        if (this_present_cipherData || that_present_cipherData) {
            if (!this_present_cipherData || !that_present_cipherData) {
                return false;
            }
            if (!this.cipherData.equals(that.cipherData)) {
                return false;
            }
        }
        boolean this_present_param = this.isSetParam();
        boolean that_present_param = that.isSetParam();
        if (this_present_param || that_present_param) {
            if (!this_present_param || !that_present_param) {
                return false;
            }
            if (!this.param.equals(that.param)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetAccessToken() ? 131071 : 524287);
        if (this.isSetAccessToken()) {
            hashCode = hashCode * 8191 + this.accessToken.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetKeyId() ? 131071 : 524287);
        if (this.isSetKeyId()) {
            hashCode = hashCode * 8191 + this.keyId.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCipherData() ? 131071 : 524287);
        if (this.isSetCipherData()) {
            hashCode = hashCode * 8191 + this.cipherData.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParam() ? 131071 : 524287);
        if (this.isSetParam()) {
            hashCode = hashCode * 8191 + this.param.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(SymmetricDecryptRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetAccessToken(), other.isSetAccessToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAccessToken() && (lastComparison = TBaseHelper.compareTo(this.accessToken, other.accessToken)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetKeyId(), other.isSetKeyId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyId() && (lastComparison = TBaseHelper.compareTo(this.keyId, other.keyId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCipherData(), other.isSetCipherData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCipherData() && (lastComparison = TBaseHelper.compareTo(this.cipherData, other.cipherData)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParam(), other.isSetParam());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParam() && (lastComparison = TBaseHelper.compareTo(this.param, other.param)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        SymmetricDecryptRequest.scheme(iprot).read(iprot, (SymmetricDecryptRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        SymmetricDecryptRequest.scheme(oprot).write(oprot, (SymmetricDecryptRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SymmetricDecryptRequest(");
        boolean first = true;
        sb.append("accessToken:");
        if (this.accessToken == null) {
            sb.append("null");
        } else {
            sb.append(this.accessToken);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("keyId:");
        if (this.keyId == null) {
            sb.append("null");
        } else {
            sb.append(this.keyId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("cipherData:");
        if (this.cipherData == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.cipherData, sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("param:");
        if (this.param == null) {
            sb.append("null");
        } else {
            sb.append(this.param);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.accessToken == null) {
            throw new TProtocolException("Required field 'accessToken' was not present! Struct: " + this.toString());
        }
        if (this.keyId == null) {
            throw new TProtocolException("Required field 'keyId' was not present! Struct: " + this.toString());
        }
        if (this.cipherData == null) {
            throw new TProtocolException("Required field 'cipherData' was not present! Struct: " + this.toString());
        }
        if (this.param != null) {
            this.param.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ACCESS_TOKEN, new FieldMetaData("accessToken", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.KEY_ID, new FieldMetaData("keyId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CIPHER_DATA, new FieldMetaData("cipherData", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.PARAM, new FieldMetaData("param", 3, new StructMetaData(12, DecSymParam.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(SymmetricDecryptRequest.class, metaDataMap);
    }

    private static class SymmetricDecryptRequestTupleScheme
    extends TupleScheme<SymmetricDecryptRequest> {
        private SymmetricDecryptRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, SymmetricDecryptRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.accessToken);
            oprot.writeString(struct.keyId);
            oprot.writeBinary(struct.cipherData);
            BitSet optionals = new BitSet();
            if (struct.isSetParam()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetParam()) {
                struct.param.write(oprot);
            }
        }

        @Override
        public void read(TProtocol prot, SymmetricDecryptRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.accessToken = iprot.readString();
            struct.setAccessTokenIsSet(true);
            struct.keyId = iprot.readString();
            struct.setKeyIdIsSet(true);
            struct.cipherData = iprot.readBinary();
            struct.setCipherDataIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.param = new DecSymParam();
                struct.param.read(iprot);
                struct.setParamIsSet(true);
            }
        }
    }

    private static class SymmetricDecryptRequestTupleSchemeFactory
    implements SchemeFactory {
        private SymmetricDecryptRequestTupleSchemeFactory() {
        }

        public SymmetricDecryptRequestTupleScheme getScheme() {
            return new SymmetricDecryptRequestTupleScheme();
        }
    }

    private static class SymmetricDecryptRequestStandardScheme
    extends StandardScheme<SymmetricDecryptRequest> {
        private SymmetricDecryptRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, SymmetricDecryptRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.accessToken = iprot.readString();
                            struct.setAccessTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.keyId = iprot.readString();
                            struct.setKeyIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.cipherData = iprot.readBinary();
                            struct.setCipherDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.param = new DecSymParam();
                            struct.param.read(iprot);
                            struct.setParamIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, SymmetricDecryptRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.accessToken != null) {
                oprot.writeFieldBegin(ACCESS_TOKEN_FIELD_DESC);
                oprot.writeString(struct.accessToken);
                oprot.writeFieldEnd();
            }
            if (struct.keyId != null) {
                oprot.writeFieldBegin(KEY_ID_FIELD_DESC);
                oprot.writeString(struct.keyId);
                oprot.writeFieldEnd();
            }
            if (struct.cipherData != null) {
                oprot.writeFieldBegin(CIPHER_DATA_FIELD_DESC);
                oprot.writeBinary(struct.cipherData);
                oprot.writeFieldEnd();
            }
            if (struct.param != null) {
                oprot.writeFieldBegin(PARAM_FIELD_DESC);
                struct.param.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SymmetricDecryptRequestStandardSchemeFactory
    implements SchemeFactory {
        private SymmetricDecryptRequestStandardSchemeFactory() {
        }

        public SymmetricDecryptRequestStandardScheme getScheme() {
            return new SymmetricDecryptRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ACCESS_TOKEN(1, "accessToken"),
        KEY_ID(2, "keyId"),
        CIPHER_DATA(3, "cipherData"),
        PARAM(4, "param");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ACCESS_TOKEN;
                }
                case 2: {
                    return KEY_ID;
                }
                case 3: {
                    return CIPHER_DATA;
                }
                case 4: {
                    return PARAM;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

