/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.failover;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.EvictingQueue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverStrategy<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_FAIL_COUNT = 10;
    private static final long DEFAULT_FAIL_DURATION = TimeUnit.MINUTES.toMillis(1L);
    private static final long DEFAULT_RECOVER_DURATION = TimeUnit.MINUTES.toMillis(1L);
    private final long failDuration;
    private final Cache<T, Boolean> failedList;
    private final LoadingCache<T, EvictingQueue<Long>> failCountMap;

    public FailoverStrategy() {
        this(10, DEFAULT_FAIL_DURATION, DEFAULT_RECOVER_DURATION);
    }

    public FailoverStrategy(final int failCount, long failDuration, long recoverDuration) {
        this.failDuration = failDuration;
        this.failedList = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(recoverDuration, TimeUnit.MILLISECONDS).build();
        this.failCountMap = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<T, EvictingQueue<Long>>(){

            public EvictingQueue<Long> load(T key) throws Exception {
                return EvictingQueue.create((int)failCount);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(T object) {
        boolean addToFail = false;
        try {
            EvictingQueue evictingQueue;
            EvictingQueue evictingQueue2 = evictingQueue = (EvictingQueue)this.failCountMap.get(object);
            synchronized (evictingQueue2) {
                evictingQueue.add((Object)System.currentTimeMillis());
                if (evictingQueue.remainingCapacity() == 0 && (Long)evictingQueue.element() >= System.currentTimeMillis() - this.failDuration) {
                    addToFail = true;
                }
            }
        }
        catch (ExecutionException e) {
            this.logger.error("Ops.", (Throwable)e);
        }
        if (addToFail) {
            this.failedList.put(object, (Object)Boolean.TRUE);
        }
    }

    public Set<T> getFailed() {
        return this.failedList.asMap().keySet();
    }
}

