/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCryptoProvider;
import kl.ssl.jsse.provider.DefaultSSLContextSpi;
import kl.ssl.jsse.provider.EngineCreator;
import kl.ssl.jsse.provider.ProvKeyManagerFactorySpi;
import kl.ssl.jsse.provider.ProvSSLContextSpi;
import kl.ssl.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.util.Strings;

public class KlGMJsseProvider
extends Provider {
    public static final String PROVIDER_NAME = "KLGMJSSE";
    private static final double PROVIDER_VERSION = 0.001;
    private static final String PROVIDER_INFO = "Koal GM JSSE Provider Version 0.0.10";
    private Map<String, BcJsseService> serviceMap = new HashMap<String, BcJsseService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private static final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();

    public KlGMJsseProvider() {
        super(PROVIDER_NAME, 0.001, PROVIDER_INFO);
        this.configure(new JcaTlsCryptoProvider());
    }

    public KlGMJsseProvider(Provider provider) {
        super(PROVIDER_NAME, 0.001, PROVIDER_INFO);
        this.configure(new JcaTlsCryptoProvider().setProvider(provider));
    }

    public KlGMJsseProvider(String config) {
        super(PROVIDER_NAME, 0.001, PROVIDER_INFO);
        String cryptoName = config = config.trim();
        int colonPos = config.indexOf(58);
        if (colonPos >= 0) {
            String second;
            String first = config.substring(0, colonPos).trim();
            cryptoName = second = config.substring(colonPos + 1).trim();
        }
        try {
            JcaTlsCryptoProvider cryptoProvider = this.createCryptoProvider(cryptoName);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("unable to set up TlsCrypto: " + e.getMessage(), e);
        }
        this.configure(new JcaTlsCryptoProvider());
    }

    public KlGMJsseProvider(JcaTlsCryptoProvider tlsCryptoProvider) {
        super(PROVIDER_NAME, 0.001, PROVIDER_INFO);
        this.configure(tlsCryptoProvider);
    }

    @Override
    public Provider configure(String configArg) {
        return new KlGMJsseProvider(configArg);
    }

    private JcaTlsCryptoProvider createCryptoProvider(String cryptoName) throws GeneralSecurityException {
        if (cryptoName.equalsIgnoreCase("default")) {
            return new JcaTlsCryptoProvider();
        }
        Provider provider = Security.getProvider(cryptoName);
        if (provider != null) {
            return new JcaTlsCryptoProvider().setProvider(provider);
        }
        try {
            Class<?> cryptoProviderClass = Class.forName(cryptoName);
            Object cryptoProviderInstance = cryptoProviderClass.newInstance();
            if (cryptoProviderInstance instanceof JcaTlsCryptoProvider) {
                return (JcaTlsCryptoProvider)cryptoProviderInstance;
            }
            if (cryptoProviderInstance instanceof Provider) {
                return new JcaTlsCryptoProvider().setProvider((Provider)cryptoProviderInstance);
            }
            throw new IllegalArgumentException("unrecognized class: " + cryptoName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("unable to find Provider/TlsCrypto class: " + cryptoName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("unable to create Provider/TlsCrypto class '" + cryptoName + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to create Provider/TlsCrypto class '" + cryptoName + "': " + e.getMessage(), e);
        }
    }

    private boolean configure(final JcaTlsCryptoProvider cryptoProvider) {
        this.addAlgorithmImplementation("KeyManagerFactory.X.509", "kl.ssl.jsse.provider.KeyManagerFactory", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvKeyManagerFactorySpi();
            }
        });
        this.addAlias("Alg.Alias.KeyManagerFactory.X509", "X.509");
        this.addAlias("Alg.Alias.KeyManagerFactory.PKIX", "X.509");
        this.addAlgorithmImplementation("TrustManagerFactory.PKIX", "kl.ssl.jsse.provider.TrustManagerFactory", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvTrustManagerFactorySpi(cryptoProvider.getHelper());
            }
        });
        this.addAlias("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        this.addAlias("Alg.Alias.TrustManagerFactory.X509", "PKIX");
        this.addAlgorithmImplementation("SSLContext.GMVPNV1.1", "kl.ssl.jsse.provider.SSLContext.GMVPNv1_1", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(cryptoProvider, new String[]{"GMVPNv1.1"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.DEFAULT", "kl.ssl.jsse.provider.SSLContext.Default", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) throws GeneralSecurityException {
                return new DefaultSSLContextSpi(cryptoProvider);
            }
        });
        this.addAlias("Alg.Alias.SSLContext.SSL", "TLS");
        return false;
    }

    void addAttribute(String key, String attributeName, String attributeValue) {
        String attributeKey = key + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.put(attributeKey, attributeValue);
    }

    void addAlgorithmImplementation(String key, String className, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.put(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlias(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public final synchronized Provider.Service getService(String type, String algorithm) {
        String upperCaseAlgName = Strings.toUpperCase((String)algorithm);
        BcJsseService service = this.serviceMap.get(type + "." + upperCaseAlgName);
        if (service == null) {
            String className;
            String aliasString = "Alg.Alias." + type + ".";
            String realName = (String)this.get(aliasString + upperCaseAlgName);
            if (realName == null) {
                realName = upperCaseAlgName;
            }
            if ((className = (String)this.get(type + "." + realName)) == null) {
                return null;
            }
            String attributeKeyStart = type + "." + upperCaseAlgName + " ";
            ArrayList<String> aliases = new ArrayList<String>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Object key : this.keySet()) {
                String sKey = (String)key;
                if (sKey.startsWith(aliasString) && this.get(key).equals(algorithm)) {
                    aliases.add(sKey.substring(aliasString.length()));
                }
                if (!sKey.startsWith(attributeKeyStart)) continue;
                attributes.put(sKey.substring(attributeKeyStart.length()), (String)this.get(sKey));
            }
            service = new BcJsseService(this, type, upperCaseAlgName, className, aliases, KlGMJsseProvider.getAttributeMap(attributes), this.creatorMap.get(className));
            this.serviceMap.put(type + "." + upperCaseAlgName, service);
        }
        return service;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> serviceSet = super.getServices();
        HashSet<Provider.Service> bcServiceSet = new HashSet<Provider.Service>();
        for (Provider.Service service : serviceSet) {
            bcServiceSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return bcServiceSet;
    }

    private static Map<String, String> getAttributeMap(Map<String, String> attributeMap) {
        Map<String, String> attrMap = attributeMaps.get(attributeMap);
        if (attrMap != null) {
            return attrMap;
        }
        attributeMaps.put(attributeMap, attributeMap);
        return attributeMap;
    }

    private static class BcJsseService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcJsseService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, EngineCreator creator) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.creator = creator;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                Object instance = this.creator.createInstance(constructorParameter);
                if (instance == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + e.getMessage(), e);
            }
        }
    }
}

