/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.color;

import java.awt.Color;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class ConstrastFunction
extends FunctionImpl {
    public static FunctionName NAME = new FunctionNameImpl("contrast", FunctionNameImpl.parameter("result", Color.class), FunctionNameImpl.parameter("reference", Color.class), FunctionNameImpl.parameter("color1", Color.class, 0, 1), FunctionNameImpl.parameter("color2", Color.class, 0, 1), FunctionNameImpl.parameter("threshold", Double.class, 0, 1));

    public ConstrastFunction() {
        this.functionName = NAME;
    }

    @Override
    public Object evaluate(Object object) {
        Color dark;
        Color light;
        double luma2;
        Color reference = (Color)this.getParameterValue(object, 0);
        Color color1 = (Color)this.getParameterValue(object, 1, Color.BLACK);
        Color color2 = (Color)this.getParameterValue(object, 2, Color.WHITE);
        double threshold = (Double)this.getParameterValue(object, 3, 0.43);
        double luma1 = this.luma(color1);
        if (luma1 > (luma2 = this.luma(color2))) {
            light = color1;
            dark = color2;
        } else {
            light = color2;
            dark = color1;
        }
        if (this.luma(reference) < threshold) {
            return light;
        }
        return dark;
    }

    private double luma(Color color) {
        double r = (double)color.getRed() / 255.0;
        double g = (double)color.getGreen() / 255.0;
        double b = (double)color.getBlue() / 255.0;
        r = r <= 0.03928 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.03928 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.03928 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }
}

