/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.util;

import com.koal.kms.sdk.ed.vo.EccCipher;
import java.nio.ByteBuffer;

public class EccCipherUtils {
    public static EccCipher convertIntoEccCipher(byte[] in) {
        int intBytes = 4;
        byte[] lenBytes = new byte[intBytes];
        int idx = 0;
        EccCipherUtils.bytesTo(in, lenBytes, idx);
        byte[] x = new byte[ByteBuffer.wrap(lenBytes).getInt()];
        EccCipherUtils.bytesTo(in, lenBytes, idx += intBytes);
        byte[] y = new byte[ByteBuffer.wrap(lenBytes).getInt()];
        EccCipherUtils.bytesTo(in, lenBytes, idx += intBytes);
        byte[] c = new byte[ByteBuffer.wrap(lenBytes).getInt()];
        EccCipherUtils.bytesTo(in, lenBytes, idx += intBytes);
        byte[] m = new byte[ByteBuffer.wrap(lenBytes).getInt()];
        EccCipherUtils.bytesTo(in, lenBytes, idx += intBytes);
        int cLength = ByteBuffer.wrap(lenBytes).getInt();
        EccCipherUtils.bytesTo(in, x, idx += intBytes);
        EccCipherUtils.bytesTo(in, y, idx += x.length);
        EccCipherUtils.bytesTo(in, c, idx += y.length);
        EccCipherUtils.bytesTo(in, m, idx + c.length);
        EccCipher eccCipher = new EccCipher();
        eccCipher.setClength(cLength);
        eccCipher.setC(c);
        eccCipher.setM(m);
        eccCipher.setX(x);
        eccCipher.setY(y);
        return eccCipher;
    }

    private static void bytesTo(byte[] src, byte[] dest, int srcIdx) {
        System.arraycopy(src, srcIdx, dest, 0, dest.length);
    }
}

