/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import kl.ssl.gmvpn.AbstractTlsClient;
import kl.ssl.gmvpn.NewSessionTicket;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCrypto;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{57363};

    public DefaultTlsClient(TlsCrypto crypto) {
        super(crypto);
    }

    @Override
    public ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.GMVPNv11.downTo(ProtocolVersion.GMVPNv11);
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.context.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
        this.context.getSecurityParameters().ticket = newSessionTicket.ticket;
        this.context.getSecurityParameters().ticket_expire_time = System.currentTimeMillis() + newSessionTicket.ticketLifetimeHint * 1000L;
    }

    public TlsSession getSession() {
        return this.context.getSession();
    }
}

