/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kl.ssl.gmvpn.AbstractTlsContext;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.CertificateRequest;
import kl.ssl.gmvpn.CertificateStatus;
import kl.ssl.gmvpn.CipherSuite;
import kl.ssl.gmvpn.ClientHello;
import kl.ssl.gmvpn.DigitallySigned;
import kl.ssl.gmvpn.NewSessionTicket;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.SessionParameters;
import kl.ssl.gmvpn.TlsAuthentication;
import kl.ssl.gmvpn.TlsClient;
import kl.ssl.gmvpn.TlsClientContextImpl;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsCredentialedSigner;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsExtensionsUtils;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsHandshakeHash;
import kl.ssl.gmvpn.TlsKeyExchange;
import kl.ssl.gmvpn.TlsPeer;
import kl.ssl.gmvpn.TlsProtocol;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected Hashtable clientAgreements = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.tlsClientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        this.tlsClient.init(this.tlsClientContext);
        this.recordStream.init(this.tlsClientContext);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    @Override
    protected void beginHandshake(boolean renegotiation) throws IOException {
        SessionParameters sessionParameters;
        super.beginHandshake(renegotiation);
        TlsSession sessionToResume = this.tlsClient.getSessionToResume();
        if (sessionToResume != null && sessionToResume.isResumable() && (sessionParameters = sessionToResume.exportSessionParameters()) != null && sessionParameters.isExtendedMasterSecret()) {
            this.tlsSession = sessionToResume;
            this.sessionParameters = sessionParameters;
        }
        this.sendClientHelloMessage();
        this.connection_state = 1;
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    @Override
    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    @Override
    protected void handleHandshakeMessage(short type, ByteArrayInputStream buf) throws IOException {
        if (this.resumedSession) {
            if (type != 20 || this.connection_state != 2) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(buf);
            this.connection_state = (short)15;
            this.sendChangeCipherSpecMessage();
            this.sendFinishedMessage();
            this.connection_state = (short)13;
            this.completeHandshake();
            return;
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        TlsUtils.receiveServerCertificate(this.tlsClientContext, buf);
                        this.authentication = this.tlsClient.getAuthentication();
                        if (null != this.authentication) break;
                        throw new TlsFatalAlert(80);
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 4: {
                        if (!this.allowCertificateStatus) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 13: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 14: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        this.receiveServerHelloMessage(buf);
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        this.applyMaxFragmentLengthExtension();
                        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
                        if (this.resumedSession) {
                            securityParameters.masterSecret = this.tlsClientContext.getCrypto().adoptSecret(this.sessionParameters.getMasterSecret());
                            this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.getContext()));
                            break block0;
                        }
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                        this.sessionParameters = null;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(buf));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: 
                    case 7: {
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)8;
                        Vector clientSupplementalData = this.tlsClient.getClientSupplementalData();
                        if (clientSupplementalData != null) {
                            this.sendSupplementalDataMessage(clientSupplementalData);
                        }
                        this.connection_state = (short)9;
                        TlsCredentials clientCredentials = null;
                        TlsCredentialedSigner credentialedSigner = null;
                        TlsStreamSigner streamSigner = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            Certificate clientCertificate = null;
                            clientCredentials = TlsClientProtocol.validateCredentials(this.authentication.getClientCredentials(this.certificateRequest));
                            if (null == clientCredentials) {
                                this.keyExchange.skipClientCredentials();
                                throw new TlsFatalAlert(41);
                            }
                            this.keyExchange.processClientCredentials(clientCredentials);
                            clientCertificate = clientCredentials.getCertificate();
                            if (clientCredentials instanceof TlsCredentialedSigner) {
                                credentialedSigner = (TlsCredentialedSigner)clientCredentials;
                                streamSigner = credentialedSigner.getStreamSigner();
                            }
                            this.sendCertificateMessage(clientCertificate, null);
                        }
                        this.connection_state = (short)10;
                        boolean forceBuffering = streamSigner != null;
                        TlsUtils.sealHandshakeHash(this.getContext(), this.recordStream.getHandshakeHash(), forceBuffering);
                        this.sendClientKeyExchangeMessage();
                        this.connection_state = (short)11;
                        TlsHandshakeHash prepareFinishHash = this.recordStream.prepareToFinish();
                        this.tlsClientContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(prepareFinishHash);
                        TlsClientProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
                        this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.getContext()));
                        if (credentialedSigner != null) {
                            DigitallySigned certificateVerify = TlsUtils.generateCertificateVerify(this.getContext(), credentialedSigner, streamSigner, prepareFinishHash);
                            this.sendCertificateVerifyMessage(certificateVerify);
                            this.connection_state = (short)12;
                        }
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)13;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)6;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: {
                        if (this.authentication == null) {
                            throw new TlsFatalAlert(40);
                        }
                        this.certificateRequest = CertificateRequest.parse(this.getContext(), buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                        TlsUtils.trackHashAlgorithms(this.recordStream.getHandshakeHash(), this.certificateRequest.getSupportedSignatureAlgorithms());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 13: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicketMessage(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)14;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(buf);
                if (this.connection_state != 16) break;
                this.handleRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.processServerCertificate(this.tlsClientContext, this.tlsClient, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector serverSupplementalData) throws IOException {
        this.tlsClient.processServerSupplementalData(serverSupplementalData);
        this.connection_state = (short)3;
        this.keyExchange = TlsUtils.initKeyExchangeClient(this.tlsClientContext, this.tlsClient);
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream buf) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void receiveServerHelloMessage(ByteArrayInputStream buf) throws IOException {
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        byte[] server_random = TlsUtils.readFully(32, (InputStream)buf);
        byte[] selectedSessionID = TlsUtils.readOpaque8(buf, 0, 32);
        int selectedCipherSuite = TlsUtils.readUint16(buf);
        short selectedCompressionMethod = TlsUtils.readUint8(buf);
        this.serverExtensions = TlsClientProtocol.readExtensions(buf);
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            if (!server_version.equals(this.tlsClientContext.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!ProtocolVersion.GMVPNv11.isEqualOrEarlierVersionOf(server_version)) {
                throw new TlsFatalAlert(47);
            }
            if (!ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), server_version)) {
                throw new TlsFatalAlert(70);
            }
            ProtocolVersion legacy_record_version = server_version.isLaterVersionOf(ProtocolVersion.GMVPNv11) ? ProtocolVersion.GMVPNv11 : server_version;
            this.recordStream.setWriteVersion(legacy_record_version);
            securityParameters.negotiatedVersion = server_version;
        }
        this.tlsClient.notifyServerVersion(server_version);
        if (!this.tlsClientContext.getClientVersion().equals(server_version)) {
            TlsUtils.checkDowngradeMarker(server_version, server_random);
        }
        securityParameters.serverRandom = server_random;
        securityParameters.sessionID = selectedSessionID;
        this.tlsClient.notifySessionID(selectedSessionID);
        boolean bl = this.resumedSession = selectedSessionID.length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])selectedSessionID, (byte[])this.tlsSession.getSessionID());
        if (!Arrays.contains((int[])this.offeredCipherSuites, (int)selectedCipherSuite) || selectedCipherSuite == 0 || CipherSuite.isSCSV(selectedCipherSuite) || !TlsUtils.isValidCipherSuiteForVersion(selectedCipherSuite, this.tlsClientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.cipherSuite = selectedCipherSuite;
        this.tlsClient.notifySelectedCipherSuite(selectedCipherSuite);
        if (0 != selectedCompressionMethod) {
            throw new TlsFatalAlert(47);
        }
        if (this.serverExtensions != null) {
            Enumeration e = this.serverExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(EXT_RenegotiationInfo) || extType.equals(EXT_SPAInfo)) continue;
                if (securityParameters.isGetClientIp() && extType.equals(EXT_ClientIp)) {
                    byte[] tmp = (byte[])this.serverExtensions.get(EXT_ClientIp);
                    System.err.println(Thread.currentThread().getId());
                    SecurityParameters.clientip.put(Thread.currentThread().getId(), new String(tmp));
                    continue;
                }
                if (null == TlsUtils.getExtensionData(this.clientExtensions, extType)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        if (securityParameters.isSPA()) {
            byte[] tmp = new byte[securityParameters.serverRandom.length + SecurityParameters.opsk.length + SecurityParameters.ipsk.length];
            System.arraycopy(securityParameters.serverRandom, 0, tmp, 0, securityParameters.serverRandom.length);
            System.arraycopy(SecurityParameters.opsk, 0, tmp, securityParameters.serverRandom.length, SecurityParameters.opsk.length);
            System.arraycopy(SecurityParameters.ipsk, 0, tmp, securityParameters.serverRandom.length + SecurityParameters.opsk.length, SecurityParameters.ipsk.length);
            byte[] tmp2 = null;
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                tmp2 = md.digest(tmp);
            }
            catch (Exception e) {
                throw new TlsFatalAlert(80);
            }
            byte[] tmp3 = new byte[16];
            System.arraycopy(tmp2, 0, tmp3, 0, 16);
            byte[] spa = (byte[])this.serverExtensions.get(EXT_SPAInfo);
            if (!Arrays.areEqual((byte[])spa, (byte[])tmp3)) {
                throw new TlsFatalAlert(80);
            }
        }
        byte[] renegExtData = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (renegExtData == null) {
                throw new TlsFatalAlert(40);
            }
            SecurityParameters saved = this.tlsClientContext.getSecurityParametersConnection();
            byte[] reneg_conn_info = TlsUtils.concat(saved.getLocalVerifyData(), saved.getPeerVerifyData());
            if (!Arrays.constantTimeAreEqual((byte[])renegExtData, (byte[])TlsClientProtocol.createRenegotiationInfo(reneg_conn_info))) {
                throw new TlsFatalAlert(40);
            }
        } else if (renegExtData == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])renegExtData, (byte[])TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable sessionClientExtensions = this.clientExtensions;
        Hashtable sessionServerExtensions = this.serverExtensions;
        if (this.resumedSession) {
            if (securityParameters.getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !server_version.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            sessionClientExtensions = null;
            sessionServerExtensions = this.sessionParameters.readServerExtensions();
        }
        if (sessionServerExtensions != null && !sessionServerExtensions.isEmpty()) {
            boolean serverSentEncryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(sessionServerExtensions);
            if (serverSentEncryptThenMAC && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = serverSentEncryptThenMAC;
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(sessionClientExtensions, sessionServerExtensions, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(sessionServerExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl2 = this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (sessionClientExtensions != null) {
            this.tlsClient.processServerExtensions(sessionServerExtensions);
        }
        securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm(this.tlsClientContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void sendCertificateVerifyMessage(DigitallySigned certificateVerify) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(this, 15);
        certificateVerify.encode(message);
        message.writeToRecordStream();
    }

    protected void sendClientHelloMessage() throws IOException {
        ProtocolVersion client_version;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            client_version = this.tlsClientContext.getClientVersion();
        } else {
            this.recordStream.setWriteVersion(ProtocolVersion.GMVPNv11);
            this.tlsClientContext.setClientSupportedVersions(this.tlsClient.getSupportedVersions());
            client_version = ProtocolVersion.getLatestTLS(this.tlsClientContext.getClientSupportedVersions());
            if (null == client_version || client_version.isEarlierVersionOf(ProtocolVersion.GMVPNv11) || client_version.isLaterVersionOf(ProtocolVersion.GMVPNv11)) {
                throw new TlsFatalAlert(80);
            }
            this.tlsClientContext.setClientVersion(client_version);
        }
        byte[] session_id = TlsUtils.EMPTY_BYTES;
        if (this.tlsSession != null && ((session_id = this.tlsSession.getSessionID()) == null || session_id.length > 32)) {
            session_id = TlsUtils.EMPTY_BYTES;
        }
        boolean fallback = this.tlsClient.isFallback();
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        if (session_id.length > 0 && this.sessionParameters != null) {
            if (!this.sessionParameters.isExtendedMasterSecret() || !Arrays.contains((int[])this.offeredCipherSuites, (int)this.sessionParameters.getCipherSuite()) || 0 != this.sessionParameters.getCompressionAlgorithm()) {
                session_id = TlsUtils.EMPTY_BYTES;
            }
            if (this.sessionParameters.ticket != null && this.sessionParameters.ticket_expire_time < System.currentTimeMillis()) {
                this.sessionParameters.ticket = null;
                this.sessionParameters.ticket_expire_time = 0L;
            }
        }
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(this.tlsClient.shouldUseGMTUnixTime(), this.tlsClientContext);
        if (securityParameters.isSPA()) {
            byte[] tmp = new byte[securityParameters.clientRandom.length + SecurityParameters.opsk.length + SecurityParameters.ipsk.length];
            System.arraycopy(securityParameters.clientRandom, 0, tmp, 0, securityParameters.clientRandom.length);
            System.arraycopy(SecurityParameters.opsk, 0, tmp, securityParameters.clientRandom.length, SecurityParameters.opsk.length);
            System.arraycopy(SecurityParameters.ipsk, 0, tmp, securityParameters.clientRandom.length + SecurityParameters.opsk.length, SecurityParameters.ipsk.length);
            byte[] tmp2 = null;
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                tmp2 = md.digest(tmp);
            }
            catch (Exception e) {
                throw new TlsFatalAlert(80);
            }
            byte[] tmp3 = new byte[16];
            System.arraycopy(tmp2, 0, tmp3, 0, 16);
            this.clientExtensions.put(EXT_SPAInfo, tmp3);
        }
        if (this.sessionParameters != null && this.sessionParameters.ticket != null) {
            this.clientExtensions.put(TlsProtocol.EXT_SessionTicket, this.sessionParameters.ticket);
        } else if (securityParameters.isSessionTicket()) {
            this.clientExtensions.put(TlsProtocol.EXT_SessionTicket, new byte[0]);
        }
        if (securityParameters.isGetClientIp()) {
            this.clientExtensions.put(TlsProtocol.EXT_ClientIp, new byte[0]);
        }
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            SecurityParameters saved = this.tlsClientContext.getSecurityParametersConnection();
            this.clientExtensions.put(EXT_RenegotiationInfo, TlsClientProtocol.createRenegotiationInfo(saved.getLocalVerifyData()));
        } else {
            boolean noRenegSCSV;
            boolean noRenegExt = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
            boolean bl = noRenegSCSV = !Arrays.contains((int[])this.offeredCipherSuites, (int)255);
            if (noRenegExt && noRenegSCSV) {
                this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)255);
            }
        }
        if (fallback && !Arrays.contains((int[])this.offeredCipherSuites, (int)22016)) {
            this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)22016);
        }
        ClientHello clientHello = new ClientHello(client_version, securityParameters.getClientRandom(), session_id, null, this.offeredCipherSuites, this.clientExtensions);
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(this, 1);
        clientHello.encode(this.tlsClientContext, message);
        message.writeToRecordStream();
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(this, 16);
        this.keyExchange.generateClientKeyExchange(message);
        message.writeToRecordStream();
    }
}

