/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.KmsException;
import com.koal.kms.sdk.ed.ClientBuilder;
import com.koal.kms.sdk.ed.DataKey;
import com.koal.kms.sdk.ed.KmsClient;
import com.koal.kms.sdk.ed.KmsGm;
import com.koal.kms.sdk.ed.SignatureVerificationKey;
import java.security.KeyPair;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum KmsCache {
    CACHE;

    private final Map<String, DataKey> decrypts = new ConcurrentHashMap<String, DataKey>();
    private final Map<String, SignatureVerificationKey> verifySign = new ConcurrentHashMap<String, SignatureVerificationKey>();
    private DataKey encrypt;
    private DataKey ctrEncrypt;
    private SignatureVerificationKey sign;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataKey getCtrKey() {
        if (null == this.ctrEncrypt || this.ctrEncrypt.isInvalid()) {
            KmsCache kmsCache = CACHE;
            synchronized (kmsCache) {
                if (null == this.ctrEncrypt || this.ctrEncrypt.isInvalid()) {
                    this.ctrEncrypt = this.getNewCtrKey();
                }
            }
        }
        return this.ctrEncrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataKey getEncrypt() {
        if (null == this.encrypt || this.encrypt.isInvalid()) {
            KmsCache kmsCache = CACHE;
            synchronized (kmsCache) {
                if (null == this.encrypt || this.encrypt.isInvalid()) {
                    this.encrypt = this.getNewDataKey();
                    this.decrypts.put(this.encrypt.getCiphertext(), this.encrypt);
                }
            }
        }
        return this.encrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataKey getDecrypt(byte[] cipherKey, String cmkId) {
        String text = Base64.getEncoder().encodeToString(cipherKey);
        if (!this.decrypts.containsKey(text)) {
            KmsCache kmsCache = CACHE;
            synchronized (kmsCache) {
                if (!this.decrypts.containsKey(text)) {
                    return this.decryptKey(cipherKey, text, cmkId);
                }
            }
        }
        return this.decrypts.get(text);
    }

    private DataKey decryptKey(byte[] cipherKey, String cipherTxt, String cmkId) {
        try {
            KmsClient client = ClientBuilder.getInstance();
            DataKey dataKey = client.decryptOldDataKey(cipherKey, cipherTxt, cmkId);
            this.decrypts.put(dataKey.getCiphertext(), dataKey);
            return dataKey;
        }
        catch (KmsException e) {
            throw new RuntimeException("\u89e3\u5bc6\u6570\u636e\u5bc6\u94a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002cause:" + e.getErr(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u6570\u636e\u5bc6\u94a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002cause:" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SignatureVerificationKey getSign() {
        if (null == this.sign || this.sign.isInvalid()) {
            KmsCache kmsCache = CACHE;
            synchronized (kmsCache) {
                if (null == this.sign || this.sign.isInvalid()) {
                    this.sign = this.getNewSignatureVerificationKey();
                    this.verifySign.put(Base64.getEncoder().encodeToString(this.sign.getPublicKey().getEncoded()), this.sign);
                }
            }
        }
        return this.sign;
    }

    private DataKey getNewDataKey() {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.generateDataKey();
        }
        catch (KmsException e) {
            throw new RuntimeException("\u521b\u5efa\u6570\u636e\u5bc6\u94a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002cause:" + e.getErr(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u6570\u636e\u5bc6\u94a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002cause:" + e.getMessage(), e);
        }
    }

    private DataKey getNewCtrKey() {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.generateCrtKey();
        }
        catch (KmsException e) {
            throw new RuntimeException("\u521b\u5efaCTR\u5bc6\u94a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002cause:" + e.getErr(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efaCTR\u5bc6\u94a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002cause:" + e.getMessage(), e);
        }
    }

    private SignatureVerificationKey getNewSignatureVerificationKey() {
        KeyPair keyPair = KmsGm.generateSm2KeyPair();
        return new SignatureVerificationKey(keyPair.getPublic(), keyPair.getPrivate());
    }
}

