/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl;

import java.io.IOException;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.crypto.TlsCipher;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsHMAC;
import kl.ssl.gmvpn.crypto.impl.TlsImplUtils;
import kl.ssl.gmvpn.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.util.Arrays;

public class TlsNullCipher
implements TlsCipher {
    protected final TlsCryptoParameters cryptoParameters;
    protected final TlsSuiteHMac readMac;
    protected final TlsSuiteHMac writeMac;

    public TlsNullCipher(TlsCryptoParameters cryptoParameters, TlsHMAC clientMac, TlsHMAC serverMac) throws IOException {
        this.cryptoParameters = cryptoParameters;
        int key_block_size = clientMac.getMacLength() + serverMac.getMacLength();
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParameters, key_block_size);
        int offset = 0;
        clientMac.setKey(key_block, offset, clientMac.getMacLength());
        serverMac.setKey(key_block, offset += clientMac.getMacLength(), serverMac.getMacLength());
        if ((offset += serverMac.getMacLength()) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParameters.isServer()) {
            this.writeMac = new TlsSuiteHMac(cryptoParameters, serverMac);
            this.readMac = new TlsSuiteHMac(cryptoParameters, clientMac);
        } else {
            this.writeMac = new TlsSuiteHMac(cryptoParameters, clientMac);
            this.readMac = new TlsSuiteHMac(cryptoParameters, serverMac);
        }
    }

    @Override
    public int getCiphertextLimit(int plaintextLimit) {
        return plaintextLimit + this.writeMac.getSize();
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        byte[] mac = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        byte[] ciphertext = new byte[len + mac.length];
        System.arraycopy(plaintext, offset, ciphertext, 0, len);
        System.arraycopy(mac, 0, ciphertext, len, mac.length);
        return ciphertext;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        byte[] computedMac;
        int macSize = this.readMac.getSize();
        if (len < macSize) {
            throw new TlsFatalAlert(50);
        }
        int macInputLen = len - macSize;
        byte[] receivedMac = Arrays.copyOfRange((byte[])ciphertext, (int)(offset + macInputLen), (int)(offset + len));
        if (!Arrays.constantTimeAreEqual((byte[])receivedMac, (byte[])(computedMac = this.readMac.calculateMac(seqNo, type, ciphertext, offset, macInputLen)))) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange((byte[])ciphertext, (int)offset, (int)(offset + macInputLen));
    }
}

