/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.util.List;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SessionParameters;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.jsse.BCSNIServerName;
import kl.ssl.jsse.provider.JsseSessionParameters;
import kl.ssl.jsse.provider.ProvSSLSessionBase;
import kl.ssl.jsse.provider.ProvSSLSessionContext;

class ProvSSLSession
extends ProvSSLSessionBase {
    static final ProvSSLSession NULL_SESSION = new ProvSSLSession(null, null, -1, null, new JsseSessionParameters(null));
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;
    protected final JsseSessionParameters jsseSessionParameters;

    ProvSSLSession(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort, TlsSession tlsSession, JsseSessionParameters jsseSessionParameters) {
        super(sslSessionContext, peerHost, peerPort);
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
        this.jsseSessionParameters = jsseSessionParameters;
    }

    @Override
    protected int getCipherSuiteTLS() {
        return null == this.sessionParameters ? 0 : this.sessionParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return null == this.tlsSession ? null : this.tlsSession.getSessionID();
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return this.jsseSessionParameters;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        throw new UnsupportedOperationException();
    }

    TlsSession getTlsSession() {
        return this.tlsSession;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (null != this.tlsSession) {
            this.tlsSession.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && null != this.tlsSession && this.tlsSession.isResumable();
    }
}

