/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.Format;
import java.text.ParseException;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.referencing.wkt.Preprocessor;
import org.geotools.resources.Arguments;
import org.geotools.resources.Classes;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;

public abstract class AbstractConsole
implements Runnable {
    protected final LineNumberReader in;
    protected final Writer out;
    protected final PrintWriter err;
    protected final String lineSeparator;
    protected final Format parser;
    private String prompt = "crs>";
    private transient String line;
    private volatile transient boolean stop;

    public AbstractConsole(Format parser) {
        this(parser, new LineNumberReader(Arguments.getReader((InputStream)System.in)));
    }

    public AbstractConsole(Format parser, LineNumberReader in) {
        this(parser, in, Arguments.getWriter((OutputStream)System.out), new PrintWriter(Arguments.getWriter((OutputStream)System.err), true), System.getProperty("line.separator", "\n"));
    }

    public AbstractConsole(Format parser, LineNumberReader in, Writer out, PrintWriter err, String lineSeparator) {
        this.parser = parser;
        this.in = in;
        this.out = out;
        this.err = err;
        this.lineSeparator = lineSeparator;
    }

    public Object parseObject(String text, Class type) throws ParseException, FactoryException {
        if (this.parser instanceof Preprocessor) {
            Preprocessor parser = (Preprocessor)this.parser;
            parser.offset = this.line != null ? Math.max(0, this.line.indexOf(text)) : 0;
            return parser.parseObject(text, type);
        }
        return this.parser.parseObject(text);
    }

    public void addDefinition(String name, String value) throws ParseException {
        if (this.parser instanceof Preprocessor) {
            ((Preprocessor)this.parser).addDefinition(name, value);
        }
    }

    public void loadDefinitions(LineNumberReader in) throws IOException, ParseException {
        while ((this.line = AbstractConsole.readLine(in)) != null) {
            String name = this.line;
            String value = null;
            int i = this.line.indexOf(61);
            if (i >= 0) {
                name = this.line.substring(0, i).trim();
                value = this.line.substring(i + 1).trim();
            }
            this.addDefinition(name, value);
        }
    }

    public void printDefinitions() throws IOException {
        if (this.parser instanceof Preprocessor) {
            ((Preprocessor)this.parser).printDefinitions(this.out);
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    private static String readLine(LineNumberReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null && ((line = line.trim()).length() == 0 || line.startsWith("//"))) {
        }
        return line;
    }

    @Override
    public void run() {
        try {
            while (!this.stop) {
                if (this.prompt != null) {
                    this.out.write(this.prompt);
                }
                this.out.flush();
                this.line = AbstractConsole.readLine(this.in);
                if (this.line == null) break;
                try {
                    this.execute(this.line);
                }
                catch (Exception exception) {
                    this.reportError(exception);
                }
            }
            this.out.flush();
            this.stop = false;
        }
        catch (IOException exception) {
            this.reportError(exception);
        }
    }

    public void executeAll() throws Exception {
        while ((this.line = AbstractConsole.readLine(this.in)) != null) {
            try {
                this.execute(this.line);
                this.out.flush();
            }
            catch (Exception e) {
                this.reportError(e);
                throw e;
            }
        }
    }

    protected abstract void execute(String var1) throws Exception;

    public void stop() {
        this.stop = true;
    }

    protected void reportError(Exception exception) {
        try {
            this.out.flush();
        }
        catch (IOException ignore) {
            Logging.unexpectedException(AbstractConsole.class, (String)"reportError", (Throwable)ignore);
        }
        this.err.print(Classes.getShortClassName((Object)exception));
        this.err.print(" at line ");
        this.err.print(this.in.getLineNumber());
        Throwable cause = exception;
        while (true) {
            String message;
            if ((message = cause.getLocalizedMessage()) != null) {
                this.err.print(": ");
                this.err.print(message);
            }
            this.err.println();
            cause = cause.getCause();
            if (cause == null) break;
            this.err.print("Caused by ");
            this.err.print(Classes.getShortClassName((Object)cause));
        }
        this.err.println("Type 'stacktrace' for stack trace information.");
        if (this.line != null && exception instanceof ParseException) {
            AbstractParser.reportError(this.err, this.line, ((ParseException)exception).getErrorOffset());
        }
        this.err.println();
    }
}

