/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import kl.ssl.gmvpn.crypto.TlsCryptoProvider;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCryptoProvider;
import kl.ssl.jsse.provider.ProvSSLContextSpi;

class DefaultSSLContextSpi
extends ProvSSLContextSpi {
    static ProvSSLContextSpi getDefaultInstance() throws Exception {
        if (null != LazyInstance.initException) {
            throw LazyInstance.initException;
        }
        return LazyInstance.instance;
    }

    DefaultSSLContextSpi(TlsCryptoProvider cryptoProvider) throws KeyManagementException {
        super(cryptoProvider, null);
        if (null != LazyManagers.initException) {
            throw new KeyManagementException("Default key/trust managers unavailable", LazyManagers.initException);
        }
        super.engineInit(LazyManagers.keyManagers, LazyManagers.trustManagers, null);
    }

    @Override
    protected void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        throw new KeyManagementException("Default SSLContext is initialized automatically");
    }

    private static class LazyManagers {
        private static final Exception initException;
        private static final KeyManager[] keyManagers;
        private static final TrustManager[] trustManagers;

        private LazyManagers() {
        }

        static {
            TrustManager[] tms;
            KeyManager[] kms;
            Exception ex = null;
            try {
                kms = ProvSSLContextSpi.getDefaultKeyManagers();
                tms = ProvSSLContextSpi.getDefaultTrustManagers();
            }
            catch (Exception e) {
                ex = e;
                kms = null;
                tms = null;
            }
            initException = ex;
            keyManagers = kms;
            trustManagers = tms;
        }
    }

    private static class LazyInstance {
        private static final Exception initException;
        private static final DefaultSSLContextSpi instance;

        private LazyInstance() {
        }

        static {
            Exception ex = LazyManagers.initException;
            DefaultSSLContextSpi i = null;
            if (null == ex) {
                try {
                    i = new DefaultSSLContextSpi(new JcaTlsCryptoProvider());
                }
                catch (Exception e) {
                    ex = e;
                    i = null;
                }
            }
            initException = ex;
            instance = i;
        }
    }
}

