/*
 * Decompiled with CFR 0.152.
 */
package cn.com.goldenwater.common.plugin.autoconfigure;

import cn.com.goldenwater.common.plugin.autoconfigure.PluginProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pf4j.PluginStatusProvider;

public class PropertyPluginStatusProvider
implements PluginStatusProvider {
    private List<String> enabledPlugins;
    private List<String> disabledPlugins;

    public PropertyPluginStatusProvider(PluginProperties pluginProperties) {
        this.enabledPlugins = pluginProperties.getEnabledPlugins() != null ? Arrays.asList(pluginProperties.getEnabledPlugins()) : new ArrayList();
        this.disabledPlugins = pluginProperties.getDisabledPlugins() != null ? Arrays.asList(pluginProperties.getDisabledPlugins()) : new ArrayList();
    }

    public static boolean isPropertySet(PluginProperties pluginProperties) {
        return pluginProperties.getEnabledPlugins() != null && pluginProperties.getEnabledPlugins().length > 0 || pluginProperties.getDisabledPlugins() != null && pluginProperties.getDisabledPlugins().length > 0;
    }

    public boolean isPluginDisabled(String pluginId) {
        if (this.disabledPlugins.contains(pluginId)) {
            return true;
        }
        return !this.enabledPlugins.isEmpty() && !this.enabledPlugins.contains(pluginId);
    }

    public void disablePlugin(String pluginId) {
        if (this.isPluginDisabled(pluginId)) {
            return;
        }
        this.disabledPlugins.add(pluginId);
        this.enabledPlugins.remove(pluginId);
    }

    public void enablePlugin(String pluginId) {
        if (!this.isPluginDisabled(pluginId)) {
            return;
        }
        this.enabledPlugins.add(pluginId);
        this.disabledPlugins.remove(pluginId);
    }
}

