/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import com.ghca.kms.thrift.api.DeriveAlgorithm;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class DeriveKeyRequest
implements TBase<DeriveKeyRequest, _Fields>,
Serializable,
Cloneable,
Comparable<DeriveKeyRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("DeriveKeyRequest");
    private static final TField ACCESS_TOKEN_FIELD_DESC = new TField("accessToken", 11, 1);
    private static final TField KEY_ID_FIELD_DESC = new TField("keyId", 11, 2);
    private static final TField ALGORITHM_FIELD_DESC = new TField("algorithm", 8, 3);
    private static final TField BYTE_LENGTH_FIELD_DESC = new TField("byteLength", 8, 4);
    private static final TField SALT_FIELD_DESC = new TField("salt", 11, 5);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new DeriveKeyRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new DeriveKeyRequestTupleSchemeFactory();
    @Nullable
    public String accessToken;
    @Nullable
    public String keyId;
    @Nullable
    public DeriveAlgorithm algorithm;
    public int byteLength;
    @Nullable
    public ByteBuffer salt;
    private static final int __BYTELENGTH_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DeriveKeyRequest() {
        this.algorithm = DeriveAlgorithm.AES_CMAC;
    }

    public DeriveKeyRequest(String accessToken, String keyId, DeriveAlgorithm algorithm, int byteLength, ByteBuffer salt) {
        this();
        this.accessToken = accessToken;
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.byteLength = byteLength;
        this.setByteLengthIsSet(true);
        this.salt = TBaseHelper.copyBinary(salt);
    }

    public DeriveKeyRequest(DeriveKeyRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetAccessToken()) {
            this.accessToken = other.accessToken;
        }
        if (other.isSetKeyId()) {
            this.keyId = other.keyId;
        }
        if (other.isSetAlgorithm()) {
            this.algorithm = other.algorithm;
        }
        this.byteLength = other.byteLength;
        if (other.isSetSalt()) {
            this.salt = TBaseHelper.copyBinary(other.salt);
        }
    }

    @Override
    public DeriveKeyRequest deepCopy() {
        return new DeriveKeyRequest(this);
    }

    @Override
    public void clear() {
        this.accessToken = null;
        this.keyId = null;
        this.algorithm = DeriveAlgorithm.AES_CMAC;
        this.setByteLengthIsSet(false);
        this.byteLength = 0;
        this.salt = null;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public DeriveKeyRequest setAccessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public void unsetAccessToken() {
        this.accessToken = null;
    }

    public boolean isSetAccessToken() {
        return this.accessToken != null;
    }

    public void setAccessTokenIsSet(boolean value) {
        if (!value) {
            this.accessToken = null;
        }
    }

    @Nullable
    public String getKeyId() {
        return this.keyId;
    }

    public DeriveKeyRequest setKeyId(@Nullable String keyId) {
        this.keyId = keyId;
        return this;
    }

    public void unsetKeyId() {
        this.keyId = null;
    }

    public boolean isSetKeyId() {
        return this.keyId != null;
    }

    public void setKeyIdIsSet(boolean value) {
        if (!value) {
            this.keyId = null;
        }
    }

    @Nullable
    public DeriveAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public DeriveKeyRequest setAlgorithm(@Nullable DeriveAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public void unsetAlgorithm() {
        this.algorithm = null;
    }

    public boolean isSetAlgorithm() {
        return this.algorithm != null;
    }

    public void setAlgorithmIsSet(boolean value) {
        if (!value) {
            this.algorithm = null;
        }
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public DeriveKeyRequest setByteLength(int byteLength) {
        this.byteLength = byteLength;
        this.setByteLengthIsSet(true);
        return this;
    }

    public void unsetByteLength() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetByteLength() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setByteLengthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public byte[] getSalt() {
        this.setSalt(TBaseHelper.rightSize(this.salt));
        return this.salt == null ? null : this.salt.array();
    }

    public ByteBuffer bufferForSalt() {
        return TBaseHelper.copyBinary(this.salt);
    }

    public DeriveKeyRequest setSalt(byte[] salt) {
        this.salt = salt == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])salt.clone());
        return this;
    }

    public DeriveKeyRequest setSalt(@Nullable ByteBuffer salt) {
        this.salt = TBaseHelper.copyBinary(salt);
        return this;
    }

    public void unsetSalt() {
        this.salt = null;
    }

    public boolean isSetSalt() {
        return this.salt != null;
    }

    public void setSaltIsSet(boolean value) {
        if (!value) {
            this.salt = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case ACCESS_TOKEN: {
                if (value == null) {
                    this.unsetAccessToken();
                    break;
                }
                this.setAccessToken((String)value);
                break;
            }
            case KEY_ID: {
                if (value == null) {
                    this.unsetKeyId();
                    break;
                }
                this.setKeyId((String)value);
                break;
            }
            case ALGORITHM: {
                if (value == null) {
                    this.unsetAlgorithm();
                    break;
                }
                this.setAlgorithm((DeriveAlgorithm)value);
                break;
            }
            case BYTE_LENGTH: {
                if (value == null) {
                    this.unsetByteLength();
                    break;
                }
                this.setByteLength((Integer)value);
                break;
            }
            case SALT: {
                if (value == null) {
                    this.unsetSalt();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setSalt((byte[])value);
                    break;
                }
                this.setSalt((ByteBuffer)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ACCESS_TOKEN: {
                return this.getAccessToken();
            }
            case KEY_ID: {
                return this.getKeyId();
            }
            case ALGORITHM: {
                return this.getAlgorithm();
            }
            case BYTE_LENGTH: {
                return this.getByteLength();
            }
            case SALT: {
                return this.getSalt();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ACCESS_TOKEN: {
                return this.isSetAccessToken();
            }
            case KEY_ID: {
                return this.isSetKeyId();
            }
            case ALGORITHM: {
                return this.isSetAlgorithm();
            }
            case BYTE_LENGTH: {
                return this.isSetByteLength();
            }
            case SALT: {
                return this.isSetSalt();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof DeriveKeyRequest) {
            return this.equals((DeriveKeyRequest)that);
        }
        return false;
    }

    public boolean equals(DeriveKeyRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_accessToken = this.isSetAccessToken();
        boolean that_present_accessToken = that.isSetAccessToken();
        if (this_present_accessToken || that_present_accessToken) {
            if (!this_present_accessToken || !that_present_accessToken) {
                return false;
            }
            if (!this.accessToken.equals(that.accessToken)) {
                return false;
            }
        }
        boolean this_present_keyId = this.isSetKeyId();
        boolean that_present_keyId = that.isSetKeyId();
        if (this_present_keyId || that_present_keyId) {
            if (!this_present_keyId || !that_present_keyId) {
                return false;
            }
            if (!this.keyId.equals(that.keyId)) {
                return false;
            }
        }
        boolean this_present_algorithm = this.isSetAlgorithm();
        boolean that_present_algorithm = that.isSetAlgorithm();
        if (this_present_algorithm || that_present_algorithm) {
            if (!this_present_algorithm || !that_present_algorithm) {
                return false;
            }
            if (!this.algorithm.equals(that.algorithm)) {
                return false;
            }
        }
        boolean this_present_byteLength = true;
        boolean that_present_byteLength = true;
        if (this_present_byteLength || that_present_byteLength) {
            if (!this_present_byteLength || !that_present_byteLength) {
                return false;
            }
            if (this.byteLength != that.byteLength) {
                return false;
            }
        }
        boolean this_present_salt = this.isSetSalt();
        boolean that_present_salt = that.isSetSalt();
        if (this_present_salt || that_present_salt) {
            if (!this_present_salt || !that_present_salt) {
                return false;
            }
            if (!this.salt.equals(that.salt)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetAccessToken() ? 131071 : 524287);
        if (this.isSetAccessToken()) {
            hashCode = hashCode * 8191 + this.accessToken.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetKeyId() ? 131071 : 524287);
        if (this.isSetKeyId()) {
            hashCode = hashCode * 8191 + this.keyId.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAlgorithm() ? 131071 : 524287);
        if (this.isSetAlgorithm()) {
            hashCode = hashCode * 8191 + this.algorithm.getValue();
        }
        hashCode = hashCode * 8191 + this.byteLength;
        hashCode = hashCode * 8191 + (this.isSetSalt() ? 131071 : 524287);
        if (this.isSetSalt()) {
            hashCode = hashCode * 8191 + this.salt.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(DeriveKeyRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetAccessToken(), other.isSetAccessToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAccessToken() && (lastComparison = TBaseHelper.compareTo(this.accessToken, other.accessToken)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetKeyId(), other.isSetKeyId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyId() && (lastComparison = TBaseHelper.compareTo(this.keyId, other.keyId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAlgorithm(), other.isSetAlgorithm());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAlgorithm() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.algorithm), (Comparable)((Object)other.algorithm))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetByteLength(), other.isSetByteLength());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetByteLength() && (lastComparison = TBaseHelper.compareTo(this.byteLength, other.byteLength)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSalt(), other.isSetSalt());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSalt() && (lastComparison = TBaseHelper.compareTo(this.salt, other.salt)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        DeriveKeyRequest.scheme(iprot).read(iprot, (DeriveKeyRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        DeriveKeyRequest.scheme(oprot).write(oprot, (DeriveKeyRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DeriveKeyRequest(");
        boolean first = true;
        sb.append("accessToken:");
        if (this.accessToken == null) {
            sb.append("null");
        } else {
            sb.append(this.accessToken);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("keyId:");
        if (this.keyId == null) {
            sb.append("null");
        } else {
            sb.append(this.keyId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("algorithm:");
        if (this.algorithm == null) {
            sb.append("null");
        } else {
            sb.append(this.algorithm);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("byteLength:");
        sb.append(this.byteLength);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("salt:");
        if (this.salt == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.salt, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.accessToken == null) {
            throw new TProtocolException("Required field 'accessToken' was not present! Struct: " + this.toString());
        }
        if (this.keyId == null) {
            throw new TProtocolException("Required field 'keyId' was not present! Struct: " + this.toString());
        }
        if (this.algorithm == null) {
            throw new TProtocolException("Required field 'algorithm' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ACCESS_TOKEN, new FieldMetaData("accessToken", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.KEY_ID, new FieldMetaData("keyId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ALGORITHM, new FieldMetaData("algorithm", 1, new EnumMetaData(16, DeriveAlgorithm.class)));
        tmpMap.put(_Fields.BYTE_LENGTH, new FieldMetaData("byteLength", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SALT, new FieldMetaData("salt", 3, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DeriveKeyRequest.class, metaDataMap);
    }

    private static class DeriveKeyRequestTupleScheme
    extends TupleScheme<DeriveKeyRequest> {
        private DeriveKeyRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, DeriveKeyRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.accessToken);
            oprot.writeString(struct.keyId);
            oprot.writeI32(struct.algorithm.getValue());
            oprot.writeI32(struct.byteLength);
            BitSet optionals = new BitSet();
            if (struct.isSetSalt()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetSalt()) {
                oprot.writeBinary(struct.salt);
            }
        }

        @Override
        public void read(TProtocol prot, DeriveKeyRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.accessToken = iprot.readString();
            struct.setAccessTokenIsSet(true);
            struct.keyId = iprot.readString();
            struct.setKeyIdIsSet(true);
            struct.algorithm = DeriveAlgorithm.findByValue(iprot.readI32());
            struct.setAlgorithmIsSet(true);
            struct.byteLength = iprot.readI32();
            struct.setByteLengthIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.salt = iprot.readBinary();
                struct.setSaltIsSet(true);
            }
        }
    }

    private static class DeriveKeyRequestTupleSchemeFactory
    implements SchemeFactory {
        private DeriveKeyRequestTupleSchemeFactory() {
        }

        public DeriveKeyRequestTupleScheme getScheme() {
            return new DeriveKeyRequestTupleScheme();
        }
    }

    private static class DeriveKeyRequestStandardScheme
    extends StandardScheme<DeriveKeyRequest> {
        private DeriveKeyRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, DeriveKeyRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.accessToken = iprot.readString();
                            struct.setAccessTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.keyId = iprot.readString();
                            struct.setKeyIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.algorithm = DeriveAlgorithm.findByValue(iprot.readI32());
                            struct.setAlgorithmIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.byteLength = iprot.readI32();
                            struct.setByteLengthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.salt = iprot.readBinary();
                            struct.setSaltIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetByteLength()) {
                throw new TProtocolException("Required field 'byteLength' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, DeriveKeyRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.accessToken != null) {
                oprot.writeFieldBegin(ACCESS_TOKEN_FIELD_DESC);
                oprot.writeString(struct.accessToken);
                oprot.writeFieldEnd();
            }
            if (struct.keyId != null) {
                oprot.writeFieldBegin(KEY_ID_FIELD_DESC);
                oprot.writeString(struct.keyId);
                oprot.writeFieldEnd();
            }
            if (struct.algorithm != null) {
                oprot.writeFieldBegin(ALGORITHM_FIELD_DESC);
                oprot.writeI32(struct.algorithm.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(BYTE_LENGTH_FIELD_DESC);
            oprot.writeI32(struct.byteLength);
            oprot.writeFieldEnd();
            if (struct.salt != null) {
                oprot.writeFieldBegin(SALT_FIELD_DESC);
                oprot.writeBinary(struct.salt);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class DeriveKeyRequestStandardSchemeFactory
    implements SchemeFactory {
        private DeriveKeyRequestStandardSchemeFactory() {
        }

        public DeriveKeyRequestStandardScheme getScheme() {
            return new DeriveKeyRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ACCESS_TOKEN(1, "accessToken"),
        KEY_ID(2, "keyId"),
        ALGORITHM(3, "algorithm"),
        BYTE_LENGTH(4, "byteLength"),
        SALT(5, "salt");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ACCESS_TOKEN;
                }
                case 2: {
                    return KEY_ID;
                }
                case 3: {
                    return ALGORITHM;
                }
                case 4: {
                    return BYTE_LENGTH;
                }
                case 5: {
                    return SALT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

