/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import kl.ssl.gmvpn.DigitallySigned;
import kl.ssl.gmvpn.crypto.TlsStreamVerifier;
import kl.ssl.gmvpn.crypto.TlsVerifier;
import kl.ssl.gmvpn.crypto.impl.jcajce.Exceptions;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;

public class JcaTlsRSAVerifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;
    private Signature rawVerifier = null;

    public JcaTlsRSAVerifier(JcaTlsCrypto crypto, PublicKey publicKey) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) throws IOException {
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) throws IOException {
        try {
            Signature verifier = this.getRawVerifier();
            AlgorithmIdentifier algID = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sha512, (ASN1Encodable)DERNull.INSTANCE);
            byte[] digestInfo = new DigestInfo(algID, hash).getEncoded();
            verifier.update(digestInfo, 0, digestInfo.length);
            return verifier.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }

    protected Signature getRawVerifier() throws GeneralSecurityException {
        if (this.rawVerifier == null) {
            this.rawVerifier = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawVerifier.initVerify(this.publicKey);
        }
        return this.rawVerifier;
    }
}

