/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum Algorithm implements TEnum
{
    RSAES_OAEP_SHA_256(1),
    RSAES_OAEP_SHA_1(2),
    SM2PKE(3),
    RSA_PASS_SHA_256(4),
    RSA_PKCS1_SHA_256(5),
    SM2DSA(6);

    private final int value;

    private Algorithm(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static Algorithm findByValue(int value) {
        switch (value) {
            case 1: {
                return RSAES_OAEP_SHA_256;
            }
            case 2: {
                return RSAES_OAEP_SHA_1;
            }
            case 3: {
                return SM2PKE;
            }
            case 4: {
                return RSA_PASS_SHA_256;
            }
            case 5: {
                return RSA_PKCS1_SHA_256;
            }
            case 6: {
                return SM2DSA;
            }
        }
        return null;
    }
}

