/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import com.ghca.kms.thrift.api.KeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class GenerateDataKeyRequest
implements TBase<GenerateDataKeyRequest, _Fields>,
Serializable,
Cloneable,
Comparable<GenerateDataKeyRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("GenerateDataKeyRequest");
    private static final TField KEY_ID_FIELD_DESC = new TField("keyId", 11, 1);
    private static final TField KEY_SPEC_FIELD_DESC = new TField("keySpec", 8, 2);
    private static final TField NUMBER_OF_BYTES_FIELD_DESC = new TField("numberOfBytes", 8, 3);
    private static final TField ENCRYPTION_CONTEXT_FIELD_DESC = new TField("encryptionContext", 13, 4);
    private static final TField ACCESS_TOKEN_FIELD_DESC = new TField("accessToken", 11, 5);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new GenerateDataKeyRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new GenerateDataKeyRequestTupleSchemeFactory();
    @Nullable
    public String keyId;
    @Nullable
    public KeySpec keySpec;
    public int numberOfBytes;
    @Nullable
    public Map<String, String> encryptionContext;
    @Nullable
    public String accessToken;
    private static final int __NUMBEROFBYTES_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public GenerateDataKeyRequest() {
        this.keySpec = KeySpec.SM4;
    }

    public GenerateDataKeyRequest(String keyId, KeySpec keySpec, int numberOfBytes, Map<String, String> encryptionContext, String accessToken) {
        this();
        this.keyId = keyId;
        this.keySpec = keySpec;
        this.numberOfBytes = numberOfBytes;
        this.setNumberOfBytesIsSet(true);
        this.encryptionContext = encryptionContext;
        this.accessToken = accessToken;
    }

    public GenerateDataKeyRequest(GenerateDataKeyRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetKeyId()) {
            this.keyId = other.keyId;
        }
        if (other.isSetKeySpec()) {
            this.keySpec = other.keySpec;
        }
        this.numberOfBytes = other.numberOfBytes;
        if (other.isSetEncryptionContext()) {
            HashMap<String, String> __this__encryptionContext = new HashMap<String, String>(other.encryptionContext);
            this.encryptionContext = __this__encryptionContext;
        }
        if (other.isSetAccessToken()) {
            this.accessToken = other.accessToken;
        }
    }

    @Override
    public GenerateDataKeyRequest deepCopy() {
        return new GenerateDataKeyRequest(this);
    }

    @Override
    public void clear() {
        this.keyId = null;
        this.keySpec = KeySpec.SM4;
        this.setNumberOfBytesIsSet(false);
        this.numberOfBytes = 0;
        this.encryptionContext = null;
        this.accessToken = null;
    }

    @Nullable
    public String getKeyId() {
        return this.keyId;
    }

    public GenerateDataKeyRequest setKeyId(@Nullable String keyId) {
        this.keyId = keyId;
        return this;
    }

    public void unsetKeyId() {
        this.keyId = null;
    }

    public boolean isSetKeyId() {
        return this.keyId != null;
    }

    public void setKeyIdIsSet(boolean value) {
        if (!value) {
            this.keyId = null;
        }
    }

    @Nullable
    public KeySpec getKeySpec() {
        return this.keySpec;
    }

    public GenerateDataKeyRequest setKeySpec(@Nullable KeySpec keySpec) {
        this.keySpec = keySpec;
        return this;
    }

    public void unsetKeySpec() {
        this.keySpec = null;
    }

    public boolean isSetKeySpec() {
        return this.keySpec != null;
    }

    public void setKeySpecIsSet(boolean value) {
        if (!value) {
            this.keySpec = null;
        }
    }

    public int getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public GenerateDataKeyRequest setNumberOfBytes(int numberOfBytes) {
        this.numberOfBytes = numberOfBytes;
        this.setNumberOfBytesIsSet(true);
        return this;
    }

    public void unsetNumberOfBytes() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetNumberOfBytes() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setNumberOfBytesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getEncryptionContextSize() {
        return this.encryptionContext == null ? 0 : this.encryptionContext.size();
    }

    public void putToEncryptionContext(String key, String val) {
        if (this.encryptionContext == null) {
            this.encryptionContext = new HashMap<String, String>();
        }
        this.encryptionContext.put(key, val);
    }

    @Nullable
    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public GenerateDataKeyRequest setEncryptionContext(@Nullable Map<String, String> encryptionContext) {
        this.encryptionContext = encryptionContext;
        return this;
    }

    public void unsetEncryptionContext() {
        this.encryptionContext = null;
    }

    public boolean isSetEncryptionContext() {
        return this.encryptionContext != null;
    }

    public void setEncryptionContextIsSet(boolean value) {
        if (!value) {
            this.encryptionContext = null;
        }
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public GenerateDataKeyRequest setAccessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public void unsetAccessToken() {
        this.accessToken = null;
    }

    public boolean isSetAccessToken() {
        return this.accessToken != null;
    }

    public void setAccessTokenIsSet(boolean value) {
        if (!value) {
            this.accessToken = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case KEY_ID: {
                if (value == null) {
                    this.unsetKeyId();
                    break;
                }
                this.setKeyId((String)value);
                break;
            }
            case KEY_SPEC: {
                if (value == null) {
                    this.unsetKeySpec();
                    break;
                }
                this.setKeySpec((KeySpec)value);
                break;
            }
            case NUMBER_OF_BYTES: {
                if (value == null) {
                    this.unsetNumberOfBytes();
                    break;
                }
                this.setNumberOfBytes((Integer)value);
                break;
            }
            case ENCRYPTION_CONTEXT: {
                if (value == null) {
                    this.unsetEncryptionContext();
                    break;
                }
                this.setEncryptionContext((Map)value);
                break;
            }
            case ACCESS_TOKEN: {
                if (value == null) {
                    this.unsetAccessToken();
                    break;
                }
                this.setAccessToken((String)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY_ID: {
                return this.getKeyId();
            }
            case KEY_SPEC: {
                return this.getKeySpec();
            }
            case NUMBER_OF_BYTES: {
                return this.getNumberOfBytes();
            }
            case ENCRYPTION_CONTEXT: {
                return this.getEncryptionContext();
            }
            case ACCESS_TOKEN: {
                return this.getAccessToken();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY_ID: {
                return this.isSetKeyId();
            }
            case KEY_SPEC: {
                return this.isSetKeySpec();
            }
            case NUMBER_OF_BYTES: {
                return this.isSetNumberOfBytes();
            }
            case ENCRYPTION_CONTEXT: {
                return this.isSetEncryptionContext();
            }
            case ACCESS_TOKEN: {
                return this.isSetAccessToken();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof GenerateDataKeyRequest) {
            return this.equals((GenerateDataKeyRequest)that);
        }
        return false;
    }

    public boolean equals(GenerateDataKeyRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_keyId = this.isSetKeyId();
        boolean that_present_keyId = that.isSetKeyId();
        if (this_present_keyId || that_present_keyId) {
            if (!this_present_keyId || !that_present_keyId) {
                return false;
            }
            if (!this.keyId.equals(that.keyId)) {
                return false;
            }
        }
        boolean this_present_keySpec = this.isSetKeySpec();
        boolean that_present_keySpec = that.isSetKeySpec();
        if (this_present_keySpec || that_present_keySpec) {
            if (!this_present_keySpec || !that_present_keySpec) {
                return false;
            }
            if (!this.keySpec.equals(that.keySpec)) {
                return false;
            }
        }
        boolean this_present_numberOfBytes = true;
        boolean that_present_numberOfBytes = true;
        if (this_present_numberOfBytes || that_present_numberOfBytes) {
            if (!this_present_numberOfBytes || !that_present_numberOfBytes) {
                return false;
            }
            if (this.numberOfBytes != that.numberOfBytes) {
                return false;
            }
        }
        boolean this_present_encryptionContext = this.isSetEncryptionContext();
        boolean that_present_encryptionContext = that.isSetEncryptionContext();
        if (this_present_encryptionContext || that_present_encryptionContext) {
            if (!this_present_encryptionContext || !that_present_encryptionContext) {
                return false;
            }
            if (!this.encryptionContext.equals(that.encryptionContext)) {
                return false;
            }
        }
        boolean this_present_accessToken = this.isSetAccessToken();
        boolean that_present_accessToken = that.isSetAccessToken();
        if (this_present_accessToken || that_present_accessToken) {
            if (!this_present_accessToken || !that_present_accessToken) {
                return false;
            }
            if (!this.accessToken.equals(that.accessToken)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetKeyId() ? 131071 : 524287);
        if (this.isSetKeyId()) {
            hashCode = hashCode * 8191 + this.keyId.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetKeySpec() ? 131071 : 524287);
        if (this.isSetKeySpec()) {
            hashCode = hashCode * 8191 + this.keySpec.getValue();
        }
        hashCode = hashCode * 8191 + this.numberOfBytes;
        hashCode = hashCode * 8191 + (this.isSetEncryptionContext() ? 131071 : 524287);
        if (this.isSetEncryptionContext()) {
            hashCode = hashCode * 8191 + this.encryptionContext.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAccessToken() ? 131071 : 524287);
        if (this.isSetAccessToken()) {
            hashCode = hashCode * 8191 + this.accessToken.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(GenerateDataKeyRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetKeyId(), other.isSetKeyId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyId() && (lastComparison = TBaseHelper.compareTo(this.keyId, other.keyId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetKeySpec(), other.isSetKeySpec());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeySpec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.keySpec), (Comparable)((Object)other.keySpec))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNumberOfBytes(), other.isSetNumberOfBytes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumberOfBytes() && (lastComparison = TBaseHelper.compareTo(this.numberOfBytes, other.numberOfBytes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEncryptionContext(), other.isSetEncryptionContext());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncryptionContext() && (lastComparison = TBaseHelper.compareTo(this.encryptionContext, other.encryptionContext)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAccessToken(), other.isSetAccessToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAccessToken() && (lastComparison = TBaseHelper.compareTo(this.accessToken, other.accessToken)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        GenerateDataKeyRequest.scheme(iprot).read(iprot, (GenerateDataKeyRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        GenerateDataKeyRequest.scheme(oprot).write(oprot, (GenerateDataKeyRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GenerateDataKeyRequest(");
        boolean first = true;
        sb.append("keyId:");
        if (this.keyId == null) {
            sb.append("null");
        } else {
            sb.append(this.keyId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("keySpec:");
        if (this.keySpec == null) {
            sb.append("null");
        } else {
            sb.append(this.keySpec);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numberOfBytes:");
        sb.append(this.numberOfBytes);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("encryptionContext:");
        if (this.encryptionContext == null) {
            sb.append("null");
        } else {
            sb.append(this.encryptionContext);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("accessToken:");
        if (this.accessToken == null) {
            sb.append("null");
        } else {
            sb.append(this.accessToken);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.keyId == null) {
            throw new TProtocolException("Required field 'keyId' was not present! Struct: " + this.toString());
        }
        if (this.accessToken == null) {
            throw new TProtocolException("Required field 'accessToken' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY_ID, new FieldMetaData("keyId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.KEY_SPEC, new FieldMetaData("keySpec", 3, new EnumMetaData(16, KeySpec.class)));
        tmpMap.put(_Fields.NUMBER_OF_BYTES, new FieldMetaData("numberOfBytes", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ENCRYPTION_CONTEXT, new FieldMetaData("encryptionContext", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ACCESS_TOKEN, new FieldMetaData("accessToken", 1, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(GenerateDataKeyRequest.class, metaDataMap);
    }

    private static class GenerateDataKeyRequestTupleScheme
    extends TupleScheme<GenerateDataKeyRequest> {
        private GenerateDataKeyRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, GenerateDataKeyRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.keyId);
            oprot.writeString(struct.accessToken);
            BitSet optionals = new BitSet();
            if (struct.isSetKeySpec()) {
                optionals.set(0);
            }
            if (struct.isSetNumberOfBytes()) {
                optionals.set(1);
            }
            if (struct.isSetEncryptionContext()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetKeySpec()) {
                oprot.writeI32(struct.keySpec.getValue());
            }
            if (struct.isSetNumberOfBytes()) {
                oprot.writeI32(struct.numberOfBytes);
            }
            if (struct.isSetEncryptionContext()) {
                oprot.writeI32(struct.encryptionContext.size());
                for (Map.Entry<String, String> _iter15 : struct.encryptionContext.entrySet()) {
                    oprot.writeString(_iter15.getKey());
                    oprot.writeString(_iter15.getValue());
                }
            }
        }

        @Override
        public void read(TProtocol prot, GenerateDataKeyRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.keyId = iprot.readString();
            struct.setKeyIdIsSet(true);
            struct.accessToken = iprot.readString();
            struct.setAccessTokenIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.keySpec = KeySpec.findByValue(iprot.readI32());
                struct.setKeySpecIsSet(true);
            }
            if (incoming.get(1)) {
                struct.numberOfBytes = iprot.readI32();
                struct.setNumberOfBytesIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map16 = iprot.readMapBegin((byte)11, (byte)11);
                struct.encryptionContext = new HashMap<String, String>(2 * _map16.size);
                for (int _i19 = 0; _i19 < _map16.size; ++_i19) {
                    String _key17 = iprot.readString();
                    String _val18 = iprot.readString();
                    struct.encryptionContext.put(_key17, _val18);
                }
                struct.setEncryptionContextIsSet(true);
            }
        }
    }

    private static class GenerateDataKeyRequestTupleSchemeFactory
    implements SchemeFactory {
        private GenerateDataKeyRequestTupleSchemeFactory() {
        }

        public GenerateDataKeyRequestTupleScheme getScheme() {
            return new GenerateDataKeyRequestTupleScheme();
        }
    }

    private static class GenerateDataKeyRequestStandardScheme
    extends StandardScheme<GenerateDataKeyRequest> {
        private GenerateDataKeyRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, GenerateDataKeyRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.keyId = iprot.readString();
                            struct.setKeyIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.keySpec = KeySpec.findByValue(iprot.readI32());
                            struct.setKeySpecIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.numberOfBytes = iprot.readI32();
                            struct.setNumberOfBytesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map10 = iprot.readMapBegin();
                            struct.encryptionContext = new HashMap<String, String>(2 * _map10.size);
                            for (int _i13 = 0; _i13 < _map10.size; ++_i13) {
                                String _key11 = iprot.readString();
                                String _val12 = iprot.readString();
                                struct.encryptionContext.put(_key11, _val12);
                            }
                            iprot.readMapEnd();
                            struct.setEncryptionContextIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.accessToken = iprot.readString();
                            struct.setAccessTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, GenerateDataKeyRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.keyId != null) {
                oprot.writeFieldBegin(KEY_ID_FIELD_DESC);
                oprot.writeString(struct.keyId);
                oprot.writeFieldEnd();
            }
            if (struct.keySpec != null) {
                oprot.writeFieldBegin(KEY_SPEC_FIELD_DESC);
                oprot.writeI32(struct.keySpec.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(NUMBER_OF_BYTES_FIELD_DESC);
            oprot.writeI32(struct.numberOfBytes);
            oprot.writeFieldEnd();
            if (struct.encryptionContext != null) {
                oprot.writeFieldBegin(ENCRYPTION_CONTEXT_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.encryptionContext.size()));
                for (Map.Entry<String, String> _iter14 : struct.encryptionContext.entrySet()) {
                    oprot.writeString(_iter14.getKey());
                    oprot.writeString(_iter14.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.accessToken != null) {
                oprot.writeFieldBegin(ACCESS_TOKEN_FIELD_DESC);
                oprot.writeString(struct.accessToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class GenerateDataKeyRequestStandardSchemeFactory
    implements SchemeFactory {
        private GenerateDataKeyRequestStandardSchemeFactory() {
        }

        public GenerateDataKeyRequestStandardScheme getScheme() {
            return new GenerateDataKeyRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY_ID(1, "keyId"),
        KEY_SPEC(2, "keySpec"),
        NUMBER_OF_BYTES(3, "numberOfBytes"),
        ENCRYPTION_CONTEXT(4, "encryptionContext"),
        ACCESS_TOKEN(5, "accessToken");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEY_ID;
                }
                case 2: {
                    return KEY_SPEC;
                }
                case 3: {
                    return NUMBER_OF_BYTES;
                }
                case 4: {
                    return ENCRYPTION_CONTEXT;
                }
                case 5: {
                    return ACCESS_TOKEN;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

