/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.Mode;
import com.koal.kms.sdk.ed.ClientBuilder;
import com.koal.kms.sdk.ed.CompressUtil;
import com.koal.kms.sdk.ed.DataKey;
import com.koal.kms.sdk.ed.KmsCache;
import com.koal.kms.sdk.ed.KmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsSdkException;
import com.koal.kms.sdk.ed.KmsUtil;
import com.koal.kms.sdk.ed.RandomSource;
import com.koal.kms.sdk.ed.SignatureVerificationKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KmsGm {
    static final byte[] IV;
    static final byte[] IV_NONE;
    static final int KEY_LEN = 32;
    static final int ID_LEN = 36;
    static final int SM4_IV_LEN = 16;
    static final int SIGN_PUBLIC_KEY_LEN = 91;
    static final String ADD = "AQIDBAUG";

    static byte[] encryptBySm4(byte[] plainData) throws KmsSdkException {
        DataKey key = KmsCache.CACHE.getEncrypt();
        byte[] iv = KmsUtil.generateRandom(16, RandomSource.LOCAL_RANDOM);
        byte[] cipherData = KmsGm.sm4EncryptPkcs7Padding(key.getPlainKey(), plainData, iv);
        byte[] cipherKey = key.getCipherKey();
        byte[] cmkId = key.getCmkId().getBytes();
        cmkId = CompressUtil.compressCmkIdAndIv(cmkId, iv);
        int total = cipherData.length + cipherKey.length + cmkId.length;
        byte[] temp = new byte[total];
        System.arraycopy(cipherData, 0, temp, 0, cipherData.length);
        System.arraycopy(cipherKey, 0, temp, cipherData.length, cipherKey.length);
        System.arraycopy(cmkId, 0, temp, cipherData.length + cipherKey.length, cmkId.length);
        return temp;
    }

    public static byte[] encryptBySm4Old(byte[] plainData) throws KmsSdkException {
        DataKey key = KmsCache.CACHE.getEncrypt();
        if (!KmsClientConfig.getInstance().getLocal().booleanValue()) {
            try {
                KmsClient instance = ClientBuilder.getInstance();
                String cipherText = instance.symmetricEncryptByDataKey(KmsClientConfig.getInstance().getCrtKeyId(), key.getDataKeyId(), Base64.getEncoder().encodeToString(plainData), Mode.CBC, null);
                return Base64.getDecoder().decode(cipherText);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        byte[] cipherData = KmsGm.sm4EncryptPkcs7Padding(key.getPlainKey(), plainData);
        byte[] cipherKey = key.getCipherKey();
        byte[] cmkId = key.getCmkId().getBytes();
        int total = cipherData.length + cipherKey.length + cmkId.length;
        byte[] temp = new byte[total];
        System.arraycopy(cipherData, 0, temp, 0, cipherData.length);
        System.arraycopy(cipherKey, 0, temp, cipherData.length, cipherKey.length);
        System.arraycopy(cmkId, 0, temp, cipherData.length + cipherKey.length, cmkId.length);
        return temp;
    }

    static byte[] decryptBySm4(byte[] cipherData) throws KmsSdkException {
        byte[] data = Arrays.copyOfRange(cipherData, 0, cipherData.length - 32 - 36);
        byte[] cipherKey = Arrays.copyOfRange(cipherData, data.length, data.length + 32);
        byte[] cmkIdIv = Arrays.copyOfRange(cipherData, data.length + 32, cipherData.length);
        CompressUtil.CmkIdAndIv cmkIdAndIv = CompressUtil.uncompressCmkIdAndIv(cmkIdIv);
        DataKey key = KmsCache.CACHE.getDecrypt(cipherKey, new String(cmkIdAndIv.getCmkId()));
        if (!KmsClientConfig.getInstance().getLocal().booleanValue()) {
            try {
                KmsClient instance = ClientBuilder.getInstance();
                String plainText = instance.symmetricDecryptByDataKey(key.getDataKeyId(), Base64.getEncoder().encodeToString(cipherData), Mode.CBC, Base64.getEncoder().encodeToString(key.getCipherKey()));
                return Base64.getDecoder().decode(plainText);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return KmsGm.sm4DecryptPkcs7Padding(key.getPlainKey(), data, cmkIdAndIv.getIv());
    }

    static KeyPair generateSm2KeyPair() {
        try {
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            keyPairGenerator.initialize(sm2Spec, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] signBySm2(byte[] digest) {
        SignatureVerificationKey key = KmsCache.CACHE.getSign();
        byte[] signed = KmsGm.sign(key.getPrivateKey(), digest);
        byte[] pulKey = key.getPublicKey().getEncoded();
        int total = signed.length + pulKey.length;
        byte[] temp = new byte[total];
        System.arraycopy(signed, 0, temp, 0, signed.length);
        System.arraycopy(pulKey, 0, temp, signed.length, pulKey.length);
        return temp;
    }

    static boolean verifySignBySm2(byte[] digest, byte[] signedTemp) {
        boolean signedSuccess = false;
        try {
            byte[] signed = Arrays.copyOfRange(signedTemp, 0, signedTemp.length - 91);
            byte[] publicKeyByte = Arrays.copyOfRange(signedTemp, signed.length, signedTemp.length);
            PublicKey publicKey = KmsGm.getPublicKey(publicKeyByte);
            signedSuccess = KmsGm.verifySign(publicKey, digest, signed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signedSuccess;
    }

    static byte[] hmacSM3Encrypt(byte[] plainData) {
        try {
            DataKey key = KmsCache.CACHE.getEncrypt();
            byte[] hmacData = KmsGm.doHmacSm3(key.getPlainKey(), plainData);
            byte[] cipherKey = key.getCipherKey();
            byte[] cmkId = key.getCmkId().getBytes();
            int total = hmacData.length + cipherKey.length + cmkId.length;
            byte[] result = new byte[total];
            System.arraycopy(hmacData, 0, result, 0, hmacData.length);
            System.arraycopy(cipherKey, 0, result, hmacData.length, cipherKey.length);
            System.arraycopy(cmkId, 0, result, hmacData.length + cipherKey.length, cmkId.length);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static boolean verifyHmacSm3(byte[] plainData, byte[] hmacData) {
        try {
            byte[] data = Arrays.copyOfRange(hmacData, 0, hmacData.length - 32 - 36);
            byte[] cipherKey = Arrays.copyOfRange(hmacData, data.length, data.length + 32);
            byte[] cmkId = Arrays.copyOfRange(hmacData, data.length + 32, hmacData.length);
            DataKey key = KmsCache.CACHE.getDecrypt(cipherKey, new String(cmkId));
            byte[] newData = KmsGm.doHmacSm3(key.getPlainKey(), plainData);
            return Arrays.equals(data, newData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] doHmacSm3(byte[] keyData, byte[] plainData) {
        KeyParameter keyParameter = new KeyParameter(keyData);
        SM3Digest sm3 = new SM3Digest();
        HMac mac = new HMac((Digest)sm3);
        mac.init((CipherParameters)keyParameter);
        mac.update(plainData, 0, plainData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static String bytesToHexString(byte[] bArr) {
        StringBuilder sb = new StringBuilder(bArr.length);
        for (byte b : bArr) {
            String sTmp = Integer.toHexString(0xFF & b);
            if (sTmp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTmp.toUpperCase());
        }
        return sb.toString();
    }

    static byte[] sm4Encrypt(byte[] keyBytes, byte[] plain) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher out = Cipher.getInstance("SM4/CBC/NoPadding", "BC");
            out.init(1, (Key)key, new IvParameterSpec(IV));
            return out.doFinal(plain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm4EncryptPkcs7PaddingIv(byte[] keyBytes, byte[] plain) {
        return KmsGm.sm4EncryptPadding(keyBytes, plain, IV);
    }

    private static byte[] sm4EncryptPadding(byte[] keyBytes, byte[] plain, byte[] iv) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher out = Cipher.getInstance("SM4/CBC/PKCS7Padding", "BC");
            out.init(1, (Key)key, new IvParameterSpec(iv));
            return out.doFinal(plain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] sm4EncryptPkcs7Padding(byte[] keyBytes, byte[] plain) {
        return KmsGm.sm4EncryptPadding(keyBytes, plain, IV_NONE);
    }

    static byte[] sm4EncryptPkcs7Padding(byte[] keyBytes, byte[] plain, byte[] iv) {
        return KmsGm.sm4EncryptPadding(keyBytes, plain, iv);
    }

    public static byte[] sm4Decrypt(byte[] keyBytes, byte[] cipher) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher in = Cipher.getInstance("SM4/CBC/NoPadding", "BC");
            in.init(2, (Key)key, new IvParameterSpec(IV));
            return in.doFinal(cipher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm4GCMDecrypt(byte[] keyBytes, byte[] cipher) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher in = Cipher.getInstance("SM4/GCM/NoPadding", "BC");
            in.init(2, (Key)key, new IvParameterSpec(IV));
            return in.doFinal(cipher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm4DecryptPkcs7PaddingIv(byte[] keyBytes, byte[] cipher) {
        return KmsGm.sm4DecryptPadding(keyBytes, cipher, IV);
    }

    public static byte[] sm4DecryptPadding(byte[] keyBytes, byte[] cipher, byte[] iv) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher in = Cipher.getInstance("SM4/CBC/PKCS7Padding", "BC");
            in.init(2, (Key)key, new IvParameterSpec(iv));
            return in.doFinal(cipher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm4DecryptPkcs7Padding(byte[] keyBytes, byte[] cipher) {
        return KmsGm.sm4DecryptPadding(keyBytes, cipher, IV_NONE);
    }

    static byte[] sm4DecryptPkcs7Padding(byte[] keyBytes, byte[] cipher, byte[] iv) {
        return KmsGm.sm4DecryptPadding(keyBytes, cipher, iv);
    }

    static byte[] sign(PrivateKey privateKey, byte[] plainText) {
        try {
            Signature sign = Signature.getInstance("SM3withSM2", "BC");
            sign.initSign(privateKey);
            sign.update(plainText);
            return sign.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean verifySign(PublicKey publicKey, byte[] digest, byte[] signed) {
        boolean signedSuccess;
        try {
            Signature verifySign = Signature.getInstance("SM3withSM2", "BC");
            verifySign.initVerify(publicKey);
            verifySign.update(digest);
            signedSuccess = verifySign.verify(signed);
        }
        catch (SignatureException e) {
            signedSuccess = false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        return signedSuccess;
    }

    static PublicKey getPublicKey(byte[] key) {
        try {
            KeyFactory kf = KeyFactory.getInstance("EC");
            return kf.generatePublic(new X509EncodedKeySpec(key));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        IV = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 4, 3, 2};
        IV_NONE = new byte[16];
    }
}

