/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.koal.kms.sdk.ed.KmsGm;
import com.koal.kms.sdk.ed.KmsSdkException;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.util.encoders.Hex;

public class CompressUtil {
    private static final Set<Integer> position = new HashSet<Integer>();

    static byte[] compressCmkIdAndIv(byte[] cmkId, byte[] iv) throws KmsSdkException {
        if (cmkId.length != 36) {
            throw new KmsSdkException("cmkId\u957f\u5ea6\u5e94\u4e3a36\uff0c\u5f53\u524d\u957f\u5ea6\uff1a" + cmkId.length);
        }
        if (iv.length != 16) {
            throw new KmsSdkException("iv\u957f\u5ea6\u5e94\u4e3a16\uff0c\u5f53\u524d\u957f\u5ea6\uff1a" + iv.length);
        }
        byte[] result = new byte[36];
        int index = 0;
        for (int i = 0; i < cmkId.length; ++i) {
            if (cmkId[i] == 45) {
                result[index] = 43;
                ++index;
                continue;
            }
            byte[] bytes = Hex.decode((String)new String(new byte[]{cmkId[i], cmkId[i + 1]}));
            result[index] = bytes[0];
            ++index;
            ++i;
        }
        System.arraycopy(iv, 0, result, 20, 16);
        return result;
    }

    static CmkIdAndIv uncompressCmkIdAndIv(byte[] bytes) throws KmsSdkException {
        boolean isCompress;
        if (bytes.length != 36) {
            throw new KmsSdkException("cmkId\u548cIv\u538b\u7f29\u957f\u5ea6\u5e94\u4e3a36\uff0c\u5f53\u524d\u957f\u5ea6\uff1a" + bytes.length);
        }
        byte[] cmkBytes = new byte[20];
        byte[] ivBytes = new byte[16];
        System.arraycopy(bytes, 0, cmkBytes, 0, cmkBytes.length);
        System.arraycopy(bytes, cmkBytes.length, ivBytes, 0, ivBytes.length);
        boolean bl = isCompress = bytes[13] == 43;
        if (!isCompress) {
            return new CmkIdAndIv(bytes, KmsGm.IV_NONE);
        }
        byte[] cmkId = new byte[36];
        int index = 0;
        for (int i = 0; i < cmkBytes.length; ++i) {
            byte cmkByte = cmkBytes[i];
            if (position.contains(i)) {
                cmkId[index] = 45;
                ++index;
                continue;
            }
            byte[] bytes1 = Hex.encode((byte[])new byte[]{cmkByte});
            cmkId[index] = bytes1[0];
            cmkId[++index] = bytes1[1];
            ++index;
        }
        return new CmkIdAndIv(cmkId, ivBytes);
    }

    public static void main(String[] args) throws KmsSdkException {
        String id = "6cbc757f-c269-4509-a64b-0d9b5b29b4f9";
        byte[] compress = CompressUtil.compressCmkIdAndIv(id.getBytes(), KmsGm.IV);
        System.out.println(compress.length);
        System.out.println(Hex.toHexString((byte[])compress));
        CmkIdAndIv cmkIdAndIv = CompressUtil.uncompressCmkIdAndIv(compress);
        System.out.println(new String(cmkIdAndIv.getCmkId()));
        System.out.println(Hex.toHexString((byte[])cmkIdAndIv.getIv()));
    }

    static {
        position.add(4);
        position.add(7);
        position.add(10);
        position.add(13);
    }

    static class CmkIdAndIv {
        private byte[] cmkId;
        private byte[] iv;

        public CmkIdAndIv(byte[] cmkId, byte[] iv) {
            this.cmkId = cmkId;
            this.iv = iv;
        }

        public byte[] getCmkId() {
            return this.cmkId;
        }

        public void setCmkId(byte[] cmkId) {
            this.cmkId = cmkId;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public void setIv(byte[] iv) {
            this.iv = iv;
        }
    }
}

