/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kl.ssl.gmvpn.AbstractTlsKeyExchange;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.DigestInputBuffer;
import kl.ssl.gmvpn.TlsCredentialedDecryptor;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsRSAUtils;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsSecret;

public class TlsRSAKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsCertificate serverCertificateEnc;
    protected TlsSecret preMasterSecret;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 1: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsRSAKeyExchange(int keyExchange) {
        super(TlsRSAKeyExchange.checkKeyExchange(keyExchange));
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireDecryptorCredentials(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverCertificate = serverCertificate.getCertificateAt(0).useInRole(0, 1);
        this.serverCertificateEnc = serverCertificate.getCertificateAt(1).useInRole(0, 1);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{1, 64};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificateEnc, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        byte[] der = this.serverCertificateEnc.getEncoded();
        TlsUtils.writeUint24(der.length, digestBuffer);
        digestBuffer.write(der);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, input, this.serverCertificate, digestBuffer);
    }
}

