/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.CertificateRequest;
import kl.ssl.gmvpn.CertificateStatusRequest;
import kl.ssl.gmvpn.DefaultTlsClient;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.ServerName;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsAuthentication;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsServerCertificate;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import kl.ssl.jsse.BCSNIHostName;
import kl.ssl.jsse.BCSNIServerName;
import kl.ssl.jsse.provider.JsseSessionParameters;
import kl.ssl.jsse.provider.JsseUtils;
import kl.ssl.jsse.provider.PropertyUtils;
import kl.ssl.jsse.provider.ProvSSLConnection;
import kl.ssl.jsse.provider.ProvSSLParameters;
import kl.ssl.jsse.provider.ProvSSLSession;
import kl.ssl.jsse.provider.ProvSSLSessionContext;
import kl.ssl.jsse.provider.ProvSSLSessionHandshake;
import kl.ssl.jsse.provider.ProvSSLSessionResumed;
import kl.ssl.jsse.provider.ProvTlsManager;
import kl.ssl.jsse.provider.ProvTlsPeer;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;

class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSession sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager manager, ProvSSLParameters sslParameters) {
        super(manager.getContextData().getCrypto());
        this.manager = manager;
        this.sslParameters = sslParameters;
    }

    @Override
    protected Vector getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected CertificateStatusRequest getCertificateStatusRequest() {
        return null;
    }

    @Override
    protected Vector getSupportedGroups(Vector namedGroupRoles) {
        return null;
    }

    @Override
    protected Vector getSNIServerNames() {
        if (provEnableSNIExtension) {
            String peerHostSNI;
            List<BCSNIServerName> sniServerNames = this.sslParameters.getServerNames();
            if (null == sniServerNames && null != (peerHostSNI = this.manager.getPeerHostSNI()) && peerHostSNI.indexOf(46) > 0 && !IPAddress.isValid((String)peerHostSNI)) {
                try {
                    sniServerNames = Collections.singletonList(new BCSNIHostName(peerHostSNI));
                }
                catch (RuntimeException e) {
                    LOG.fine("Failed to add peer host as default SNI host_name: " + peerHostSNI);
                }
            }
            if (null != sniServerNames && !sniServerNames.isEmpty()) {
                Vector<ServerName> serverNames = new Vector<ServerName>(sniServerNames.size());
                for (BCSNIServerName sniServerName : sniServerNames) {
                    serverNames.addElement(new ServerName((short)sniServerName.getType(), sniServerName.getEncoded()));
                }
                return serverNames;
            }
        }
        return null;
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    @Override
    protected Vector getSupportedSignatureAlgorithms() {
        return JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                int selectedCipherSuite = ProvTlsClient.this.context.getSecurityParametersHandshake().getCipherSuite();
                int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(selectedCipherSuite);
                switch (keyExchangeAlgorithm) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(80);
                    }
                }
                short[] certTypes = certificateRequest.getCertificateTypes();
                if (certTypes == null || certTypes.length == 0) {
                    return null;
                }
                String[] keyTypes = new String[certTypes.length];
                for (int i = 0; i < certTypes.length; ++i) {
                    keyTypes[i] = JsseUtils.getAuthTypeClient(certTypes[i]);
                }
                Principal[] issuers = null;
                Vector cas = certificateRequest.getCertificateAuthorities();
                if (cas != null && cas.size() > 0) {
                    X500Name[] names = cas.toArray(new X500Name[cas.size()]);
                    Set<X500Principal> principals = JsseUtils.toX500Principals(names);
                    issuers = principals.toArray(new Principal[principals.size()]);
                }
                String alias = ProvTlsClient.this.manager.chooseClientAlias(keyTypes, issuers);
                TlsCrypto crypto = ProvTlsClient.this.getCrypto();
                if (!(crypto instanceof JcaTlsCrypto)) {
                    throw new UnsupportedOperationException();
                }
                X509ExtendedKeyManager x509KeyManager = ProvTlsClient.this.manager.getContextData().getX509KeyManager();
                PrivateKey privateKey = x509KeyManager.getPrivateKey(alias);
                Certificate certificate = JsseUtils.getCertificateMessage(crypto, x509KeyManager.getCertificateChain(alias));
                if (privateKey == null || certificate.isEmpty()) {
                    return null;
                }
                switch (keyExchangeAlgorithm) {
                    case 1: 
                    case 2: {
                        short signatureAlgorithm = certificate.getCertificateAt(0).getLegacySignatureAlgorithm();
                        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(ProvTlsClient.this.context, ProvTlsClient.this.context.getSecurityParametersHandshake().getClientSigAlgs(), signatureAlgorithm);
                        return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(ProvTlsClient.this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
                    }
                }
                throw new TlsFatalAlert(80);
            }

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                if (null == serverCertificate || null == serverCertificate.getCertificate() || serverCertificate.getCertificate().isEmpty()) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] chain = JsseUtils.getX509CertificateChain(ProvTlsClient.this.manager.getContextData().getCrypto(), serverCertificate.getCertificate());
                int selectedCipherSuite = ProvTlsClient.this.context.getSecurityParametersHandshake().getCipherSuite();
                String authType = JsseUtils.getAuthTypeServer(TlsUtils.getKeyExchangeAlgorithm(selectedCipherSuite));
                ProvTlsClient.this.manager.checkServerTrusted(chain, authType);
            }
        };
    }

    @Override
    public ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContext().getSupportedVersions(this.sslParameters.getProtocols());
    }

    @Override
    public TlsSession getSessionToResume() {
        TlsSession sessionToResume;
        ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
        ProvSSLSession availableSSLSession = sslSessionContext.getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
        if (null != availableSSLSession && null != (sessionToResume = availableSSLSession.getTlsSession()) && this.isResumable(availableSSLSession)) {
            this.sslSession = availableSSLSession;
            return sessionToResume;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        Level level;
        super.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        Level level2 = alertLevel == 1 ? Level.FINE : (level = alertDescription == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client raised", alertLevel, alertDescription);
            if (message != null) {
                msg = msg + ": " + message;
            }
            LOG.log(level, msg, cause);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level level;
        super.notifyAlertReceived(alertLevel, alertDescription);
        Level level2 = level = alertLevel == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client received", alertLevel, alertDescription);
            LOG.log(level, msg);
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession connectionTlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != connectionTlsSession) {
            ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
            String peerHost = this.manager.getPeerHost();
            int peerPort = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm());
            this.sslSession = sslSessionContext.reportSession(peerHost, peerPort, connectionTlsSession, jsseSessionParameters);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        boolean allowLegacyHelloMessages;
        if (!secureRenegotiation && !(allowLegacyHelloMessages = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.manager.getContext().validateNegotiatedCipherSuite(selectedCipherSuite);
        LOG.fine("Client notified of selected cipher suite: " + this.manager.getContext().getCipherSuiteString(selectedCipherSuite));
        super.notifySelectedCipherSuite(selectedCipherSuite);
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        String protocolString = this.manager.getContext().getProtocolString(serverVersion);
        LOG.fine("Client notified of selected protocol version: " + protocolString);
        super.notifyServerVersion(serverVersion);
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        boolean isResumed;
        boolean bl = isResumed = null != sessionID && sessionID.length > 0 && null != this.sslSession && Arrays.areEqual((byte[])sessionID, (byte[])this.sslSession.getId());
        if (isResumed) {
            LOG.fine("Server resumed session: " + Hex.toHexString((byte[])sessionID));
        } else {
            if (sessionID == null || sessionID.length < 1) {
                LOG.fine("Server did not specify a session ID");
            } else {
                LOG.fine("Server specified new session: " + Hex.toHexString((byte[])sessionID));
            }
            if (!this.manager.getEnableSessionCreation()) {
                throw new IllegalStateException("Server did not resume session and session creation is disabled");
            }
        }
        ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
        String peerHost = this.manager.getPeerHost();
        int peerPort = this.manager.getPeerPort();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProvSSLSessionHandshake handshakeSession = !isResumed ? new ProvSSLSessionHandshake(sslSessionContext, peerHost, peerPort, securityParameters) : new ProvSSLSessionResumed(sslSessionContext, peerHost, peerPort, securityParameters, this.sslSession.getTlsSession(), this.sslSession.getJsseSessionParameters());
        this.manager.notifyHandshakeSession(handshakeSession);
    }

    protected boolean isResumable(ProvSSLSession availableSSLSession) {
        String identificationProtocol;
        JsseSessionParameters jsseSessionParameters = availableSSLSession.getJsseSessionParameters();
        String endpointIDAlgorithm = this.sslParameters.getEndpointIdentificationAlgorithm();
        if (null != endpointIDAlgorithm && !endpointIDAlgorithm.equalsIgnoreCase(identificationProtocol = jsseSessionParameters.getIdentificationProtocol())) {
            LOG.finest("Session not resumed - endpoint ID algorithm mismatch; requested: " + endpointIDAlgorithm + ", session: " + identificationProtocol);
            return false;
        }
        return true;
    }
}

