/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.CertificateRequest;
import kl.ssl.gmvpn.CertificateStatus;
import kl.ssl.gmvpn.DigestInputBuffer;
import kl.ssl.gmvpn.DigitallySigned;
import kl.ssl.gmvpn.HashAlgorithm;
import kl.ssl.gmvpn.MACAlgorithm;
import kl.ssl.gmvpn.PRFAlgorithm;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.SessionParameters;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsAuthentication;
import kl.ssl.gmvpn.TlsClient;
import kl.ssl.gmvpn.TlsClientContext;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsCredentialedAgreement;
import kl.ssl.gmvpn.TlsCredentialedDecryptor;
import kl.ssl.gmvpn.TlsCredentialedSigner;
import kl.ssl.gmvpn.TlsCredentialedSignerAndDecryptor;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsHandshakeHash;
import kl.ssl.gmvpn.TlsKeyExchange;
import kl.ssl.gmvpn.TlsKeyExchangeFactory;
import kl.ssl.gmvpn.TlsObjectIdentifiers;
import kl.ssl.gmvpn.TlsProtocol;
import kl.ssl.gmvpn.TlsServer;
import kl.ssl.gmvpn.TlsServerCertificateImpl;
import kl.ssl.gmvpn.TlsServerContext;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsSessionImpl;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCipher;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsHash;
import kl.ssl.gmvpn.crypto.TlsSecret;
import kl.ssl.gmvpn.crypto.TlsStreamSigner;
import kl.ssl.gmvpn.crypto.TlsStreamVerifier;
import kl.ssl.gmvpn.crypto.TlsVerifier;
import kl.ssl.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Shorts;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public class TlsUtils {
    private static byte[] DOWNGRADE_TLS11 = Hex.decode((String)"444F574E47524400");
    private static byte[] DOWNGRADE_TLS12 = Hex.decode((String)"444F574E47524401");
    private static final Hashtable CERT_SIG_ALG_OIDS = TlsUtils.createCertSigAlgOIDs();
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    protected static short MINIMUM_HASH_STRICT = (short)2;
    protected static short MINIMUM_HASH_PREFERRED = (short)4;

    private static void addCertSigAlgOID(Hashtable h, ASN1ObjectIdentifier oid, short hashAlgorithm, short signatureAlgorithm) {
        h.put(oid.getId(), SignatureAndHashAlgorithm.getInstance(hashAlgorithm, signatureAlgorithm));
    }

    private static Hashtable createCertSigAlgOIDs() {
        Hashtable h = new Hashtable();
        TlsUtils.addCertSigAlgOID(h, GMObjectIdentifiers.sm2sign_with_sm3, (short)7, (short)12);
        TlsUtils.addCertSigAlgOID(h, OIWObjectIdentifiers.sha1WithRSA, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha1WithRSAEncryption, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha224WithRSAEncryption, (short)3, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha256WithRSAEncryption, (short)4, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha384WithRSAEncryption, (short)5, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha512WithRSAEncryption, (short)6, (short)1);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.id_dsa_with_sha1, (short)2, (short)2);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, (short)4, (short)1);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256, (short)8, (short)9);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_RSA_PSS_SHA_512, (short)8, (short)11);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA512, (short)6, (short)3);
        return h;
    }

    public static void checkUint8(short i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int i) throws IOException {
        if (!TlsUtils.isValidUint16(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long i) throws IOException {
        if (!TlsUtils.isValidUint16(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int i) throws IOException {
        if (!TlsUtils.isValidUint24(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long i) throws IOException {
        if (!TlsUtils.isValidUint24(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long i) throws IOException {
        if (!TlsUtils.isValidUint32(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long i) throws IOException {
        if (!TlsUtils.isValidUint48(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long i) throws IOException {
        if (!TlsUtils.isValidUint64(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint8(int i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint8(long i) {
        return (i & 0xFFL) == i;
    }

    public static boolean isValidUint16(int i) {
        return (i & 0xFFFF) == i;
    }

    public static boolean isValidUint16(long i) {
        return (i & 0xFFFFL) == i;
    }

    public static boolean isValidUint24(int i) {
        return (i & 0xFFFFFF) == i;
    }

    public static boolean isValidUint24(long i) {
        return (i & 0xFFFFFFL) == i;
    }

    public static boolean isValidUint32(long i) {
        return (i & 0xFFFFFFFFL) == i;
    }

    public static boolean isValidUint48(long i) {
        return (i & 0xFFFFFFFFFFFFL) == i;
    }

    public static boolean isValidUint64(long i) {
        return true;
    }

    public static boolean isTLSv10(ProtocolVersion version) {
        return ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv10(TlsContext context) {
        return TlsUtils.isTLSv10(context.getServerVersion());
    }

    public static boolean isTLSv11(ProtocolVersion version) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsContext context) {
        return TlsUtils.isTLSv11(context.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion version) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext context) {
        return TlsUtils.isTLSv12(context.getServerVersion());
    }

    public static boolean isTLSv13(ProtocolVersion version) {
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv13(TlsContext context) {
        return TlsUtils.isTLSv13(context.getServerVersion());
    }

    public static void writeUint8(short i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(int i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(short i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint8(int i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint16(int i, OutputStream output) throws IOException {
        output.write(i >>> 8);
        output.write(i);
    }

    public static void writeUint16(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 8);
        buf[offset + 1] = (byte)i;
    }

    public static void writeUint24(int i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint24(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 16);
        buf[offset + 1] = (byte)(i >>> 8);
        buf[offset + 2] = (byte)i;
    }

    public static void writeUint32(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint32(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 24);
        buf[offset + 1] = (byte)(i >>> 16);
        buf[offset + 2] = (byte)(i >>> 8);
        buf[offset + 3] = (byte)i;
    }

    public static void writeUint48(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 40));
        output.write((byte)(i >>> 32));
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint48(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 40);
        buf[offset + 1] = (byte)(i >>> 32);
        buf[offset + 2] = (byte)(i >>> 24);
        buf[offset + 3] = (byte)(i >>> 16);
        buf[offset + 4] = (byte)(i >>> 8);
        buf[offset + 5] = (byte)i;
    }

    public static void writeUint64(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 56));
        output.write((byte)(i >>> 48));
        output.write((byte)(i >>> 40));
        output.write((byte)(i >>> 32));
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint64(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 56);
        buf[offset + 1] = (byte)(i >>> 48);
        buf[offset + 2] = (byte)(i >>> 40);
        buf[offset + 3] = (byte)(i >>> 32);
        buf[offset + 4] = (byte)(i >>> 24);
        buf[offset + 5] = (byte)(i >>> 16);
        buf[offset + 6] = (byte)(i >>> 8);
        buf[offset + 7] = (byte)i;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint8(buf.length);
        TlsUtils.writeUint8(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque8(byte[] data, byte[] buf, int off) throws IOException {
        TlsUtils.checkUint8(data.length);
        TlsUtils.writeUint8(data.length, buf, off);
        System.arraycopy(data, 0, buf, off + 1, data.length);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint16(buf.length);
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint24(buf.length);
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint8(uints[i], output);
        }
    }

    public static void writeUint8Array(short[] uints, byte[] buf, int offset) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint8(uints[i], buf, offset);
            ++offset;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, OutputStream output) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, output);
        TlsUtils.writeUint8Array(uints, output);
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, byte[] buf, int offset) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, buf, offset);
        TlsUtils.writeUint8Array(uints, buf, offset + 1);
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint16(uints[i], output);
        }
    }

    public static void writeUint16Array(int[] uints, byte[] buf, int offset) throws IOException {
        for (int i = 0; i < uints.length; ++i) {
            TlsUtils.writeUint16(uints[i], buf, offset);
            offset += 2;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, OutputStream output) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        TlsUtils.writeUint16Array(uints, output);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, byte[] buf, int offset) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 2);
    }

    public static byte[] decodeOpaque8(byte[] buf) throws IOException {
        return TlsUtils.decodeOpaque8(buf, 0);
    }

    public static byte[] decodeOpaque8(byte[] buf, int minLength) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length < 1) {
            throw new TlsFatalAlert(50);
        }
        short length = TlsUtils.readUint8(buf, 0);
        if (buf.length != length + 1 || length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return Arrays.copyOfRange((byte[])buf, (int)1, (int)buf.length);
    }

    public static byte[] decodeOpaque16(byte[] buf) throws IOException {
        return TlsUtils.decodeOpaque16(buf, 0);
    }

    public static byte[] decodeOpaque16(byte[] buf, int minLength) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length < 2) {
            throw new TlsFatalAlert(50);
        }
        int length = TlsUtils.readUint16(buf, 0);
        if (buf.length != length + 2 || length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return Arrays.copyOfRange((byte[])buf, (int)2, (int)buf.length);
    }

    public static short decodeUint8(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 1) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8(buf, 0);
    }

    public static short[] decodeUint8ArrayWithUint8Length(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        int count = TlsUtils.readUint8(buf, 0);
        if (buf.length != count + 1) {
            throw new TlsFatalAlert(50);
        }
        short[] uints = new short[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint8(buf, i + 1);
        }
        return uints;
    }

    public static int decodeUint16(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 2) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint16(buf, 0);
    }

    public static long decodeUint32(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 4) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint32(buf, 0);
    }

    public static byte[] encodeOpaque8(byte[] buf) throws IOException {
        TlsUtils.checkUint8(buf.length);
        return Arrays.prepend((byte[])buf, (byte)((byte)buf.length));
    }

    public static byte[] encodeOpaque16(byte[] buf) throws IOException {
        return Arrays.concatenate((byte[])TlsUtils.encodeUint16(buf.length), (byte[])buf);
    }

    public static byte[] encodeUint8(short uint) throws IOException {
        TlsUtils.checkUint8(uint);
        byte[] encoding = new byte[1];
        TlsUtils.writeUint8(uint, encoding, 0);
        return encoding;
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] uints) throws IOException {
        byte[] result = new byte[1 + uints.length];
        TlsUtils.writeUint8ArrayWithUint8Length(uints, result, 0);
        return result;
    }

    public static byte[] encodeUint16(int uint) throws IOException {
        TlsUtils.checkUint16(uint);
        byte[] encoding = new byte[2];
        TlsUtils.writeUint16(uint, encoding, 0);
        return encoding;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] uints) throws IOException {
        int length = 2 * uints.length;
        byte[] result = new byte[2 + length];
        TlsUtils.writeUint16ArrayWithUint16Length(uints, result, 0);
        return result;
    }

    public static byte[] encodeUint32(long uint) throws IOException {
        TlsUtils.checkUint32(uint);
        byte[] encoding = new byte[4];
        TlsUtils.writeUint32(uint, encoding, 0);
        return encoding;
    }

    public static byte[] encodeVersion(ProtocolVersion version) throws IOException {
        return new byte[]{(byte)version.getMajorVersion(), (byte)version.getMinorVersion()};
    }

    public static short readUint8(InputStream input) throws IOException {
        int i = input.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (short)i;
    }

    public static short readUint8(byte[] buf, int offset) {
        return (short)(buf[offset] & 0xFF);
    }

    public static int readUint16(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        if (i3 < 0) {
            throw new EOFException();
        }
        return i1 << 16 | i2 << 8 | i3;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        int i4 = input.read();
        if (i4 < 0) {
            throw new EOFException();
        }
        return (long)(i1 << 24 | i2 << 16 | i3 << 8 | i4) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 24;
        n |= (buf[++offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return (long)(n |= buf[++offset] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream input) throws IOException {
        int hi = TlsUtils.readUint24(input);
        int lo = TlsUtils.readUint24(input);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] buf, int offset) {
        int hi = TlsUtils.readUint24(buf, offset);
        int lo = TlsUtils.readUint24(buf, offset + 3);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        int read = Streams.readFully((InputStream)input, (byte[])buf);
        if (read == 0) {
            return null;
        }
        if (read != length) {
            throw new EOFException();
        }
        return buf;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        if (length != Streams.readFully((InputStream)input, (byte[])buf)) {
            throw new EOFException();
        }
        return buf;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int length = buf.length;
        if (length > 0 && length != Streams.readFully((InputStream)input, (byte[])buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short length = TlsUtils.readUint8(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque8(InputStream input, int minLength) throws IOException {
        short length = TlsUtils.readUint8(input);
        if (length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque8(InputStream input, int minLength, int maxLength) throws IOException {
        short length = TlsUtils.readUint8(input);
        if (length < minLength || maxLength < length) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque16(InputStream input, int minLength) throws IOException {
        int length = TlsUtils.readUint16(input);
        if (length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int length = TlsUtils.readUint24(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque24(InputStream input, int minLength) throws IOException {
        int length = TlsUtils.readUint24(input);
        if (length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] uints = new short[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint8(input);
        }
        return uints;
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] uints = new int[count];
        for (int i = 0; i < count; ++i) {
            uints[i] = TlsUtils.readUint16(input);
        }
        return uints;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) throws IOException {
        try {
            return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(50, (Throwable)e);
        }
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        try {
            return ProtocolVersion.get(i1, i2);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(50, (Throwable)e);
        }
    }

    public static ASN1Primitive readASN1Object(byte[] encoding) throws IOException {
        ASN1InputStream asn1 = new ASN1InputStream(encoding);
        ASN1Primitive result = asn1.readObject();
        if (null == result) {
            throw new TlsFatalAlert(50);
        }
        if (null != asn1.readObject()) {
            throw new TlsFatalAlert(50);
        }
        return result;
    }

    public static ASN1Primitive readDERObject(byte[] encoding) throws IOException {
        ASN1Primitive result = TlsUtils.readASN1Object(encoding);
        byte[] check = result.getEncoded("DER");
        if (!Arrays.areEqual((byte[])check, (byte[])encoding)) {
            throw new TlsFatalAlert(50);
        }
        return result;
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int t = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(t >>> 24);
        buf[offset + 1] = (byte)(t >>> 16);
        buf[offset + 2] = (byte)(t >>> 8);
        buf[offset + 3] = (byte)t;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static void addIfSupported(Vector supportedAlgs, TlsCrypto crypto, SignatureAndHashAlgorithm alg) {
        if (crypto.hasSignatureAndHashAlgorithm(alg)) {
            supportedAlgs.addElement(alg);
        }
    }

    public static void addIfSupported(Vector supportedGroups, TlsCrypto crypto, int namedGroup) {
        if (crypto.hasNamedGroup(namedGroup)) {
            supportedGroups.addElement(Integers.valueOf((int)namedGroup));
        }
    }

    public static void addIfSupported(Vector supportedGroups, TlsCrypto crypto, int[] namedGroups) {
        for (int i = 0; i < namedGroups.length; ++i) {
            TlsUtils.addIfSupported(supportedGroups, crypto, namedGroups[i]);
        }
    }

    public static boolean addToSet(Vector s, int i) {
        boolean result;
        boolean bl = result = !s.contains(Integers.valueOf((int)i));
        if (result) {
            s.add(Integers.valueOf((int)i));
        }
        return result;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)2);
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)3);
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)1);
    }

    public static SignatureAndHashAlgorithm getDefaultSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: {
                return SignatureAndHashAlgorithm.getInstance((short)2, signatureAlgorithm);
            }
        }
        return null;
    }

    public static Vector getDefaultSignatureAlgorithms(short signatureAlgorithm) {
        SignatureAndHashAlgorithm sigAndHashAlg = TlsUtils.getDefaultSignatureAlgorithm(signatureAlgorithm);
        return null == sigAndHashAlg ? new Vector() : TlsUtils.vectorOfOne(sigAndHashAlg);
    }

    public static Vector getDefaultSupportedSignatureAlgorithms(TlsContext context) {
        int i;
        TlsCrypto crypto = context.getCrypto();
        SignatureAndHashAlgorithm[] intrinsicSigAlgs = new SignatureAndHashAlgorithm[]{SignatureAndHashAlgorithm.rsa_pss_rsae_sha256, SignatureAndHashAlgorithm.rsa_pss_rsae_sha384, SignatureAndHashAlgorithm.rsa_pss_rsae_sha512, SignatureAndHashAlgorithm.rsa_pss_pss_sha256, SignatureAndHashAlgorithm.rsa_pss_pss_sha384, SignatureAndHashAlgorithm.rsa_pss_pss_sha512};
        short[] hashAlgorithms = new short[]{2, 3, 4, 5, 6};
        short[] signatureAlgorithms = new short[]{1, 2, 3};
        Vector result = new Vector();
        for (i = 0; i < intrinsicSigAlgs.length; ++i) {
            TlsUtils.addIfSupported(result, crypto, intrinsicSigAlgs[i]);
        }
        for (i = 0; i < signatureAlgorithms.length; ++i) {
            for (int j = 0; j < hashAlgorithms.length; ++j) {
                TlsUtils.addIfSupported(result, crypto, new SignatureAndHashAlgorithm(hashAlgorithms[j], signatureAlgorithms[i]));
            }
        }
        return result;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext context, TlsCredentialedSigner signerCredentials) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12(context) && (signatureAndHashAlgorithm = signerCredentials.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable extensions, Integer extensionType) {
        return extensions == null ? null : (byte[])extensions.get(extensionType);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable extensions, Integer extensionType, short alertDescription) throws IOException {
        byte[] extension_data = TlsUtils.getExtensionData(extensions, extensionType);
        if (extension_data == null) {
            return false;
        }
        if (extension_data.length != 0) {
            throw new TlsFatalAlert(alertDescription);
        }
        return true;
    }

    public static TlsSession importSession(byte[] sessionID, SessionParameters sessionParameters) {
        return new TlsSessionImpl(sessionID, sessionParameters);
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion version) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static short getLegacyClientCertType(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 64;
            }
            case 12: {
                return 64;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClient(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClientCert(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: 
            case 4: {
                return 2;
            }
            case 64: 
            case 66: {
                return 12;
            }
            case 1: 
            case 3: 
            case 65: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmServer(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 12;
            }
        }
        return -1;
    }

    static short getLegacySignatureAlgorithmServerCert(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 2: {
                return 12;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, OutputStream output) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int length = 2 * supportedSignatureAlgorithms.size();
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (entry.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            entry.encode(output);
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int count = length / 2;
        Vector<SignatureAndHashAlgorithm> supportedSignatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(count);
        for (int i = 0; i < count; ++i) {
            SignatureAndHashAlgorithm sigAndHashAlg = SignatureAndHashAlgorithm.parse(input);
            if (0 == sigAndHashAlg.getSignature()) continue;
            supportedSignatureAlgorithms.addElement(sigAndHashAlg);
        }
        return supportedSignatureAlgorithms;
    }

    public static void verifySupportedSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAlgorithm.getSignature() == 0 || !TlsUtils.containsSignatureAlgorithm(supportedSignatureAlgorithms, signatureAlgorithm)) {
            throw new TlsFatalAlert(47);
        }
    }

    public static boolean containsSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (entry.getHash() != signatureAlgorithm.getHash() || entry.getSignature() != signatureAlgorithm.getSignature()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnySignatureAlgorithm(Vector supportedSignatureAlgorithms, short signatureAlgorithm) {
        for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (entry.getSignature() != signatureAlgorithm) continue;
            return true;
        }
        return false;
    }

    public static TlsSecret PRF(TlsContext context, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        int prfAlgorithm = context.getSecurityParametersHandshake().getPrfAlgorithm();
        return secret.deriveUsingPRF(prfAlgorithm, asciiLabel, seed, length);
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    static byte[] calculateEndPointHash(TlsContext context, String sigAlgOID, byte[] enc) {
        return TlsUtils.calculateEndPointHash(context, sigAlgOID, enc, 0, enc.length);
    }

    static byte[] calculateEndPointHash(TlsContext context, String sigAlgOID, byte[] enc, int encOff, int encLen) {
        SignatureAndHashAlgorithm sigAndHashAlg;
        if (sigAlgOID != null && (sigAndHashAlg = TlsUtils.getCertSigAndHashAlg(sigAlgOID)) != null) {
            short hashAlgorithm = sigAndHashAlg.getHash();
            switch (hashAlgorithm) {
                case 1: 
                case 2: {
                    hashAlgorithm = 4;
                    break;
                }
                case 0: 
                case 8: {
                    return EMPTY_BYTES;
                }
            }
            TlsHash hash = context.getCrypto().createHash(hashAlgorithm);
            if (hash != null) {
                hash.update(enc, encOff, encLen);
                return hash.calculateHash();
            }
        }
        return EMPTY_BYTES;
    }

    static TlsSecret calculateMasterSecret(TlsContext context, TlsSecret preMasterSecret) {
        SecurityParameters sp = context.getSecurityParametersHandshake();
        String asciiLabel = "master secret";
        byte[] seed = TlsUtils.concat(sp.getClientRandom(), sp.getServerRandom());
        return TlsUtils.PRF(context, preMasterSecret, asciiLabel, seed, 48);
    }

    static byte[] calculateTLSVerifyData(TlsContext context, TlsHandshakeHash handshakeHash, boolean isServer) {
        String asciiLabel = isServer ? "server finished" : "client finished";
        byte[] prfHash = TlsUtils.getCurrentPRFHash(handshakeHash);
        return TlsUtils.calculateTLSVerifyData(context, asciiLabel, prfHash);
    }

    static byte[] calculateTLSVerifyData(TlsContext context, String asciiLabel, byte[] prfHash) {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        TlsSecret master_secret = securityParameters.getMasterSecret();
        int verify_data_length = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(context, master_secret, asciiLabel, prfHash, verify_data_length).extract();
    }

    public static short getHashAlgorithmForHMACAlgorithm(int macAlgorithm) {
        switch (macAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
        }
        throw new IllegalArgumentException("specified MACAlgorithm not an HMAC: " + MACAlgorithm.getText(macAlgorithm));
    }

    public static short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 7;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(prfAlgorithm));
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    static byte[] calculateSignatureHash(TlsContext context, SignatureAndHashAlgorithm algorithm, DigestInputBuffer buf) {
        TlsCrypto crypto = context.getCrypto();
        TlsHash h = crypto.createHash((short)7);
        SecurityParameters sp = context.getSecurityParametersHandshake();
        byte[] cr = sp.getClientRandom();
        byte[] sr = sp.getServerRandom();
        h.update(cr, 0, cr.length);
        h.update(sr, 0, sr.length);
        buf.updateDigest(h);
        return h.calculateHash();
    }

    static void sendSignatureInput(TlsContext context, DigestInputBuffer buf, OutputStream output) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        output.write(Arrays.concatenate((byte[])securityParameters.getClientRandom(), (byte[])securityParameters.getServerRandom()));
        buf.copyTo(output);
        output.close();
    }

    static DigitallySigned generateCertificateVerify(TlsContext context, TlsCredentialedSigner credentialedSigner, TlsStreamSigner streamSigner, TlsHandshakeHash handshakeHash) throws IOException {
        byte[] signature;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(context, credentialedSigner);
        if (streamSigner != null) {
            handshakeHash.copyBufferTo(streamSigner.getOutputStream());
            signature = streamSigner.getSignature();
        } else {
            byte[] hash = signatureAndHashAlgorithm == null ? context.getSecurityParametersHandshake().getSessionHash() : handshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            signature = credentialedSigner.generateRawSignature(hash);
        }
        return new DigitallySigned(signatureAndHashAlgorithm, signature);
    }

    static void verifyCertificateVerify(TlsServerContext serverContext, CertificateRequest certificateRequest, DigitallySigned certificateVerify, TlsHandshakeHash handshakeHash) throws IOException {
        boolean verified;
        short signatureAlgorithm;
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        Certificate clientCertificate = securityParameters.getPeerCertificate();
        TlsCertificate verifyingCert = clientCertificate.getCertificateAt(0);
        SignatureAndHashAlgorithm sigAndHashAlg = certificateVerify.getAlgorithm();
        if (null == sigAndHashAlg) {
            signatureAlgorithm = verifyingCert.getLegacySignatureAlgorithm();
            short clientCertType = TlsUtils.getLegacyClientCertType(signatureAlgorithm);
            if (clientCertType < 0 || !Arrays.contains((short[])certificateRequest.getCertificateTypes(), (short)clientCertType)) {
                throw new TlsFatalAlert(47);
            }
        } else {
            signatureAlgorithm = sigAndHashAlg.getSignature();
            if (!TlsUtils.isValidSignatureAlgorithmForCertificateVerify(signatureAlgorithm, certificateRequest.getCertificateTypes())) {
                throw new TlsFatalAlert(47);
            }
            TlsUtils.verifySupportedSignatureAlgorithm(certificateRequest.getSupportedSignatureAlgorithms(), sigAndHashAlg);
        }
        try {
            TlsVerifier verifier = verifyingCert.createVerifier(signatureAlgorithm);
            TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(certificateVerify);
            if (streamVerifier != null) {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                handshakeHash.copyBufferTo(bo);
                MessageDigest md = MessageDigest.getInstance("SM3", "BC");
                byte[] d = md.digest(bo.toByteArray());
                streamVerifier.getOutputStream().write(d);
                verified = streamVerifier.isVerified();
            } else {
                byte[] hash = securityParameters.getSessionHash();
                verified = verifier.verifyRawSignature(certificateVerify, hash);
            }
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static void generateServerKeyExchangeSignature(TlsContext context, TlsCredentialedSigner credentials, DigestInputBuffer digestBuffer) throws IOException {
        byte[] signature;
        SignatureAndHashAlgorithm algorithm = TlsUtils.getSignatureAndHashAlgorithm(context, credentials);
        TlsStreamSigner streamSigner = credentials.getStreamSigner();
        if (streamSigner != null) {
            TlsUtils.sendSignatureInput(context, digestBuffer, streamSigner.getOutputStream());
            signature = streamSigner.getSignature();
        } else {
            byte[] der = credentials.getCertificate().getCertificateAt(1).getEncoded();
            SecurityParameters sp = context.getSecurityParametersHandshake();
            byte[] cr = sp.getClientRandom();
            byte[] sr = sp.getServerRandom();
            byte[] data = new byte[cr.length + sr.length + der.length + 3];
            System.arraycopy(cr, 0, data, 0, cr.length);
            System.arraycopy(sr, 0, data, cr.length, sr.length);
            TlsUtils.writeUint24(der.length, data, cr.length + sr.length);
            System.arraycopy(der, 0, data, cr.length + sr.length + 3, der.length);
            signature = credentials.generateRawSignature(data);
        }
        DigitallySigned digitallySigned = new DigitallySigned(algorithm, signature);
        digitallySigned.encode(digestBuffer);
    }

    static void verifyServerKeyExchangeSignature(TlsContext context, InputStream signatureInput, TlsCertificate serverCertificate, DigestInputBuffer digestBuffer) throws IOException {
        boolean verified;
        DigitallySigned digitallySigned = DigitallySigned.parse(context, signatureInput);
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        int keyExchangeAlgorithm = securityParameters.getKeyExchangeAlgorithm();
        SignatureAndHashAlgorithm sigAndHashAlg = digitallySigned.getAlgorithm();
        short signatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmServer(keyExchangeAlgorithm);
        TlsVerifier verifier = serverCertificate.createVerifier(signatureAlgorithm);
        TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(digitallySigned);
        if (streamVerifier != null) {
            TlsUtils.sendSignatureInput(context, digestBuffer, streamVerifier.getOutputStream());
            verified = streamVerifier.isVerified();
        } else {
            byte[] hash = TlsUtils.calculateSignatureHash(context, sigAndHashAlg, digestBuffer);
            verified = verifier.verifyRawSignature(digitallySigned, hash);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static void trackHashAlgorithms(TlsHandshakeHash handshakeHash, Vector supportedSignatureAlgorithms) {
        if (supportedSignatureAlgorithms != null) {
            for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
                short hashAlgorithm = signatureAndHashAlgorithm.getHash();
                if (8 == hashAlgorithm) {
                    handshakeHash.forceBuffering();
                    continue;
                }
                if (!HashAlgorithm.isRecognized(hashAlgorithm)) continue;
                handshakeHash.trackHashAlgorithm(hashAlgorithm);
            }
        }
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static Vector vectorOfOne(Object obj) {
        Vector<Object> v = new Vector<Object>(1);
        v.addElement(obj);
        return v;
    }

    public static int getCipherType(int cipherSuite) {
        switch (TlsUtils.getEncryptionAlgorithm(cipherSuite)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public static int getEncryptionAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 57363: 
            case 57369: 
            case 57370: {
                return 1;
            }
            case 57427: {
                return 2;
            }
        }
        return -1;
    }

    public static int getKeyExchangeAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 57369: 
            case 57370: {
                return 1;
            }
            case 57363: 
            case 57427: {
                return 2;
            }
        }
        return -1;
    }

    public static Vector getKeyExchangeAlgorithms(int[] cipherSuites) {
        Vector result = new Vector();
        if (null != cipherSuites) {
            for (int i = 0; i < cipherSuites.length; ++i) {
                TlsUtils.addToSet(result, TlsUtils.getKeyExchangeAlgorithm(cipherSuites[i]));
            }
            result.removeElement(Integers.valueOf((int)-1));
        }
        return result;
    }

    public static int getMACAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 57363: 
            case 57369: 
            case 57427: {
                return 6;
            }
            case 57370: {
                return 2;
            }
        }
        return -1;
    }

    public static ProtocolVersion getMinimumVersion(int cipherSuite) {
        switch (cipherSuite) {
            case 57363: 
            case 57369: 
            case 57370: 
            case 57427: {
                return ProtocolVersion.GMVPNv11;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static boolean isAEADCipherSuite(int cipherSuite) throws IOException {
        return 2 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isBlockCipherSuite(int cipherSuite) throws IOException {
        return 1 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isStreamCipherSuite(int cipherSuite) throws IOException {
        return 0 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int cipherSuite, Vector sigAlgs) {
        return true;
    }

    public static boolean isValidCipherSuiteForVersion(int cipherSuite, ProtocolVersion serverVersion) {
        return TlsUtils.getMinimumVersion(cipherSuite).isEqualOrEarlierVersionOf(serverVersion.getEquivalentTLSVersion());
    }

    static boolean isValidSignatureAlgorithmForCertificateVerify(short signatureAlgorithm, short[] clientCertificateTypes) {
        for (int i = 0; i < clientCertificateTypes.length; ++i) {
            if (!TlsUtils.isValidSignatureAlgorithmForClientCertType(signatureAlgorithm, clientCertificateTypes[i])) continue;
            return true;
        }
        return false;
    }

    static boolean isValidSignatureAlgorithmForClientCertType(short signatureAlgorithm, short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: {
                switch (signatureAlgorithm) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                return 2 == signatureAlgorithm;
            }
            case 64: {
                switch (signatureAlgorithm) {
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    static boolean isValidSignatureAlgorithmForServerKeyExchange(short signatureAlgorithm, int keyExchangeAlgorithm) {
        return true;
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(TlsContext context, Vector sigHashAlgs, short signatureAlgorithm) throws IOException {
        if (!TlsUtils.isTLSv12(context)) {
            return null;
        }
        if (sigHashAlgs == null) {
            sigHashAlgs = TlsUtils.getDefaultSignatureAlgorithms(signatureAlgorithm);
        }
        SignatureAndHashAlgorithm result = null;
        for (int i = 0; i < sigHashAlgs.size(); ++i) {
            short hash;
            SignatureAndHashAlgorithm sigHashAlg = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i);
            if (sigHashAlg.getSignature() != signatureAlgorithm || (hash = sigHashAlg.getHash()) < MINIMUM_HASH_STRICT) continue;
            if (result == null) {
                result = sigHashAlg;
                continue;
            }
            short current = result.getHash();
            if (current < MINIMUM_HASH_PREFERRED) {
                if (hash <= current) continue;
                result = sigHashAlg;
                continue;
            }
            if (hash < MINIMUM_HASH_PREFERRED || hash >= current) continue;
            result = sigHashAlg;
        }
        if (result == null) {
            throw new TlsFatalAlert(80);
        }
        return result;
    }

    public static Vector getUsableSignatureAlgorithms(Vector sigHashAlgs) {
        if (sigHashAlgs == null) {
            Vector<Short> v = new Vector<Short>(3);
            v.addElement(Shorts.valueOf((short)1));
            v.addElement(Shorts.valueOf((short)2));
            v.addElement(Shorts.valueOf((short)3));
            return v;
        }
        Vector<Short> v = new Vector<Short>();
        for (int i = 0; i < sigHashAlgs.size(); ++i) {
            Short sigAlg;
            SignatureAndHashAlgorithm sigHashAlg = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i);
            if (sigHashAlg.getHash() < MINIMUM_HASH_STRICT || v.contains(sigAlg = Shorts.valueOf((short)sigHashAlg.getSignature()))) continue;
            v.addElement(sigAlg);
        }
        return v;
    }

    public static int[] getCommonCipherSuites(int[] peerCipherSuites, int[] localCipherSuites, boolean useLocalOrder) {
        int[] ordered = peerCipherSuites;
        int[] unordered = localCipherSuites;
        if (useLocalOrder) {
            ordered = localCipherSuites;
            unordered = peerCipherSuites;
        }
        int count = 0;
        int limit = Math.min(ordered.length, unordered.length);
        int[] candidates = new int[limit];
        for (int i = 0; i < ordered.length; ++i) {
            int candidate = ordered[i];
            if (TlsUtils.contains(candidates, 0, count, candidate) || !Arrays.contains((int[])unordered, (int)candidate)) continue;
            candidates[count++] = candidate;
        }
        if (count < limit) {
            candidates = Arrays.copyOf((int[])candidates, (int)count);
        }
        return candidates;
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] suites) {
        int[] supported = new int[suites.length];
        int count = 0;
        for (int i = 0; i < suites.length; ++i) {
            int suite = suites[i];
            if (!TlsUtils.isSupportedCipherSuite(crypto, suite)) continue;
            supported[count++] = suite;
        }
        if (count < supported.length) {
            supported = Arrays.copyOf((int[])supported, (int)count);
        }
        return supported;
    }

    public static boolean isSupportedCipherSuite(TlsCrypto crypto, int cipherSuite) {
        return TlsUtils.isSupportedKeyExchange(crypto, TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) && crypto.hasEncryptionAlgorithm(TlsUtils.getEncryptionAlgorithm(cipherSuite)) && crypto.hasMacAlgorithm(TlsUtils.getMACAlgorithm(cipherSuite));
    }

    public static boolean isSupportedKeyExchange(TlsCrypto crypto, int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 1: {
                return crypto.hasRSAEncryption();
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    static boolean hasAnyRSASigAlgs(TlsCrypto crypto) {
        return crypto.hasSignatureAlgorithm((short)1) || crypto.hasSignatureAlgorithm((short)4) || crypto.hasSignatureAlgorithm((short)5) || crypto.hasSignatureAlgorithm((short)6) || crypto.hasSignatureAlgorithm((short)9) || crypto.hasSignatureAlgorithm((short)10) || crypto.hasSignatureAlgorithm((short)11);
    }

    static byte[] getCurrentPRFHash(TlsHandshakeHash handshakeHash) {
        return handshakeHash.forkPRFHash().calculateHash();
    }

    static void sealHandshakeHash(TlsContext context, TlsHandshakeHash handshakeHash, boolean forceBuffering) {
        if (forceBuffering || !context.getCrypto().hasAllRawSignatureAlgorithms()) {
            handshakeHash.forceBuffering();
        }
        handshakeHash.sealHashAlgorithms();
    }

    private static TlsKeyExchange createKeyExchangeClient(TlsClient client, int keyExchange) throws IOException {
        TlsKeyExchangeFactory factory = client.getKeyExchangeFactory();
        switch (keyExchange) {
            case 1: {
                return factory.createRSAKeyExchange(keyExchange);
            }
            case 2: {
                return factory.createSM2KeyExchange(keyExchange);
            }
        }
        throw new TlsFatalAlert(80);
    }

    private static TlsKeyExchange createKeyExchangeServer(TlsServer server, int keyExchange) throws IOException {
        TlsKeyExchangeFactory factory = server.getKeyExchangeFactory();
        switch (keyExchange) {
            case 1: {
                return factory.createRSAKeyExchange(keyExchange);
            }
            case 2: {
                return factory.createSM2KeyExchange(keyExchange);
            }
        }
        throw new TlsFatalAlert(80);
    }

    private static TlsKeyExchange initKeyExchange(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        keyExchange.init(context);
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(context.getServerVersion())) {
            if (null == securityParameters.getClientSigAlgs()) {
                short signatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmServerCert(securityParameters.getKeyExchangeAlgorithm());
                securityParameters.clientSigAlgs = TlsUtils.getDefaultSignatureAlgorithms(signatureAlgorithm);
            }
            if (null == securityParameters.getClientSigAlgsCert()) {
                securityParameters.clientSigAlgsCert = securityParameters.getClientSigAlgs();
            }
        } else {
            securityParameters.clientSigAlgs = null;
            securityParameters.clientSigAlgsCert = null;
        }
        return keyExchange;
    }

    static TlsKeyExchange initKeyExchangeClient(TlsClientContext context, TlsClient client) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        int cipherSuite = securityParameters.getCipherSuite();
        securityParameters.keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        TlsKeyExchange keyExchange = TlsUtils.createKeyExchangeClient(client, securityParameters.getKeyExchangeAlgorithm());
        return TlsUtils.initKeyExchange(context, keyExchange);
    }

    static TlsKeyExchange initKeyExchangeServer(TlsServerContext context, TlsServer server) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        int cipherSuite = securityParameters.getCipherSuite();
        securityParameters.keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        TlsKeyExchange keyExchange = TlsUtils.createKeyExchangeServer(server, securityParameters.getKeyExchangeAlgorithm());
        return TlsUtils.initKeyExchange(context, keyExchange);
    }

    static TlsCipher initCipher(TlsContext context) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        int cipherSuite = securityParameters.getCipherSuite();
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(cipherSuite);
        int macAlgorithm = TlsUtils.getMACAlgorithm(cipherSuite);
        if (encryptionAlgorithm < 0 || macAlgorithm < 0) {
            throw new TlsFatalAlert(80);
        }
        TlsSecret masterSecret = context.getSecurityParametersHandshake().getMasterSecret();
        return masterSecret.createCipher(new TlsCryptoParameters(context), encryptionAlgorithm, macAlgorithm);
    }

    static void checkSigAlgOfClientCerts(TlsContext context, Certificate clientCertificate, CertificateRequest certificateRequest) throws IOException {
        Vector supportedSignatureAlgorithms = certificateRequest.getSupportedSignatureAlgorithms();
        for (int i = 0; i < clientCertificate.getLength(); ++i) {
            String sigAlgOID = clientCertificate.getCertificateAt(i).getSigAlgOID();
            SignatureAndHashAlgorithm sigAndHashAlg = TlsUtils.getCertSigAndHashAlg(sigAlgOID);
            boolean valid = false;
            if (null != sigAndHashAlg) {
                if (null == supportedSignatureAlgorithms) {
                    short[] certificateTypes = certificateRequest.getCertificateTypes();
                    for (int j = 0; j < certificateTypes.length; ++j) {
                        if (sigAndHashAlg.getSignature() != TlsUtils.getLegacySignatureAlgorithmClientCert(certificateTypes[j])) continue;
                        valid = true;
                        break;
                    }
                } else {
                    valid = TlsUtils.containsSignatureAlgorithm(supportedSignatureAlgorithms, sigAndHashAlg);
                }
            }
            if (valid) continue;
            throw new TlsFatalAlert(42);
        }
    }

    static void checkSigAlgOfServerCerts(TlsContext context, Certificate serverCertificate) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        Vector clientSigAlgsCert = securityParameters.getClientSigAlgsCert();
        for (int i = 0; i < serverCertificate.getLength(); ++i) {
            String sigAlgOID = serverCertificate.getCertificateAt(i).getSigAlgOID();
            SignatureAndHashAlgorithm sigAndHashAlg = TlsUtils.getCertSigAndHashAlg(sigAlgOID);
            boolean valid = false;
            if (null != sigAndHashAlg) {
                short signatureAlgorithm;
                valid = null == clientSigAlgsCert ? (signatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmServerCert(securityParameters.getKeyExchangeAlgorithm())) == sigAndHashAlg.getSignature() : TlsUtils.containsSignatureAlgorithm(clientSigAlgsCert, sigAndHashAlg);
            }
            if (valid) continue;
            throw new TlsFatalAlert(42);
        }
    }

    static void checkTlsFeatures(Certificate serverCertificate, Hashtable clientExtensions, Hashtable serverExtensions) throws IOException {
        byte[] tlsFeatures = serverCertificate.getCertificateAt(0).getExtension(TlsObjectIdentifiers.id_pe_tlsfeature);
        if (tlsFeatures != null) {
            Enumeration tlsExtensions = ((ASN1Sequence)TlsUtils.readDERObject(tlsFeatures)).getObjects();
            while (tlsExtensions.hasMoreElements()) {
                Integer extensionType;
                BigInteger tlsExtension = ((ASN1Integer)tlsExtensions.nextElement()).getPositiveValue();
                if (tlsExtension.bitLength() > 16 || !clientExtensions.containsKey(extensionType = Integers.valueOf((int)tlsExtension.intValue())) || serverExtensions.containsKey(extensionType)) continue;
                throw new TlsFatalAlert(46);
            }
        }
    }

    static void processClientCertificate(TlsServerContext serverContext, Certificate clientCertificate, CertificateRequest certificateRequest, TlsKeyExchange keyExchange, TlsServer server) throws IOException {
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        if (null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(10);
        }
        if (null == certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        if (clientCertificate.isEmpty()) {
            keyExchange.skipClientCredentials();
        } else {
            if (server.shouldCheckSigAlgOfPeerCerts()) {
                TlsUtils.checkSigAlgOfClientCerts(serverContext, clientCertificate, certificateRequest);
            }
            keyExchange.processClientCertificate(clientCertificate);
        }
        securityParameters.peerCertificate = clientCertificate;
        server.notifyClientCertificate(clientCertificate);
    }

    static void processServerCertificate(TlsClientContext clientContext, TlsClient client, CertificateStatus serverCertificateStatus, TlsKeyExchange keyExchange, TlsAuthentication clientAuthentication, Hashtable clientExtensions, Hashtable serverExtensions) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        if (null == clientAuthentication) {
            keyExchange.skipServerCredentials();
            securityParameters.tlsServerEndPoint = EMPTY_BYTES;
            return;
        }
        Certificate serverCertificate = securityParameters.getPeerCertificate();
        TlsUtils.checkTlsFeatures(serverCertificate, clientExtensions, serverExtensions);
        if (client.shouldCheckSigAlgOfPeerCerts()) {
            // empty if block
        }
        keyExchange.processServerCertificate(serverCertificate);
        if (ProvX509TrustManager.validateCertChain) {
            clientAuthentication.notifyServerCertificate(new TlsServerCertificateImpl(serverCertificate, serverCertificateStatus));
        }
    }

    static SignatureAndHashAlgorithm getCertSigAndHashAlg(String sigAlgOID) {
        return (SignatureAndHashAlgorithm)CERT_SIG_ALG_OIDS.get(sigAlgOID);
    }

    static CertificateRequest validateCertificateRequest(CertificateRequest certificateRequest, TlsKeyExchange keyExchange) throws IOException {
        short[] validClientCertificateTypes = keyExchange.getClientCertificateTypes();
        if (validClientCertificateTypes == null || validClientCertificateTypes.length < 1) {
            throw new TlsFatalAlert(10);
        }
        if ((certificateRequest = TlsUtils.normalizeCertificateRequest(certificateRequest, validClientCertificateTypes)) == null) {
            throw new TlsFatalAlert(47);
        }
        return certificateRequest;
    }

    static CertificateRequest normalizeCertificateRequest(CertificateRequest certificateRequest, short[] validClientCertificateTypes) {
        if (TlsUtils.containsAll(validClientCertificateTypes, certificateRequest.getCertificateTypes())) {
            return certificateRequest;
        }
        short[] retained = TlsUtils.retainAll(certificateRequest.getCertificateTypes(), validClientCertificateTypes);
        if (retained.length < 1) {
            return null;
        }
        return new CertificateRequest(retained, certificateRequest.getSupportedSignatureAlgorithms(), certificateRequest.getCertificateAuthorities());
    }

    static boolean contains(int[] buf, int off, int len, int value) {
        for (int i = 0; i < len; ++i) {
            if (value != buf[off + i]) continue;
            return true;
        }
        return false;
    }

    static boolean containsAll(short[] container, short[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (Arrays.contains((short[])container, (short)elements[i])) continue;
            return false;
        }
        return true;
    }

    static short[] retainAll(short[] retainer, short[] elements) {
        short[] retained = new short[Math.min(retainer.length, elements.length)];
        int count = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (!Arrays.contains((short[])retainer, (short)elements[i])) continue;
            retained[count++] = elements[i];
        }
        return TlsUtils.truncate(retained, count);
    }

    static short[] truncate(short[] a, int n) {
        if (n < a.length) {
            return a;
        }
        short[] t = new short[n];
        System.arraycopy(a, 0, t, 0, n);
        return t;
    }

    static TlsCredentialedAgreement requireAgreementCredentials(TlsCredentials credentials) throws IOException {
        if (!(credentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedAgreement)credentials;
    }

    static TlsCredentialedDecryptor requireDecryptorCredentials(TlsCredentials credentials) throws IOException {
        if (!(credentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedDecryptor)credentials;
    }

    static TlsCredentialedSignerAndDecryptor requireSignerAndDecryptorCredentials(TlsCredentials credentials) throws IOException {
        if (!(credentials instanceof TlsCredentialedSignerAndDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedSignerAndDecryptor)credentials;
    }

    static TlsCredentialedSigner requireSignerCredentials(TlsCredentials credentials) throws IOException {
        if (!(credentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedSigner)credentials;
    }

    private static void checkDowngradeMarker(byte[] randomBlock, byte[] downgradeMarker) throws IOException {
        byte[] bytes = Arrays.copyOfRange((byte[])randomBlock, (int)(randomBlock.length - downgradeMarker.length), (int)randomBlock.length);
        if (Arrays.constantTimeAreEqual((byte[])bytes, (byte[])downgradeMarker)) {
            throw new TlsFatalAlert(47);
        }
    }

    static void checkDowngradeMarker(ProtocolVersion version, byte[] randomBlock) throws IOException {
        if ((version = version.getEquivalentTLSVersion()).isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            TlsUtils.checkDowngradeMarker(randomBlock, DOWNGRADE_TLS11);
        }
        if (version.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv12)) {
            TlsUtils.checkDowngradeMarker(randomBlock, DOWNGRADE_TLS12);
        }
    }

    static void writeDowngradeMarker(ProtocolVersion version, byte[] randomBlock) throws IOException {
        byte[] marker;
        if (ProtocolVersion.TLSv12 == (version = version.getEquivalentTLSVersion())) {
            marker = DOWNGRADE_TLS12;
        } else if (version.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            marker = DOWNGRADE_TLS11;
        } else {
            throw new TlsFatalAlert(80);
        }
        System.arraycopy(marker, 0, randomBlock, randomBlock.length - marker.length, marker.length);
    }

    static void receiveServerCertificate(TlsClientContext clientContext, ByteArrayInputStream buf) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        if (null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayOutputStream endPointHash = new ByteArrayOutputStream();
        Certificate serverCertificate = Certificate.parse(clientContext, buf, endPointHash);
        TlsProtocol.assertEmpty(buf);
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        securityParameters.peerCertificate = serverCertificate;
        securityParameters.tlsServerEndPoint = endPointHash.toByteArray();
    }

    public static boolean containsNonAscii(byte[] bs) {
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] & 0xFF;
            if (c < 128) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') continue;
            return true;
        }
        return false;
    }
}

