/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.BaseSimpleFeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;

public class SubFeatureCollection
extends BaseSimpleFeatureCollection {
    protected Filter filter;
    protected SimpleFeatureCollection collection;
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    public SubFeatureCollection(SimpleFeatureCollection collection) {
        this(collection, (Filter)Filter.INCLUDE);
    }

    public SubFeatureCollection(SimpleFeatureCollection collection, Filter subfilter) {
        super((SimpleFeatureType)collection.getSchema());
        if (subfilter == null) {
            subfilter = Filter.INCLUDE;
        }
        if (subfilter.equals(Filter.EXCLUDE)) {
            throw new IllegalArgumentException("A subcollection with Filter.EXCLUDE would be empty");
        }
        if (collection instanceof SubFeatureCollection) {
            SubFeatureCollection filtered = (SubFeatureCollection)collection;
            if (subfilter.equals(Filter.INCLUDE)) {
                this.collection = filtered.collection;
                this.filter = filtered.filter();
            } else {
                this.collection = filtered.collection;
                this.filter = this.ff.and(filtered.filter(), subfilter);
            }
        } else {
            this.collection = collection;
            this.filter = subfilter;
        }
    }

    @Override
    public SimpleFeatureIterator features() {
        return new FilteringSimpleFeatureIterator(this.collection.features(), this.filter());
    }

    @Override
    public int size() {
        int count = 0;
        try (SimpleFeatureIterator i = this.features();){
            while (i.hasNext()) {
                i.next();
                ++count;
            }
        }
        return count;
    }

    protected Filter filter() {
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
        return this.filter;
    }

    protected Filter createFilter() {
        return Filter.INCLUDE;
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter.equals(Filter.INCLUDE)) {
            return this;
        }
        if (filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection((SimpleFeatureType)this.schema);
        }
        return new SubFeatureCollection(this, filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return new SubFeatureList(this.collection, this.filter, order);
    }

    @Override
    public String getID() {
        return this.collection.getID();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds(this);
    }
}

