/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import kl.ssl.jsse.BCExtendedSSLSession;
import kl.ssl.jsse.BCSSLEngine;
import kl.ssl.jsse.BCSSLParameters;
import kl.ssl.jsse.provider.ContextData;
import kl.ssl.jsse.provider.ProvSSLContextSpi;
import kl.ssl.jsse.provider.ProvSSLEngine;
import kl.ssl.jsse.provider.ReflectionUtil;
import kl.ssl.jsse.provider.SSLParametersUtil;
import kl.ssl.jsse.provider.SSLSessionUtil;

abstract class SSLEngineUtil {
    private static final Method getHandshakeSession;
    private static final Method getSSLParameters;

    SSLEngineUtil() {
    }

    static SSLEngine create(ProvSSLContextSpi context, ContextData contextData) {
        return new ProvSSLEngine(context, contextData);
    }

    static SSLEngine create(ProvSSLContextSpi context, ContextData contextData, String host, int port) {
        return new ProvSSLEngine(context, contextData, host, port);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sslEngine) {
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getBCHandshakeSession();
        }
        if (null != sslEngine && null != getHandshakeSession) {
            try {
                SSLSession sslSession = (SSLSession)ReflectionUtil.invokeGetter(sslEngine, getHandshakeSession);
                if (null != sslSession) {
                    return SSLSessionUtil.importSSLSession(sslSession);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sslEngine) {
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getParameters();
        }
        if (null != sslEngine && null != getSSLParameters) {
            try {
                SSLParameters sslParameters = (SSLParameters)ReflectionUtil.invokeGetter(sslEngine, getSSLParameters);
                if (null != sslParameters) {
                    return SSLParametersUtil.importSSLParameters(sslParameters);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLEngine");
        getHandshakeSession = ReflectionUtil.findMethod(methods, "getHandshakeSession");
        getSSLParameters = ReflectionUtil.findMethod(methods, "getSSLParameters");
    }
}

