/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.util.Vector;
import kl.ssl.gmvpn.TlsUtils;
import org.bouncycastle.util.Strings;

public final class ProtocolVersion {
    public static final ProtocolVersion GMVPNv11 = new ProtocolVersion(257, "GMVPN 3.0");
    public static final ProtocolVersion SSLv3 = new ProtocolVersion(768, "SSL 3.0");
    public static final ProtocolVersion TLSv10 = new ProtocolVersion(769, "TLS 1.0");
    public static final ProtocolVersion TLSv11 = new ProtocolVersion(770, "TLS 1.1");
    public static final ProtocolVersion TLSv12 = new ProtocolVersion(771, "TLS 1.2");
    public static final ProtocolVersion TLSv13 = new ProtocolVersion(772, "TLS 1.3");
    public static final ProtocolVersion DTLSv10 = new ProtocolVersion(65279, "DTLS 1.0");
    public static final ProtocolVersion DTLSv12 = new ProtocolVersion(65277, "DTLS 1.2");
    private int version;
    private String name;

    public static boolean contains(ProtocolVersion[] versions, ProtocolVersion version) {
        if (versions != null && version != null) {
            for (int i = 0; i < versions.length; ++i) {
                if (!version.equals(versions[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static ProtocolVersion getEarliestTLS(ProtocolVersion[] versions) {
        ProtocolVersion earliest = null;
        if (null != versions) {
            for (int i = 0; i < versions.length; ++i) {
                ProtocolVersion next = versions[i];
                if (null == next || !next.isTLS() || null != earliest && next.getMinorVersion() >= earliest.getMinorVersion()) continue;
                earliest = next;
            }
        }
        return earliest;
    }

    public static ProtocolVersion getLatestTLS(ProtocolVersion[] versions) {
        ProtocolVersion latest = null;
        if (null != versions) {
            for (int i = 0; i < versions.length; ++i) {
                ProtocolVersion next = versions[i];
                if (null == next || !next.isTLS() || null != latest && next.getMinorVersion() <= latest.getMinorVersion()) continue;
                latest = next;
            }
        }
        return latest;
    }

    private ProtocolVersion(int v, String name) {
        this.version = v & 0xFFFF;
        this.name = name;
    }

    public ProtocolVersion[] downTo(ProtocolVersion min) {
        if (!this.isEqualOrLaterVersionOf(min)) {
            throw new IllegalArgumentException("'min' must be an equal or earlier version of this one");
        }
        Vector<ProtocolVersion> result = new Vector<ProtocolVersion>();
        result.addElement(this);
        ProtocolVersion current = this;
        while (!current.equals(min)) {
            current = current.getPreviousVersion();
            result.addElement(current);
        }
        ProtocolVersion[] versions = new ProtocolVersion[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            versions[i] = (ProtocolVersion)result.elementAt(i);
        }
        return versions;
    }

    public int getFullVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.version >> 8;
    }

    public int getMinorVersion() {
        return this.version & 0xFF;
    }

    public boolean isDTLS() {
        return this.getMajorVersion() == 254;
    }

    public boolean isTLS() {
        return this.getMajorVersion() == 1;
    }

    public ProtocolVersion getEquivalentTLSVersion() {
        switch (this.getMajorVersion()) {
            case 1: {
                return this;
            }
        }
        return null;
    }

    public ProtocolVersion getNextVersion() {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        switch (major) {
            case 1: {
                switch (minor) {
                    case 255: {
                        return null;
                    }
                }
                return ProtocolVersion.get(major, minor + 1);
            }
        }
        return null;
    }

    public ProtocolVersion getPreviousVersion() {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        switch (major) {
            case 1: {
                switch (minor) {
                    case 0: {
                        return null;
                    }
                }
                return ProtocolVersion.get(major, minor - 1);
            }
        }
        return null;
    }

    public boolean isEarlierVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int diffMinorVersion = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? diffMinorVersion > 0 : diffMinorVersion < 0;
    }

    public boolean isEqualOrEarlierVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int diffMinorVersion = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? diffMinorVersion >= 0 : diffMinorVersion <= 0;
    }

    public boolean isEqualOrLaterVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int diffMinorVersion = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? diffMinorVersion <= 0 : diffMinorVersion >= 0;
    }

    public boolean isLaterVersionOf(ProtocolVersion version) {
        if (null == version || this.getMajorVersion() != version.getMajorVersion()) {
            return false;
        }
        int diffMinorVersion = this.getMinorVersion() - version.getMinorVersion();
        return this.isDTLS() ? diffMinorVersion < 0 : diffMinorVersion > 0;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ProtocolVersion && this.equals((ProtocolVersion)other);
    }

    public boolean equals(ProtocolVersion other) {
        return other != null && this.version == other.version;
    }

    public int hashCode() {
        return this.version;
    }

    public static ProtocolVersion get(int major, int minor) {
        switch (major) {
            case 1: {
                switch (minor) {
                    case 1: {
                        return GMVPNv11;
                    }
                }
                return ProtocolVersion.getUnknownVersion(major, minor, "GMVPN");
            }
        }
        return ProtocolVersion.getUnknownVersion(major, minor, "UNKNOWN");
    }

    public ProtocolVersion[] only() {
        return new ProtocolVersion[]{this};
    }

    public String toString() {
        return this.name;
    }

    private static void checkUint8(int versionOctet) {
        if (!TlsUtils.isValidUint8(versionOctet)) {
            throw new IllegalArgumentException("'versionOctet' is not a valid octet");
        }
    }

    private static ProtocolVersion getUnknownVersion(int major, int minor, String prefix) {
        ProtocolVersion.checkUint8(major);
        ProtocolVersion.checkUint8(minor);
        int v = major << 8 | minor;
        String hex = Strings.toUpperCase((String)Integer.toHexString(0x10000 | v).substring(1));
        return new ProtocolVersion(v, prefix + " 0x" + hex);
    }
}

