/*
 * Decompiled with CFR 0.152.
 */
package cn.com.goldenwater.common.plugin.autoconfigure;

import cn.com.goldenwater.common.plugin.SpringPluginManager;
import cn.com.goldenwater.common.plugin.autoconfigure.PluginProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.pf4j.DefaultPluginManager;
import org.pf4j.RuntimeMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={DefaultPluginManager.class})
@EnableConfigurationProperties(value={PluginProperties.class})
public class PluginAutoConfiguration {
    @Autowired
    Environment environment;
    @Autowired
    private PluginProperties pluginProperties;

    public PluginAutoConfiguration(PluginProperties properties) {
        this.pluginProperties = properties;
    }

    @Bean
    @ConditionalOnClass(value={SpringPluginManager.class})
    public SpringPluginManager pluginManager() {
        String profile = StringUtils.arrayToCommaDelimitedString((Object[])this.environment.getActiveProfiles());
        System.out.println(">> plugin profile " + profile + " pluginProperties.getmode() " + this.pluginProperties.getMode());
        if (this.pluginProperties.getMode().equals(profile)) {
            System.setProperty("pf4j.mode", RuntimeMode.DEVELOPMENT.toString());
        } else {
            System.setProperty("pf4j.mode", RuntimeMode.DEPLOYMENT.toString());
        }
        Path pluginPath = Paths.get(this.pluginProperties.getPath(), new String[0]);
        SpringPluginManager appPluginManager = null;
        try {
            appPluginManager = new SpringPluginManager(new Path[]{pluginPath});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appPluginManager;
    }
}

