/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.AbstractSymbolizer;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.Description;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.StyleFactoryImpl2;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;
import org.opengis.style.ContrastEnhancement;
import org.opengis.style.OverlapBehavior;
import org.opengis.style.ShadedRelief;

public class RasterSymbolizerImpl
extends AbstractSymbolizer
implements RasterSymbolizer {
    private OverlapBehavior behavior;
    private FilterFactory filterFactory;
    private ChannelSelection channelSelection = new ChannelSelectionImpl();
    private ColorMapImpl colorMap = new ColorMapImpl();
    private ContrastEnhancementImpl contrastEnhancement = new ContrastEnhancementImpl();
    private ShadedReliefImpl shadedRelief;
    private String geometryName;
    private Symbolizer symbolizer;
    private Expression opacity;

    public RasterSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()));
    }

    public RasterSymbolizerImpl(FilterFactory factory) {
        this(factory, null, null, null, null);
    }

    public RasterSymbolizerImpl(FilterFactory factory, Description desc, String name, Unit<Length> uom, OverlapBehavior behavior) {
        super(name, desc, (String)null, uom);
        this.filterFactory = factory;
        this.opacity = this.filterFactory.literal(1.0);
        this.behavior = behavior;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.behavior == null ? 0 : this.behavior.hashCode());
        result = 31 * result + (this.channelSelection == null ? 0 : this.channelSelection.hashCode());
        result = 31 * result + (this.colorMap == null ? 0 : this.colorMap.hashCode());
        result = 31 * result + (this.contrastEnhancement == null ? 0 : this.contrastEnhancement.hashCode());
        result = 31 * result + (this.filterFactory == null ? 0 : this.filterFactory.hashCode());
        result = 31 * result + (this.opacity == null ? 0 : this.opacity.hashCode());
        result = 31 * result + (this.shadedRelief == null ? 0 : this.shadedRelief.hashCode());
        result = 31 * result + (this.symbolizer == null ? 0 : this.symbolizer.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RasterSymbolizerImpl other = (RasterSymbolizerImpl)obj;
        if (this.behavior == null ? other.behavior != null : !this.behavior.equals((Object)other.behavior)) {
            return false;
        }
        if (this.channelSelection == null ? other.channelSelection != null : !this.channelSelection.equals(other.channelSelection)) {
            return false;
        }
        if (this.colorMap == null ? other.colorMap != null : !this.colorMap.equals(other.colorMap)) {
            return false;
        }
        if (this.contrastEnhancement == null ? other.contrastEnhancement != null : !this.contrastEnhancement.equals(other.contrastEnhancement)) {
            return false;
        }
        if (this.filterFactory == null ? other.filterFactory != null : !this.filterFactory.equals(other.filterFactory)) {
            return false;
        }
        if (this.opacity == null ? other.opacity != null : !this.opacity.equals(other.opacity)) {
            return false;
        }
        if (this.shadedRelief == null ? other.shadedRelief != null : !this.shadedRelief.equals(other.shadedRelief)) {
            return false;
        }
        return !(this.symbolizer == null ? other.symbolizer != null : !this.symbolizer.equals(other.symbolizer));
    }

    public ChannelSelection getChannelSelection() {
        return this.channelSelection;
    }

    public ColorMapImpl getColorMap() {
        return this.colorMap;
    }

    public ContrastEnhancementImpl getContrastEnhancement() {
        return this.contrastEnhancement;
    }

    public Symbolizer getImageOutline() {
        return this.symbolizer;
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    @Deprecated
    public Expression getOverlap() {
        OverlapBehavior overlap = this.getOverlapBehavior();
        if (overlap == null) {
            overlap = OverlapBehavior.RANDOM;
        }
        return this.filterFactory.literal((Object)overlap.toString());
    }

    public OverlapBehavior getOverlapBehavior() {
        return this.behavior;
    }

    public void setOverlapBehavior(OverlapBehavior overlapBehavior) {
        this.behavior = overlapBehavior;
    }

    public ShadedReliefImpl getShadedRelief() {
        return this.shadedRelief;
    }

    public void setChannelSelection(org.opengis.style.ChannelSelection channel) {
        if (this.channelSelection == channel) {
            return;
        }
        this.channelSelection = ChannelSelectionImpl.cast(channel);
    }

    public void setColorMap(ColorMap colorMap) {
        if (this.colorMap == colorMap) {
            return;
        }
        this.colorMap = ColorMapImpl.cast(colorMap);
    }

    public void setContrastEnhancement(ContrastEnhancement contrastEnhancement) {
        if (this.contrastEnhancement == contrastEnhancement) {
            return;
        }
        this.contrastEnhancement = ContrastEnhancementImpl.cast(contrastEnhancement);
    }

    public void setImageOutline(org.opengis.style.Symbolizer symbolizer) {
        if (symbolizer == null) {
            this.symbolizer = null;
        } else if (symbolizer instanceof LineSymbolizer || symbolizer instanceof PolygonSymbolizer) {
            if (this.symbolizer == symbolizer) {
                return;
            }
            this.symbolizer = StyleFactoryImpl2.cast(symbolizer);
        } else {
            throw new IllegalArgumentException("Only a line or polygon symbolizer may be used to outline a raster");
        }
    }

    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        this.opacity = opacity;
    }

    @Deprecated
    public void setOverlap(Expression overlap) {
        if (overlap == null) {
            return;
        }
        OverlapBehavior overlapBehavior = OverlapBehavior.valueOf((String)((String)overlap.evaluate(null, String.class)));
        this.setOverlapBehavior(overlapBehavior);
    }

    public void setShadedRelief(ShadedRelief shadedRelief) {
        if (this.shadedRelief == shadedRelief) {
            return;
        }
        this.shadedRelief = ShadedReliefImpl.cast(shadedRelief);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.RasterSymbolizer)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((RasterSymbolizer)this);
    }

    public Object clone() {
        Object clone;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    static RasterSymbolizerImpl cast(org.opengis.style.Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof RasterSymbolizerImpl) {
            return (RasterSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof org.opengis.style.RasterSymbolizer) {
            org.opengis.style.RasterSymbolizer rasterSymbolizer = (org.opengis.style.RasterSymbolizer)symbolizer;
            RasterSymbolizerImpl copy = new RasterSymbolizerImpl();
            copy.setChannelSelection(rasterSymbolizer.getChannelSelection());
            copy.setColorMap(rasterSymbolizer.getColorMap());
            copy.setContrastEnhancement(rasterSymbolizer.getContrastEnhancement());
            copy.setDescription(rasterSymbolizer.getDescription());
            copy.setGeometryPropertyName(rasterSymbolizer.getGeometryPropertyName());
            copy.setImageOutline(rasterSymbolizer.getImageOutline());
            copy.setName(rasterSymbolizer.getName());
            copy.setOpacity(rasterSymbolizer.getOpacity());
            copy.setOverlapBehavior(rasterSymbolizer.getOverlapBehavior());
            copy.setShadedRelief(rasterSymbolizer.getShadedRelief());
            copy.setUnitOfMeasure((Unit<Length>)rasterSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

