/*
 * Decompiled with CFR 0.152.
 */
package wContour;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import wContour.Global.Border;
import wContour.Global.BorderLine;
import wContour.Global.BorderPoint;
import wContour.Global.EndPoint;
import wContour.Global.Extent;
import wContour.Global.IJPoint;
import wContour.Global.Line;
import wContour.Global.PointD;
import wContour.Global.PointF;
import wContour.Global.PolyLine;
import wContour.Global.Polygon;

public class Contour {
    private static List<EndPoint> _endPointList = new ArrayList<EndPoint>();

    public static List<PolyLine> tracingContourLines(double[][] S0, double[] X, double[] Y, int nc, double[] contour, double undefData, List<Border> borders, int[][] S1) {
        List<PolyLine> contourLines = Contour.createContourLines_UndefData(S0, X, Y, nc, contour, S1, undefData, borders);
        return contourLines;
    }

    public static List<Border> tracingBorders(double[][] S0, double[] X, double[] Y, int[][] S1, double undefData) {
        BorderLine bLine;
        BorderLine aLine;
        PointD aPoint;
        boolean isContinue;
        int rt;
        int lt;
        int rb;
        int lb;
        int t;
        int b;
        int r;
        int l;
        int j;
        int i;
        ArrayList<BorderLine> borderLines = new ArrayList<BorderLine>();
        int m = S0.length;
        int n = S0[0].length;
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                S1[i][j] = Contour.doubleEquals(S0[i][j], undefData) ? 0 : 1;
            }
        }
        for (i = 1; i < m - 1; ++i) {
            for (j = 1; j < n - 1; ++j) {
                if (S1[i][j] != 1) continue;
                l = S1[i][j - 1];
                r = S1[i][j + 1];
                b = S1[i - 1][j];
                t = S1[i + 1][j];
                lb = S1[i - 1][j - 1];
                rb = S1[i - 1][j + 1];
                lt = S1[i + 1][j - 1];
                rt = S1[i + 1][j + 1];
                if (l > 0 && r > 0 && b > 0 && t > 0 && lb > 0 && rb > 0 && lt > 0 && rt > 0) {
                    S1[i][j] = 2;
                }
                if (l + r + b + t + lb + rb + lt + rt > 2) continue;
                S1[i][j] = 0;
            }
        }
        do {
            isContinue = false;
            for (i = 1; i < m - 1; ++i) {
                for (j = 1; j < n - 1; ++j) {
                    if (S1[i][j] != 1) continue;
                    l = S1[i][j - 1];
                    r = S1[i][j + 1];
                    b = S1[i - 1][j];
                    t = S1[i + 1][j];
                    lb = S1[i - 1][j - 1];
                    rb = S1[i - 1][j + 1];
                    lt = S1[i + 1][j - 1];
                    rt = S1[i + 1][j + 1];
                    if (l == 0 && r == 0 || b == 0 && t == 0) {
                        S1[i][j] = 0;
                        isContinue = true;
                    }
                    if (!(lt == 0 && r == 0 && b == 0 || rt == 0 && l == 0 && b == 0 || lb == 0 && r == 0 && t == 0) && (rb != 0 || l != 0 || t != 0)) continue;
                    S1[i][j] = 0;
                    isContinue = true;
                }
            }
        } while (isContinue);
        for (j = 0; j < n; ++j) {
            if (S1[0][j] == 1) {
                if (S1[1][j] == 0) {
                    S1[0][j] = 0;
                } else if (j == 0) {
                    if (S1[0][j + 1] == 0) {
                        S1[0][j] = 0;
                    }
                } else if (j == n - 1) {
                    if (S1[0][n - 2] == 0) {
                        S1[0][j] = 0;
                    }
                } else if (S1[0][j - 1] == 0 && S1[0][j + 1] == 0) {
                    S1[0][j] = 0;
                }
            }
            if (S1[m - 1][j] != 1) continue;
            if (S1[m - 2][j] == 0) {
                S1[m - 1][j] = 0;
                continue;
            }
            if (j == 0) {
                if (S1[m - 1][j + 1] != 0) continue;
                S1[m - 1][j] = 0;
                continue;
            }
            if (j == n - 1) {
                if (S1[m - 1][n - 2] != 0) continue;
                S1[m - 1][j] = 0;
                continue;
            }
            if (S1[m - 1][j - 1] != 0 || S1[m - 1][j + 1] != 0) continue;
            S1[m - 1][j] = 0;
        }
        for (i = 0; i < m; ++i) {
            if (S1[i][0] == 1) {
                if (S1[i][1] == 0) {
                    S1[i][0] = 0;
                } else if (i == 0) {
                    if (S1[i + 1][0] == 0) {
                        S1[i][0] = 0;
                    }
                } else if (i == m - 1) {
                    if (S1[m - 2][0] == 0) {
                        S1[i][0] = 0;
                    }
                } else if (S1[i - 1][0] == 0 && S1[i + 1][0] == 0) {
                    S1[i][0] = 0;
                }
            }
            if (S1[i][n - 1] != 1) continue;
            if (S1[i][n - 2] == 0) {
                S1[i][n - 1] = 0;
                continue;
            }
            if (i == 0) {
                if (S1[i + 1][n - 1] != 0) continue;
                S1[i][n - 1] = 0;
                continue;
            }
            if (i == m - 1) {
                if (S1[m - 2][n - 1] != 0) continue;
                S1[i][n - 1] = 0;
                continue;
            }
            if (S1[i - 1][n - 1] != 0 || S1[i + 1][n - 1] != 0) continue;
            S1[i][n - 1] = 0;
        }
        int[][] S2 = new int[m + 2][n + 2];
        for (i = 0; i < m + 2; ++i) {
            for (j = 0; j < n + 2; ++j) {
                S2[i][j] = i == 0 || i == m + 1 ? 0 : (j == 0 || j == n + 1 ? 0 : S1[i - 1][j - 1]);
            }
        }
        int[][] UNum = new int[m + 2][n + 2];
        for (i = 0; i < m + 2; ++i) {
            for (j = 0; j < n + 2; ++j) {
                if (S2[i][j] == 1) {
                    l = S2[i][j - 1];
                    r = S2[i][j + 1];
                    b = S2[i - 1][j];
                    t = S2[i + 1][j];
                    lb = S2[i - 1][j - 1];
                    rb = S2[i - 1][j + 1];
                    lt = S2[i + 1][j - 1];
                    rt = S2[i + 1][j + 1];
                    if (l == 1 && r == 1 && b == 1 && t == 1 && (lb == 0 && rt == 0 || rb == 0 && lt == 0)) {
                        UNum[i][j] = 2;
                        continue;
                    }
                    UNum[i][j] = 1;
                    continue;
                }
                UNum[i][j] = 0;
            }
        }
        int i3 = 0;
        int j3 = 0;
        for (i = 1; i < m + 1; ++i) {
            for (j = 1; j < n + 1; ++j) {
                int[] ij3;
                if (S2[i][j] != 1) continue;
                ArrayList<PointD> pointList = new ArrayList<PointD>();
                ArrayList<IJPoint> ijPList = new ArrayList<IJPoint>();
                aPoint = new PointD();
                aPoint.X = X[j - 1];
                aPoint.Y = Y[i - 1];
                IJPoint aijPoint = new IJPoint();
                aijPoint.I = i - 1;
                aijPoint.J = j - 1;
                pointList.add(aPoint);
                ijPList.add(aijPoint);
                int sI = i;
                int sJ = j;
                int i2 = i;
                int j2 = j;
                int i1 = i2;
                int j1 = -1;
                while (Contour.traceBorder(S2, i1, i2, j1, j2, ij3 = new int[]{i3, j3})) {
                    i3 = ij3[0];
                    j3 = ij3[1];
                    i1 = i2;
                    j1 = j2;
                    i2 = i3;
                    j2 = j3;
                    UNum[i3][j3] = UNum[i3][j3] - 1;
                    if (UNum[i3][j3] == 0) {
                        S2[i3][j3] = 3;
                    }
                    aPoint = new PointD();
                    aPoint.X = X[j3 - 1];
                    aPoint.Y = Y[i3 - 1];
                    aijPoint = new IJPoint();
                    aijPoint.I = i3 - 1;
                    aijPoint.J = j3 - 1;
                    pointList.add(aPoint);
                    ijPList.add(aijPoint);
                    if (i3 != sI || j3 != sJ) continue;
                    break;
                }
                UNum[i][j] = UNum[i][j] - 1;
                if (UNum[i][j] == 0) {
                    S2[i][j] = 3;
                }
                if (pointList.size() <= 1) continue;
                BorderLine aBLine = new BorderLine();
                aBLine.area = Contour.getExtentAndArea(pointList, aBLine.extent);
                aBLine.isOutLine = true;
                aBLine.isClockwise = true;
                aBLine.pointList = pointList;
                aBLine.ijPointList = ijPList;
                borderLines.add(aBLine);
            }
        }
        ArrayList<Border> borders = new ArrayList<Border>();
        block16: for (i = 1; i < borderLines.size(); ++i) {
            aLine = (BorderLine)borderLines.get(i);
            for (j = 0; j < i; ++j) {
                bLine = (BorderLine)borderLines.get(j);
                if (!(aLine.area > bLine.area)) continue;
                borderLines.remove(i);
                borderLines.add(j, aLine);
                continue block16;
            }
        }
        if (borderLines.size() == 1) {
            aLine = (BorderLine)borderLines.get(0);
            if (!Contour.isClockwise(aLine.pointList)) {
                Collections.reverse(aLine.pointList);
                Collections.reverse(aLine.ijPointList);
            }
            aLine.isClockwise = true;
            ArrayList<BorderLine> lineList = new ArrayList<BorderLine>();
            lineList.add(aLine);
            Border aBorder = new Border();
            aBorder.LineList = lineList;
            borders.add(aBorder);
        } else {
            for (i = 0; i < borderLines.size() && i != borderLines.size(); ++i) {
                aLine = (BorderLine)borderLines.get(i);
                if (!Contour.isClockwise(aLine.pointList)) {
                    Collections.reverse(aLine.pointList);
                    Collections.reverse(aLine.ijPointList);
                }
                aLine.isClockwise = true;
                ArrayList<BorderLine> lineList = new ArrayList<BorderLine>();
                lineList.add(aLine);
                for (j = i + 1; j < borderLines.size() && j != borderLines.size(); ++j) {
                    bLine = (BorderLine)borderLines.get(j);
                    if (!(bLine.extent.xMin > aLine.extent.xMin) || !(bLine.extent.xMax < aLine.extent.xMax) || !(bLine.extent.yMin > aLine.extent.yMin) || !(bLine.extent.yMax < aLine.extent.yMax) || !Contour.pointInPolygon(aLine.pointList, aPoint = bLine.pointList.get(0))) continue;
                    bLine.isOutLine = false;
                    if (Contour.isClockwise(bLine.pointList)) {
                        Collections.reverse(bLine.pointList);
                        Collections.reverse(bLine.ijPointList);
                    }
                    bLine.isClockwise = false;
                    lineList.add(bLine);
                    borderLines.remove(j);
                    --j;
                }
                Border aBorder = new Border();
                aBorder.LineList = lineList;
                borders.add(aBorder);
            }
        }
        return borders;
    }

    private static List<PolyLine> createContourLines_UndefData(double[][] S0, double[] X, double[] Y, int nc, double[] contour, int[][] S1, double undefData, List<Border> borders) {
        BorderLine aBLine;
        Border aBorder;
        int j;
        int i;
        ArrayList<PolyLine> contourLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        double dShift = contour[0] * 1.0E-5;
        if (dShift == 0.0) {
            dShift = 1.0E-5;
        }
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                if (Contour.doubleEquals(S0[i][j], undefData)) continue;
                S0[i][j] = S0[i][j] + dShift;
            }
        }
        int[][][] SB = new int[2][m][n - 1];
        int[][][] HB = new int[2][m - 1][n];
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                if (j < n - 1) {
                    SB[0][i][j] = -1;
                    SB[1][i][j] = -1;
                }
                if (i >= m - 1) continue;
                HB[0][i][j] = -1;
                HB[1][i][j] = -1;
            }
        }
        for (i = 0; i < borders.size(); ++i) {
            aBorder = borders.get(i);
            for (j = 0; j < aBorder.getLineNum(); ++j) {
                aBLine = aBorder.LineList.get(j);
                List<IJPoint> ijPList = aBLine.ijPointList;
                for (int k = 0; k < ijPList.size() - 1; ++k) {
                    int sj;
                    int si;
                    IJPoint aijP = ijPList.get(k);
                    IJPoint bijP = ijPList.get(k + 1);
                    if (aijP.I == bijP.I) {
                        si = aijP.I;
                        sj = Math.min(aijP.J, bijP.J);
                        SB[0][si][sj] = i;
                        if (bijP.J > aijP.J) {
                            SB[1][si][sj] = 1;
                            continue;
                        }
                        SB[1][si][sj] = 0;
                        continue;
                    }
                    sj = aijP.J;
                    si = Math.min(aijP.I, bijP.I);
                    HB[0][si][sj] = i;
                    HB[1][si][sj] = bijP.I > aijP.I ? 0 : 1;
                }
            }
        }
        double[][] S = new double[m][n - 1];
        double[][] H = new double[m - 1][n];
        for (int c = 0; c < nc; ++c) {
            double w = contour[c];
            for (i = 0; i < m; ++i) {
                for (j = 0; j < n; ++j) {
                    if (j < n - 1) {
                        S[i][j] = S1[i][j] != 0 && S1[i][j + 1] != 0 ? ((S0[i][j] - w) * (S0[i][j + 1] - w) < 0.0 ? (w - S0[i][j]) / (S0[i][j + 1] - S0[i][j]) : -2.0) : -2.0;
                    }
                    if (i >= m - 1) continue;
                    if (S1[i][j] != 0 && S1[i + 1][j] != 0) {
                        if ((S0[i][j] - w) * (S0[i + 1][j] - w) < 0.0) {
                            H[i][j] = (w - S0[i][j]) / (S0[i + 1][j] - S0[i][j]);
                            continue;
                        }
                        H[i][j] = -2.0;
                        continue;
                    }
                    H[i][j] = -2.0;
                }
            }
            List<PolyLine> cLineList = Contour.isoline_UndefData(S0, X, Y, w, S, H, SB, HB, contourLineList.size());
            contourLineList.addAll(cLineList);
        }
        for (i = 0; i < borders.size(); ++i) {
            aBorder = borders.get(i);
            aBLine = aBorder.LineList.get(0);
            for (j = 0; j < contourLineList.size(); ++j) {
                PointD aPoint;
                PolyLine aLine = (PolyLine)contourLineList.get(j);
                if (aLine.Type.equals("Close") && Contour.pointInPolygon(aBLine.pointList, aPoint = aLine.PointList.get(0))) {
                    aLine.BorderIdx = i;
                }
                contourLineList.remove(j);
                contourLineList.add(j, aLine);
            }
        }
        return contourLineList;
    }

    private static List<PolyLine> createContourLines(double[][] S0, double[] X, double[] Y, int nc, double[] contour, double nx, double ny) {
        int j;
        int i;
        ArrayList<PolyLine> contourLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        double[][] S = new double[m][n - 1];
        double[][] H = new double[m - 1][n];
        double dShift = contour[0] * 1.0E-5;
        if (dShift == 0.0) {
            dShift = 1.0E-5;
        }
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                S0[i][j] = S0[i][j] + dShift;
            }
        }
        for (int c = 0; c < nc; ++c) {
            double w = contour[c];
            for (i = 0; i < m; ++i) {
                for (j = 0; j < n; ++j) {
                    if (j < n - 1) {
                        S[i][j] = (S0[i][j] - w) * (S0[i][j + 1] - w) < 0.0 ? (w - S0[i][j]) / (S0[i][j + 1] - S0[i][j]) : -2.0;
                    }
                    if (i >= m - 1) continue;
                    H[i][j] = (S0[i][j] - w) * (S0[i + 1][j] - w) < 0.0 ? (w - S0[i][j]) / (S0[i + 1][j] - S0[i][j]) : -2.0;
                }
            }
            List<PolyLine> bLineList = Contour.isoline_Bottom(S0, X, Y, w, nx, ny, S, H);
            List<PolyLine> lLineList = Contour.isoline_Left(S0, X, Y, w, nx, ny, S, H);
            List<PolyLine> tLineList = Contour.isoline_Top(S0, X, Y, w, nx, ny, S, H);
            List<PolyLine> rLineList = Contour.isoline_Right(S0, X, Y, w, nx, ny, S, H);
            List<PolyLine> cLineList = Contour.isoline_Close(S0, X, Y, w, nx, ny, S, H);
            contourLineList.addAll(bLineList);
            contourLineList.addAll(lLineList);
            contourLineList.addAll(tLineList);
            contourLineList.addAll(rLineList);
            contourLineList.addAll(cLineList);
        }
        return contourLineList;
    }

    private static List<PolyLine> cutContourWithPolygon(List<PolyLine> alinelist, List<PointD> polyList) {
        ArrayList<PolyLine> newLineList = new ArrayList<PolyLine>();
        PolyLine bLine = new PolyLine();
        EndPoint aEndPoint = new EndPoint();
        _endPointList = new ArrayList<EndPoint>();
        if (!Contour.isClockwise(polyList)) {
            Collections.reverse(polyList);
        }
        for (int i = 0; i < alinelist.size(); ++i) {
            int j;
            PolyLine aLine = alinelist.get(i);
            double aValue = aLine.Value;
            String aType = aLine.Type;
            ArrayList<PointD> aPList = new ArrayList<PointD>(aLine.PointList);
            boolean ifInPolygon = false;
            ArrayList<PointD> newPlist = new ArrayList<PointD>();
            if (aType.equals("Close") && Contour.pointInPolygon(polyList, (PointD)aPList.get(0))) {
                boolean isAllIn = true;
                int notInIdx = 0;
                for (j = 0; j < aPList.size(); ++j) {
                    if (Contour.pointInPolygon(polyList, (PointD)aPList.get(j))) continue;
                    notInIdx = j;
                    isAllIn = false;
                    break;
                }
                if (!isAllIn) {
                    ArrayList bPList = new ArrayList();
                    for (j = notInIdx; j < aPList.size(); ++j) {
                        bPList.add(aPList.get(j));
                    }
                    for (j = 1; j < notInIdx; ++j) {
                        bPList.add(aPList.get(j));
                    }
                    bPList.add(bPList.get(0));
                    aPList = bPList;
                }
            }
            PointD p1 = new PointD();
            for (j = 0; j < aPList.size(); ++j) {
                Line lineB;
                PointD q2;
                int k;
                PointD IPoint;
                PointD q1;
                Line lineA;
                PointD p2 = (PointD)aPList.get(j);
                if (Contour.pointInPolygon(polyList, p2)) {
                    if (!ifInPolygon && j > 0) {
                        lineA = new Line();
                        lineA.P1 = p1;
                        lineA.P2 = p2;
                        q1 = polyList.get(polyList.size() - 1);
                        IPoint = new PointD();
                        for (k = 0; k < polyList.size(); ++k) {
                            q2 = polyList.get(k);
                            lineB = new Line();
                            lineB.P1 = q1;
                            lineB.P2 = q2;
                            if (Contour.isLineSegmentCross(lineA, lineB)) {
                                IPoint = Contour.getCrossPoint(lineA, lineB);
                                aEndPoint.sPoint = q1;
                                aEndPoint.Point = IPoint;
                                aEndPoint.Index = newLineList.size();
                                _endPointList.add(aEndPoint);
                                break;
                            }
                            q1 = q2;
                        }
                        newPlist.add(IPoint);
                        aType = "Border";
                    }
                    newPlist.add((PointD)aPList.get(j));
                    ifInPolygon = true;
                } else if (ifInPolygon) {
                    lineA = new Line();
                    lineA.P1 = p1;
                    lineA.P2 = p2;
                    q1 = polyList.get(polyList.size() - 1);
                    IPoint = new PointD();
                    for (k = 0; k < polyList.size(); ++k) {
                        q2 = polyList.get(k);
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (Contour.isLineSegmentCross(lineA, lineB)) {
                            IPoint = Contour.getCrossPoint(lineA, lineB);
                            aEndPoint.sPoint = q1;
                            aEndPoint.Point = IPoint;
                            aEndPoint.Index = newLineList.size();
                            _endPointList.add(aEndPoint);
                            break;
                        }
                        q1 = q2;
                    }
                    newPlist.add(IPoint);
                    bLine.Value = aValue;
                    bLine.Type = aType;
                    bLine.PointList = newPlist;
                    newLineList.add(bLine);
                    ifInPolygon = false;
                    newPlist = new ArrayList();
                    aType = "Border";
                }
                p1 = p2;
            }
            if (!ifInPolygon || newPlist.size() <= 1) continue;
            bLine.Value = aValue;
            bLine.Type = aType;
            bLine.PointList = newPlist;
            newLineList.add(bLine);
        }
        return newLineList;
    }

    private static List<PolyLine> cutContourLines(List<PolyLine> alinelist, Border aBorder) {
        List<PointD> pointList = aBorder.LineList.get((int)0).pointList;
        ArrayList<PolyLine> newLineList = new ArrayList<PolyLine>();
        EndPoint aEndPoint = new EndPoint();
        _endPointList = new ArrayList<EndPoint>();
        if (!Contour.isClockwise(pointList)) {
            Collections.reverse(pointList);
        }
        for (int i = 0; i < alinelist.size(); ++i) {
            PolyLine bLine;
            int j;
            PolyLine aLine = alinelist.get(i);
            double aValue = aLine.Value;
            String aType = aLine.Type;
            ArrayList<PointD> aPList = new ArrayList<PointD>(aLine.PointList);
            boolean ifInPolygon = false;
            ArrayList<PointD> newPlist = new ArrayList<PointD>();
            if (aType.equals("Close") && Contour.pointInPolygon(pointList, (PointD)aPList.get(0))) {
                boolean isAllIn = true;
                int notInIdx = 0;
                for (j = 0; j < aPList.size(); ++j) {
                    if (Contour.pointInPolygon(pointList, (PointD)aPList.get(j))) continue;
                    notInIdx = j;
                    isAllIn = false;
                    break;
                }
                if (!isAllIn) {
                    ArrayList bPList = new ArrayList();
                    for (j = notInIdx; j < aPList.size(); ++j) {
                        bPList.add(aPList.get(j));
                    }
                    for (j = 1; j < notInIdx; ++j) {
                        bPList.add(aPList.get(j));
                    }
                    bPList.add(bPList.get(0));
                    aPList = bPList;
                }
            }
            PointD p1 = new PointD();
            for (j = 0; j < aPList.size(); ++j) {
                Line lineB;
                PointD q2;
                int k;
                PointD IPoint;
                PointD q1;
                Line lineA;
                PointD p2 = (PointD)aPList.get(j);
                if (Contour.pointInPolygon(pointList, p2)) {
                    if (!ifInPolygon && j > 0) {
                        lineA = new Line();
                        lineA.P1 = p1;
                        lineA.P2 = p2;
                        q1 = pointList.get(pointList.size() - 1);
                        IPoint = new PointD();
                        for (k = 0; k < pointList.size(); ++k) {
                            q2 = pointList.get(k);
                            lineB = new Line();
                            lineB.P1 = q1;
                            lineB.P2 = q2;
                            if (Contour.isLineSegmentCross(lineA, lineB)) {
                                IPoint = Contour.getCrossPoint(lineA, lineB);
                                aEndPoint.sPoint = q1;
                                aEndPoint.Point = IPoint;
                                aEndPoint.Index = newLineList.size();
                                _endPointList.add(aEndPoint);
                                break;
                            }
                            q1 = q2;
                        }
                        newPlist.add(IPoint);
                        aType = "Border";
                    }
                    newPlist.add((PointD)aPList.get(j));
                    ifInPolygon = true;
                } else if (ifInPolygon) {
                    lineA = new Line();
                    lineA.P1 = p1;
                    lineA.P2 = p2;
                    q1 = pointList.get(pointList.size() - 1);
                    IPoint = new PointD();
                    for (k = 0; k < pointList.size(); ++k) {
                        q2 = pointList.get(k);
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (Contour.isLineSegmentCross(lineA, lineB)) {
                            IPoint = Contour.getCrossPoint(lineA, lineB);
                            aEndPoint.sPoint = q1;
                            aEndPoint.Point = IPoint;
                            aEndPoint.Index = newLineList.size();
                            _endPointList.add(aEndPoint);
                            break;
                        }
                        q1 = q2;
                    }
                    newPlist.add(IPoint);
                    bLine = new PolyLine();
                    bLine.Value = aValue;
                    bLine.Type = aType;
                    bLine.PointList = newPlist;
                    newLineList.add(bLine);
                    ifInPolygon = false;
                    newPlist = new ArrayList();
                    aType = "Border";
                }
                p1 = p2;
            }
            if (!ifInPolygon || newPlist.size() <= 1) continue;
            bLine = new PolyLine();
            bLine.Value = aValue;
            bLine.Type = aType;
            bLine.PointList = newPlist;
            newLineList.add(bLine);
        }
        return newLineList;
    }

    public static List<PolyLine> smoothLines(List<PolyLine> aLineList) {
        ArrayList<PolyLine> newLineList = new ArrayList<PolyLine>();
        for (int i = 0; i < aLineList.size(); ++i) {
            PointD cP;
            PointD aP;
            PointD bP;
            PolyLine aline = aLineList.get(i);
            List<PointD> newPList = new ArrayList<PointD>(aline.PointList);
            if (newPList.size() <= 1) continue;
            if (newPList.size() == 2) {
                bP = new PointD();
                aP = (PointD)newPList.get(0);
                cP = newPList.get(1);
                bP.X = (cP.X - aP.X) / 4.0 + aP.X;
                bP.Y = (cP.Y - aP.Y) / 4.0 + aP.Y;
                newPList.add(1, bP);
                bP = new PointD();
                bP.X = (cP.X - aP.X) / 4.0 * 3.0 + aP.X;
                bP.Y = (cP.Y - aP.Y) / 4.0 * 3.0 + aP.Y;
                newPList.add(2, bP);
            }
            if (newPList.size() == 3) {
                bP = new PointD();
                aP = (PointD)newPList.get(0);
                cP = newPList.get(1);
                bP.X = (cP.X - aP.X) / 2.0 + aP.X;
                bP.Y = (cP.Y - aP.Y) / 2.0 + aP.Y;
                newPList.add(1, bP);
            }
            newPList = Contour.BSplineScanning(newPList, newPList.size());
            aline.PointList = newPList;
            newLineList.add(aline);
        }
        return newLineList;
    }

    public static List<PointD> smoothPoints(List<PointD> pointList) {
        return Contour.BSplineScanning(pointList, pointList.size());
    }

    public static List<Polygon> tracingPolygons(double[][] S0, List<PolyLine> cLineList, List<Border> borderList, double[] contour) {
        List<Object> aPolygonList = new ArrayList();
        ArrayList<Polygon> newPolygonList = new ArrayList<Polygon>();
        ArrayList<BorderPoint> bPList = new ArrayList<BorderPoint>();
        ArrayList<PolyLine> lineList = new ArrayList<PolyLine>();
        ArrayList<BorderPoint> aBorderList = new ArrayList<BorderPoint>();
        double aValue = 0.0;
        for (int i = 0; i < borderList.size(); ++i) {
            List<BorderPoint> newBPList;
            Polygon aPolygon;
            IJPoint aijP;
            PolyLine aLine;
            BorderPoint aBPoint;
            PointD aPoint;
            int j;
            aBorderList.clear();
            bPList.clear();
            lineList.clear();
            aPolygonList.clear();
            Border aBorder = borderList.get(i);
            BorderLine aBLine = aBorder.LineList.get(0);
            List<PointD> PList = aBLine.pointList;
            if (!Contour.isClockwise(PList)) {
                Collections.reverse(PList);
            }
            if (aBorder.getLineNum() == 1) {
                for (j = 0; j < PList.size(); ++j) {
                    aPoint = PList.get(j);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = -1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = S0[aBLine.ijPointList.get((int)j).I][aBLine.ijPointList.get((int)j).J];
                    aBorderList.add(aBPoint);
                }
                for (j = 0; j < cLineList.size(); ++j) {
                    aLine = cLineList.get(j);
                    if (aLine.BorderIdx != i) continue;
                    lineList.add(aLine);
                    if (!aLine.Type.equals("Border")) continue;
                    aPoint = aLine.PointList.get(0);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                    aPoint = aLine.PointList.get(aLine.PointList.size() - 1);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                }
                if (lineList.isEmpty()) {
                    aijP = aBLine.ijPointList.get(0);
                    aPolygon = new Polygon();
                    if (S0[aijP.I][aijP.J] < contour[0]) {
                        aValue = contour[0];
                        aPolygon.IsHighCenter = false;
                    } else {
                        for (j = contour.length - 1; j >= 0; --j) {
                            if (!(S0[aijP.I][aijP.J] > contour[j])) continue;
                            aValue = contour[j];
                            break;
                        }
                        aPolygon.IsHighCenter = true;
                    }
                    if (PList.size() > 0) {
                        aPolygon.IsBorder = true;
                        aPolygon.HighValue = aValue;
                        aPolygon.LowValue = aValue;
                        aPolygon.Extent = new Extent();
                        aPolygon.Area = Contour.getExtentAndArea(PList, aPolygon.Extent);
                        aPolygon.StartPointIdx = 0;
                        aPolygon.IsClockWise = true;
                        aPolygon.OutLine.Type = "Border";
                        aPolygon.OutLine.Value = aValue;
                        aPolygon.OutLine.BorderIdx = i;
                        aPolygon.OutLine.PointList = PList;
                        aPolygon.HoleLines = new ArrayList<PolyLine>();
                        aPolygonList.add(aPolygon);
                    }
                } else {
                    newBPList = bPList.size() > 0 ? Contour.insertPoint2Border(bPList, aBorderList) : aBorderList;
                    aPolygonList = Contour.tracingPolygons(lineList, newBPList);
                }
                aPolygonList = Contour.addPolygonHoles(aPolygonList);
            } else {
                aBLine = aBorder.LineList.get(0);
                for (j = 0; j < cLineList.size(); ++j) {
                    aLine = cLineList.get(j);
                    if (aLine.BorderIdx != i) continue;
                    lineList.add(aLine);
                    if (!aLine.Type.equals("Border")) continue;
                    aPoint = aLine.PointList.get(0);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                    aPoint = aLine.PointList.get(aLine.PointList.size() - 1);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                }
                if (lineList.isEmpty()) {
                    aijP = aBLine.ijPointList.get(0);
                    aPolygon = new Polygon();
                    if (S0[aijP.I][aijP.J] < contour[0]) {
                        aValue = contour[0];
                        aPolygon.IsHighCenter = false;
                    } else {
                        for (j = contour.length - 1; j >= 0; --j) {
                            if (!(S0[aijP.I][aijP.J] > contour[j])) continue;
                            aValue = contour[j];
                            break;
                        }
                        aPolygon.IsHighCenter = true;
                    }
                    if (PList.size() > 0) {
                        aPolygon.IsBorder = true;
                        aPolygon.HighValue = aValue;
                        aPolygon.LowValue = aValue;
                        aPolygon.Area = Contour.getExtentAndArea(PList, aPolygon.Extent);
                        aPolygon.StartPointIdx = 0;
                        aPolygon.IsClockWise = true;
                        aPolygon.OutLine.Type = "Border";
                        aPolygon.OutLine.Value = aValue;
                        aPolygon.OutLine.BorderIdx = i;
                        aPolygon.OutLine.PointList = PList;
                        aPolygon.HoleLines = new ArrayList<PolyLine>();
                        aPolygonList.add(aPolygon);
                    }
                } else {
                    int[] pNums = new int[aBorder.getLineNum()];
                    newBPList = Contour.insertPoint2Border_Ring(S0, bPList, aBorder, pNums);
                    aPolygonList = Contour.tracingPolygons_Ring(lineList, newBPList, aBorder, contour, pNums);
                    ArrayList<Object> sortList = new ArrayList<Object>();
                    while (aPolygonList.size() > 0) {
                        boolean isInsert = false;
                        for (j = 0; j < sortList.size(); ++j) {
                            if (!(((Polygon)aPolygonList.get((int)0)).Area > ((Polygon)sortList.get((int)j)).Area)) continue;
                            sortList.add(aPolygonList.get(0));
                            isInsert = true;
                            break;
                        }
                        if (!isInsert) {
                            sortList.add(aPolygonList.get(0));
                        }
                        aPolygonList.remove(0);
                    }
                    aPolygonList = sortList;
                }
                ArrayList<List<PointD>> holeList = new ArrayList<List<PointD>>();
                for (j = 0; j < aBorder.getLineNum(); ++j) {
                    holeList.add(aBorder.LineList.get((int)j).pointList);
                }
                if (holeList.size() > 0) {
                    Contour.addHoles_Ring(aPolygonList, holeList);
                }
                aPolygonList = Contour.addPolygonHoles_Ring(aPolygonList);
            }
            newPolygonList.addAll(aPolygonList);
        }
        for (Polygon nPolygon : newPolygonList) {
            if (Contour.isClockwise(nPolygon.OutLine.PointList)) continue;
            Collections.reverse(nPolygon.OutLine.PointList);
        }
        return newPolygonList;
    }

    private static List<Polygon> createContourPolygons(List<PolyLine> LineList, Extent aBound, double[] contour) {
        List<BorderPoint> newBorderList = Contour.insertPoint2RectangleBorder(LineList, aBound);
        List<Polygon> aPolygonList = Contour.tracingPolygons(LineList, newBorderList, aBound, contour);
        return aPolygonList;
    }

    private static List<Polygon> createCutContourPolygons(List<PolyLine> LineList, List<PointD> polyList, Extent aBound, double[] contour) {
        ArrayList<BorderPoint> borderList = new ArrayList<BorderPoint>();
        if (!Contour.isClockwise(polyList)) {
            Collections.reverse(polyList);
        }
        for (int i = 0; i < polyList.size(); ++i) {
            PointD aPoint = polyList.get(i);
            BorderPoint aBPoint = new BorderPoint();
            aBPoint.Id = -1;
            aBPoint.Point = aPoint;
            borderList.add(aBPoint);
        }
        List<BorderPoint> newBorderList = Contour.insertEndPoint2Border(_endPointList, borderList);
        List<Polygon> aPolygonList = Contour.tracingPolygons(LineList, newBorderList, aBound, contour);
        return aPolygonList;
    }

    private static List<Polygon> createBorderContourPolygons(double[][] S0, List<PolyLine> cLineList, List<Border> borderList, Extent aBound, double[] contour) {
        List<Object> aPolygonList = new ArrayList();
        ArrayList<Polygon> newPolygonList = new ArrayList<Polygon>();
        ArrayList<BorderPoint> bPList = new ArrayList<BorderPoint>();
        List<Object> PList = new ArrayList();
        ArrayList<PolyLine> lineList = new ArrayList<PolyLine>();
        ArrayList<BorderPoint> aBorderList = new ArrayList<BorderPoint>();
        double aValue = 0.0;
        for (int i = 0; i < borderList.size(); ++i) {
            List<BorderPoint> newBPList;
            Polygon aPolygon;
            IJPoint aijP;
            PolyLine aLine;
            BorderPoint aBPoint;
            PointD aPoint;
            int j;
            BorderLine aBLine;
            aBorderList.clear();
            bPList.clear();
            lineList.clear();
            aPolygonList.clear();
            Border aBorder = borderList.get(i);
            if (aBorder.getLineNum() == 1) {
                aBLine = aBorder.LineList.get(0);
                PList = aBLine.pointList;
                if (!Contour.isClockwise(PList)) {
                    Collections.reverse(PList);
                }
                for (j = 0; j < PList.size(); ++j) {
                    aPoint = (PointD)PList.get(j);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = -1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = S0[aBLine.ijPointList.get((int)j).I][aBLine.ijPointList.get((int)j).J];
                    aBorderList.add(aBPoint);
                }
                for (j = 0; j < cLineList.size(); ++j) {
                    aLine = cLineList.get(j);
                    if (aLine.BorderIdx != i) continue;
                    lineList.add(aLine);
                    if (!aLine.Type.equals("Border")) continue;
                    aPoint = aLine.PointList.get(0);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                    aPoint = aLine.PointList.get(aLine.PointList.size() - 1);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                }
                if (lineList.isEmpty()) {
                    aijP = aBLine.ijPointList.get(0);
                    aPolygon = new Polygon();
                    if (S0[aijP.I][aijP.J] < contour[0]) {
                        aValue = contour[0];
                        aPolygon.IsHighCenter = false;
                    } else {
                        for (j = contour.length - 1; j >= 0; --j) {
                            if (!(S0[aijP.I][aijP.J] > contour[j])) continue;
                            aValue = contour[j];
                            break;
                        }
                        aPolygon.IsHighCenter = true;
                    }
                    if (PList.size() > 0) {
                        aPolygon.HighValue = aValue;
                        aPolygon.LowValue = aValue;
                        aPolygon.Extent = new Extent();
                        aPolygon.Area = Contour.getExtentAndArea(PList, aPolygon.Extent);
                        aPolygon.StartPointIdx = 0;
                        aPolygon.IsClockWise = true;
                        aPolygon.OutLine.Type = "Border";
                        aPolygon.OutLine.Value = aValue;
                        aPolygon.OutLine.BorderIdx = i;
                        aPolygon.OutLine.PointList = PList;
                        aPolygonList.add(aPolygon);
                    }
                } else {
                    newBPList = Contour.insertPoint2Border(bPList, aBorderList);
                    aPolygonList = Contour.tracingPolygons(lineList, newBPList);
                }
            } else {
                aBLine = aBorder.LineList.get(0);
                for (j = 0; j < cLineList.size(); ++j) {
                    aLine = cLineList.get(j);
                    if (aLine.BorderIdx != i) continue;
                    lineList.add(aLine);
                    if (!aLine.Type.equals("Border")) continue;
                    aPoint = aLine.PointList.get(0);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                    aPoint = aLine.PointList.get(aLine.PointList.size() - 1);
                    aBPoint = new BorderPoint();
                    aBPoint.Id = lineList.size() - 1;
                    aBPoint.Point = aPoint;
                    aBPoint.Value = aLine.Value;
                    bPList.add(aBPoint);
                }
                if (lineList.isEmpty()) {
                    aPolygon = new Polygon();
                    aijP = aBLine.ijPointList.get(0);
                    if (S0[aijP.I][aijP.J] < contour[0]) {
                        aValue = contour[0];
                        aPolygon.IsHighCenter = false;
                    } else {
                        for (j = contour.length - 1; j >= 0; --j) {
                            if (!(S0[aijP.I][aijP.J] > contour[j])) continue;
                            aValue = contour[j];
                            break;
                        }
                        aPolygon.IsHighCenter = true;
                    }
                    if (PList.size() > 0) {
                        aPolygon.HighValue = aValue;
                        aPolygon.LowValue = aValue;
                        aPolygon.Area = Contour.getExtentAndArea(PList, aPolygon.Extent);
                        aPolygon.StartPointIdx = 0;
                        aPolygon.IsClockWise = true;
                        aPolygon.OutLine.Type = "Border";
                        aPolygon.OutLine.Value = aValue;
                        aPolygon.OutLine.BorderIdx = i;
                        aPolygon.OutLine.PointList = PList;
                        aPolygonList.add(aPolygon);
                    }
                } else {
                    int[] pNums = new int[aBorder.getLineNum()];
                    newBPList = Contour.insertPoint2Border_Ring(S0, bPList, aBorder, pNums);
                    aPolygonList = Contour.tracingPolygons_Ring(lineList, newBPList, aBorder, contour, pNums);
                }
            }
            newPolygonList.addAll(aPolygonList);
        }
        return newPolygonList;
    }

    public static boolean pointInPolygon(List<PointD> poly, PointD aPoint) {
        boolean inside = false;
        int nPoints = poly.size();
        if (nPoints < 3) {
            return false;
        }
        double xOld = poly.get((int)(nPoints - 1)).X;
        double yOld = poly.get((int)(nPoints - 1)).Y;
        for (int i = 0; i < nPoints; ++i) {
            double y2;
            double y1;
            double x2;
            double x1;
            double xNew = poly.get((int)i).X;
            double yNew = poly.get((int)i).Y;
            if (xNew > xOld) {
                x1 = xOld;
                x2 = xNew;
                y1 = yOld;
                y2 = yNew;
            } else {
                x1 = xNew;
                x2 = xOld;
                y1 = yNew;
                y2 = yOld;
            }
            if (xNew < aPoint.X == aPoint.X <= xOld && (aPoint.Y - y1) * (x2 - x1) < (y2 - y1) * (aPoint.X - x1)) {
                inside = !inside;
            }
            xOld = xNew;
            yOld = yNew;
        }
        return inside;
    }

    public static boolean pointInPolygon(Polygon aPolygon, PointD aPoint) {
        if (aPolygon.HasHoles()) {
            boolean isIn = Contour.pointInPolygon(aPolygon.OutLine.PointList, aPoint);
            if (isIn) {
                for (PolyLine aLine : aPolygon.HoleLines) {
                    if (!Contour.pointInPolygon(aLine.PointList, aPoint)) continue;
                    isIn = false;
                    break;
                }
            }
            return isIn;
        }
        return Contour.pointInPolygon(aPolygon.OutLine.PointList, aPoint);
    }

    public static List<PolyLine> clipPolylines(List<PolyLine> polylines, List<PointD> clipPList) {
        ArrayList<PolyLine> newPolylines = new ArrayList<PolyLine>();
        for (PolyLine aPolyline : polylines) {
            newPolylines.addAll(Contour.cutPolyline(aPolyline, clipPList));
        }
        return newPolylines;
    }

    public static List<Polygon> clipPolygons(List<Polygon> polygons, List<PointD> clipPList) {
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon aPolygon = polygons.get(i);
            if (aPolygon.HasHoles()) {
                newPolygons.addAll(Contour.cutPolygon_Hole(aPolygon, clipPList));
                continue;
            }
            newPolygons.addAll(Contour.cutPolygon(aPolygon, clipPList));
        }
        ArrayList<Polygon> outPolygons = new ArrayList<Polygon>();
        for (int i = 0; i < newPolygons.size(); ++i) {
            Polygon aPolygon = (Polygon)newPolygons.get(i);
            boolean isInserted = false;
            for (int j = 0; j < outPolygons.size(); ++j) {
                if (!(aPolygon.Area > ((Polygon)outPolygons.get((int)j)).Area)) continue;
                outPolygons.add(j, aPolygon);
                isInserted = true;
                break;
            }
            if (isInserted) continue;
            outPolygons.add(aPolygon);
        }
        return outPolygons;
    }

    private static boolean traceBorder(int[][] S1, int i1, int i2, int j1, int j2, int[] ij3) {
        boolean canTrace = true;
        if (i1 < i2) {
            if (S1[i2][j2 - 1] == 1 && S1[i2][j2 + 1] == 1) {
                int a = S1[i2 - 1][j2 - 1];
                int b = S1[i2 + 1][j2];
                int c = S1[i2 + 1][j2 - 1];
                if (a != 0 && b == 0 || a == 0 && b != 0 && c != 0) {
                    ij3[0] = i2;
                    ij3[1] = j2 - 1;
                } else {
                    ij3[0] = i2;
                    ij3[1] = j2 + 1;
                }
            } else if (S1[i2][j2 - 1] == 1 && S1[i2 + 1][j2] == 1) {
                int a = S1[i2 + 1][j2 - 1];
                int b = S1[i2 + 1][j2 + 1];
                int c = S1[i2][j2 - 1];
                int d = S1[i2][j2 + 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2;
                        ij3[1] = j2 - 1;
                    } else {
                        ij3[0] = i2 + 1;
                        ij3[1] = j2;
                    }
                } else {
                    ij3[0] = i2;
                    ij3[1] = j2 - 1;
                }
            } else if (S1[i2][j2 + 1] == 1 && S1[i2 + 1][j2] == 1) {
                int a = S1[i2 + 1][j2 - 1];
                int b = S1[i2 + 1][j2 + 1];
                int c = S1[i2][j2 - 1];
                int d = S1[i2][j2 + 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2;
                        ij3[1] = j2 + 1;
                    } else {
                        ij3[0] = i2 + 1;
                        ij3[1] = j2;
                    }
                } else {
                    ij3[0] = i2;
                    ij3[1] = j2 + 1;
                }
            } else if (S1[i2][j2 - 1] == 1) {
                ij3[0] = i2;
                ij3[1] = j2 - 1;
            } else if (S1[i2][j2 + 1] == 1) {
                ij3[0] = i2;
                ij3[1] = j2 + 1;
            } else if (S1[i2 + 1][j2] == 1) {
                ij3[0] = i2 + 1;
                ij3[1] = j2;
            } else {
                canTrace = false;
            }
        } else if (j1 < j2) {
            if (S1[i2 + 1][j2] == 1 && S1[i2 - 1][j2] == 1) {
                int a = S1[i2 + 1][j2 - 1];
                int b = S1[i2][j2 + 1];
                int c = S1[i2 + 1][j2 + 1];
                if (a != 0 && b == 0 || a == 0 && b != 0 && c != 0) {
                    ij3[0] = i2 + 1;
                    ij3[1] = j2;
                } else {
                    ij3[0] = i2 - 1;
                    ij3[1] = j2;
                }
            } else if (S1[i2 + 1][j2] == 1 && S1[i2][j2 + 1] == 1) {
                int c = S1[i2 - 1][j2];
                int d = S1[i2 + 1][j2];
                int a = S1[i2 - 1][j2 + 1];
                int b = S1[i2 + 1][j2 + 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2 + 1;
                        ij3[1] = j2;
                    } else {
                        ij3[0] = i2;
                        ij3[1] = j2 + 1;
                    }
                } else {
                    ij3[0] = i2 + 1;
                    ij3[1] = j2;
                }
            } else if (S1[i2 - 1][j2] == 1 && S1[i2][j2 + 1] == 1) {
                int c = S1[i2 - 1][j2];
                int d = S1[i2 + 1][j2];
                int a = S1[i2 - 1][j2 + 1];
                int b = S1[i2 + 1][j2 + 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2 - 1;
                        ij3[1] = j2;
                    } else {
                        ij3[0] = i2;
                        ij3[1] = j2 + 1;
                    }
                } else {
                    ij3[0] = i2 - 1;
                    ij3[1] = j2;
                }
            } else if (S1[i2 + 1][j2] == 1) {
                ij3[0] = i2 + 1;
                ij3[1] = j2;
            } else if (S1[i2 - 1][j2] == 1) {
                ij3[0] = i2 - 1;
                ij3[1] = j2;
            } else if (S1[i2][j2 + 1] == 1) {
                ij3[0] = i2;
                ij3[1] = j2 + 1;
            } else {
                canTrace = false;
            }
        } else if (i1 > i2) {
            if (S1[i2][j2 - 1] == 1 && S1[i2][j2 + 1] == 1) {
                int a = S1[i2 + 1][j2 - 1];
                int b = S1[i2 - 1][j2];
                int c = S1[i2 - 1][j2 + 1];
                if (a != 0 && b == 0 || a == 0 && b != 0 && c != 0) {
                    ij3[0] = i2;
                    ij3[1] = j2 - 1;
                } else {
                    ij3[0] = i2;
                    ij3[1] = j2 + 1;
                }
            } else if (S1[i2][j2 - 1] == 1 && S1[i2 - 1][j2] == 1) {
                int a = S1[i2 - 1][j2 - 1];
                int b = S1[i2 - 1][j2 + 1];
                int c = S1[i2][j2 - 1];
                int d = S1[i2][j2 + 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2;
                        ij3[1] = j2 - 1;
                    } else {
                        ij3[0] = i2 - 1;
                        ij3[1] = j2;
                    }
                } else {
                    ij3[0] = i2;
                    ij3[1] = j2 - 1;
                }
            } else if (S1[i2][j2 + 1] == 1 && S1[i2 - 1][j2] == 1) {
                int a = S1[i2 - 1][j2 - 1];
                int b = S1[i2 - 1][j2 + 1];
                int c = S1[i2][j2 - 1];
                int d = S1[i2][j2 + 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2;
                        ij3[1] = j2 + 1;
                    } else {
                        ij3[0] = i2 - 1;
                        ij3[1] = j2;
                    }
                } else {
                    ij3[0] = i2;
                    ij3[1] = j2 + 1;
                }
            } else if (S1[i2][j2 - 1] == 1) {
                ij3[0] = i2;
                ij3[1] = j2 - 1;
            } else if (S1[i2][j2 + 1] == 1) {
                ij3[0] = i2;
                ij3[1] = j2 + 1;
            } else if (S1[i2 - 1][j2] == 1) {
                ij3[0] = i2 - 1;
                ij3[1] = j2;
            } else {
                canTrace = false;
            }
        } else if (j1 > j2) {
            if (S1[i2 + 1][j2] == 1 && S1[i2 - 1][j2] == 1) {
                int a = S1[i2 + 1][j2 + 1];
                int b = S1[i2][j2 - 1];
                int c = S1[i2 - 1][j2 - 1];
                if (a != 0 && b == 0 || a == 0 && b != 0 && c != 0) {
                    ij3[0] = i2 + 1;
                    ij3[1] = j2;
                } else {
                    ij3[0] = i2 - 1;
                    ij3[1] = j2;
                }
            } else if (S1[i2 + 1][j2] == 1 && S1[i2][j2 - 1] == 1) {
                int c = S1[i2 - 1][j2];
                int d = S1[i2 + 1][j2];
                int a = S1[i2 - 1][j2 - 1];
                int b = S1[i2 + 1][j2 - 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2 + 1;
                        ij3[1] = j2;
                    } else {
                        ij3[0] = i2;
                        ij3[1] = j2 - 1;
                    }
                } else {
                    ij3[0] = i2 + 1;
                    ij3[1] = j2;
                }
            } else if (S1[i2 - 1][j2] == 1 && S1[i2][j2 - 1] == 1) {
                int c = S1[i2 - 1][j2];
                int d = S1[i2 + 1][j2];
                int a = S1[i2 - 1][j2 - 1];
                int b = S1[i2 + 1][j2 - 1];
                if (a == 0 || b == 0 || c == 0 || d == 0) {
                    if (a == 0 && d == 0 || b == 0 && c == 0) {
                        ij3[0] = i2 - 1;
                        ij3[1] = j2;
                    } else {
                        ij3[0] = i2;
                        ij3[1] = j2 - 1;
                    }
                } else {
                    ij3[0] = i2 - 1;
                    ij3[1] = j2;
                }
            } else if (S1[i2 + 1][j2] == 1) {
                ij3[0] = i2 + 1;
                ij3[1] = j2;
            } else if (S1[i2 - 1][j2] == 1) {
                ij3[0] = i2 - 1;
                ij3[1] = j2;
            } else if (S1[i2][j2 - 1] == 1) {
                ij3[0] = i2;
                ij3[1] = j2 - 1;
            } else {
                canTrace = false;
            }
        }
        return canTrace;
    }

    private static boolean traceIsoline_UndefData(int i1, int i2, double[][] H, double[][] S, int j1, int j2, double[] X, double[] Y, double a2x, int[] ij3, double[] a3xy, boolean[] IsS) {
        boolean canTrace = true;
        double a3x = 0.0;
        double a3y = 0.0;
        int i3 = 0;
        int j3 = 0;
        boolean isS = true;
        if (i1 < i2) {
            if (H[i2][j2] != -2.0 && H[i2][j2 + 1] != -2.0) {
                if (H[i2][j2] < H[i2][j2 + 1]) {
                    a3x = X[j2];
                    a3y = Y[i2] + H[i2][j2] * (Y[i2 + 1] - Y[i2]);
                    i3 = i2;
                    j3 = j2;
                    H[i3][j3] = -2.0;
                    isS = false;
                } else {
                    a3x = X[j2 + 1];
                    a3y = Y[i2] + H[i2][j2 + 1] * (Y[i2 + 1] - Y[i2]);
                    i3 = i2;
                    j3 = j2 + 1;
                    H[i3][j3] = -2.0;
                    isS = false;
                }
            } else if (H[i2][j2] != -2.0 && H[i2][j2 + 1] == -2.0) {
                a3x = X[j2];
                a3y = Y[i2] + H[i2][j2] * (Y[i2 + 1] - Y[i2]);
                i3 = i2;
                j3 = j2;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (H[i2][j2] == -2.0 && H[i2][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2] + H[i2][j2 + 1] * (Y[i2 + 1] - Y[i2]);
                i3 = i2;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (S[i2 + 1][j2] != -2.0) {
                a3x = X[j2] + S[i2 + 1][j2] * (X[j2 + 1] - X[j2]);
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else {
                canTrace = false;
            }
        } else if (j1 < j2) {
            if (S[i2][j2] != -2.0 && S[i2 + 1][j2] != -2.0) {
                if (S[i2][j2] < S[i2 + 1][j2]) {
                    a3x = X[j2] + S[i2][j2] * (X[j2 + 1] - X[j2]);
                    a3y = Y[i2];
                    i3 = i2;
                    j3 = j2;
                    S[i3][j3] = -2.0;
                    isS = true;
                } else {
                    a3x = X[j2] + S[i2 + 1][j2] * (X[j2 + 1] - X[j2]);
                    a3y = Y[i2 + 1];
                    i3 = i2 + 1;
                    j3 = j2;
                    S[i3][j3] = -2.0;
                    isS = true;
                }
            } else if (S[i2][j2] != -2.0 && S[i2 + 1][j2] == -2.0) {
                a3x = X[j2] + S[i2][j2] * (X[j2 + 1] - X[j2]);
                a3y = Y[i2];
                i3 = i2;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else if (S[i2][j2] == -2.0 && S[i2 + 1][j2] != -2.0) {
                a3x = X[j2] + S[i2 + 1][j2] * (X[j2 + 1] - X[j2]);
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else if (H[i2][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2] + H[i2][j2 + 1] * (Y[i2 + 1] - Y[i2]);
                i3 = i2;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
                isS = false;
            } else {
                canTrace = false;
            }
        } else if (X[j2] < a2x) {
            if (H[i2 - 1][j2] != -2.0 && H[i2 - 1][j2 + 1] != -2.0) {
                if (H[i2 - 1][j2] > H[i2 - 1][j2 + 1]) {
                    a3x = X[j2];
                    a3y = Y[i2 - 1] + H[i2 - 1][j2] * (Y[i2] - Y[i2 - 1]);
                    i3 = i2 - 1;
                    j3 = j2;
                    H[i3][j3] = -2.0;
                    isS = false;
                } else {
                    a3x = X[j2 + 1];
                    a3y = Y[i2 - 1] + H[i2 - 1][j2 + 1] * (Y[i2] - Y[i2 - 1]);
                    i3 = i2 - 1;
                    j3 = j2 + 1;
                    H[i3][j3] = -2.0;
                    isS = false;
                }
            } else if (H[i2 - 1][j2] != -2.0 && H[i2 - 1][j2 + 1] == -2.0) {
                a3x = X[j2];
                a3y = Y[i2 - 1] + H[i2 - 1][j2] * (Y[i2] - Y[i2 - 1]);
                i3 = i2 - 1;
                j3 = j2;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (H[i2 - 1][j2] == -2.0 && H[i2 - 1][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2 - 1] + H[i2 - 1][j2 + 1] * (Y[i2] - Y[i2 - 1]);
                i3 = i2 - 1;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (S[i2 - 1][j2] != -2.0) {
                a3x = X[j2] + S[i2 - 1][j2] * (X[j2 + 1] - X[j2]);
                a3y = Y[i2 - 1];
                i3 = i2 - 1;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else {
                canTrace = false;
            }
        } else if (S[i2 + 1][j2 - 1] != -2.0 && S[i2][j2 - 1] != -2.0) {
            if (S[i2 + 1][j2 - 1] > S[i2][j2 - 1]) {
                a3x = X[j2 - 1] + S[i2 + 1][j2 - 1] * (X[j2] - X[j2 - 1]);
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2 - 1;
                S[i3][j3] = -2.0;
                isS = true;
            } else {
                a3x = X[j2 - 1] + S[i2][j2 - 1] * (X[j2] - X[j2 - 1]);
                a3y = Y[i2];
                i3 = i2;
                j3 = j2 - 1;
                S[i3][j3] = -2.0;
                isS = true;
            }
        } else if (S[i2 + 1][j2 - 1] != -2.0 && S[i2][j2 - 1] == -2.0) {
            a3x = X[j2 - 1] + S[i2 + 1][j2 - 1] * (X[j2] - X[j2 - 1]);
            a3y = Y[i2 + 1];
            i3 = i2 + 1;
            j3 = j2 - 1;
            S[i3][j3] = -2.0;
            isS = true;
        } else if (S[i2 + 1][j2 - 1] == -2.0 && S[i2][j2 - 1] != -2.0) {
            a3x = X[j2 - 1] + S[i2][j2 - 1] * (X[j2] - X[j2 - 1]);
            a3y = Y[i2];
            i3 = i2;
            j3 = j2 - 1;
            S[i3][j3] = -2.0;
            isS = true;
        } else if (H[i2][j2 - 1] != -2.0) {
            a3x = X[j2 - 1];
            a3y = Y[i2] + H[i2][j2 - 1] * (Y[i2 + 1] - Y[i2]);
            i3 = i2;
            j3 = j2 - 1;
            H[i3][j3] = -2.0;
            isS = false;
        } else {
            canTrace = false;
        }
        ij3[0] = i3;
        ij3[1] = j3;
        a3xy[0] = a3x;
        a3xy[1] = a3y;
        IsS[0] = isS;
        return canTrace;
    }

    private static boolean traceIsoline_UndefData_bak(int i1, int i2, double[][] H, double[][] S, int j1, int j2, double[] X, double[] Y, double nx, double ny, double a2x, int[] ij3, double[] a3xy, boolean[] IsS) {
        boolean canTrace = true;
        double a3x = 0.0;
        double a3y = 0.0;
        int i3 = 0;
        int j3 = 0;
        boolean isS = true;
        if (i1 < i2) {
            if (H[i2][j2] != -2.0 && H[i2][j2 + 1] != -2.0) {
                if (H[i2][j2] < H[i2][j2 + 1]) {
                    a3x = X[j2];
                    a3y = Y[i2] + H[i2][j2] * ny;
                    i3 = i2;
                    j3 = j2;
                    H[i3][j3] = -2.0;
                    isS = false;
                } else {
                    a3x = X[j2 + 1];
                    a3y = Y[i2] + H[i2][j2 + 1] * ny;
                    i3 = i2;
                    j3 = j2 + 1;
                    H[i3][j3] = -2.0;
                    isS = false;
                }
            } else if (H[i2][j2] != -2.0 && H[i2][j2 + 1] == -2.0) {
                a3x = X[j2];
                a3y = Y[i2] + H[i2][j2] * ny;
                i3 = i2;
                j3 = j2;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (H[i2][j2] == -2.0 && H[i2][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2] + H[i2][j2 + 1] * ny;
                i3 = i2;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (S[i2 + 1][j2] != -2.0) {
                a3x = X[j2] + S[i2 + 1][j2] * nx;
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else {
                canTrace = false;
            }
        } else if (j1 < j2) {
            if (S[i2][j2] != -2.0 && S[i2 + 1][j2] != -2.0) {
                if (S[i2][j2] < S[i2 + 1][j2]) {
                    a3x = X[j2] + S[i2][j2] * nx;
                    a3y = Y[i2];
                    i3 = i2;
                    j3 = j2;
                    S[i3][j3] = -2.0;
                    isS = true;
                } else {
                    a3x = X[j2] + S[i2 + 1][j2] * nx;
                    a3y = Y[i2 + 1];
                    i3 = i2 + 1;
                    j3 = j2;
                    S[i3][j3] = -2.0;
                    isS = true;
                }
            } else if (S[i2][j2] != -2.0 && S[i2 + 1][j2] == -2.0) {
                a3x = X[j2] + S[i2][j2] * nx;
                a3y = Y[i2];
                i3 = i2;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else if (S[i2][j2] == -2.0 && S[i2 + 1][j2] != -2.0) {
                a3x = X[j2] + S[i2 + 1][j2] * nx;
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else if (H[i2][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2] + H[i2][j2 + 1] * ny;
                i3 = i2;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
                isS = false;
            } else {
                canTrace = false;
            }
        } else if (X[j2] < a2x) {
            if (H[i2 - 1][j2] != -2.0 && H[i2 - 1][j2 + 1] != -2.0) {
                if (H[i2 - 1][j2] > H[i2 - 1][j2 + 1]) {
                    a3x = X[j2];
                    a3y = Y[i2 - 1] + H[i2 - 1][j2] * ny;
                    i3 = i2 - 1;
                    j3 = j2;
                    H[i3][j3] = -2.0;
                    isS = false;
                } else {
                    a3x = X[j2 + 1];
                    a3y = Y[i2 - 1] + H[i2 - 1][j2 + 1] * ny;
                    i3 = i2 - 1;
                    j3 = j2 + 1;
                    H[i3][j3] = -2.0;
                    isS = false;
                }
            } else if (H[i2 - 1][j2] != -2.0 && H[i2 - 1][j2 + 1] == -2.0) {
                a3x = X[j2];
                a3y = Y[i2 - 1] + H[i2 - 1][j2] * ny;
                i3 = i2 - 1;
                j3 = j2;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (H[i2 - 1][j2] == -2.0 && H[i2 - 1][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2 - 1] + H[i2 - 1][j2 + 1] * ny;
                i3 = i2 - 1;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
                isS = false;
            } else if (S[i2 - 1][j2] != -2.0) {
                a3x = X[j2] + S[i2 - 1][j2] * nx;
                a3y = Y[i2 - 1];
                i3 = i2 - 1;
                j3 = j2;
                S[i3][j3] = -2.0;
                isS = true;
            } else {
                canTrace = false;
            }
        } else if (S[i2 + 1][j2 - 1] != -2.0 && S[i2][j2 - 1] != -2.0) {
            if (S[i2 + 1][j2 - 1] > S[i2][j2 - 1]) {
                a3x = X[j2 - 1] + S[i2 + 1][j2 - 1] * nx;
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2 - 1;
                S[i3][j3] = -2.0;
                isS = true;
            } else {
                a3x = X[j2 - 1] + S[i2][j2 - 1] * nx;
                a3y = Y[i2];
                i3 = i2;
                j3 = j2 - 1;
                S[i3][j3] = -2.0;
                isS = true;
            }
        } else if (S[i2 + 1][j2 - 1] != -2.0 && S[i2][j2 - 1] == -2.0) {
            a3x = X[j2 - 1] + S[i2 + 1][j2 - 1] * nx;
            a3y = Y[i2 + 1];
            i3 = i2 + 1;
            j3 = j2 - 1;
            S[i3][j3] = -2.0;
            isS = true;
        } else if (S[i2 + 1][j2 - 1] == -2.0 && S[i2][j2 - 1] != -2.0) {
            a3x = X[j2 - 1] + S[i2][j2 - 1] * nx;
            a3y = Y[i2];
            i3 = i2;
            j3 = j2 - 1;
            S[i3][j3] = -2.0;
            isS = true;
        } else if (H[i2][j2 - 1] != -2.0) {
            a3x = X[j2 - 1];
            a3y = Y[i2] + H[i2][j2 - 1] * ny;
            i3 = i2;
            j3 = j2 - 1;
            H[i3][j3] = -2.0;
            isS = false;
        } else {
            canTrace = false;
        }
        ij3[0] = i3;
        ij3[1] = j3;
        a3xy[0] = a3x;
        a3xy[1] = a3y;
        IsS[0] = isS;
        return canTrace;
    }

    private static List<PolyLine> isoline_UndefData(double[][] S0, double[] X, double[] Y, double W, double[][] S, double[][] H, int[][][] SB, int[][][] HB, int lineNum) {
        boolean[] IsS;
        double[] a3xy;
        int[] ij3;
        double sy;
        double sx;
        ArrayList<PointD> pointList;
        PolyLine aLine;
        PointD aPoint;
        int j1;
        int i1;
        double a2y;
        double a2x;
        int j2;
        int i2;
        int j;
        int i;
        ArrayList<PolyLine> cLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        int i3 = 0;
        int j3 = 0;
        double a3x = 0.0;
        double a3y = 0.0;
        boolean isS = true;
        EndPoint aEndPoint = new EndPoint();
        for (i = 0; i < m; ++i) {
            for (j = 0; j < n; ++j) {
                ArrayList<PointD> pList;
                block41: {
                    boolean[] IsS2;
                    double[] a3xy2;
                    int[] ij32;
                    if (j < n - 1 && SB[0][i][j] > -1 && S[i][j] != -2.0) {
                        block40: {
                            pList = new ArrayList<PointD>();
                            i2 = i;
                            j2 = j;
                            a2x = X[j2] + S[i2][j2] * (X[j2 + 1] - X[j2]);
                            a2y = Y[i2];
                            if (SB[1][i][j] == 0) {
                                i1 = -1;
                                aEndPoint.sPoint.X = X[j + 1];
                                aEndPoint.sPoint.Y = Y[i];
                            } else {
                                i1 = i2;
                                aEndPoint.sPoint.X = X[j];
                                aEndPoint.sPoint.Y = Y[i];
                            }
                            j1 = j2;
                            aPoint = new PointD();
                            aPoint.X = a2x;
                            aPoint.Y = a2y;
                            pList.add(aPoint);
                            aEndPoint.Index = lineNum + cLineList.size();
                            aEndPoint.Point = aPoint;
                            aEndPoint.BorderIdx = SB[0][i][j];
                            _endPointList.add(aEndPoint);
                            aLine = new PolyLine();
                            aLine.Type = "Border";
                            aLine.BorderIdx = SB[0][i][j];
                            while (Contour.traceIsoline_UndefData(i1, i2, H, S, j1, j2, X, Y, a2x, ij32 = new int[]{i3, j3}, a3xy2 = new double[]{a3x, a3y}, IsS2 = new boolean[]{isS})) {
                                i3 = ij32[0];
                                j3 = ij32[1];
                                a3x = a3xy2[0];
                                a3y = a3xy2[1];
                                isS = IsS2[0];
                                aPoint = new PointD();
                                aPoint.X = a3x;
                                aPoint.Y = a3y;
                                pList.add(aPoint);
                                if (isS) {
                                    if (SB[0][i3][j3] > -1) {
                                        if (SB[1][i3][j3] == 0) {
                                            aEndPoint.sPoint.X = X[j3 + 1];
                                            aEndPoint.sPoint.Y = Y[i3];
                                        } else {
                                            aEndPoint.sPoint.X = X[j3];
                                            aEndPoint.sPoint.Y = Y[i3];
                                        }
                                        break block40;
                                    }
                                } else if (HB[0][i3][j3] > -1) {
                                    if (HB[1][i3][j3] == 0) {
                                        aEndPoint.sPoint.X = X[j3];
                                        aEndPoint.sPoint.Y = Y[i3];
                                    } else {
                                        aEndPoint.sPoint.X = X[j3];
                                        aEndPoint.sPoint.Y = Y[i3 + 1];
                                    }
                                    break block40;
                                }
                                a2x = a3x;
                                i1 = i2;
                                j1 = j2;
                                i2 = i3;
                                j2 = j3;
                            }
                            aLine.Type = "Error";
                        }
                        S[i][j] = -2.0;
                        if (pList.size() > 1 && !aLine.Type.equals("Error")) {
                            aEndPoint.Point = aPoint;
                            _endPointList.add(aEndPoint);
                            aLine.Value = W;
                            aLine.PointList = pList;
                            cLineList.add(aLine);
                        } else {
                            _endPointList.remove(_endPointList.size() - 1);
                        }
                    }
                    if (i >= m - 1 || HB[0][i][j] <= -1 || H[i][j] == -2.0) continue;
                    pList = new ArrayList();
                    i2 = i;
                    j2 = j;
                    a2x = X[j2];
                    a2y = Y[i2] + H[i2][j2] * (Y[i2 + 1] - Y[i2]);
                    i1 = i2;
                    if (HB[1][i][j] == 0) {
                        j1 = -1;
                        aEndPoint.sPoint.X = X[j];
                        aEndPoint.sPoint.Y = Y[i];
                    } else {
                        j1 = j2;
                        aEndPoint.sPoint.X = X[j];
                        aEndPoint.sPoint.Y = Y[i + 1];
                    }
                    aPoint = new PointD();
                    aPoint.X = a2x;
                    aPoint.Y = a2y;
                    pList.add(aPoint);
                    aEndPoint.Index = lineNum + cLineList.size();
                    aEndPoint.Point = aPoint;
                    aEndPoint.BorderIdx = HB[0][i][j];
                    _endPointList.add(aEndPoint);
                    aLine = new PolyLine();
                    aLine.Type = "Border";
                    aLine.BorderIdx = HB[0][i][j];
                    while (Contour.traceIsoline_UndefData(i1, i2, H, S, j1, j2, X, Y, a2x, ij32 = new int[]{i3, j3}, a3xy2 = new double[]{a3x, a3y}, IsS2 = new boolean[]{isS})) {
                        i3 = ij32[0];
                        j3 = ij32[1];
                        a3x = a3xy2[0];
                        a3y = a3xy2[1];
                        isS = IsS2[0];
                        aPoint = new PointD();
                        aPoint.X = a3x;
                        aPoint.Y = a3y;
                        pList.add(aPoint);
                        if (isS) {
                            if (SB[0][i3][j3] > -1) {
                                if (SB[1][i3][j3] == 0) {
                                    aEndPoint.sPoint.X = X[j3 + 1];
                                    aEndPoint.sPoint.Y = Y[i3];
                                } else {
                                    aEndPoint.sPoint.X = X[j3];
                                    aEndPoint.sPoint.Y = Y[i3];
                                }
                                break block41;
                            }
                        } else if (HB[0][i3][j3] > -1) {
                            if (HB[1][i3][j3] == 0) {
                                aEndPoint.sPoint.X = X[j3];
                                aEndPoint.sPoint.Y = Y[i3];
                            } else {
                                aEndPoint.sPoint.X = X[j3];
                                aEndPoint.sPoint.Y = Y[i3 + 1];
                            }
                            break block41;
                        }
                        a2x = a3x;
                        i1 = i2;
                        j1 = j2;
                        i2 = i3;
                        j2 = j3;
                    }
                    aLine.Type = "Error";
                }
                H[i][j] = -2.0;
                if (pList.size() > 1 && !aLine.Type.equals("Error")) {
                    aEndPoint.Point = aPoint;
                    _endPointList.add(aEndPoint);
                    aLine.Value = W;
                    aLine.PointList = pList;
                    cLineList.add(aLine);
                    continue;
                }
                _endPointList.remove(_endPointList.size() - 1);
            }
        }
        for (j = 0; j < n - 1; ++j) {
            if (S[0][j] != -2.0) {
                S[0][j] = -2.0;
            }
            if (S[m - 1][j] == -2.0) continue;
            S[m - 1][j] = -2.0;
        }
        for (i = 0; i < m - 1; ++i) {
            if (H[i][0] != -2.0) {
                H[i][0] = -2.0;
            }
            if (H[i][n - 1] == -2.0) continue;
            H[i][n - 1] = -2.0;
        }
        for (i = 1; i < m - 2; ++i) {
            for (j = 1; j < n - 1; ++j) {
                block42: {
                    if (H[i][j] == -2.0) continue;
                    pointList = new ArrayList<PointD>();
                    i2 = i;
                    j2 = j;
                    a2x = X[j2];
                    a2y = Y[i] + H[i][j2] * (Y[i + 1] - Y[i]);
                    j1 = -1;
                    i1 = i2;
                    sx = a2x;
                    sy = a2y;
                    aPoint = new PointD();
                    aPoint.X = a2x;
                    aPoint.Y = a2y;
                    pointList.add(aPoint);
                    aLine = new PolyLine();
                    aLine.Type = "Close";
                    while (Contour.traceIsoline_UndefData(i1, i2, H, S, j1, j2, X, Y, a2x, ij3 = new int[2], a3xy = new double[2], IsS = new boolean[1])) {
                        i3 = ij3[0];
                        j3 = ij3[1];
                        a3x = a3xy[0];
                        a3y = a3xy[1];
                        aPoint = new PointD();
                        aPoint.X = a3x;
                        aPoint.Y = a3y;
                        pointList.add(aPoint);
                        if (!(Math.abs(a3y - sy) < 1.0E-6) || !(Math.abs(a3x - sx) < 1.0E-6)) {
                            a2x = a3x;
                            i1 = i2;
                            j1 = j2;
                            i2 = i3;
                            j2 = j3;
                            continue;
                        }
                        break block42;
                    }
                    aLine.Type = "Error";
                }
                H[i][j] = -2.0;
                if (pointList.size() <= 1 || aLine.Type.equals("Error")) continue;
                aLine.Value = W;
                aLine.PointList = pointList;
                cLineList.add(aLine);
            }
        }
        for (i = 1; i < m - 1; ++i) {
            for (j = 1; j < n - 2; ++j) {
                block43: {
                    if (S[i][j] == -2.0) continue;
                    pointList = new ArrayList();
                    i2 = i;
                    j2 = j;
                    a2x = X[j2] + S[i][j] * (X[j2 + 1] - X[j2]);
                    a2y = Y[i];
                    j1 = j2;
                    i1 = -1;
                    sx = a2x;
                    sy = a2y;
                    aPoint = new PointD();
                    aPoint.X = a2x;
                    aPoint.Y = a2y;
                    pointList.add(aPoint);
                    aLine = new PolyLine();
                    aLine.Type = "Close";
                    while (Contour.traceIsoline_UndefData(i1, i2, H, S, j1, j2, X, Y, a2x, ij3 = new int[2], a3xy = new double[2], IsS = new boolean[1])) {
                        i3 = ij3[0];
                        j3 = ij3[1];
                        a3x = a3xy[0];
                        a3y = a3xy[1];
                        aPoint = new PointD();
                        aPoint.X = a3x;
                        aPoint.Y = a3y;
                        pointList.add(aPoint);
                        if (!(Math.abs(a3y - sy) < 1.0E-6) || !(Math.abs(a3x - sx) < 1.0E-6)) {
                            a2x = a3x;
                            i1 = i2;
                            j1 = j2;
                            i2 = i3;
                            j2 = j3;
                            continue;
                        }
                        break block43;
                    }
                    aLine.Type = "Error";
                }
                S[i][j] = -2.0;
                if (pointList.size() <= 1 || aLine.Type.equals("Error")) continue;
                aLine.Value = W;
                aLine.PointList = pointList;
                cLineList.add(aLine);
            }
        }
        return cLineList;
    }

    private static Object[] traceIsoline(int i1, int i2, double[][] H, double[][] S, int j1, int j2, double[] X, double[] Y, double nx, double ny, double a2x) {
        int j3;
        int i3;
        double a3y;
        double a3x;
        if (i1 < i2) {
            if (H[i2][j2] != -2.0 && H[i2][j2 + 1] != -2.0) {
                if (H[i2][j2] < H[i2][j2 + 1]) {
                    a3x = X[j2];
                    a3y = Y[i2] + H[i2][j2] * ny;
                    i3 = i2;
                    j3 = j2;
                    H[i3][j3] = -2.0;
                } else {
                    a3x = X[j2 + 1];
                    a3y = Y[i2] + H[i2][j2 + 1] * ny;
                    i3 = i2;
                    j3 = j2 + 1;
                    H[i3][j3] = -2.0;
                }
            } else if (H[i2][j2] != -2.0 && H[i2][j2 + 1] == -2.0) {
                a3x = X[j2];
                a3y = Y[i2] + H[i2][j2] * ny;
                i3 = i2;
                j3 = j2;
                H[i3][j3] = -2.0;
            } else if (H[i2][j2] == -2.0 && H[i2][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2] + H[i2][j2 + 1] * ny;
                i3 = i2;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
            } else {
                a3x = X[j2] + S[i2 + 1][j2] * nx;
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2;
                S[i3][j3] = -2.0;
            }
        } else if (j1 < j2) {
            if (S[i2][j2] != -2.0 && S[i2 + 1][j2] != -2.0) {
                if (S[i2][j2] < S[i2 + 1][j2]) {
                    a3x = X[j2] + S[i2][j2] * nx;
                    a3y = Y[i2];
                    i3 = i2;
                    j3 = j2;
                    S[i3][j3] = -2.0;
                } else {
                    a3x = X[j2] + S[i2 + 1][j2] * nx;
                    a3y = Y[i2 + 1];
                    i3 = i2 + 1;
                    j3 = j2;
                    S[i3][j3] = -2.0;
                }
            } else if (S[i2][j2] != -2.0 && S[i2 + 1][j2] == -2.0) {
                a3x = X[j2] + S[i2][j2] * nx;
                a3y = Y[i2];
                i3 = i2;
                j3 = j2;
                S[i3][j3] = -2.0;
            } else if (S[i2][j2] == -2.0 && S[i2 + 1][j2] != -2.0) {
                a3x = X[j2] + S[i2 + 1][j2] * nx;
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2;
                S[i3][j3] = -2.0;
            } else {
                a3x = X[j2 + 1];
                a3y = Y[i2] + H[i2][j2 + 1] * ny;
                i3 = i2;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
            }
        } else if (X[j2] < a2x) {
            if (H[i2 - 1][j2] != -2.0 && H[i2 - 1][j2 + 1] != -2.0) {
                if (H[i2 - 1][j2] > H[i2 - 1][j2 + 1]) {
                    a3x = X[j2];
                    a3y = Y[i2 - 1] + H[i2 - 1][j2] * ny;
                    i3 = i2 - 1;
                    j3 = j2;
                    H[i3][j3] = -2.0;
                } else {
                    a3x = X[j2 + 1];
                    a3y = Y[i2 - 1] + H[i2 - 1][j2 + 1] * ny;
                    i3 = i2 - 1;
                    j3 = j2 + 1;
                    H[i3][j3] = -2.0;
                }
            } else if (H[i2 - 1][j2] != -2.0 && H[i2 - 1][j2 + 1] == -2.0) {
                a3x = X[j2];
                a3y = Y[i2 - 1] + H[i2 - 1][j2] * ny;
                i3 = i2 - 1;
                j3 = j2;
                H[i3][j3] = -2.0;
            } else if (H[i2 - 1][j2] == -2.0 && H[i2 - 1][j2 + 1] != -2.0) {
                a3x = X[j2 + 1];
                a3y = Y[i2 - 1] + H[i2 - 1][j2 + 1] * ny;
                i3 = i2 - 1;
                j3 = j2 + 1;
                H[i3][j3] = -2.0;
            } else {
                a3x = X[j2] + S[i2 - 1][j2] * nx;
                a3y = Y[i2 - 1];
                i3 = i2 - 1;
                j3 = j2;
                S[i3][j3] = -2.0;
            }
        } else if (S[i2 + 1][j2 - 1] != -2.0 && S[i2][j2 - 1] != -2.0) {
            if (S[i2 + 1][j2 - 1] > S[i2][j2 - 1]) {
                a3x = X[j2 - 1] + S[i2 + 1][j2 - 1] * nx;
                a3y = Y[i2 + 1];
                i3 = i2 + 1;
                j3 = j2 - 1;
                S[i3][j3] = -2.0;
            } else {
                a3x = X[j2 - 1] + S[i2][j2 - 1] * nx;
                a3y = Y[i2];
                i3 = i2;
                j3 = j2 - 1;
                S[i3][j3] = -2.0;
            }
        } else if (S[i2 + 1][j2 - 1] != -2.0 && S[i2][j2 - 1] == -2.0) {
            a3x = X[j2 - 1] + S[i2 + 1][j2 - 1] * nx;
            a3y = Y[i2 + 1];
            i3 = i2 + 1;
            j3 = j2 - 1;
            S[i3][j3] = -2.0;
        } else if (S[i2 + 1][j2 - 1] == -2.0 && S[i2][j2 - 1] != -2.0) {
            a3x = X[j2 - 1] + S[i2][j2 - 1] * nx;
            a3y = Y[i2];
            i3 = i2;
            j3 = j2 - 1;
            S[i3][j3] = -2.0;
        } else {
            a3x = X[j2 - 1];
            a3y = Y[i2] + H[i2][j2 - 1] * ny;
            i3 = i2;
            j3 = j2 - 1;
            H[i3][j3] = -2.0;
        }
        return new Object[]{i3, j3, a3x, a3y};
    }

    private static List<PolyLine> isoline_Bottom(double[][] S0, double[] X, double[] Y, double W, double nx, double ny, double[][] S, double[][] H) {
        ArrayList<PolyLine> bLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        int j1 = 0;
        PointD aPoint = new PointD();
        PolyLine aLine = new PolyLine();
        for (int j = 0; j < n - 1; ++j) {
            if (S[0][j] == -2.0) continue;
            ArrayList<PointD> pointList = new ArrayList<PointD>();
            int i2 = 0;
            int j2 = j;
            double a2x = X[j] + S[0][j] * nx;
            double a2y = Y[0];
            int i1 = -1;
            aPoint.X = a2x;
            aPoint.Y = a2y;
            pointList.add(aPoint);
            while (true) {
                Object[] returnVal = Contour.traceIsoline(i1, i2, H, S, j1, j2, X, Y, nx, ny, a2x);
                int i3 = Integer.parseInt(returnVal[0].toString());
                int j3 = Integer.parseInt(returnVal[1].toString());
                double a3x = Double.parseDouble(returnVal[2].toString());
                double a3y = Double.parseDouble(returnVal[3].toString());
                aPoint.X = a3x;
                aPoint.Y = a3y;
                pointList.add(aPoint);
                if (i3 == m - 1 || j3 == n - 1 || a3y == Y[0] || a3x == X[0]) break;
                a2x = a3x;
                i1 = i2;
                j1 = j2;
                i2 = i3;
                j2 = j3;
            }
            S[0][j] = -2.0;
            if (pointList.size() <= 4) continue;
            aLine.Value = W;
            aLine.Type = "Bottom";
            aLine.PointList = new ArrayList<PointD>(pointList);
            bLineList.add(aLine);
        }
        return bLineList;
    }

    private static List<PolyLine> isoline_Left(double[][] S0, double[] X, double[] Y, double W, double nx, double ny, double[][] S, double[][] H) {
        ArrayList<PolyLine> lLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        PointD aPoint = new PointD();
        PolyLine aLine = new PolyLine();
        for (int i = 0; i < m - 1; ++i) {
            if (H[i][0] == -2.0) continue;
            ArrayList<PointD> pointList = new ArrayList<PointD>();
            int i2 = i;
            int j2 = 0;
            double a2x = X[0];
            double a2y = Y[i] + H[i][0] * ny;
            int j1 = -1;
            int i1 = i2;
            aPoint.X = a2x;
            aPoint.Y = a2y;
            pointList.add(aPoint);
            while (true) {
                Object[] returnVal = Contour.traceIsoline(i1, i2, H, S, j1, j2, X, Y, nx, ny, a2x);
                int i3 = Integer.parseInt(returnVal[0].toString());
                int j3 = Integer.parseInt(returnVal[1].toString());
                double a3x = Double.parseDouble(returnVal[2].toString());
                double a3y = Double.parseDouble(returnVal[3].toString());
                aPoint.X = a3x;
                aPoint.Y = a3y;
                pointList.add(aPoint);
                if (i3 == m - 1 || j3 == n - 1 || a3y == Y[0] || a3x == X[0]) break;
                a2x = a3x;
                i1 = i2;
                j1 = j2;
                i2 = i3;
                j2 = j3;
            }
            if (pointList.size() <= 4) continue;
            aLine.Value = W;
            aLine.Type = "Left";
            aLine.PointList = new ArrayList<PointD>(pointList);
            lLineList.add(aLine);
        }
        return lLineList;
    }

    private static List<PolyLine> isoline_Top(double[][] S0, double[] X, double[] Y, double W, double nx, double ny, double[][] S, double[][] H) {
        ArrayList<PolyLine> tLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        PointD aPoint = new PointD();
        PolyLine aLine = new PolyLine();
        for (int j = 0; j < n - 1; ++j) {
            if (S[m - 1][j] == -2.0) continue;
            ArrayList<PointD> pointList = new ArrayList<PointD>();
            int i2 = m - 1;
            int j2 = j;
            double a2x = X[j] + S[i2][j] * nx;
            double a2y = Y[i2];
            int i1 = i2;
            int j1 = j2;
            aPoint.X = a2x;
            aPoint.Y = a2y;
            pointList.add(aPoint);
            while (true) {
                Object[] returnVal = Contour.traceIsoline(i1, i2, H, S, j1, j2, X, Y, nx, ny, a2x);
                int i3 = Integer.parseInt(returnVal[0].toString());
                int j3 = Integer.parseInt(returnVal[1].toString());
                double a3x = Double.parseDouble(returnVal[2].toString());
                double a3y = Double.parseDouble(returnVal[3].toString());
                aPoint.X = a3x;
                aPoint.Y = a3y;
                pointList.add(aPoint);
                if (i3 == m - 1 || j3 == n - 1 || a3y == Y[0] || a3x == X[0]) break;
                a2x = a3x;
                i1 = i2;
                j1 = j2;
                i2 = i3;
                j2 = j3;
            }
            S[m - 1][j] = -2.0;
            if (pointList.size() <= 4) continue;
            aLine.Value = W;
            aLine.Type = "Top";
            aLine.PointList = new ArrayList<PointD>(pointList);
            tLineList.add(aLine);
        }
        return tLineList;
    }

    private static List<PolyLine> isoline_Right(double[][] S0, double[] X, double[] Y, double W, double nx, double ny, double[][] S, double[][] H) {
        ArrayList<PolyLine> rLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        PointD aPoint = new PointD();
        PolyLine aLine = new PolyLine();
        for (int i = 0; i < m - 1; ++i) {
            if (H[i][n - 1] == -2.0) continue;
            ArrayList<PointD> pointList = new ArrayList<PointD>();
            int i2 = i;
            int j2 = n - 1;
            double a2x = X[j2];
            double a2y = Y[i] + H[i][j2] * ny;
            int j1 = j2;
            int i1 = i2;
            aPoint.X = a2x;
            aPoint.Y = a2y;
            pointList.add(aPoint);
            while (true) {
                Object[] returnVal = Contour.traceIsoline(i1, i2, H, S, j1, j2, X, Y, nx, ny, a2x);
                int i3 = Integer.parseInt(returnVal[0].toString());
                int j3 = Integer.parseInt(returnVal[1].toString());
                double a3x = Double.parseDouble(returnVal[2].toString());
                double a3y = Double.parseDouble(returnVal[3].toString());
                aPoint.X = a3x;
                aPoint.Y = a3y;
                pointList.add(aPoint);
                if (i3 == m - 1 || j3 == n - 1 || a3y == Y[0] || a3x == X[0]) break;
                a2x = a3x;
                i1 = i2;
                j1 = j2;
                i2 = i3;
                j2 = j3;
            }
            if (pointList.size() <= 4) continue;
            aLine.Value = W;
            aLine.Type = "Right";
            aLine.PointList = new ArrayList<PointD>(pointList);
            rLineList.add(aLine);
        }
        return rLineList;
    }

    private static List<PolyLine> isoline_Close(double[][] S0, double[] X, double[] Y, double W, double nx, double ny, double[][] S, double[][] H) {
        double a3y;
        double a3x;
        int j3;
        int i3;
        Object[] returnVal;
        double sy;
        double sx;
        int i1;
        int j1;
        double a2y;
        double a2x;
        int j2;
        int i2;
        ArrayList<PointD> pointList;
        int j;
        int i;
        ArrayList<PolyLine> cLineList = new ArrayList<PolyLine>();
        int m = S0.length;
        int n = S0[0].length;
        PointD aPoint = new PointD();
        PolyLine aLine = new PolyLine();
        for (i = 1; i < m - 2; ++i) {
            for (j = 1; j < n - 1; ++j) {
                if (H[i][j] == -2.0) continue;
                pointList = new ArrayList<PointD>();
                i2 = i;
                j2 = j;
                a2x = X[j2];
                a2y = Y[i] + H[i][j2] * ny;
                j1 = 0;
                i1 = i2;
                sx = a2x;
                sy = a2y;
                aPoint.X = a2x;
                aPoint.Y = a2y;
                pointList.add(aPoint);
                do {
                    returnVal = Contour.traceIsoline(i1, i2, H, S, j1, j2, X, Y, nx, ny, a2x);
                    i3 = Integer.parseInt(returnVal[0].toString());
                    j3 = Integer.parseInt(returnVal[1].toString());
                    a3x = Double.parseDouble(returnVal[2].toString());
                    a3y = Double.parseDouble(returnVal[3].toString());
                    if (i3 == 0 && j3 == 0) break;
                    aPoint.X = a3x;
                    aPoint.Y = a3y;
                    pointList.add(aPoint);
                    if (Math.abs(a3y - sy) < 1.0E-6 && Math.abs(a3x - sx) < 1.0E-6) break;
                    a2x = a3x;
                    i1 = i2;
                    j1 = j2;
                    i2 = i3;
                    j2 = j3;
                } while (i2 != m - 1 && j2 != n - 1);
                H[i][j] = -2.0;
                if (pointList.size() <= 4) continue;
                aLine.Value = W;
                aLine.Type = "Close";
                aLine.PointList = new ArrayList<PointD>(pointList);
                cLineList.add(aLine);
            }
        }
        for (i = 1; i < m - 1; ++i) {
            for (j = 1; j < n - 2; ++j) {
                if (S[i][j] == -2.0) continue;
                pointList = new ArrayList();
                i2 = i;
                j2 = j;
                a2x = X[j2] + S[i][j] * nx;
                a2y = Y[i];
                j1 = j2;
                i1 = 0;
                sx = a2x;
                sy = a2y;
                aPoint.X = a2x;
                aPoint.Y = a2y;
                pointList.add(aPoint);
                do {
                    returnVal = Contour.traceIsoline(i1, i2, H, S, j1, j2, X, Y, nx, ny, a2x);
                    i3 = Integer.parseInt(returnVal[0].toString());
                    j3 = Integer.parseInt(returnVal[1].toString());
                    a3x = Double.parseDouble(returnVal[2].toString());
                    a3y = Double.parseDouble(returnVal[3].toString());
                    aPoint.X = a3x;
                    aPoint.Y = a3y;
                    pointList.add(aPoint);
                    if (Math.abs(a3y - sy) < 1.0E-6 && Math.abs(a3x - sx) < 1.0E-6) break;
                    a2x = a3x;
                    i1 = i2;
                    j1 = j2;
                    i2 = i3;
                    j2 = j3;
                } while (i2 != m - 1 && j2 != n - 1);
                S[i][j] = -2.0;
                if (pointList.size() <= 4) continue;
                aLine.Value = W;
                aLine.Type = "Close";
                aLine.PointList = new ArrayList<PointD>(pointList);
                cLineList.add(aLine);
            }
        }
        return cLineList;
    }

    private static List<Polygon> tracingPolygons(List<PolyLine> LineList, List<BorderPoint> borderList, Extent bBound, double[] contour) {
        Extent cBound2;
        Extent cBound1;
        ArrayList<Polygon> cPolygonlist;
        Polygon aPolygon;
        int j;
        PointD aPoint;
        double bValue;
        double aValue;
        int i;
        ArrayList<Object> newPList;
        ArrayList<Polygon> aPolygonList;
        block61: {
            Extent aBound;
            PolyLine aLine;
            ArrayList<PolyLine> aLineList;
            block59: {
                int outPIdx;
                boolean IfSameValue;
                BorderPoint bP;
                ArrayList<BorderPoint> lineBorderList;
                block60: {
                    if (LineList.isEmpty()) {
                        return new ArrayList<Polygon>();
                    }
                    aPolygonList = new ArrayList<Polygon>();
                    aLineList = new ArrayList<PolyLine>(LineList);
                    newPList = new ArrayList<PointD>();
                    int[] timesArray = new int[borderList.size() - 1];
                    for (i = 0; i < timesArray.length; ++i) {
                        timesArray[i] = 0;
                    }
                    aValue = 0.0;
                    bValue = 0.0;
                    lineBorderList = new ArrayList<BorderPoint>();
                    int pNum = borderList.size() - 1;
                    block1: for (i = 0; i < pNum; ++i) {
                        int vNum;
                        if (borderList.get((int)i).Id == -1) continue;
                        int pIdx = i;
                        ArrayList<PointD> aPList = new ArrayList<PointD>();
                        lineBorderList.add(borderList.get(i));
                        if (timesArray[pIdx] < 2) {
                            aPList.add(borderList.get((int)pIdx).Point);
                            if (++pIdx == pNum) {
                                pIdx = 0;
                            }
                            vNum = 0;
                            while (true) {
                                bP = borderList.get(pIdx);
                                if (bP.Id == -1) {
                                    if (timesArray[pIdx] == 1) break;
                                    aPList.add(bP.Point);
                                    int n = pIdx;
                                    timesArray[n] = timesArray[n] + 1;
                                } else {
                                    if (timesArray[pIdx] == 2) break;
                                    int n = pIdx;
                                    timesArray[n] = timesArray[n] + 1;
                                    aLine = (PolyLine)aLineList.get(bP.Id);
                                    if (vNum == 0) {
                                        aValue = aLine.Value;
                                        bValue = aLine.Value;
                                        ++vNum;
                                    } else if (aValue == bValue) {
                                        if (aLine.Value > aValue) {
                                            bValue = aLine.Value;
                                        } else if (aLine.Value < aValue) {
                                            aValue = aLine.Value;
                                        }
                                        ++vNum;
                                    }
                                    newPList = new ArrayList<PointD>(aLine.PointList);
                                    aPoint = (PointD)newPList.get(0);
                                    if (bP.Point.X != aPoint.X || bP.Point.Y != aPoint.Y) {
                                        Collections.reverse(newPList);
                                    }
                                    aPList.addAll(newPList);
                                    for (j = 0; j < borderList.size() - 1; ++j) {
                                        if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                                        int n2 = pIdx = j;
                                        timesArray[n2] = timesArray[n2] + 1;
                                        break;
                                    }
                                }
                                if (pIdx == i) {
                                    if (aPList.size() <= 0) break;
                                    aPolygon = new Polygon();
                                    aPolygon.LowValue = aValue;
                                    aPolygon.HighValue = bValue;
                                    aBound = new Extent();
                                    aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                                    aPolygon.IsClockWise = true;
                                    aPolygon.StartPointIdx = lineBorderList.size() - 1;
                                    aPolygon.Extent = aBound;
                                    aPolygon.OutLine.PointList = aPList;
                                    aPolygon.OutLine.Value = aValue;
                                    aPolygon.IsHighCenter = true;
                                    aPolygon.OutLine.Type = "Border";
                                    aPolygonList.add(aPolygon);
                                    break;
                                }
                                if (++pIdx != pNum) continue;
                                pIdx = 0;
                            }
                        }
                        if (timesArray[pIdx = i] >= 2) continue;
                        aPList = new ArrayList();
                        aPList.add(borderList.get((int)pIdx).Point);
                        if (--pIdx == -1) {
                            pIdx = pNum - 1;
                        }
                        vNum = 0;
                        while (true) {
                            bP = borderList.get(pIdx);
                            if (bP.Id == -1) {
                                if (timesArray[pIdx] == 1) continue block1;
                                aPList.add(bP.Point);
                                int n = pIdx;
                                timesArray[n] = timesArray[n] + 1;
                            } else {
                                if (timesArray[pIdx] == 2) continue block1;
                                int n = pIdx;
                                timesArray[n] = timesArray[n] + 1;
                                aLine = (PolyLine)aLineList.get(bP.Id);
                                if (vNum == 0) {
                                    aValue = aLine.Value;
                                    bValue = aLine.Value;
                                    ++vNum;
                                } else if (aValue == bValue) {
                                    if (aLine.Value > aValue) {
                                        bValue = aLine.Value;
                                    } else if (aLine.Value < aValue) {
                                        aValue = aLine.Value;
                                    }
                                    ++vNum;
                                }
                                newPList = new ArrayList<PointD>(aLine.PointList);
                                aPoint = (PointD)newPList.get(0);
                                if (bP.Point.X != aPoint.X || bP.Point.Y != aPoint.Y) {
                                    Collections.reverse(newPList);
                                }
                                aPList.addAll(newPList);
                                for (j = 0; j < borderList.size() - 1; ++j) {
                                    if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                                    int n3 = pIdx = j;
                                    timesArray[n3] = timesArray[n3] + 1;
                                    break;
                                }
                            }
                            if (pIdx == i) {
                                if (aPList.size() <= 0) continue block1;
                                aPolygon = new Polygon();
                                aPolygon.LowValue = aValue;
                                aPolygon.HighValue = bValue;
                                aBound = new Extent();
                                aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                                aPolygon.IsClockWise = false;
                                aPolygon.StartPointIdx = lineBorderList.size() - 1;
                                aPolygon.Extent = aBound;
                                aPolygon.OutLine.PointList = aPList;
                                aPolygon.OutLine.Value = aValue;
                                aPolygon.IsHighCenter = true;
                                aPolygon.OutLine.Type = "Border";
                                aPolygonList.add(aPolygon);
                                continue block1;
                            }
                            if (--pIdx != -1) continue;
                            pIdx = pNum - 1;
                        }
                    }
                    cPolygonlist = new ArrayList<Polygon>();
                    for (i = 0; i < aLineList.size(); ++i) {
                        aLine = (PolyLine)aLineList.get(i);
                        if (!aLine.Type.equals("Close") || aLine.PointList.size() <= 0) continue;
                        aPolygon = new Polygon();
                        aPolygon.LowValue = aLine.Value;
                        aPolygon.HighValue = aLine.Value;
                        aBound = new Extent();
                        aPolygon.Area = Contour.getExtentAndArea(aLine.PointList, aBound);
                        aPolygon.IsClockWise = Contour.isClockwise(aLine.PointList);
                        aPolygon.Extent = aBound;
                        aPolygon.OutLine = aLine;
                        aPolygon.IsHighCenter = true;
                        boolean isInserted = false;
                        for (j = 0; j < cPolygonlist.size(); ++j) {
                            if (!(aPolygon.Area > ((Polygon)cPolygonlist.get((int)j)).Area)) continue;
                            cPolygonlist.add(j, aPolygon);
                            isInserted = true;
                            break;
                        }
                        if (isInserted) continue;
                        cPolygonlist.add(aPolygon);
                    }
                    if (aPolygonList.size() <= 0) break block59;
                    IfSameValue = false;
                    aPolygon = (Polygon)aPolygonList.get(0);
                    if (aPolygon.LowValue == aPolygon.HighValue) {
                        block58: {
                            outPIdx = aPolygon.StartPointIdx;
                            do {
                                if (aPolygon.IsClockWise) {
                                    if (--outPIdx == -1) {
                                        outPIdx = lineBorderList.size() - 1;
                                    }
                                } else if (++outPIdx == lineBorderList.size()) {
                                    outPIdx = 0;
                                }
                                bP = (BorderPoint)lineBorderList.get(outPIdx);
                                aLine = (PolyLine)aLineList.get(bP.Id);
                                if (aLine.Value != aPolygon.LowValue) break block58;
                            } while (outPIdx != aPolygon.StartPointIdx);
                            IfSameValue = true;
                            break block60;
                        }
                        IfSameValue = false;
                    }
                }
                if (IfSameValue) {
                    if (cPolygonlist.size() > 0) {
                        Polygon cPolygon = (Polygon)cPolygonlist.get(0);
                        cBound1 = cPolygon.Extent;
                        for (i = 0; i < aPolygonList.size(); ++i) {
                            aPolygon = (Polygon)aPolygonList.get(i);
                            cBound2 = aPolygon.Extent;
                            aPolygon.IsHighCenter = !(cBound1.xMin > cBound2.xMin && cBound1.yMin > cBound2.yMin && cBound1.xMax < cBound2.xMax && cBound1.yMax < cBound2.yMax);
                        }
                    } else {
                        boolean tf = true;
                        for (i = 0; i < aPolygonList.size(); ++i) {
                            aPolygon = (Polygon)aPolygonList.get(i);
                            aPolygon.IsHighCenter = tf = !tf;
                        }
                    }
                } else {
                    block11: for (i = 0; i < aPolygonList.size(); ++i) {
                        aPolygon = (Polygon)aPolygonList.get(i);
                        if (aPolygon.LowValue != aPolygon.HighValue) continue;
                        boolean IsSides = false;
                        outPIdx = aPolygon.StartPointIdx;
                        while (true) {
                            if (aPolygon.IsClockWise) {
                                if (--outPIdx == -1) {
                                    outPIdx = lineBorderList.size() - 1;
                                }
                            } else if (++outPIdx == lineBorderList.size()) {
                                outPIdx = 0;
                            }
                            bP = (BorderPoint)lineBorderList.get(outPIdx);
                            aLine = (PolyLine)aLineList.get(bP.Id);
                            if (aLine.Value != aPolygon.LowValue) break;
                            if (outPIdx == aPolygon.StartPointIdx) continue block11;
                            IsSides = !IsSides;
                        }
                        if (IsSides) {
                            if (!(aLine.Value < aPolygon.LowValue)) continue;
                            aPolygon.IsHighCenter = false;
                            continue;
                        }
                        if (!(aLine.Value > aPolygon.LowValue)) continue;
                        aPolygon.IsHighCenter = false;
                    }
                }
                break block61;
            }
            double max = ((PolyLine)aLineList.get((int)0)).Value;
            double min = ((PolyLine)aLineList.get((int)0)).Value;
            for (PolyLine aPLine : aLineList) {
                if (aPLine.Value > max) {
                    max = aPLine.Value;
                }
                if (!(aPLine.Value < min)) continue;
                min = aPLine.Value;
            }
            aPolygon = new Polygon();
            aLine = new PolyLine();
            aLine.Type = "Border";
            aLine.Value = contour[0];
            aPolygon.IsHighCenter = false;
            if (cPolygonlist.size() > 0 && ((Polygon)cPolygonlist.get((int)0)).LowValue == max) {
                aLine.Value = contour[contour.length - 1];
                aPolygon.IsHighCenter = true;
            }
            newPList.clear();
            aPoint = new PointD();
            aPoint.X = bBound.xMin;
            aPoint.Y = bBound.yMin;
            newPList.add(aPoint);
            aPoint = new PointD();
            aPoint.X = bBound.xMin;
            aPoint.Y = bBound.yMax;
            newPList.add(aPoint);
            aPoint = new PointD();
            aPoint.X = bBound.xMax;
            aPoint.Y = bBound.yMax;
            newPList.add(aPoint);
            aPoint = new PointD();
            aPoint.X = bBound.xMax;
            aPoint.Y = bBound.yMin;
            newPList.add(aPoint);
            newPList.add(newPList.get(0));
            aLine.PointList = new ArrayList<Object>(newPList);
            if (aLine.PointList.size() > 0) {
                aPolygon.LowValue = aLine.Value;
                aPolygon.HighValue = aLine.Value;
                aBound = new Extent();
                aPolygon.Area = Contour.getExtentAndArea(aLine.PointList, aBound);
                aPolygon.IsClockWise = Contour.isClockwise(aLine.PointList);
                aPolygon.Extent = aBound;
                aPolygon.OutLine = aLine;
                aPolygonList.add(aPolygon);
            }
        }
        aPolygonList.addAll(cPolygonlist);
        int polygonNum = aPolygonList.size();
        block14: for (i = polygonNum - 1; i >= 0; --i) {
            aPolygon = (Polygon)aPolygonList.get(i);
            if (!aPolygon.OutLine.Type.equals("Close")) continue;
            cBound1 = aPolygon.Extent;
            aValue = aPolygon.LowValue;
            aPoint = aPolygon.OutLine.PointList.get(0);
            for (j = i - 1; j >= 0; --j) {
                Polygon bPolygon = (Polygon)aPolygonList.get(j);
                cBound2 = bPolygon.Extent;
                bValue = bPolygon.LowValue;
                newPList = new ArrayList<PointD>(bPolygon.OutLine.PointList);
                if (!Contour.pointInPolygon(newPList, aPoint) || !(cBound1.xMin > cBound2.xMin) || !(cBound1.yMin > cBound2.yMin) || !(cBound1.xMax < cBound2.xMax) || !(cBound1.yMax < cBound2.yMax)) continue;
                if (aValue < bValue) {
                    aPolygon.IsHighCenter = false;
                    continue block14;
                }
                if (aValue != bValue || !bPolygon.IsHighCenter) continue block14;
                aPolygon.IsHighCenter = false;
                continue block14;
            }
        }
        return aPolygonList;
    }

    private static List<Polygon> tracingPolygons(List<PolyLine> LineList, List<BorderPoint> borderList) {
        Extent aBound;
        Polygon aPolygon;
        int j;
        PolyLine aLine;
        int i;
        if (LineList.isEmpty()) {
            return new ArrayList<Polygon>();
        }
        List<Polygon> aPolygonList = new ArrayList<Polygon>();
        ArrayList<PolyLine> aLineList = new ArrayList<PolyLine>(LineList);
        int[] timesArray = new int[borderList.size() - 1];
        for (i = 0; i < timesArray.length; ++i) {
            timesArray[i] = 0;
        }
        double aValue = 0.0;
        double bValue = 0.0;
        double cValue = 0.0;
        ArrayList<BorderPoint> lineBorderList = new ArrayList<BorderPoint>();
        int pNum = borderList.size() - 1;
        block1: for (i = 0; i < pNum; ++i) {
            PointD aPoint;
            ArrayList<PointD> newPList;
            BorderPoint bP;
            int vNum;
            if (borderList.get((int)i).Id == -1) continue;
            int pIdx = i;
            ArrayList<PointD> aPList = new ArrayList<PointD>();
            lineBorderList.add(borderList.get(i));
            if (timesArray[pIdx] < 2) {
                aPList.add(borderList.get((int)pIdx).Point);
                if (++pIdx == pNum) {
                    pIdx = 0;
                }
                vNum = 0;
                while (true) {
                    bP = borderList.get(pIdx);
                    if (bP.Id == -1) {
                        if (timesArray[pIdx] == 1) break;
                        cValue = bP.Value;
                        aPList.add(bP.Point);
                        int n = pIdx;
                        timesArray[n] = timesArray[n] + 1;
                    } else {
                        if (timesArray[pIdx] == 2) break;
                        int n = pIdx;
                        timesArray[n] = timesArray[n] + 1;
                        aLine = (PolyLine)aLineList.get(bP.Id);
                        if (vNum == 0) {
                            aValue = aLine.Value;
                            bValue = aLine.Value;
                            ++vNum;
                        } else if (aValue == bValue) {
                            if (aLine.Value > aValue) {
                                bValue = aLine.Value;
                            } else if (aLine.Value < aValue) {
                                aValue = aLine.Value;
                            }
                            ++vNum;
                        }
                        newPList = new ArrayList<PointD>(aLine.PointList);
                        aPoint = (PointD)newPList.get(0);
                        if (bP.Point.X != aPoint.X || bP.Point.Y != aPoint.Y) {
                            Collections.reverse(newPList);
                        }
                        aPList.addAll(newPList);
                        for (j = 0; j < borderList.size() - 1; ++j) {
                            if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                            int n2 = pIdx = j;
                            timesArray[n2] = timesArray[n2] + 1;
                            break;
                        }
                    }
                    if (pIdx == i) {
                        if (aPList.size() <= 0) break;
                        aPolygon = new Polygon();
                        aPolygon.IsBorder = true;
                        aPolygon.LowValue = aValue;
                        aPolygon.HighValue = bValue;
                        aBound = new Extent();
                        aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                        aPolygon.IsClockWise = true;
                        aPolygon.StartPointIdx = lineBorderList.size() - 1;
                        aPolygon.Extent = aBound;
                        aPolygon.OutLine.PointList = aPList;
                        aPolygon.OutLine.Value = aValue;
                        aPolygon.IsHighCenter = true;
                        aPolygon.HoleLines = new ArrayList<PolyLine>();
                        if (aValue == bValue && cValue < aValue) {
                            aPolygon.IsHighCenter = false;
                        }
                        aPolygon.OutLine.Type = "Border";
                        aPolygonList.add(aPolygon);
                        break;
                    }
                    if (++pIdx != pNum) continue;
                    pIdx = 0;
                }
            }
            if (timesArray[pIdx = i] >= 2) continue;
            aPList = new ArrayList();
            aPList.add(borderList.get((int)pIdx).Point);
            if (--pIdx == -1) {
                pIdx = pNum - 1;
            }
            vNum = 0;
            while (true) {
                bP = borderList.get(pIdx);
                if (bP.Id == -1) {
                    if (timesArray[pIdx] == 1) continue block1;
                    cValue = bP.Value;
                    aPList.add(bP.Point);
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                } else {
                    if (timesArray[pIdx] == 2) continue block1;
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                    aLine = (PolyLine)aLineList.get(bP.Id);
                    if (vNum == 0) {
                        aValue = aLine.Value;
                        bValue = aLine.Value;
                        ++vNum;
                    } else if (aValue == bValue) {
                        if (aLine.Value > aValue) {
                            bValue = aLine.Value;
                        } else if (aLine.Value < aValue) {
                            aValue = aLine.Value;
                        }
                        ++vNum;
                    }
                    newPList = new ArrayList<PointD>(aLine.PointList);
                    aPoint = (PointD)newPList.get(0);
                    if (bP.Point.X != aPoint.X || bP.Point.Y != aPoint.Y) {
                        Collections.reverse(newPList);
                    }
                    aPList.addAll(newPList);
                    for (j = 0; j < borderList.size() - 1; ++j) {
                        if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                        int n3 = pIdx = j;
                        timesArray[n3] = timesArray[n3] + 1;
                        break;
                    }
                }
                if (pIdx == i) {
                    if (aPList.size() <= 0) continue block1;
                    aPolygon = new Polygon();
                    aPolygon.IsBorder = true;
                    aPolygon.LowValue = aValue;
                    aPolygon.HighValue = bValue;
                    aBound = new Extent();
                    aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                    aPolygon.IsClockWise = false;
                    aPolygon.StartPointIdx = lineBorderList.size() - 1;
                    aPolygon.Extent = aBound;
                    aPolygon.OutLine.PointList = aPList;
                    aPolygon.OutLine.Value = aValue;
                    aPolygon.IsHighCenter = true;
                    aPolygon.HoleLines = new ArrayList<PolyLine>();
                    if (aValue == bValue && cValue < aValue) {
                        aPolygon.IsHighCenter = false;
                    }
                    aPolygon.OutLine.Type = "Border";
                    aPolygonList.add(aPolygon);
                    continue block1;
                }
                if (--pIdx != -1) continue;
                pIdx = pNum - 1;
            }
        }
        ArrayList<Polygon> cPolygonlist = new ArrayList<Polygon>();
        for (i = 0; i < aLineList.size(); ++i) {
            aLine = (PolyLine)aLineList.get(i);
            if (!aLine.Type.equals("Close") || aLine.PointList.size() <= 0) continue;
            aPolygon = new Polygon();
            aPolygon.IsBorder = false;
            aPolygon.LowValue = aLine.Value;
            aPolygon.HighValue = aLine.Value;
            aBound = new Extent();
            aPolygon.Area = Contour.getExtentAndArea(aLine.PointList, aBound);
            aPolygon.IsClockWise = Contour.isClockwise(aLine.PointList);
            aPolygon.Extent = aBound;
            aPolygon.OutLine = aLine;
            aPolygon.IsHighCenter = true;
            aPolygon.HoleLines = new ArrayList<PolyLine>();
            boolean isInserted = false;
            for (j = 0; j < cPolygonlist.size(); ++j) {
                if (!(aPolygon.Area > ((Polygon)cPolygonlist.get((int)j)).Area)) continue;
                cPolygonlist.add(j, aPolygon);
                isInserted = true;
                break;
            }
            if (isInserted) continue;
            cPolygonlist.add(aPolygon);
        }
        aPolygonList = Contour.judgePolygonHighCenter(aPolygonList, cPolygonlist, aLineList, borderList);
        return aPolygonList;
    }

    private static List<Polygon> tracingClipPolygons(Polygon inPolygon, List<PolyLine> LineList, List<BorderPoint> borderList) {
        int i;
        if (LineList.isEmpty()) {
            return new ArrayList<Polygon>();
        }
        ArrayList<Polygon> aPolygonList = new ArrayList<Polygon>();
        ArrayList<PolyLine> aLineList = new ArrayList<PolyLine>(LineList);
        int[] timesArray = new int[borderList.size() - 1];
        for (i = 0; i < timesArray.length; ++i) {
            timesArray[i] = 0;
        }
        ArrayList<BorderPoint> lineBorderList = new ArrayList<BorderPoint>();
        int pNum = borderList.size() - 1;
        block1: for (i = 0; i < pNum; ++i) {
            Extent aBound;
            Polygon aPolygon;
            int j;
            PointD aPoint;
            ArrayList<PointD> newPList;
            PolyLine aLine;
            BorderPoint bP;
            int o;
            int aIdx;
            PointD bPoint;
            ArrayList<PointD> aPList;
            if (borderList.get((int)i).Id == -1) continue;
            int pIdx = i;
            lineBorderList.add(borderList.get(i));
            PointD b1Point = borderList.get((int)pIdx).Point;
            if (timesArray[pIdx] < 1) {
                aPList = new ArrayList<PointD>();
                aPList.add(borderList.get((int)pIdx).Point);
                if (++pIdx == pNum) {
                    pIdx = 0;
                }
                bPoint = (PointD)borderList.get((int)pIdx).Point.clone();
                if (borderList.get((int)pIdx).Id == -1) {
                    aIdx = pIdx + 10;
                    for (o = 1; o <= 10; ++o) {
                        if (borderList.get((int)(pIdx + o)).Id <= -1) continue;
                        aIdx = pIdx + o - 1;
                        break;
                    }
                    bPoint = (PointD)borderList.get((int)aIdx).Point.clone();
                } else {
                    bPoint.X = (bPoint.X + b1Point.X) / 2.0;
                    bPoint.Y = (bPoint.Y + b1Point.Y) / 2.0;
                }
                if (Contour.pointInPolygon(inPolygon, bPoint)) {
                    while (true) {
                        bP = borderList.get(pIdx);
                        if (bP.Id == -1) {
                            if (timesArray[pIdx] == 1) break;
                            aPList.add(bP.Point);
                            int n = pIdx;
                            timesArray[n] = timesArray[n] + 1;
                        } else {
                            if (timesArray[pIdx] == 1) break;
                            int n = pIdx;
                            timesArray[n] = timesArray[n] + 1;
                            aLine = (PolyLine)aLineList.get(bP.Id);
                            newPList = new ArrayList<PointD>(aLine.PointList);
                            aPoint = (PointD)newPList.get(0);
                            if (!Contour.doubleEquals(bP.Point.X, aPoint.X) || !Contour.doubleEquals(bP.Point.Y, aPoint.Y)) {
                                Collections.reverse(newPList);
                            }
                            aPList.addAll(newPList);
                            for (j = 0; j < borderList.size() - 1; ++j) {
                                if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                                int n2 = pIdx = j;
                                timesArray[n2] = timesArray[n2] + 1;
                                break;
                            }
                        }
                        if (pIdx == i) {
                            if (aPList.size() <= 0) break;
                            aPolygon = new Polygon();
                            aPolygon.IsBorder = true;
                            aPolygon.LowValue = inPolygon.LowValue;
                            aPolygon.HighValue = inPolygon.HighValue;
                            aBound = new Extent();
                            aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                            aPolygon.IsClockWise = true;
                            aPolygon.StartPointIdx = lineBorderList.size() - 1;
                            aPolygon.Extent = aBound;
                            aPolygon.OutLine.PointList = aPList;
                            aPolygon.OutLine.Value = inPolygon.LowValue;
                            aPolygon.IsHighCenter = inPolygon.IsHighCenter;
                            aPolygon.OutLine.Type = "Border";
                            aPolygon.HoleLines = new ArrayList<PolyLine>();
                            aPolygonList.add(aPolygon);
                            break;
                        }
                        if (++pIdx != pNum) continue;
                        pIdx = 0;
                    }
                }
            }
            if (timesArray[pIdx = i] >= 1) continue;
            aPList = new ArrayList();
            aPList.add(borderList.get((int)pIdx).Point);
            if (--pIdx == -1) {
                pIdx = pNum - 1;
            }
            bPoint = (PointD)borderList.get((int)pIdx).Point.clone();
            if (borderList.get((int)pIdx).Id == -1) {
                aIdx = pIdx + 10;
                for (o = 1; o <= 10; ++o) {
                    if (borderList.get((int)(pIdx + o)).Id <= -1) continue;
                    aIdx = pIdx + o - 1;
                    break;
                }
                bPoint = (PointD)borderList.get((int)aIdx).Point.clone();
            } else {
                bPoint.X = (bPoint.X + b1Point.X) / 2.0;
                bPoint.Y = (bPoint.Y + b1Point.Y) / 2.0;
            }
            if (!Contour.pointInPolygon(inPolygon, bPoint)) continue;
            while (true) {
                bP = borderList.get(pIdx);
                if (bP.Id == -1) {
                    if (timesArray[pIdx] == 1) continue block1;
                    aPList.add(bP.Point);
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                } else {
                    if (timesArray[pIdx] == 1) continue block1;
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                    aLine = (PolyLine)aLineList.get(bP.Id);
                    newPList = new ArrayList<PointD>(aLine.PointList);
                    aPoint = (PointD)newPList.get(0);
                    if (!Contour.doubleEquals(bP.Point.X, aPoint.X) || !Contour.doubleEquals(bP.Point.Y, aPoint.Y)) {
                        Collections.reverse(newPList);
                    }
                    aPList.addAll(newPList);
                    for (j = 0; j < borderList.size() - 1; ++j) {
                        if (j == pIdx || borderList.get((int)j).Id != bP.Id) continue;
                        int n3 = pIdx = j;
                        timesArray[n3] = timesArray[n3] + 1;
                        break;
                    }
                }
                if (pIdx == i) {
                    if (aPList.size() <= 0) continue block1;
                    aPolygon = new Polygon();
                    aPolygon.IsBorder = true;
                    aPolygon.LowValue = inPolygon.LowValue;
                    aPolygon.HighValue = inPolygon.HighValue;
                    aBound = new Extent();
                    aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                    aPolygon.IsClockWise = false;
                    aPolygon.StartPointIdx = lineBorderList.size() - 1;
                    aPolygon.Extent = aBound;
                    aPolygon.OutLine.PointList = aPList;
                    aPolygon.OutLine.Value = inPolygon.LowValue;
                    aPolygon.IsHighCenter = inPolygon.IsHighCenter;
                    aPolygon.OutLine.Type = "Border";
                    aPolygon.HoleLines = new ArrayList<PolyLine>();
                    aPolygonList.add(aPolygon);
                    continue block1;
                }
                if (--pIdx != -1) continue;
                pIdx = pNum - 1;
            }
        }
        return aPolygonList;
    }

    private static List<Polygon> judgePolygonHighCenter(List<Polygon> borderPolygons, List<Polygon> closedPolygons, List<PolyLine> aLineList, List<BorderPoint> borderList) {
        Polygon aPolygon;
        ArrayList<PointD> newPList = new ArrayList();
        if (borderPolygons.isEmpty()) {
            double max = aLineList.get((int)0).Value;
            double min = aLineList.get((int)0).Value;
            for (PolyLine aPLine : aLineList) {
                if (aPLine.Value > max) {
                    max = aPLine.Value;
                }
                if (!(aPLine.Value < min)) continue;
                min = aPLine.Value;
            }
            aPolygon = new Polygon();
            double aValue = borderList.get((int)0).Value;
            if (aValue < min) {
                max = min;
                min = aValue;
                aPolygon.IsHighCenter = true;
            } else if (aValue > max) {
                min = max;
                max = aValue;
                aPolygon.IsHighCenter = false;
            }
            PolyLine aLine = new PolyLine();
            aLine.Type = "Border";
            aLine.Value = aValue;
            newPList.clear();
            for (BorderPoint aP : borderList) {
                newPList.add(aP.Point);
            }
            aLine.PointList = new ArrayList<PointD>(newPList);
            if (aLine.PointList.size() > 0) {
                aPolygon.IsBorder = true;
                aPolygon.LowValue = min;
                aPolygon.HighValue = max;
                Extent aBound = new Extent();
                aPolygon.Area = Contour.getExtentAndArea(aLine.PointList, aBound);
                aPolygon.IsClockWise = Contour.isClockwise(aLine.PointList);
                aPolygon.Extent = aBound;
                aPolygon.OutLine = aLine;
                aPolygon.HoleLines = new ArrayList<PolyLine>();
                borderPolygons.add(aPolygon);
            }
        }
        borderPolygons.addAll(closedPolygons);
        int polygonNum = borderPolygons.size();
        block2: for (int i = 1; i < polygonNum; ++i) {
            aPolygon = borderPolygons.get(i);
            if (!aPolygon.OutLine.Type.equals("Close")) continue;
            Extent cBound1 = aPolygon.Extent;
            PointD aPoint = aPolygon.OutLine.PointList.get(0);
            for (int j = i - 1; j >= 0; --j) {
                Polygon bPolygon = borderPolygons.get(j);
                Extent cBound2 = bPolygon.Extent;
                newPList = new ArrayList<PointD>(bPolygon.OutLine.PointList);
                if (!Contour.pointInPolygon(newPList, aPoint) || !(cBound1.xMin > cBound2.xMin) || !(cBound1.yMin > cBound2.yMin) || !(cBound1.xMax < cBound2.xMax) || !(cBound1.yMax < cBound2.yMax)) continue;
                if (bPolygon.IsHighCenter) {
                    aPolygon.IsHighCenter = aPolygon.HighValue != bPolygon.LowValue;
                    continue block2;
                }
                aPolygon.IsHighCenter = aPolygon.LowValue == bPolygon.HighValue;
                continue block2;
            }
        }
        return borderPolygons;
    }

    private static List<Polygon> judgePolygonHighCenter_old(List<Polygon> borderPolygons, List<Polygon> closedPolygons, List<PolyLine> aLineList, List<BorderPoint> borderList) {
        Polygon aPolygon;
        ArrayList<PointD> newPList = new ArrayList<PointD>();
        if (borderPolygons.isEmpty()) {
            double max = aLineList.get((int)0).Value;
            double min = aLineList.get((int)0).Value;
            for (PolyLine aPLine : aLineList) {
                if (aPLine.Value > max) {
                    max = aPLine.Value;
                }
                if (!(aPLine.Value < min)) continue;
                min = aPLine.Value;
            }
            aPolygon = new Polygon();
            PolyLine aLine = new PolyLine();
            aLine.Type = "Border";
            aLine.Value = min;
            aPolygon.IsHighCenter = false;
            if (closedPolygons.size() > 0 && borderList.get((int)0).Value >= closedPolygons.get((int)0).LowValue) {
                aLine.Value = max;
                aPolygon.IsHighCenter = true;
            }
            newPList.clear();
            for (BorderPoint aP : borderList) {
                newPList.add(aP.Point);
            }
            aLine.PointList = new ArrayList<PointD>(newPList);
            if (aLine.PointList.size() > 0) {
                aPolygon.IsBorder = true;
                aPolygon.LowValue = aLine.Value;
                aPolygon.HighValue = aLine.Value;
                Extent aBound = new Extent();
                aPolygon.Area = Contour.getExtentAndArea(aLine.PointList, aBound);
                aPolygon.IsClockWise = Contour.isClockwise(aLine.PointList);
                aPolygon.Extent = aBound;
                aPolygon.OutLine = aLine;
                aPolygon.HoleLines = new ArrayList<PolyLine>();
                borderPolygons.add(aPolygon);
            }
        }
        borderPolygons.addAll(closedPolygons);
        int polygonNum = borderPolygons.size();
        block2: for (int i = 1; i < polygonNum; ++i) {
            aPolygon = borderPolygons.get(i);
            if (!aPolygon.OutLine.Type.equals("Close")) continue;
            Extent cBound1 = aPolygon.Extent;
            double aValue = aPolygon.LowValue;
            PointD aPoint = aPolygon.OutLine.PointList.get(0);
            for (int j = i - 1; j >= 0; --j) {
                Polygon bPolygon = borderPolygons.get(j);
                Extent cBound2 = bPolygon.Extent;
                double bValue = bPolygon.LowValue;
                newPList = new ArrayList<PointD>(bPolygon.OutLine.PointList);
                if (!Contour.pointInPolygon(newPList, aPoint) || !(cBound1.xMin > cBound2.xMin) || !(cBound1.yMin > cBound2.yMin) || !(cBound1.xMax < cBound2.xMax) || !(cBound1.yMax < cBound2.yMax)) continue;
                if (aValue < bValue) {
                    aPolygon.IsHighCenter = false;
                    continue block2;
                }
                if (aValue != bValue || !bPolygon.IsHighCenter) continue block2;
                aPolygon.IsHighCenter = false;
                continue block2;
            }
        }
        return borderPolygons;
    }

    private static List<Polygon> tracingPolygons_Ring(List<PolyLine> LineList, List<BorderPoint> borderList, Border aBorder, double[] contour, int[] pNums) {
        Extent aBound;
        Polygon aPolygon;
        int j;
        PointD aPoint;
        ArrayList<PointD> newPList;
        PolyLine aLine;
        int i;
        ArrayList<Polygon> aPolygonList = new ArrayList<Polygon>();
        ArrayList<PolyLine> aLineList = new ArrayList<PolyLine>(LineList);
        int[] timesArray = new int[borderList.size()];
        for (i = 0; i < timesArray.length; ++i) {
            timesArray[i] = 0;
        }
        double aValue = 0.0;
        double bValue = 0.0;
        double cValue = 0.0;
        ArrayList<BorderPoint> lineBorderList = new ArrayList<BorderPoint>();
        int pNum = borderList.size();
        block1: for (i = 0; i < pNum; ++i) {
            int idx;
            int theIdx;
            int eIdx;
            int sIdx;
            int idx2;
            int baseNum;
            boolean isTooBig;
            BorderPoint bP1;
            int vNum;
            int borderIdx2;
            int borderIdx1;
            ArrayList<Integer> bIdxList;
            ArrayList<PointD> aPList;
            int innerIdx;
            BorderPoint bP;
            if (borderList.get((int)i).Id == -1) continue;
            int pIdx = i;
            lineBorderList.add(borderList.get(i));
            boolean sameBorderIdx = false;
            if (timesArray[pIdx] < 2) {
                bP = borderList.get(pIdx);
                innerIdx = bP.BInnerIdx;
                aPList = new ArrayList<PointD>();
                bIdxList = new ArrayList<Integer>();
                aPList.add(bP.Point);
                bIdxList.add(pIdx);
                borderIdx2 = borderIdx1 = bP.BorderIdx;
                ++pIdx;
                if (++innerIdx == pNums[borderIdx1] - 1) {
                    pIdx -= pNums[borderIdx1] - 1;
                }
                vNum = 0;
                while (true) {
                    bP = borderList.get(pIdx);
                    if (bP.Id == -1) {
                        if (timesArray[pIdx] == 1) break;
                        cValue = bP.Value;
                        aPList.add(bP.Point);
                        int n = pIdx;
                        timesArray[n] = timesArray[n] + 1;
                        bIdxList.add(pIdx);
                    } else {
                        if (timesArray[pIdx] == 2) break;
                        int n = pIdx;
                        timesArray[n] = timesArray[n] + 1;
                        bIdxList.add(pIdx);
                        aLine = (PolyLine)aLineList.get(bP.Id);
                        if (vNum == 0) {
                            aValue = aLine.Value;
                            bValue = aLine.Value;
                            ++vNum;
                        } else if (aValue == bValue) {
                            if (aLine.Value > aValue) {
                                bValue = aLine.Value;
                            } else if (aLine.Value < aValue) {
                                aValue = aLine.Value;
                            }
                            ++vNum;
                        }
                        newPList = new ArrayList<PointD>(aLine.PointList);
                        aPoint = (PointD)newPList.get(0);
                        if (bP.Point.X != aPoint.X || bP.Point.Y != aPoint.Y) {
                            Collections.reverse(newPList);
                        }
                        aPList.addAll(newPList);
                        for (j = 0; j < borderList.size(); ++j) {
                            if (j == pIdx) continue;
                            bP1 = borderList.get(j);
                            if (bP1.Id != bP.Id) continue;
                            pIdx = j;
                            innerIdx = bP1.BInnerIdx;
                            int n2 = pIdx;
                            timesArray[n2] = timesArray[n2] + 1;
                            bIdxList.add(pIdx);
                            borderIdx2 = bP1.BorderIdx;
                            if (bP.BorderIdx <= 0 || bP.BorderIdx != bP1.BorderIdx) break;
                            sameBorderIdx = true;
                            break;
                        }
                    }
                    if (pIdx == i) {
                        if (aPList.size() <= 0) break;
                        if (sameBorderIdx) {
                            isTooBig = false;
                            baseNum = 0;
                            for (idx2 = 0; idx2 < bP.BorderIdx; ++idx2) {
                                baseNum += pNums[idx2];
                            }
                            sIdx = baseNum;
                            eIdx = baseNum + pNums[bP.BorderIdx];
                            theIdx = sIdx;
                            for (idx = sIdx; idx < eIdx; ++idx) {
                                if (bIdxList.contains(idx)) continue;
                                theIdx = idx;
                                break;
                            }
                            if (Contour.pointInPolygon(aPList, borderList.get((int)theIdx).Point)) {
                                isTooBig = true;
                            }
                            if (isTooBig) break;
                        }
                        aPolygon = new Polygon();
                        aPolygon.IsBorder = true;
                        aPolygon.IsInnerBorder = sameBorderIdx;
                        aPolygon.LowValue = aValue;
                        aPolygon.HighValue = bValue;
                        aBound = new Extent();
                        aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                        aPolygon.IsClockWise = true;
                        aPolygon.StartPointIdx = lineBorderList.size() - 1;
                        aPolygon.Extent = aBound;
                        aPolygon.OutLine.PointList = aPList;
                        aPolygon.OutLine.Value = aValue;
                        aPolygon.IsHighCenter = true;
                        if (aValue == bValue && cValue < aValue) {
                            aPolygon.IsHighCenter = false;
                        }
                        aPolygon.OutLine.Type = "Border";
                        aPolygon.HoleLines = new ArrayList<PolyLine>();
                        aPolygonList.add(aPolygon);
                        break;
                    }
                    ++pIdx;
                    ++innerIdx;
                    if (borderIdx1 != borderIdx2) {
                        borderIdx1 = borderIdx2;
                    }
                    if (innerIdx != pNums[borderIdx1] - 1) continue;
                    pIdx -= pNums[borderIdx1] - 1;
                    innerIdx = 0;
                }
            }
            sameBorderIdx = false;
            pIdx = i;
            if (timesArray[pIdx] >= 2) continue;
            aPList = new ArrayList();
            bIdxList = new ArrayList();
            bP = borderList.get(pIdx);
            innerIdx = bP.BInnerIdx;
            aPList.add(bP.Point);
            bIdxList.add(pIdx);
            borderIdx2 = borderIdx1 = bP.BorderIdx;
            --pIdx;
            if (--innerIdx == -1) {
                pIdx += pNums[borderIdx1] - 1;
            }
            vNum = 0;
            while (true) {
                bP = borderList.get(pIdx);
                if (bP.Id == -1) {
                    if (timesArray[pIdx] == 1) continue block1;
                    cValue = bP.Value;
                    aPList.add(bP.Point);
                    bIdxList.add(pIdx);
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                } else {
                    if (timesArray[pIdx] == 2) continue block1;
                    int n = pIdx;
                    timesArray[n] = timesArray[n] + 1;
                    bIdxList.add(pIdx);
                    aLine = (PolyLine)aLineList.get(bP.Id);
                    if (vNum == 0) {
                        aValue = aLine.Value;
                        bValue = aLine.Value;
                        ++vNum;
                    } else if (aValue == bValue) {
                        if (aLine.Value > aValue) {
                            bValue = aLine.Value;
                        } else if (aLine.Value < aValue) {
                            aValue = aLine.Value;
                        }
                        ++vNum;
                    }
                    newPList = new ArrayList<PointD>(aLine.PointList);
                    aPoint = (PointD)newPList.get(0);
                    if (bP.Point.X != aPoint.X || bP.Point.Y != aPoint.Y) {
                        Collections.reverse(newPList);
                    }
                    aPList.addAll(newPList);
                    for (j = 0; j < borderList.size(); ++j) {
                        if (j == pIdx) continue;
                        bP1 = borderList.get(j);
                        if (bP1.Id != bP.Id) continue;
                        pIdx = j;
                        innerIdx = bP1.BInnerIdx;
                        int n3 = pIdx;
                        timesArray[n3] = timesArray[n3] + 1;
                        bIdxList.add(pIdx);
                        borderIdx2 = bP1.BorderIdx;
                        if (bP.BorderIdx <= 0 || bP.BorderIdx != bP1.BorderIdx) break;
                        sameBorderIdx = true;
                        break;
                    }
                }
                if (pIdx == i) {
                    if (aPList.size() <= 0) continue block1;
                    if (sameBorderIdx) {
                        isTooBig = false;
                        baseNum = 0;
                        for (idx2 = 0; idx2 < bP.BorderIdx; ++idx2) {
                            baseNum += pNums[idx2];
                        }
                        sIdx = baseNum;
                        eIdx = baseNum + pNums[bP.BorderIdx];
                        theIdx = sIdx;
                        for (idx = sIdx; idx < eIdx; ++idx) {
                            if (bIdxList.contains(idx)) continue;
                            theIdx = idx;
                            break;
                        }
                        if (Contour.pointInPolygon(aPList, borderList.get((int)theIdx).Point)) {
                            isTooBig = true;
                        }
                        if (isTooBig) continue block1;
                    }
                    aPolygon = new Polygon();
                    aPolygon.IsBorder = true;
                    aPolygon.IsInnerBorder = sameBorderIdx;
                    aPolygon.LowValue = aValue;
                    aPolygon.HighValue = bValue;
                    aBound = new Extent();
                    aPolygon.Area = Contour.getExtentAndArea(aPList, aBound);
                    aPolygon.IsClockWise = false;
                    aPolygon.StartPointIdx = lineBorderList.size() - 1;
                    aPolygon.Extent = aBound;
                    aPolygon.OutLine.PointList = aPList;
                    aPolygon.OutLine.Value = aValue;
                    aPolygon.IsHighCenter = true;
                    if (aValue == bValue && cValue < aValue) {
                        aPolygon.IsHighCenter = false;
                    }
                    aPolygon.OutLine.Type = "Border";
                    aPolygon.HoleLines = new ArrayList<PolyLine>();
                    aPolygonList.add(aPolygon);
                    continue block1;
                }
                --pIdx;
                --innerIdx;
                if (borderIdx1 != borderIdx2) {
                    borderIdx1 = borderIdx2;
                }
                if (innerIdx != -1) continue;
                pIdx += pNums[borderIdx1];
                innerIdx = pNums[borderIdx1] - 1;
            }
        }
        ArrayList<Polygon> cPolygonlist = new ArrayList<Polygon>();
        for (i = 0; i < aLineList.size(); ++i) {
            aLine = (PolyLine)aLineList.get(i);
            if (!aLine.Type.equals("Close")) continue;
            aPolygon = new Polygon();
            aPolygon.IsBorder = false;
            aPolygon.LowValue = aLine.Value;
            aPolygon.HighValue = aLine.Value;
            aBound = new Extent();
            aPolygon.Area = Contour.getExtentAndArea(aLine.PointList, aBound);
            aPolygon.IsClockWise = Contour.isClockwise(aLine.PointList);
            aPolygon.Extent = aBound;
            aPolygon.OutLine = aLine;
            aPolygon.IsHighCenter = true;
            aPolygon.HoleLines = new ArrayList<PolyLine>();
            boolean isInserted = false;
            for (j = 0; j < cPolygonlist.size(); ++j) {
                if (!(aPolygon.Area > ((Polygon)cPolygonlist.get((int)j)).Area)) continue;
                cPolygonlist.add(j, aPolygon);
                isInserted = true;
                break;
            }
            if (isInserted) continue;
            cPolygonlist.add(aPolygon);
        }
        if (aPolygonList.isEmpty()) {
            aLine = new PolyLine();
            aLine.Type = "Border";
            aLine.Value = contour[0];
            aLine.PointList = new ArrayList<PointD>(aBorder.LineList.get((int)0).pointList);
            if (aLine.PointList.size() > 0) {
                aPolygon = new Polygon();
                aPolygon.LowValue = aLine.Value;
                aPolygon.HighValue = aLine.Value;
                aBound = new Extent();
                aPolygon.Area = Contour.getExtentAndArea(aLine.PointList, aBound);
                aPolygon.IsClockWise = Contour.isClockwise(aLine.PointList);
                aPolygon.Extent = aBound;
                aPolygon.OutLine = aLine;
                aPolygon.IsHighCenter = false;
                aPolygonList.add(aPolygon);
            }
        }
        aPolygonList.addAll(cPolygonlist);
        int polygonNum = aPolygonList.size();
        block12: for (i = polygonNum - 1; i >= 0; --i) {
            aPolygon = (Polygon)aPolygonList.get(i);
            if (!aPolygon.OutLine.Type.equals("Close")) continue;
            Extent cBound1 = aPolygon.Extent;
            aValue = aPolygon.LowValue;
            aPoint = aPolygon.OutLine.PointList.get(0);
            for (j = i - 1; j >= 0; --j) {
                Polygon bPolygon = (Polygon)aPolygonList.get(j);
                Extent cBound2 = bPolygon.Extent;
                bValue = bPolygon.LowValue;
                newPList = new ArrayList<PointD>(bPolygon.OutLine.PointList);
                if (!Contour.pointInPolygon(newPList, aPoint) || !(cBound1.xMin > cBound2.xMin & cBound1.yMin > cBound2.yMin & cBound1.xMax < cBound2.xMax & cBound1.yMax < cBound2.yMax)) continue;
                if (aValue < bValue) {
                    aPolygon.IsHighCenter = false;
                    continue block12;
                }
                if (aValue != bValue || !bPolygon.IsHighCenter) continue block12;
                aPolygon.IsHighCenter = false;
                continue block12;
            }
        }
        return aPolygonList;
    }

    private static List<Polygon> addPolygonHoles(List<Polygon> polygonList) {
        int j;
        int i;
        ArrayList<Polygon> holePolygons = new ArrayList<Polygon>();
        for (i = 0; i < polygonList.size(); ++i) {
            Polygon aPolygon = polygonList.get(i);
            if (aPolygon.IsBorder) continue;
            aPolygon.HoleIndex = 1;
            holePolygons.add(aPolygon);
        }
        if (holePolygons.isEmpty()) {
            return polygonList;
        }
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        block1: for (i = 1; i < holePolygons.size(); ++i) {
            Polygon aPolygon = (Polygon)holePolygons.get(i);
            for (j = i - 1; j >= 0; --j) {
                Polygon bPolygon = (Polygon)holePolygons.get(j);
                if (!bPolygon.Extent.Include(aPolygon.Extent) || !Contour.pointInPolygon(bPolygon.OutLine.PointList, aPolygon.OutLine.PointList.get(0))) continue;
                aPolygon.HoleIndex = bPolygon.HoleIndex + 1;
                bPolygon.AddHole(aPolygon);
                continue block1;
            }
        }
        ArrayList hole1Polygons = new ArrayList();
        for (i = 0; i < holePolygons.size(); ++i) {
            if (((Polygon)holePolygons.get((int)i)).HoleIndex != 1) continue;
            hole1Polygons.add(holePolygons.get(i));
        }
        for (i = 0; i < polygonList.size(); ++i) {
            Polygon aPolygon = polygonList.get(i);
            if (!aPolygon.IsBorder) continue;
            for (j = 0; j < hole1Polygons.size(); ++j) {
                Polygon bPolygon = (Polygon)hole1Polygons.get(j);
                if (!aPolygon.Extent.Include(bPolygon.Extent) || !Contour.pointInPolygon(aPolygon.OutLine.PointList, bPolygon.OutLine.PointList.get(0))) continue;
                aPolygon.AddHole(bPolygon);
            }
            newPolygons.add(aPolygon);
        }
        newPolygons.addAll(holePolygons);
        return newPolygons;
    }

    private static List<Polygon> addPolygonHoles_Ring(List<Polygon> polygonList) {
        int j;
        int i;
        ArrayList<Polygon> holePolygons = new ArrayList<Polygon>();
        for (i = 0; i < polygonList.size(); ++i) {
            Polygon aPolygon = polygonList.get(i);
            if (aPolygon.IsBorder && !aPolygon.IsInnerBorder) continue;
            aPolygon.HoleIndex = 1;
            holePolygons.add(aPolygon);
        }
        if (holePolygons.isEmpty()) {
            return polygonList;
        }
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        block1: for (i = 1; i < holePolygons.size(); ++i) {
            Polygon aPolygon = (Polygon)holePolygons.get(i);
            for (j = i - 1; j >= 0; --j) {
                Polygon bPolygon = (Polygon)holePolygons.get(j);
                if (!bPolygon.Extent.Include(aPolygon.Extent) || !Contour.pointInPolygon(bPolygon.OutLine.PointList, aPolygon.OutLine.PointList.get(0))) continue;
                aPolygon.HoleIndex = bPolygon.HoleIndex + 1;
                bPolygon.AddHole(aPolygon);
                continue block1;
            }
        }
        ArrayList hole1Polygons = new ArrayList();
        for (i = 0; i < holePolygons.size(); ++i) {
            if (((Polygon)holePolygons.get((int)i)).HoleIndex != 1) continue;
            hole1Polygons.add(holePolygons.get(i));
        }
        for (i = 0; i < polygonList.size(); ++i) {
            Polygon aPolygon = polygonList.get(i);
            if (!aPolygon.IsBorder || aPolygon.IsInnerBorder) continue;
            for (j = 0; j < hole1Polygons.size(); ++j) {
                Polygon bPolygon = (Polygon)hole1Polygons.get(j);
                if (!aPolygon.Extent.Include(bPolygon.Extent) || !Contour.pointInPolygon(aPolygon.OutLine.PointList, bPolygon.OutLine.PointList.get(0))) continue;
                aPolygon.AddHole(bPolygon);
            }
            newPolygons.add(aPolygon);
        }
        newPolygons.addAll(holePolygons);
        return newPolygons;
    }

    private static void addHoles_Ring(List<Polygon> polygonList, List<List<PointD>> holeList) {
        block0: for (int i = 0; i < holeList.size(); ++i) {
            List<PointD> holePs = holeList.get(i);
            Extent aExtent = Contour.getExtent(holePs);
            for (int j = polygonList.size() - 1; j >= 0; --j) {
                Polygon aPolygon = polygonList.get(j);
                if (!aPolygon.Extent.Include(aExtent)) continue;
                boolean isHole = true;
                for (PointD aP : holePs) {
                    if (Contour.pointInPolygon(aPolygon.OutLine.PointList, aP)) continue;
                    isHole = false;
                    break;
                }
                if (!isHole) continue;
                aPolygon.AddHole(holePs);
                continue block0;
            }
        }
    }

    private static List<PolyLine> cutPolyline(PolyLine inPolyline, List<PointD> clipPList) {
        PolyLine bLine;
        int i;
        Extent cutExtent;
        ArrayList<PolyLine> newPolylines = new ArrayList<PolyLine>();
        List<PointD> aPList = inPolyline.PointList;
        Extent plExtent = Contour.getExtent(aPList);
        if (!Contour.isExtentCross(plExtent, cutExtent = Contour.getExtent(clipPList))) {
            return newPolylines;
        }
        if (!Contour.isClockwise(clipPList)) {
            Collections.reverse(clipPList);
        }
        if (Contour.pointInPolygon(clipPList, aPList.get(0))) {
            boolean isAllIn = true;
            int notInIdx = 0;
            for (i = 0; i < aPList.size(); ++i) {
                if (Contour.pointInPolygon(clipPList, aPList.get(i))) continue;
                notInIdx = i;
                isAllIn = false;
                break;
            }
            if (!isAllIn) {
                if (inPolyline.Type.equals("Close")) {
                    ArrayList<PointD> bPList = new ArrayList<PointD>();
                    for (i = notInIdx; i < aPList.size(); ++i) {
                        bPList.add(aPList.get(i));
                    }
                    for (i = 1; i < notInIdx; ++i) {
                        bPList.add(aPList.get(i));
                    }
                    bPList.add((PointD)bPList.get(0));
                    aPList = new ArrayList<PointD>(bPList);
                } else {
                    Collections.reverse(aPList);
                }
            } else {
                newPolylines.add(inPolyline);
                return newPolylines;
            }
        }
        boolean isInPolygon = Contour.pointInPolygon(clipPList, aPList.get(0));
        ArrayList<PointD> newPlist = new ArrayList<PointD>();
        PointD p1 = aPList.get(0);
        for (i = 1; i < aPList.size(); ++i) {
            Line lineB;
            PointD q2;
            int j;
            Line lineA;
            PointD IPoint;
            PointD p2 = aPList.get(i);
            if (Contour.pointInPolygon(clipPList, p2)) {
                if (!isInPolygon) {
                    IPoint = new PointD();
                    lineA = new Line();
                    lineA.P1 = p1;
                    lineA.P2 = p2;
                    PointD q1 = clipPList.get(clipPList.size() - 1);
                    for (j = 0; j < clipPList.size(); ++j) {
                        q2 = clipPList.get(j);
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (Contour.isLineSegmentCross(lineA, lineB)) {
                            IPoint = Contour.getCrossPoint(lineA, lineB);
                            break;
                        }
                        q1 = q2;
                    }
                    newPlist.add(IPoint);
                }
                newPlist.add(aPList.get(i));
                isInPolygon = true;
            } else if (isInPolygon) {
                IPoint = new PointD();
                lineA = new Line();
                lineA.P1 = p1;
                lineA.P2 = p2;
                PointD q1 = clipPList.get(clipPList.size() - 1);
                for (j = 0; j < clipPList.size(); ++j) {
                    q2 = clipPList.get(j);
                    lineB = new Line();
                    lineB.P1 = q1;
                    lineB.P2 = q2;
                    if (Contour.isLineSegmentCross(lineA, lineB)) {
                        IPoint = Contour.getCrossPoint(lineA, lineB);
                        break;
                    }
                    q1 = q2;
                }
                newPlist.add(IPoint);
                bLine = new PolyLine();
                bLine.Value = inPolyline.Value;
                bLine.Type = inPolyline.Type;
                bLine.PointList = newPlist;
                newPolylines.add(bLine);
                isInPolygon = false;
                newPlist = new ArrayList();
            }
            p1 = p2;
        }
        if (isInPolygon && newPlist.size() > 1) {
            bLine = new PolyLine();
            bLine.Value = inPolyline.Value;
            bLine.Type = inPolyline.Type;
            bLine.PointList = newPlist;
            newPolylines.add(bLine);
        }
        return newPolylines;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static List<Polygon> cutPolygon_Hole(Polygon inPolygon, List<PointD> clipPList) {
        BorderPoint aBP;
        ArrayList<BorderPoint> borderList;
        int i;
        Extent cutExtent;
        List<Polygon> newPolygons = new ArrayList<Polygon>();
        ArrayList<PolyLine> newPolylines = new ArrayList<PolyLine>();
        List aPList = inPolygon.OutLine.PointList;
        Extent plExtent = Contour.getExtent(aPList);
        if (!Contour.isExtentCross(plExtent, cutExtent = Contour.getExtent(clipPList))) {
            return newPolygons;
        }
        if (!Contour.isClockwise(clipPList)) {
            Collections.reverse(clipPList);
        }
        ArrayList<List<PointD>> newLines = new ArrayList<List<PointD>>();
        if (!Contour.pointInPolygon(clipPList, aPList.get(0))) {
            newLines.add(aPList);
        } else {
            boolean isAllIn = true;
            int notInIdx = 0;
            for (i = 0; i < aPList.size(); ++i) {
                if (Contour.pointInPolygon(clipPList, aPList.get(i))) continue;
                notInIdx = i;
                isAllIn = false;
                break;
            }
            if (isAllIn) {
                newPolygons.add(inPolygon);
                return newPolygons;
            }
            ArrayList<PointD> bPList = new ArrayList<PointD>();
            for (i = notInIdx; i < aPList.size(); ++i) {
                bPList.add(aPList.get(i));
            }
            for (i = 1; i < notInIdx; ++i) {
                bPList.add(aPList.get(i));
            }
            bPList.add((PointD)bPList.get(0));
            newLines.add(bPList);
        }
        ArrayList<List<PointD>> holeLines = new ArrayList<List<PointD>>();
        int h = 0;
        while (true) {
            block35: {
                int notInIdx;
                boolean isAllIn;
                List<PointD> holePList;
                block37: {
                    block34: {
                        block36: {
                            if (h >= inPolygon.HoleLines.size()) break block34;
                            holePList = inPolygon.HoleLines.get((int)h).PointList;
                            plExtent = Contour.getExtent(holePList);
                            if (!Contour.isExtentCross(plExtent, cutExtent)) break block35;
                            if (!Contour.pointInPolygon(clipPList, holePList.get(0))) break block36;
                            isAllIn = true;
                            notInIdx = 0;
                            break block37;
                        }
                        newLines.add(holePList);
                        break block35;
                    }
                    borderList = new ArrayList<BorderPoint>();
                    aBP = new BorderPoint();
                    for (PointD aP : clipPList) {
                        aBP = new BorderPoint();
                        aBP.Point = aP;
                        aBP.Id = -1;
                        borderList.add(aBP);
                    }
                    break;
                }
                for (i = 0; i < holePList.size(); ++i) {
                    if (Contour.pointInPolygon(clipPList, holePList.get(i))) continue;
                    notInIdx = i;
                    isAllIn = false;
                    break;
                }
                if (!isAllIn) {
                    ArrayList<PointD> bPList = new ArrayList<PointD>();
                    for (i = notInIdx; i < holePList.size(); ++i) {
                        bPList.add(holePList.get(i));
                    }
                    for (i = 1; i < notInIdx; ++i) {
                        bPList.add(holePList.get(i));
                    }
                    bPList.add((PointD)bPList.get(0));
                    newLines.add(bPList);
                } else {
                    holeLines.add(holePList);
                }
            }
            ++h;
        }
        int l = 0;
        block8: while (true) {
            if (l >= newLines.size()) {
                if (newPolylines.size() > 0) {
                    newPolygons = Contour.tracingClipPolygons(inPolygon, newPolylines, borderList);
                } else if (Contour.pointInPolygon(aPList, clipPList.get(0))) {
                    Extent aBound = new Extent();
                    Polygon aPolygon = new Polygon();
                    aPolygon.IsBorder = true;
                    aPolygon.LowValue = inPolygon.LowValue;
                    aPolygon.HighValue = inPolygon.HighValue;
                    aPolygon.Area = Contour.getExtentAndArea(clipPList, aBound);
                    aPolygon.IsClockWise = true;
                    aPolygon.Extent = aBound;
                    aPolygon.OutLine.PointList = clipPList;
                    aPolygon.OutLine.Value = inPolygon.LowValue;
                    aPolygon.IsHighCenter = inPolygon.IsHighCenter;
                    aPolygon.OutLine.Type = "Border";
                    aPolygon.HoleLines = new ArrayList<PolyLine>();
                    newPolygons.add(aPolygon);
                }
                if (holeLines.size() > 0) {
                    Contour.addHoles_Ring(newPolygons, holeLines);
                }
                return newPolygons;
            }
            aPList = (List)newLines.get(l);
            boolean isInPolygon = false;
            ArrayList arrayList = new ArrayList();
            PointD p1 = (PointD)aPList.get(0);
            int inIdx = -1;
            int outIdx = -1;
            boolean newLine = true;
            int a1 = 0;
            i = 1;
            while (true) {
                PointD p2;
                block42: {
                    void var22_31;
                    Line lineB;
                    PointD q2;
                    int j;
                    PointD IPoint;
                    PointD q1;
                    Line lineA;
                    block43: {
                        block40: {
                            block41: {
                                block38: {
                                    block39: {
                                        if (i >= aPList.size()) break block38;
                                        p2 = (PointD)aPList.get(i);
                                        if (!Contour.pointInPolygon(clipPList, p2)) break block39;
                                        if (isInPolygon) break block40;
                                        lineA = new Line();
                                        lineA.P1 = p1;
                                        lineA.P2 = p2;
                                        q1 = ((BorderPoint)borderList.get((int)(borderList.size() - 1))).Point;
                                        IPoint = new PointD();
                                        break block41;
                                    }
                                    if (!isInPolygon) break block42;
                                    lineA = new Line();
                                    lineA.P1 = p1;
                                    lineA.P2 = p2;
                                    q1 = ((BorderPoint)borderList.get((int)(borderList.size() - 1))).Point;
                                    IPoint = new PointD();
                                    break block43;
                                }
                                ++l;
                                continue block8;
                            }
                            for (j = 0; j < borderList.size(); ++j) {
                                q2 = ((BorderPoint)borderList.get((int)j)).Point;
                                lineB = new Line();
                                lineB.P1 = q1;
                                lineB.P2 = q2;
                                if (Contour.isLineSegmentCross(lineA, lineB)) {
                                    IPoint = Contour.getCrossPoint(lineA, lineB);
                                    aBP = new BorderPoint();
                                    aBP.Id = newPolylines.size();
                                    aBP.Point = IPoint;
                                    borderList.add(j, aBP);
                                    inIdx = j;
                                    break;
                                }
                                q1 = q2;
                            }
                            var22_31.add(IPoint);
                        }
                        var22_31.add(aPList.get(i));
                        isInPolygon = true;
                        break block42;
                    }
                    for (j = 0; j < borderList.size(); ++j) {
                        q2 = ((BorderPoint)borderList.get((int)j)).Point;
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (Contour.isLineSegmentCross(lineA, lineB)) {
                            if (!newLine) {
                                if (inIdx - outIdx >= 1 && inIdx - outIdx <= 10) {
                                    if (!Contour.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx, aBP);
                                    }
                                } else if (inIdx - outIdx <= -1 && inIdx - outIdx >= -10) {
                                    if (!Contour.twoPointsInside(a1, outIdx, inIdx, j)) {
                                        borderList.remove(inIdx);
                                        borderList.add(outIdx + 1, aBP);
                                    }
                                } else if (inIdx == outIdx && !Contour.twoPointsInside(a1, outIdx, inIdx, j)) {
                                    borderList.remove(inIdx);
                                    borderList.add(inIdx + 1, aBP);
                                }
                            }
                            IPoint = Contour.getCrossPoint(lineA, lineB);
                            aBP = new BorderPoint();
                            aBP.Id = newPolylines.size();
                            aBP.Point = IPoint;
                            borderList.add(j, aBP);
                            outIdx = j;
                            a1 = inIdx;
                            newLine = false;
                            break;
                        }
                        q1 = q2;
                    }
                    var22_31.add(IPoint);
                    PolyLine bLine = new PolyLine();
                    bLine.Value = inPolygon.OutLine.Value;
                    bLine.Type = inPolygon.OutLine.Type;
                    bLine.PointList = var22_31;
                    newPolylines.add(bLine);
                    isInPolygon = false;
                    ArrayList arrayList2 = new ArrayList();
                }
                p1 = p2;
                ++i;
            }
            break;
        }
    }

    private static List<Polygon> cutPolygon(Polygon inPolygon, List<PointD> clipPList) {
        int i;
        Extent cutExtent;
        List<Polygon> newPolygons = new ArrayList<Polygon>();
        ArrayList<PolyLine> newPolylines = new ArrayList<PolyLine>();
        List<PointD> aPList = inPolygon.OutLine.PointList;
        Extent plExtent = Contour.getExtent(aPList);
        if (!Contour.isExtentCross(plExtent, cutExtent = Contour.getExtent(clipPList))) {
            return newPolygons;
        }
        if (!Contour.isClockwise(clipPList)) {
            Collections.reverse(clipPList);
        }
        if (Contour.pointInPolygon(clipPList, aPList.get(0))) {
            boolean isAllIn = true;
            int notInIdx = 0;
            for (i = 0; i < aPList.size(); ++i) {
                if (Contour.pointInPolygon(clipPList, aPList.get(i))) continue;
                notInIdx = i;
                isAllIn = false;
                break;
            }
            if (!isAllIn) {
                ArrayList<PointD> bPList = new ArrayList<PointD>();
                for (i = notInIdx; i < aPList.size(); ++i) {
                    bPList.add(aPList.get(i));
                }
                for (i = 1; i < notInIdx; ++i) {
                    bPList.add(aPList.get(i));
                }
                bPList.add((PointD)bPList.get(0));
                aPList = new ArrayList<PointD>(bPList);
            } else {
                newPolygons.add(inPolygon);
                return newPolygons;
            }
        }
        ArrayList<BorderPoint> borderList = new ArrayList<BorderPoint>();
        BorderPoint aBP = new BorderPoint();
        for (PointD aP : clipPList) {
            aBP = new BorderPoint();
            aBP.Point = aP;
            aBP.Id = -1;
            borderList.add(aBP);
        }
        boolean isInPolygon = false;
        ArrayList<PointD> newPlist = new ArrayList<PointD>();
        PointD p1 = aPList.get(0);
        int inIdx = -1;
        int outIdx = -1;
        int a1 = 0;
        boolean isNewLine = true;
        for (i = 1; i < aPList.size(); ++i) {
            Line lineB;
            PointD q2;
            int j;
            PointD IPoint;
            PointD q1;
            Line lineA;
            PointD p2 = aPList.get(i);
            if (Contour.pointInPolygon(clipPList, p2)) {
                if (!isInPolygon) {
                    lineA = new Line();
                    lineA.P1 = p1;
                    lineA.P2 = p2;
                    q1 = ((BorderPoint)borderList.get((int)(borderList.size() - 1))).Point;
                    IPoint = new PointD();
                    for (j = 0; j < borderList.size(); ++j) {
                        q2 = ((BorderPoint)borderList.get((int)j)).Point;
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (Contour.isLineSegmentCross(lineA, lineB)) {
                            IPoint = Contour.getCrossPoint(lineA, lineB);
                            aBP = new BorderPoint();
                            aBP.Id = newPolylines.size();
                            aBP.Point = IPoint;
                            borderList.add(j, aBP);
                            inIdx = j;
                            break;
                        }
                        q1 = q2;
                    }
                    newPlist.add(IPoint);
                }
                newPlist.add(aPList.get(i));
                isInPolygon = true;
            } else if (isInPolygon) {
                lineA = new Line();
                lineA.P1 = p1;
                lineA.P2 = p2;
                q1 = ((BorderPoint)borderList.get((int)(borderList.size() - 1))).Point;
                IPoint = new PointD();
                for (j = 0; j < borderList.size(); ++j) {
                    q2 = ((BorderPoint)borderList.get((int)j)).Point;
                    lineB = new Line();
                    lineB.P1 = q1;
                    lineB.P2 = q2;
                    if (Contour.isLineSegmentCross(lineA, lineB)) {
                        if (!isNewLine) {
                            if (inIdx - outIdx >= 1 && inIdx - outIdx <= 10) {
                                if (!Contour.twoPointsInside(a1, outIdx, inIdx, j)) {
                                    borderList.remove(inIdx);
                                    borderList.add(outIdx, aBP);
                                }
                            } else if (inIdx - outIdx <= -1 && inIdx - outIdx >= -10) {
                                if (!Contour.twoPointsInside(a1, outIdx, inIdx, j)) {
                                    borderList.remove(inIdx);
                                    borderList.add(outIdx + 1, aBP);
                                }
                            } else if (inIdx == outIdx && !Contour.twoPointsInside(a1, outIdx, inIdx, j)) {
                                borderList.remove(inIdx);
                                borderList.add(inIdx + 1, aBP);
                            }
                        }
                        IPoint = Contour.getCrossPoint(lineA, lineB);
                        aBP = new BorderPoint();
                        aBP.Id = newPolylines.size();
                        aBP.Point = IPoint;
                        borderList.add(j, aBP);
                        outIdx = j;
                        a1 = inIdx;
                        isNewLine = false;
                        break;
                    }
                    q1 = q2;
                }
                newPlist.add(IPoint);
                PolyLine bLine = new PolyLine();
                bLine.Value = inPolygon.OutLine.Value;
                bLine.Type = inPolygon.OutLine.Type;
                bLine.PointList = newPlist;
                newPolylines.add(bLine);
                isInPolygon = false;
                newPlist = new ArrayList();
            }
            p1 = p2;
        }
        if (newPolylines.size() > 0) {
            newPolygons = Contour.tracingClipPolygons(inPolygon, newPolylines, borderList);
        } else if (Contour.pointInPolygon(aPList, clipPList.get(0))) {
            Extent aBound = new Extent();
            Polygon aPolygon = new Polygon();
            aPolygon.IsBorder = true;
            aPolygon.LowValue = inPolygon.LowValue;
            aPolygon.HighValue = inPolygon.HighValue;
            aPolygon.Area = Contour.getExtentAndArea(clipPList, aBound);
            aPolygon.IsClockWise = true;
            aPolygon.Extent = aBound;
            aPolygon.OutLine.PointList = clipPList;
            aPolygon.OutLine.Value = inPolygon.LowValue;
            aPolygon.IsHighCenter = inPolygon.IsHighCenter;
            aPolygon.OutLine.Type = "Border";
            aPolygon.HoleLines = new ArrayList<PolyLine>();
            newPolygons.add(aPolygon);
        }
        return newPolygons;
    }

    private static boolean twoPointsInside(int a1, int a2, int b1, int b2) {
        if (a2 < a1) {
            ++a1;
        }
        if (b1 < a1) {
            ++a1;
        }
        if (b1 < a2) {
            ++a2;
        }
        if (a2 < a1) {
            int c = a1;
            a1 = a2;
            a2 = c;
        }
        if (b1 > a1 && b1 <= a2) {
            return b2 > a1 && b2 <= a2;
        }
        return b2 <= a1 || b2 > a2;
    }

    private static List<PointD> BSplineScanning(List<PointD> pointList, int sum) {
        ArrayList<PointD> newPList = new ArrayList<PointD>();
        if (sum < 4) {
            return null;
        }
        boolean isClose = false;
        PointD aPoint = pointList.get(0);
        PointD bPoint = pointList.get(sum - 1);
        if (aPoint.X == bPoint.X && aPoint.Y == bPoint.Y) {
            pointList.remove(0);
            pointList.add(pointList.get(0));
            pointList.add(pointList.get(1));
            pointList.add(pointList.get(2));
            pointList.add(pointList.get(3));
            pointList.add(pointList.get(4));
            pointList.add(pointList.get(5));
            pointList.add(pointList.get(6));
            isClose = true;
        }
        sum = pointList.size();
        for (int i = 0; i < sum - 3; ++i) {
            for (float t = 0.0f; t <= 1.0f; t += 0.05f) {
                double[] xy = Contour.BSpline(pointList, t, i);
                double X = xy[0];
                double Y = xy[1];
                if (isClose) {
                    if (i <= 3) continue;
                    aPoint = new PointD();
                    aPoint.X = X;
                    aPoint.Y = Y;
                    newPList.add(aPoint);
                    continue;
                }
                aPoint = new PointD();
                aPoint.X = X;
                aPoint.Y = Y;
                newPList.add(aPoint);
            }
        }
        if (isClose) {
            newPList.add((PointD)newPList.get(0));
        } else {
            newPList.add(0, pointList.get(0));
            newPList.add(pointList.get(pointList.size() - 1));
        }
        return newPList;
    }

    private static double[] BSpline(List<PointD> pointList, double t, int i) {
        double[] f = new double[4];
        Contour.fb(t, f);
        double X = 0.0;
        double Y = 0.0;
        for (int j = 0; j < 4; ++j) {
            PointD aPoint = pointList.get(i + j);
            X += f[j] * aPoint.X;
            Y += f[j] * aPoint.Y;
        }
        double[] xy = new double[]{X, Y};
        return xy;
    }

    private static double f0(double t) {
        return 0.16666666666666666 * (-t + 1.0) * (-t + 1.0) * (-t + 1.0);
    }

    private static double f1(double t) {
        return 0.16666666666666666 * (3.0 * t * t * t - 6.0 * t * t + 4.0);
    }

    private static double f2(double t) {
        return 0.16666666666666666 * (-3.0 * t * t * t + 3.0 * t * t + 3.0 * t + 1.0);
    }

    private static double f3(double t) {
        return 0.16666666666666666 * t * t * t;
    }

    private static void fb(double t, double[] fs) {
        fs[0] = Contour.f0(t);
        fs[1] = Contour.f1(t);
        fs[2] = Contour.f2(t);
        fs[3] = Contour.f3(t);
    }

    public static List<PolyLine> tracingStreamline(double[][] U, double[][] V, double[] X, double[] Y, double UNDEF, int density) {
        int j;
        int i;
        ArrayList<PolyLine> streamLines = new ArrayList<PolyLine>();
        int xNum = U[1].length;
        int yNum = U.length;
        double[][] Dx = new double[yNum][xNum];
        double[][] Dy = new double[yNum][xNum];
        double deltX = X[1] - X[0];
        double deltY = Y[1] - Y[0];
        if (density == 0) {
            density = 1;
        }
        double radius = deltX / Math.pow(density, 2.0);
        double smallRadius = radius * 1.5;
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                if (Math.abs(U[i][j] / UNDEF - 1.0) < 0.01) {
                    Dx[i][j] = 0.1;
                    Dy[i][j] = 0.1;
                    continue;
                }
                double WS = Math.sqrt(U[i][j] * U[i][j] + V[i][j] * V[i][j]);
                if (WS == 0.0) {
                    WS = 1.0;
                }
                Dx[i][j] = U[i][j] / WS * deltX / (double)density;
                Dy[i][j] = V[i][j] / WS * deltY / (double)density;
            }
        }
        ArrayList[][] SPoints = new ArrayList[yNum - 1][xNum - 1];
        int[][] flags = new int[yNum - 1][xNum - 1];
        for (i = 0; i < yNum - 1; ++i) {
            for (j = 0; j < xNum - 1; ++j) {
                flags[i][j] = i % 2 == 0 && j % 2 == 0 ? 0 : 1;
                SPoints[i][j] = new ArrayList();
            }
        }
        int lineN = 0;
        for (i = 0; i < yNum - 1; ++i) {
            for (j = 0; j < xNum - 1; ++j) {
                double dis;
                BorderPoint pointEnd;
                BorderPoint pointStart;
                boolean isTerminating;
                boolean isInDomain;
                int[] iijj;
                int loopN;
                if (flags[i][j] != 0) continue;
                ArrayList<PointD> pList = new ArrayList<PointD>();
                PointD aPoint = new PointD();
                PolyLine aPL = new PolyLine();
                aPoint.X = X[j] + deltX / 2.0;
                aPoint.Y = Y[i] + deltY / 2.0;
                pList.add((PointD)aPoint.clone());
                BorderPoint borderP = new BorderPoint();
                borderP.Point = (PointD)aPoint.clone();
                borderP.Id = lineN;
                SPoints[i][j].add(borderP);
                flags[i][j] = 1;
                int ii = i;
                int jj = j;
                int loopLimit = 500;
                for (loopN = 0; loopN < loopLimit; ++loopN) {
                    iijj = new int[]{ii, jj};
                    isInDomain = Contour.tracingStreamlinePoint(aPoint, Dx, Dy, X, Y, iijj, true);
                    ii = iijj[0];
                    jj = iijj[1];
                    if (!isInDomain || Math.abs(U[ii][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii][jj + 1] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj + 1] / UNDEF - 1.0) < 0.01) break;
                    isTerminating = false;
                    for (BorderPoint sPoint : SPoints[ii][jj]) {
                        if (!(Math.sqrt((aPoint.X - sPoint.Point.X) * (aPoint.X - sPoint.Point.X) + (aPoint.Y - sPoint.Point.Y) * (aPoint.Y - sPoint.Point.Y)) < radius)) continue;
                        isTerminating = true;
                        break;
                    }
                    if (!isTerminating && SPoints[ii][jj].size() > 1) {
                        pointStart = (BorderPoint)SPoints[ii][jj].get(0);
                        pointEnd = (BorderPoint)SPoints[ii][jj].get(1);
                        if ((lineN != pointStart.Id || lineN != pointEnd.Id) && (dis = Contour.distance_point2line(pointStart.Point, pointEnd.Point, aPoint)) < smallRadius) {
                            isTerminating = true;
                        }
                    }
                    if (isTerminating) break;
                    pList.add((PointD)aPoint.clone());
                    borderP = new BorderPoint();
                    borderP.Point = (PointD)aPoint.clone();
                    borderP.Id = lineN;
                    SPoints[ii][jj].add(borderP);
                    flags[ii][jj] = 1;
                }
                aPoint.X = X[j] + deltX / 2.0;
                aPoint.Y = Y[i] + deltY / 2.0;
                ii = i;
                jj = j;
                for (loopN = 0; loopN < loopLimit; ++loopN) {
                    iijj = new int[]{ii, jj};
                    isInDomain = Contour.tracingStreamlinePoint(aPoint, Dx, Dy, X, Y, iijj, false);
                    ii = iijj[0];
                    jj = iijj[1];
                    if (!isInDomain || Math.abs(U[ii][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii][jj + 1] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj + 1] / UNDEF - 1.0) < 0.01) break;
                    isTerminating = false;
                    for (BorderPoint sPoint : SPoints[ii][jj]) {
                        if (!(Math.sqrt((aPoint.X - sPoint.Point.X) * (aPoint.X - sPoint.Point.X) + (aPoint.Y - sPoint.Point.Y) * (aPoint.Y - sPoint.Point.Y)) < radius)) continue;
                        isTerminating = true;
                        break;
                    }
                    if (!isTerminating && SPoints[ii][jj].size() > 1) {
                        pointStart = (BorderPoint)SPoints[ii][jj].get(0);
                        pointEnd = (BorderPoint)SPoints[ii][jj].get(1);
                        if ((lineN != pointStart.Id || lineN != pointEnd.Id) && (dis = Contour.distance_point2line(pointStart.Point, pointEnd.Point, aPoint)) < smallRadius) {
                            isTerminating = true;
                        }
                    }
                    if (isTerminating) break;
                    pList.add(0, (PointD)aPoint.clone());
                    borderP = new BorderPoint();
                    borderP.Point = (PointD)aPoint.clone();
                    borderP.Id = lineN;
                    SPoints[ii][jj].add(borderP);
                    flags[ii][jj] = 1;
                }
                if (pList.size() <= 1) continue;
                aPL.PointList = pList;
                streamLines.add(aPL);
                ++lineN;
            }
        }
        return streamLines;
    }

    private static List<PolyLine> tracingStreamline_back(double[][] U, double[][] V, double[] X, double[] Y, double UNDEF, int density) {
        int j;
        int i;
        ArrayList<PolyLine> streamLines = new ArrayList<PolyLine>();
        int xNum = U[1].length;
        int yNum = U.length;
        double[][] Dx = new double[yNum][xNum];
        double[][] Dy = new double[yNum][xNum];
        double deltX = X[1] - X[0];
        double deltY = Y[1] - Y[0];
        if (density == 0) {
            density = 1;
        }
        double radius = deltX / (double)(density * density);
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                if (Math.abs(U[i][j] / UNDEF - 1.0) < 0.01) {
                    Dx[i][j] = 0.1;
                    Dy[i][j] = 0.1;
                    continue;
                }
                double WS = Math.sqrt(U[i][j] * U[i][j] + V[i][j] * V[i][j]);
                if (WS == 0.0) {
                    WS = 1.0;
                }
                Dx[i][j] = U[i][j] / WS * deltX / (double)density;
                Dy[i][j] = V[i][j] / WS * deltY / (double)density;
            }
        }
        ArrayList[][] SPoints = new ArrayList[yNum - 1][xNum - 1];
        int[][] flags = new int[yNum - 1][xNum - 1];
        for (i = 0; i < yNum - 1; ++i) {
            for (j = 0; j < xNum - 1; ++j) {
                flags[i][j] = i % 2 == 0 && j % 2 == 0 ? 0 : 1;
                SPoints[i][j] = new ArrayList();
            }
        }
        for (i = 0; i < yNum - 1; ++i) {
            for (j = 0; j < xNum - 1; ++j) {
                boolean isTerminating;
                boolean isInDomain;
                int[] iijj;
                int loopN;
                if (flags[i][j] != 0) continue;
                ArrayList<PointD> pList = new ArrayList<PointD>();
                PointD aPoint = new PointD();
                PolyLine aPL = new PolyLine();
                aPoint.X = X[j] + deltX / 2.0;
                aPoint.Y = Y[i] + deltY / 2.0;
                pList.add((PointD)aPoint.clone());
                SPoints[i][j].add((PointD)aPoint.clone());
                flags[i][j] = 1;
                int ii = i;
                int jj = j;
                int loopLimit = 500;
                for (loopN = 0; loopN < loopLimit; ++loopN) {
                    iijj = new int[]{ii, jj};
                    isInDomain = Contour.tracingStreamlinePoint(aPoint, Dx, Dy, X, Y, iijj, true);
                    ii = iijj[0];
                    jj = iijj[1];
                    if (!isInDomain || Math.abs(U[ii][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii][jj + 1] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj + 1] / UNDEF - 1.0) < 0.01) break;
                    isTerminating = false;
                    for (PointD sPoint : SPoints[ii][jj]) {
                        if (!(Math.sqrt((aPoint.X - sPoint.X) * (aPoint.X - sPoint.X) + (aPoint.Y - sPoint.Y) * (aPoint.Y - sPoint.Y)) < radius)) continue;
                        isTerminating = true;
                        break;
                    }
                    if (isTerminating) break;
                    pList.add((PointD)aPoint.clone());
                    SPoints[ii][jj].add((PointD)aPoint.clone());
                    flags[ii][jj] = 1;
                }
                aPoint.X = X[j] + deltX / 2.0;
                aPoint.Y = Y[i] + deltY / 2.0;
                ii = i;
                jj = j;
                for (loopN = 0; loopN < loopLimit; ++loopN) {
                    iijj = new int[]{ii, jj};
                    isInDomain = Contour.tracingStreamlinePoint(aPoint, Dx, Dy, X, Y, iijj, false);
                    ii = iijj[0];
                    jj = iijj[1];
                    if (!isInDomain || Math.abs(U[ii][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii][jj + 1] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj] / UNDEF - 1.0) < 0.01 || Math.abs(U[ii + 1][jj + 1] / UNDEF - 1.0) < 0.01) break;
                    isTerminating = false;
                    for (PointD sPoint : SPoints[ii][jj]) {
                        if (!(Math.sqrt((aPoint.X - sPoint.X) * (aPoint.X - sPoint.X) + (aPoint.Y - sPoint.Y) * (aPoint.Y - sPoint.Y)) < radius)) continue;
                        isTerminating = true;
                        break;
                    }
                    if (isTerminating) break;
                    pList.add(0, (PointD)aPoint.clone());
                    SPoints[ii][jj].add((PointD)aPoint.clone());
                    flags[ii][jj] = 1;
                }
                if (pList.size() <= 1) continue;
                aPL.PointList = pList;
                streamLines.add(aPL);
            }
        }
        return streamLines;
    }

    private static boolean tracingStreamlinePoint(PointD aPoint, double[][] Dx, double[][] Dy, double[] X, double[] Y, int[] iijj, boolean isForward) {
        int xNum = X.length;
        int yNum = Y.length;
        double deltX = X[1] - X[0];
        double deltY = Y[1] - Y[0];
        int ii = iijj[0];
        int jj = iijj[1];
        double a = Dx[ii][jj];
        double b = Dx[ii][jj + 1];
        double c = Dx[ii + 1][jj];
        double d = Dx[ii + 1][jj + 1];
        double val1 = a + (c - a) * ((aPoint.Y - Y[ii]) / deltY);
        double val2 = b + (d - b) * ((aPoint.Y - Y[ii]) / deltY);
        double dx = val1 + (val2 - val1) * ((aPoint.X - X[jj]) / deltX);
        a = Dy[ii][jj];
        b = Dy[ii][jj + 1];
        c = Dy[ii + 1][jj];
        d = Dy[ii + 1][jj + 1];
        val1 = a + (c - a) * ((aPoint.Y - Y[ii]) / deltY);
        val2 = b + (d - b) * ((aPoint.Y - Y[ii]) / deltY);
        double dy = val1 + (val2 - val1) * ((aPoint.X - X[jj]) / deltX);
        if (isForward) {
            aPoint.X += dx;
            aPoint.Y += dy;
        } else {
            aPoint.X -= dx;
            aPoint.Y -= dy;
        }
        if (!(aPoint.X >= X[jj] && aPoint.X <= X[jj + 1] && aPoint.Y >= Y[ii] && aPoint.Y <= Y[ii + 1])) {
            if (aPoint.X < X[0] || aPoint.X > X[X.length - 1] || aPoint.Y < Y[0] || aPoint.Y > Y[Y.length - 1]) {
                return false;
            }
            block0: for (int ti = ii - 2; ti < ii + 3; ++ti) {
                if (ti < 0 || ti >= yNum || !(aPoint.Y >= Y[ti]) || !(aPoint.Y <= Y[ti + 1])) continue;
                ii = ti;
                for (int tj = jj - 2; tj < jj + 3; ++tj) {
                    if (tj < 0 || tj >= xNum || !(aPoint.X >= X[tj]) || !(aPoint.X <= X[tj + 1])) continue;
                    jj = tj;
                    break block0;
                }
                break;
            }
        }
        iijj[0] = ii;
        iijj[1] = jj;
        return true;
    }

    private static double distance_point2line(PointD pt1, PointD pt2, PointD point) {
        double k = (pt2.Y - pt1.Y) / (pt2.X - pt1.X);
        double x = (k * k * pt1.X + k * (point.Y - pt1.Y) + point.X) / (k * k + 1.0);
        double y = k * (x - pt1.X) + pt1.Y;
        double dis = Math.sqrt((point.Y - y) * (point.Y - y) + (point.X - x) * (point.X - x));
        return dis;
    }

    private static Extent getExtent(List<PointD> pList) {
        PointD aPoint = pList.get(0);
        double minX = aPoint.X;
        double maxX = aPoint.X;
        double minY = aPoint.Y;
        double maxY = aPoint.Y;
        for (int i = 1; i < pList.size(); ++i) {
            aPoint = pList.get(i);
            if (aPoint.X < minX) {
                minX = aPoint.X;
            }
            if (aPoint.X > maxX) {
                maxX = aPoint.X;
            }
            if (aPoint.Y < minY) {
                minY = aPoint.Y;
            }
            if (!(aPoint.Y > maxY)) continue;
            maxY = aPoint.Y;
        }
        Extent aExtent = new Extent();
        aExtent.xMin = minX;
        aExtent.yMin = minY;
        aExtent.xMax = maxX;
        aExtent.yMax = maxY;
        return aExtent;
    }

    private static double getExtentAndArea(List<PointD> pList, Extent aExtent) {
        PointD aPoint = pList.get(0);
        double minX = aPoint.X;
        double maxX = aPoint.X;
        double minY = aPoint.Y;
        double maxY = aPoint.Y;
        for (int i = 1; i < pList.size(); ++i) {
            aPoint = pList.get(i);
            if (aPoint.X < minX) {
                minX = aPoint.X;
            }
            if (aPoint.X > maxX) {
                maxX = aPoint.X;
            }
            if (aPoint.Y < minY) {
                minY = aPoint.Y;
            }
            if (!(aPoint.Y > maxY)) continue;
            maxY = aPoint.Y;
        }
        aExtent.xMin = minX;
        aExtent.yMin = minY;
        aExtent.xMax = maxX;
        aExtent.yMax = maxY;
        double bArea = (maxX - minX) * (maxY - minY);
        return bArea;
    }

    public static boolean isClockwise(List<PointD> pointList) {
        double yMax = 0.0;
        int yMaxIdx = 0;
        for (int i = 0; i < pointList.size() - 1; ++i) {
            PointD aPoint = pointList.get(i);
            if (i == 0) {
                yMax = aPoint.Y;
                yMaxIdx = 0;
                continue;
            }
            if (!(yMax < aPoint.Y)) continue;
            yMax = aPoint.Y;
            yMaxIdx = i;
        }
        int p1Idx = yMaxIdx - 1;
        int p2Idx = yMaxIdx;
        int p3Idx = yMaxIdx + 1;
        if (yMaxIdx == 0) {
            p1Idx = pointList.size() - 2;
        }
        PointD p1 = pointList.get(p1Idx);
        PointD p2 = pointList.get(p2Idx);
        PointD p3 = pointList.get(p3Idx);
        return (p3.X - p1.X) * (p2.Y - p1.Y) - (p2.X - p1.X) * (p3.Y - p1.Y) > 0.0;
    }

    private static boolean isLineSegmentCross(Line lineA, Line lineB) {
        Extent boundA = new Extent();
        Extent boundB = new Extent();
        ArrayList<PointD> PListA = new ArrayList<PointD>();
        ArrayList<PointD> PListB = new ArrayList<PointD>();
        PListA.add(lineA.P1);
        PListA.add(lineA.P2);
        PListB.add(lineB.P1);
        PListB.add(lineB.P2);
        Contour.getExtentAndArea(PListA, boundA);
        Contour.getExtentAndArea(PListB, boundB);
        if (!Contour.isExtentCross(boundA, boundB)) {
            return false;
        }
        double XP1 = (lineB.P1.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P1.Y - lineA.P1.Y);
        double XP2 = (lineB.P2.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P2.Y - lineA.P1.Y);
        return !(XP1 * XP2 > 0.0);
    }

    private static boolean isExtentCross(Extent aBound, Extent bBound) {
        return !(aBound.xMin > bBound.xMax || aBound.xMax < bBound.xMin || aBound.yMin > bBound.yMax) && !(aBound.yMax < bBound.yMin);
    }

    public static PointF getCrossPoint(PointF aP1, PointF aP2, PointF bP1, PointF bP2) {
        PointF IPoint = new PointF(0.0f, 0.0f);
        double XP1 = (bP1.X - aP1.X) * (aP2.Y - aP1.Y) - (aP2.X - aP1.X) * (bP1.Y - aP1.Y);
        double XP2 = (bP2.X - aP1.X) * (aP2.Y - aP1.Y) - (aP2.X - aP1.X) * (bP2.Y - aP1.Y);
        if (XP1 == 0.0) {
            IPoint = bP1;
        } else if (XP2 == 0.0) {
            IPoint = bP2;
        } else {
            PointF p1 = aP1;
            PointF p2 = aP2;
            PointF q1 = bP1;
            PointF q2 = bP2;
            double tempLeft = (q2.X - q1.X) * (p1.Y - p2.Y) - (p2.X - p1.X) * (q1.Y - q2.Y);
            double tempRight = (p1.Y - q1.Y) * (p2.X - p1.X) * (q2.X - q1.X) + q1.X * (q2.Y - q1.Y) * (p2.X - p1.X) - p1.X * (p2.Y - p1.Y) * (q2.X - q1.X);
            IPoint.X = (float)(tempRight / tempLeft);
            tempLeft = (p1.X - p2.X) * (q2.Y - q1.Y) - (p2.Y - p1.Y) * (q1.X - q2.X);
            tempRight = p2.Y * (p1.X - p2.X) * (q2.Y - q1.Y) + (q2.X - p2.X) * (q2.Y - q1.Y) * (p1.Y - p2.Y) - q2.Y * (q1.X - q2.X) * (p2.Y - p1.Y);
            IPoint.Y = (float)(tempRight / tempLeft);
        }
        return IPoint;
    }

    private static PointD getCrossPoint(Line lineA, Line lineB) {
        PointD IPoint = new PointD();
        double XP1 = (lineB.P1.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P1.Y - lineA.P1.Y);
        double XP2 = (lineB.P2.X - lineA.P1.X) * (lineA.P2.Y - lineA.P1.Y) - (lineA.P2.X - lineA.P1.X) * (lineB.P2.Y - lineA.P1.Y);
        if (XP1 == 0.0) {
            IPoint = lineB.P1;
        } else if (XP2 == 0.0) {
            IPoint = lineB.P2;
        } else {
            PointD p1 = lineA.P1;
            PointD p2 = lineA.P2;
            PointD q1 = lineB.P1;
            PointD q2 = lineB.P2;
            double tempLeft = (q2.X - q1.X) * (p1.Y - p2.Y) - (p2.X - p1.X) * (q1.Y - q2.Y);
            double tempRight = (p1.Y - q1.Y) * (p2.X - p1.X) * (q2.X - q1.X) + q1.X * (q2.Y - q1.Y) * (p2.X - p1.X) - p1.X * (p2.Y - p1.Y) * (q2.X - q1.X);
            IPoint.X = tempRight / tempLeft;
            tempLeft = (p1.X - p2.X) * (q2.Y - q1.Y) - (p2.Y - p1.Y) * (q1.X - q2.X);
            tempRight = p2.Y * (p1.X - p2.X) * (q2.Y - q1.Y) + (q2.X - p2.X) * (q2.Y - q1.Y) * (p1.Y - p2.Y) - q2.Y * (q1.X - q2.X) * (p2.Y - p1.Y);
            IPoint.Y = tempRight / tempLeft;
        }
        return IPoint;
    }

    private static List<BorderPoint> insertPoint2Border(List<BorderPoint> bPList, List<BorderPoint> aBorderList) {
        ArrayList<BorderPoint> BorderList = new ArrayList<BorderPoint>(aBorderList);
        block0: for (int i = 0; i < bPList.size(); ++i) {
            BorderPoint bP = bPList.get(i);
            PointD p3 = bP.Point;
            BorderPoint aBPoint = (BorderPoint)BorderList.get(0);
            PointD p1 = aBPoint.Point;
            for (int j = 1; j < BorderList.size(); ++j) {
                aBPoint = (BorderPoint)BorderList.get(j);
                PointD p2 = aBPoint.Point;
                if ((p3.X - p1.X) * (p3.X - p2.X) <= 0.0 && (p3.Y - p1.Y) * (p3.Y - p2.Y) <= 0.0 && (p3.X - p1.X) * (p2.Y - p1.Y) - (p2.X - p1.X) * (p3.Y - p1.Y) == 0.0) {
                    BorderList.add(j, bP);
                    continue block0;
                }
                p1 = p2;
            }
        }
        return BorderList;
    }

    private static List<BorderPoint> insertPoint2RectangleBorder(List<PolyLine> LineList, Extent aBound) {
        PointD aPoint;
        BorderPoint bP;
        ArrayList<BorderPoint> LBPList = new ArrayList<BorderPoint>();
        ArrayList<BorderPoint> TBPList = new ArrayList<BorderPoint>();
        ArrayList<BorderPoint> RBPList = new ArrayList<BorderPoint>();
        ArrayList<BorderPoint> BBPList = new ArrayList<BorderPoint>();
        ArrayList<BorderPoint> BorderList = new ArrayList<BorderPoint>();
        for (int i = 0; i < LineList.size(); ++i) {
            PolyLine aLine = LineList.get(i);
            if ("Close".equals(aLine.Type)) continue;
            ArrayList<PointD> aPointList = new ArrayList<PointD>(aLine.PointList);
            bP = new BorderPoint();
            bP.Id = i;
            for (int k = 0; k <= 1; ++k) {
                BorderPoint bPoint;
                int j;
                aPoint = k == 0 ? (PointD)aPointList.get(0) : (PointD)aPointList.get(aPointList.size() - 1);
                bP.Point = aPoint;
                boolean IsInserted = false;
                if (aPoint.X == aBound.xMin) {
                    for (j = 0; j < LBPList.size(); ++j) {
                        bPoint = (BorderPoint)LBPList.get(j);
                        if (!(aPoint.Y < bPoint.Point.Y)) continue;
                        LBPList.add(j, bP);
                        IsInserted = true;
                        break;
                    }
                    if (IsInserted) continue;
                    LBPList.add(bP);
                    continue;
                }
                if (aPoint.X == aBound.xMax) {
                    for (j = 0; j < RBPList.size(); ++j) {
                        bPoint = (BorderPoint)RBPList.get(j);
                        if (!(aPoint.Y > bPoint.Point.Y)) continue;
                        RBPList.add(j, bP);
                        IsInserted = true;
                        break;
                    }
                    if (IsInserted) continue;
                    RBPList.add(bP);
                    continue;
                }
                if (aPoint.Y == aBound.yMin) {
                    for (j = 0; j < BBPList.size(); ++j) {
                        bPoint = (BorderPoint)BBPList.get(j);
                        if (!(aPoint.X > bPoint.Point.X)) continue;
                        BBPList.add(j, bP);
                        IsInserted = true;
                        break;
                    }
                    if (IsInserted) continue;
                    BBPList.add(bP);
                    continue;
                }
                if (aPoint.Y != aBound.yMax) continue;
                for (j = 0; j < TBPList.size(); ++j) {
                    bPoint = (BorderPoint)TBPList.get(j);
                    if (!(aPoint.X < bPoint.Point.X)) continue;
                    TBPList.add(j, bP);
                    IsInserted = true;
                    break;
                }
                if (IsInserted) continue;
                TBPList.add(bP);
            }
        }
        bP = new BorderPoint();
        bP.Id = -1;
        aPoint = new PointD();
        aPoint.X = aBound.xMin;
        aPoint.Y = aBound.yMin;
        bP.Point = aPoint;
        BorderList.add(bP);
        BorderList.addAll(LBPList);
        bP = new BorderPoint();
        bP.Id = -1;
        aPoint = new PointD();
        aPoint.X = aBound.xMin;
        aPoint.Y = aBound.yMax;
        bP.Point = aPoint;
        BorderList.add(bP);
        BorderList.addAll(TBPList);
        bP = new BorderPoint();
        bP.Id = -1;
        aPoint = new PointD();
        aPoint.X = aBound.xMax;
        aPoint.Y = aBound.yMax;
        bP.Point = aPoint;
        BorderList.add(bP);
        BorderList.addAll(RBPList);
        bP = new BorderPoint();
        bP.Id = -1;
        aPoint = new PointD();
        aPoint.X = aBound.xMax;
        aPoint.Y = aBound.yMin;
        bP.Point = aPoint;
        BorderList.add(bP);
        BorderList.addAll(BBPList);
        BorderList.add((BorderPoint)BorderList.get(0));
        return BorderList;
    }

    private static List<BorderPoint> insertEndPoint2Border(List<EndPoint> EPList, List<BorderPoint> aBorderList) {
        ArrayList<EndPoint> temEPList = new ArrayList<EndPoint>();
        ArrayList<Object[]> dList = new ArrayList<Object[]>();
        ArrayList<BorderPoint> BorderList = new ArrayList<BorderPoint>();
        ArrayList<EndPoint> aEPList = new ArrayList<EndPoint>(EPList);
        BorderPoint aBPoint = aBorderList.get(0);
        PointD p1 = aBPoint.Point;
        BorderList.add(aBPoint);
        for (int i = 1; i < aBorderList.size(); ++i) {
            EndPoint aEP;
            int j;
            aBPoint = aBorderList.get(i);
            PointD p2 = aBPoint.Point;
            temEPList.clear();
            for (j = 0; j < aEPList.size() && j != aEPList.size(); ++j) {
                aEP = (EndPoint)aEPList.get(j);
                if (!(Math.abs(aEP.sPoint.X - p1.X) < 1.0E-6) || !(Math.abs(aEP.sPoint.Y - p1.Y) < 1.0E-6)) continue;
                temEPList.add(aEP);
                aEPList.remove(j);
                --j;
            }
            if (temEPList.size() > 0) {
                BorderPoint bP;
                dList.clear();
                if (temEPList.size() > 1) {
                    for (j = 0; j < temEPList.size(); ++j) {
                        aEP = (EndPoint)temEPList.get(j);
                        double dist = Math.pow(aEP.Point.X - p1.X, 2.0) + Math.pow(aEP.Point.Y - p1.Y, 2.0);
                        if (j == 0) {
                            dList.add(new Object[]{dist, j});
                            continue;
                        }
                        boolean IsInsert = false;
                        for (int k = 0; k < dList.size(); ++k) {
                            if (!(dist < Double.parseDouble(((Object[])dList.get(k))[0].toString()))) continue;
                            dList.add(k, new Object[]{dist, j});
                            IsInsert = true;
                            break;
                        }
                        if (IsInsert) continue;
                        dList.add(new Object[]{dist, j});
                    }
                    for (j = 0; j < dList.size(); ++j) {
                        aEP = (EndPoint)temEPList.get(Integer.parseInt(((Object[])dList.get(j))[1].toString()));
                        bP = new BorderPoint();
                        bP.Id = aEP.Index;
                        bP.Point = aEP.Point;
                        BorderList.add(bP);
                    }
                } else {
                    aEP = (EndPoint)temEPList.get(0);
                    bP = new BorderPoint();
                    bP.Id = aEP.Index;
                    bP.Point = aEP.Point;
                    BorderList.add(bP);
                }
            }
            BorderList.add(aBPoint);
            p1 = p2;
        }
        return BorderList;
    }

    private static List<BorderPoint> insertPoint2Border_Ring(double[][] S0, List<BorderPoint> bPList, Border aBorder, int[] pNums) {
        ArrayList<BorderPoint> newBPList = new ArrayList<BorderPoint>();
        ArrayList<BorderPoint> tempBPList = new ArrayList<BorderPoint>();
        ArrayList<BorderPoint> tempBPList1 = new ArrayList<BorderPoint>();
        for (int k = 0; k < aBorder.getLineNum(); ++k) {
            BorderPoint bP;
            int i;
            BorderLine aBLine = aBorder.LineList.get(k);
            tempBPList.clear();
            for (i = 0; i < aBLine.pointList.size(); ++i) {
                BorderPoint aBPoint = new BorderPoint();
                aBPoint.Id = -1;
                aBPoint.BorderIdx = k;
                aBPoint.Point = aBLine.pointList.get(i);
                aBPoint.Value = S0[aBLine.ijPointList.get((int)i).I][aBLine.ijPointList.get((int)i).J];
                tempBPList.add(aBPoint);
            }
            block2: for (i = 0; i < bPList.size(); ++i) {
                bP = (BorderPoint)bPList.get(i).clone();
                bP.BorderIdx = k;
                PointD p3 = bP.Point;
                PointD p1 = (PointD)((BorderPoint)tempBPList.get((int)0)).Point.clone();
                for (int j = 1; j < tempBPList.size(); ++j) {
                    PointD p2 = (PointD)((BorderPoint)tempBPList.get((int)j)).Point.clone();
                    if ((p3.X - p1.X) * (p3.X - p2.X) <= 0.0 && (p3.Y - p1.Y) * (p3.Y - p2.Y) <= 0.0 && (p3.X - p1.X) * (p2.Y - p1.Y) - (p2.X - p1.X) * (p3.Y - p1.Y) == 0.0) {
                        tempBPList.add(j, bP);
                        continue block2;
                    }
                    p1 = p2;
                }
            }
            tempBPList1.clear();
            i = 0;
            while (i < tempBPList.size()) {
                bP = (BorderPoint)tempBPList.get(i);
                bP.BInnerIdx = i++;
                tempBPList1.add(bP);
            }
            pNums[k] = tempBPList1.size();
            newBPList.addAll(tempBPList1);
        }
        return newBPList;
    }

    private static boolean doubleEquals(double a, double b) {
        double difference = Math.abs(a * 1.0E-5);
        return Math.abs(a - b) <= difference;
    }
}

