/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.KmsApi;
import com.koal.kms.sdk.ed.AbstractKmsClient;
import com.koal.kms.sdk.ed.KmsApiClientFactory;
import com.koal.kms.sdk.ed.KmsApiClientPool;
import com.koal.kms.sdk.ed.KmsClientConfig;
import java.time.Duration;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.thrift.TException;

public class KmsClientSocketImpl
extends AbstractKmsClient {
    private final KmsApiClientPool kmsApiClientPool;

    protected KmsClientSocketImpl() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        KmsClientConfig kmsClientConfig = KmsClientConfig.getInstance();
        config.setMaxTotal(kmsClientConfig.getPooling().getMaxTotal());
        config.setMaxIdle(kmsClientConfig.getPooling().getMaxTotal() / 2);
        config.setMinIdle(kmsClientConfig.getPooling().getMinIdle());
        config.setTestWhileIdle(kmsClientConfig.getPooling().getTestWhileIdle());
        config.setTestOnBorrow(kmsClientConfig.getPooling().getTestOnBorrow());
        config.setTestOnReturn(kmsClientConfig.getPooling().getTestOnReturn());
        config.setTimeBetweenEvictionRuns(Duration.ofMillis(kmsClientConfig.getPooling().getValidatePeriod()));
        config.setMinEvictableIdleTime(Duration.ofMillis(kmsClientConfig.getPooling().getValidatePeriod()));
        this.kmsApiClientPool = new KmsApiClientPool((PooledObjectFactory<KmsApi.Client>)new KmsApiClientFactory(), (GenericObjectPoolConfig<KmsApi.Client>)config);
        Runtime.getRuntime().addShutdownHook(new ClosePool());
    }

    @Override
    protected KmsApi.Client getKmsApiClient() throws TException {
        return this.kmsApiClientPool.acquire();
    }

    @Override
    protected void returnKmsApiClient(KmsApi.Client client) throws TException {
        this.kmsApiClientPool.release(client);
    }

    @Override
    public KmsApi.Client getApiClient() throws TException {
        return this.kmsApiClientPool.acquire();
    }

    @Override
    public void closeKmsClient(KmsApi.Client client) throws TException {
        this.returnKmsApiClient(client);
    }

    private class ClosePool
    extends Thread {
        private ClosePool() {
        }

        @Override
        public void run() {
            if (null != KmsClientSocketImpl.this.kmsApiClientPool) {
                KmsClientSocketImpl.this.kmsApiClientPool.close();
            }
        }
    }
}

