/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.property.PropertyFeatureSource;
import org.geotools.data.property.PropertyFeatureStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;

public class PropertyDataStore
extends ContentDataStore {
    protected File dir;

    public PropertyDataStore(File dir) {
        this(dir, null);
    }

    public PropertyDataStore(File dir, String namespaceURI) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        if (namespaceURI == null) {
            namespaceURI = dir.getName();
        }
        this.dir = dir;
        this.setNamespaceURI(namespaceURI);
        this.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        this.setGeometryFactory(new GeometryFactory());
        this.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        this.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        File file = new File(this.dir, typeName + ".properties");
        if (file.exists()) {
            throw new FileNotFoundException("Unable to create a new property file: file exists " + file);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("_=");
        writer.write(DataUtilities.encodeType((SimpleFeatureType)featureType));
        writer.flush();
        writer.close();
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.dir);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.dir.toURI());
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    protected List<Name> createTypeNames() throws IOException {
        String[] list = this.dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        ArrayList<Name> typeNames = new ArrayList<Name>();
        for (int i = 0; i < list.length; ++i) {
            String typeName = list[i].substring(0, list[i].lastIndexOf(46));
            typeNames.add((Name)new NameImpl(this.namespaceURI, typeName));
        }
        return typeNames;
    }

    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add((Name)new NameImpl(this.namespaceURI, typeName));
        }
        return names;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        File file = new File(this.dir, entry.getTypeName() + ".properties");
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.canWrite()) {
            return new PropertyFeatureStore(entry, Query.ALL);
        }
        return new PropertyFeatureSource(entry, Query.ALL);
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) throws IOException {
        File file;
        if (!typeName.endsWith(".properties")) {
            typeName = typeName + ".properties";
        }
        if (!(file = new File(this.dir, typeName)).exists()) {
            throw new IOException("Can't delete " + file.getAbsolutePath() + " because it doesn't exist!");
        }
        file.delete();
    }
}

