/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import kl.ssl.gmvpn.AbstractTlsPeer;
import kl.ssl.gmvpn.CertificateStatusRequest;
import kl.ssl.gmvpn.NewSessionTicket;
import kl.ssl.gmvpn.OCSPStatusRequest;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsClient;
import kl.ssl.gmvpn.TlsClientContext;
import kl.ssl.gmvpn.TlsECCUtils;
import kl.ssl.gmvpn.TlsExtensionsUtils;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import org.bouncycastle.util.Integers;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsClientContext context;
    protected int[] cipherSuites;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;

    public AbstractTlsClient(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        switch (extensionType) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(extensionData);
                return true;
            }
            case 11: {
                TlsExtensionsUtils.readSupportedPointFormatsExtension(extensionData);
                return true;
            }
        }
        return false;
    }

    protected void checkForUnexpectedServerExtension(Hashtable serverExtensions, Integer extensionType) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(serverExtensions, extensionType);
        if (extensionData != null && !this.allowUnexpectedServerExtension(extensionType, extensionData)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected abstract int[] getSupportedCipherSuites();

    protected Vector getSupportedGroups(Vector namedGroupRoles) {
        TlsCrypto crypto = this.getCrypto();
        Vector supportedGroups = new Vector();
        if (namedGroupRoles.contains(Integers.valueOf((int)2))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, 29);
        }
        if (namedGroupRoles.contains(Integers.valueOf((int)2)) || namedGroupRoles.contains(Integers.valueOf((int)3))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{23, 24});
        }
        if (namedGroupRoles.contains(Integers.valueOf((int)1))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{256, 257, 258});
        }
        return supportedGroups;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.supportedGroups = null;
        this.supportedSignatureAlgorithms = null;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        ProtocolVersion clientVersion;
        CertificateStatusRequest statusRequest;
        Vector sniServerNames;
        Vector protocolNames;
        Hashtable clientExtensions = new Hashtable();
        boolean offeringPreTLSv13 = false;
        ProtocolVersion[] supportedVersions = this.getSupportedVersions();
        for (int i = 0; i < supportedVersions.length; ++i) {
            if (TlsUtils.isTLSv13(supportedVersions[i])) continue;
            offeringPreTLSv13 = true;
            break;
        }
        if (offeringPreTLSv13) {
            TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
        }
        if ((protocolNames = this.getProtocolNames()) != null) {
            TlsExtensionsUtils.addALPNExtensionClient(clientExtensions, protocolNames);
        }
        if ((sniServerNames = this.getSNIServerNames()) != null) {
            TlsExtensionsUtils.addServerNameExtensionClient(clientExtensions, sniServerNames);
        }
        if ((statusRequest = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(clientExtensions, statusRequest);
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion = this.context.getClientVersion())) {
            this.supportedSignatureAlgorithms = this.getSupportedSignatureAlgorithms();
            TlsExtensionsUtils.addSignatureAlgorithmsExtension(clientExtensions, this.supportedSignatureAlgorithms);
        }
        return clientExtensions;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions != null) {
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_supported_groups);
            int selectedCipherSuite = this.context.getSecurityParametersHandshake().getCipherSuite();
            if (TlsECCUtils.isECCCipherSuite(selectedCipherSuite)) {
                TlsExtensionsUtils.getSupportedPointFormatsExtension(serverExtensions);
            } else {
                this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_padding);
        }
    }

    @Override
    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

