/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

public class SignatureScheme {
    public static final int rsa_pkcs1_sha1 = 513;
    public static final int ecdsa_sha1 = 515;
    public static final int rsa_pkcs1_sha256 = 1025;
    public static final int rsa_pkcs1_sha384 = 1281;
    public static final int rsa_pkcs1_sha512 = 1537;
    public static final int ecdsa_secp256r1_sha256 = 1027;
    public static final int ecdsa_secp384r1_sha384 = 1283;
    public static final int ecdsa_secp521r1_sha512 = 1539;
    public static final int rsa_pss_rsae_sha256 = 2052;
    public static final int rsa_pss_rsae_sha384 = 2053;
    public static final int rsa_pss_rsae_sha512 = 2054;
    public static final int rsa_pss_pss_sha256 = 2057;
    public static final int rsa_pss_pss_sha384 = 2058;
    public static final int rsa_pss_pss_sha512 = 2059;

    public static String getName(int signatureScheme) {
        switch (signatureScheme) {
            case 513: {
                return "rsa_pkcs1_sha1";
            }
            case 515: {
                return "ecdsa_sha1";
            }
            case 1025: {
                return "rsa_pkcs1_sha256";
            }
            case 1281: {
                return "rsa_pkcs1_sha384";
            }
            case 1537: {
                return "rsa_pkcs1_sha512";
            }
            case 1027: {
                return "ecdsa_secp256r1_sha256";
            }
            case 1283: {
                return "ecdsa_secp384r1_sha384";
            }
            case 1539: {
                return "ecdsa_secp521r1_sha512";
            }
            case 2052: {
                return "rsa_pss_rsae_sha256";
            }
            case 2053: {
                return "rsa_pss_rsae_sha384";
            }
            case 2054: {
                return "rsa_pss_rsae_sha512";
            }
            case 2057: {
                return "rsa_pss_pss_sha256";
            }
            case 2058: {
                return "rsa_pss_pss_sha384";
            }
            case 2059: {
                return "rsa_pss_pss_sha512";
            }
        }
        return "UNKNOWN";
    }

    public static String getText(int signatureScheme) {
        return SignatureScheme.getName(signatureScheme) + "(" + signatureScheme + ")";
    }

    public static boolean isPrivate(int signatureScheme) {
        return signatureScheme >>> 9 == 254;
    }
}

