/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.bc;

import java.io.IOException;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;

public class BcTlsSM2Signer
extends BcTlsSigner {
    public BcTlsSM2Signer(BcTlsCrypto crypto, ECPrivateKeyParameters privateKey) {
        super(crypto, (AsymmetricKeyParameter)privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        SM2Signer signer = new SM2Signer();
        signer.init(true, (CipherParameters)this.privateKey);
        signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

