/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.pool;

import com.koal.kms.sdk.ed.thrift.pool.ThriftConnectionPool;
import com.koal.kms.sdk.ed.thrift.pool.ThriftServer;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThriftConnectionPool
implements ThriftConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(DefaultThriftConnectionPool.class);
    private final GenericKeyedObjectPool<ThriftServer, TTransport> connections;

    public DefaultThriftConnectionPool(KeyedPooledObjectFactory<ThriftServer, TTransport> factory, GenericKeyedObjectPoolConfig<TTransport> config) {
        this.connections = new GenericKeyedObjectPool(factory, config);
    }

    @Override
    public TTransport getConnection(ThriftServer thriftServer) {
        try {
            logger.info("{}", (Object)thriftServer);
            return (TTransport)this.connections.borrowObject((Object)thriftServer);
        }
        catch (Exception e) {
            logger.error("Fail to get connection for {}:{}", new Object[]{thriftServer.getHost(), thriftServer.getPort(), e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void returnConnection(ThriftServer thriftServer, TTransport transport) {
        this.connections.returnObject((Object)thriftServer, (Object)transport);
    }

    @Override
    public void returnBrokenConnection(ThriftServer thriftServer, TTransport transport) {
        try {
            this.connections.invalidateObject((Object)thriftServer, (Object)transport);
        }
        catch (Exception e) {
            logger.error("Fail to invalid object:{},{}", new Object[]{thriftServer, transport, e});
        }
    }

    @Override
    public void close() {
        this.connections.close();
    }

    @Override
    public void clear(ThriftServer thriftServer) {
        this.connections.clear((Object)thriftServer);
    }

    public GenericKeyedObjectPool<ThriftServer, TTransport> getPool() {
        return this.connections;
    }
}

