/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kl.ssl.gmvpn.NamedGroup;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;

public class TlsECCUtils {
    public static TlsECConfig createNamedECConfig(TlsContext context, int namedGroup) throws IOException {
        if (NamedGroup.getCurveBits(namedGroup) < 1) {
            throw new TlsFatalAlert(80);
        }
        return new TlsECConfig(namedGroup);
    }

    public static int getMinimumCurveBits(int cipherSuite) {
        return TlsECCUtils.isECCCipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isECCCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static void checkPointEncoding(int namedGroup, byte[] encoding) throws IOException {
        if (encoding == null || encoding.length < 1) {
            throw new TlsFatalAlert(47);
        }
        switch (namedGroup) {
            case 29: 
            case 30: {
                return;
            }
        }
        switch (encoding[0]) {
            case 4: {
                return;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig receiveECDHConfig(TlsContext context, InputStream input) throws IOException {
        int[] clientSupportedGroups;
        short curveType = TlsUtils.readUint8(input);
        if (curveType != 3) {
            throw new TlsFatalAlert(40);
        }
        int namedGroup = TlsUtils.readUint16(input);
        if (NamedGroup.refersToAnECDHCurve(namedGroup) && (null == (clientSupportedGroups = context.getSecurityParametersHandshake().getClientSupportedGroups()) || Arrays.contains((int[])clientSupportedGroups, (int)namedGroup))) {
            return new TlsECConfig(namedGroup);
        }
        throw new TlsFatalAlert(47);
    }

    public static void writeECConfig(TlsECConfig ecConfig, OutputStream output) throws IOException {
        TlsECCUtils.writeNamedECParameters(ecConfig.getNamedGroup(), output);
    }

    public static void writeNamedECParameters(int namedGroup, OutputStream output) throws IOException {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, output);
        TlsUtils.checkUint16(namedGroup);
        TlsUtils.writeUint16(namedGroup, output);
    }
}

