/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.util.List;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.jsse.BCSNIServerName;
import kl.ssl.jsse.provider.JsseSessionParameters;
import kl.ssl.jsse.provider.JsseUtils;
import kl.ssl.jsse.provider.ProvSSLSessionBase;
import kl.ssl.jsse.provider.ProvSSLSessionContext;

class ProvSSLSessionHandshake
extends ProvSSLSessionBase {
    protected final SecurityParameters securityParameters;

    ProvSSLSessionHandshake(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort, SecurityParameters securityParameters) {
        super(sslSessionContext, peerHost, peerPort);
        this.securityParameters = securityParameters;
    }

    String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.securityParameters);
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.securityParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.securityParameters.getSessionID();
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return null;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.securityParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.securityParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.securityParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        return JsseUtils.convertSNIServerNames(this.securityParameters.getClientServerNames());
    }
}

