/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.util;

import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.jsse.BCSSLParameters;
import kl.ssl.jsse.BCSSLSocket;
import kl.ssl.jsse.util.CustomSSLSocketFactory;

public class SessionTicketSocketFactory
extends CustomSSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(SessionTicketSocketFactory.class.getName());
    protected static final ThreadLocal<SessionTicketSocketFactory> threadLocal = new ThreadLocal();
    protected String clientId;

    public static SocketFactory getDefault() {
        SSLSocketFactory sslSocketFactory = threadLocal.get();
        if (null != sslSocketFactory) {
            return sslSocketFactory;
        }
        return SSLSocketFactory.getDefault();
    }

    public SessionTicketSocketFactory(SSLSocketFactory delegate, String clientId) {
        super(delegate);
        this.clientId = clientId;
    }

    public SessionTicketSocketFactory(SSLSocketFactory delegate, String clientId, TlsSession session) {
        super(delegate);
        this.clientId = clientId;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        try {
            threadLocal.set(this);
            V v = callable.call();
            return v;
        }
        finally {
            threadLocal.remove();
        }
    }

    @Override
    protected Socket configureSocket(Socket s) {
        if (s instanceof BCSSLSocket) {
            BCSSLSocket ssl = (BCSSLSocket)((Object)s);
            BCSSLParameters sslParameters = new BCSSLParameters();
            if (this.clientId != null) {
                TlsSession tlsSession = SecurityParameters.TLS_SESSION_MAP.get(this.clientId);
                if (tlsSession != null) {
                    tlsSession.validate();
                    sslParameters.setSession(tlsSession);
                }
                sslParameters.setClientId(this.clientId);
            }
            ssl.setParameters(sslParameters);
        }
        return s;
    }
}

