/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl;

import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsHMAC;
import kl.ssl.gmvpn.crypto.TlsMAC;
import kl.ssl.gmvpn.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

class TlsSuiteHMac
implements TlsSuiteMac {
    protected final TlsCryptoParameters cryptoParams;
    protected final TlsHMAC mac;
    protected final int digestBlockSize;
    protected final int digestOverhead;
    protected final int macSize;

    static int getMacSize(TlsCryptoParameters cryptoParams, TlsMAC mac) {
        int macSize = mac.getMacLength();
        if (cryptoParams.getSecurityParametersHandshake().isTruncatedHMac()) {
            macSize = Math.min(macSize, 10);
        }
        return macSize;
    }

    public TlsSuiteHMac(TlsCryptoParameters cryptoParams, TlsHMAC mac) {
        this.cryptoParams = cryptoParams;
        this.mac = mac;
        this.macSize = TlsSuiteHMac.getMacSize(cryptoParams, mac);
        this.digestBlockSize = mac.getInternalBlockSize();
        this.digestOverhead = this.digestBlockSize / 8;
    }

    @Override
    public int getSize() {
        return this.macSize;
    }

    @Override
    public byte[] calculateMac(long seqNo, short type, byte[] msg, int msgOff, int msgLen) {
        byte[] macHeader = new byte[13];
        TlsUtils.writeUint64(seqNo, macHeader, 0);
        TlsUtils.writeUint8(type, macHeader, 8);
        TlsUtils.writeVersion(this.cryptoParams.getServerVersion(), macHeader, 9);
        TlsUtils.writeUint16(msgLen, macHeader, macHeader.length - 2);
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(msg, msgOff, msgLen);
        return this.truncate(this.mac.calculateMAC());
    }

    @Override
    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] msg, int msgOff, int msgLen, int fullLength, byte[] dummyData) {
        byte[] result = this.calculateMac(seqNo, type, msg, msgOff, msgLen);
        int headerLength = 13;
        int extra = this.getDigestBlockCount(headerLength + fullLength) - this.getDigestBlockCount(headerLength + msgLen);
        while (--extra >= 0) {
            this.mac.update(dummyData, 0, this.digestBlockSize);
        }
        this.mac.update(dummyData, 0, 1);
        this.mac.reset();
        return result;
    }

    protected int getDigestBlockCount(int inputLength) {
        return (inputLength + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] bs) {
        if (bs.length <= this.macSize) {
            return bs;
        }
        return Arrays.copyOf((byte[])bs, (int)this.macSize);
    }
}

