/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import kl.ssl.jsse.BCSNIHostName;
import kl.ssl.jsse.BCSNIMatcher;
import kl.ssl.jsse.BCSNIServerName;
import kl.ssl.jsse.provider.JsseUtils;
import kl.ssl.jsse.provider.JsseUtils_7;

abstract class JsseUtils_8
extends JsseUtils_7 {
    JsseUtils_8() {
    }

    static SNIMatcher exportSNIMatcher(BCSNIMatcher matcher) {
        if (null == matcher) {
            return null;
        }
        if (matcher instanceof ImportSNIMatcher) {
            return ((ImportSNIMatcher)matcher).unwrap();
        }
        return new ExportSNIMatcher(matcher);
    }

    static Object exportSNIMatchers(Collection<BCSNIMatcher> matchers) {
        if (matchers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIMatcher> result = new ArrayList<SNIMatcher>(matchers.size());
        for (BCSNIMatcher matcher : matchers) {
            result.add(JsseUtils_8.exportSNIMatcher(matcher));
        }
        return Collections.unmodifiableList(result);
    }

    static SNIServerName exportSNIServerName(BCSNIServerName serverName) {
        if (null == serverName) {
            return null;
        }
        int type = serverName.getType();
        byte[] encoded = serverName.getEncoded();
        switch (type) {
            case 0: {
                return new SNIHostName(encoded);
            }
        }
        return new UnknownServerName(type, encoded);
    }

    static Object exportSNIServerNames(Collection<BCSNIServerName> serverNames) {
        if (serverNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIServerName> result = new ArrayList<SNIServerName>(serverNames.size());
        for (BCSNIServerName serverName : serverNames) {
            result.add(JsseUtils_8.exportSNIServerName(serverName));
        }
        return Collections.unmodifiableList(result);
    }

    static BCSNIMatcher importSNIMatcher(SNIMatcher matcher) {
        if (null == matcher) {
            return null;
        }
        if (matcher instanceof ExportSNIMatcher) {
            return ((ExportSNIMatcher)matcher).unwrap();
        }
        return new ImportSNIMatcher(matcher);
    }

    static List<BCSNIMatcher> importSNIMatchers(Object getSNIMatchersResult) {
        Collection matchers = (Collection)getSNIMatchersResult;
        if (matchers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIMatcher> result = new ArrayList<BCSNIMatcher>(matchers.size());
        for (SNIMatcher matcher : matchers) {
            result.add(JsseUtils_8.importSNIMatcher(matcher));
        }
        return Collections.unmodifiableList(result);
    }

    static BCSNIServerName importSNIServerName(SNIServerName serverName) {
        if (null == serverName) {
            return null;
        }
        int type = serverName.getType();
        byte[] encoded = serverName.getEncoded();
        switch (type) {
            case 0: {
                return new BCSNIHostName(encoded);
            }
        }
        return new JsseUtils.BCUnknownServerName(type, encoded);
    }

    static List<BCSNIServerName> importSNIServerNames(Object getServerNamesResult) {
        Collection serverNames = (Collection)getServerNamesResult;
        if (serverNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> result = new ArrayList<BCSNIServerName>(serverNames.size());
        for (SNIServerName serverName : serverNames) {
            result.add(JsseUtils_8.importSNIServerName(serverName));
        }
        return Collections.unmodifiableList(result);
    }

    static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int type, byte[] encoded) {
            super(type, encoded);
        }
    }

    static class ImportSNIMatcher
    extends BCSNIMatcher {
        private final SNIMatcher matcher;

        ImportSNIMatcher(SNIMatcher matcher) {
            super(matcher.getType());
            this.matcher = matcher;
        }

        @Override
        public boolean matches(BCSNIServerName serverName) {
            return this.matcher.matches(JsseUtils_8.exportSNIServerName(serverName));
        }

        SNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class ExportSNIMatcher
    extends SNIMatcher {
        private final BCSNIMatcher matcher;

        ExportSNIMatcher(BCSNIMatcher matcher) {
            super(matcher.getType());
            this.matcher = matcher;
        }

        @Override
        public boolean matches(SNIServerName serverName) {
            return this.matcher.matches(JsseUtils_8.importSNIServerName(serverName));
        }

        BCSNIMatcher unwrap() {
            return this.matcher;
        }
    }
}

