/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

public class SignatureAlgorithm {
    public static final short anonymous = 0;
    public static final short rsa = 1;
    public static final short dsa = 2;
    public static final short ecdsa = 3;
    public static final short sm2 = 12;
    public static final short rsa_pss_rsae_sha256 = 4;
    public static final short rsa_pss_rsae_sha384 = 5;
    public static final short rsa_pss_rsae_sha512 = 6;
    public static final short rsa_pss_pss_sha256 = 9;
    public static final short rsa_pss_pss_sha384 = 10;
    public static final short rsa_pss_pss_sha512 = 11;

    public static String getName(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 0: {
                return "anonymous";
            }
            case 1: {
                return "rsa";
            }
            case 2: {
                return "dsa";
            }
            case 3: {
                return "ecdsa";
            }
            case 12: {
                return "sm2";
            }
            case 4: {
                return "rsa_pss_rsae_sha256";
            }
            case 5: {
                return "rsa_pss_rsae_sha384";
            }
            case 6: {
                return "rsa_pss_rsae_sha512";
            }
            case 9: {
                return "rsa_pss_pss_sha256";
            }
            case 10: {
                return "rsa_pss_pss_sha384";
            }
            case 11: {
                return "rsa_pss_pss_sha512";
            }
        }
        return "UNKNOWN";
    }

    public static short getRSAPSSHashAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 4: 
            case 9: {
                return 4;
            }
            case 5: 
            case 10: {
                return 5;
            }
            case 6: 
            case 11: {
                return 6;
            }
        }
        return -1;
    }

    public static String getText(short signatureAlgorithm) {
        return SignatureAlgorithm.getName(signatureAlgorithm) + "(" + signatureAlgorithm + ")";
    }

    public static boolean hasIntrinsicHash(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRSAPSS(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }
}

