/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.concurrent.ConcurrentHashMap;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.DefaultTlsCredentialedSigner;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsSigner;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsRSASigner;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsSM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    public static final ConcurrentHashMap<String, TlsSigner> SIGNER_MAP = new ConcurrentHashMap();

    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner signer;
        String algorithm = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey || "RSA".equals(algorithm)) {
            signer = new JcaTlsRSASigner(crypto, privateKey);
        } else if (privateKey instanceof ECPrivateKey) {
            signer = new JcaTlsSM2Signer(crypto, (ECPrivateKey)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, SIGNER_MAP.get(((BCECPrivateKey)privateKey).getD().toString()) != null ? SIGNER_MAP.get(((BCECPrivateKey)privateKey).getD().toString()) : JcaDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

