/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.Mode;
import com.koal.kms.sdk.ed.ClientBuilder;
import com.koal.kms.sdk.ed.DataKey;
import com.koal.kms.sdk.ed.KmsCache;
import com.koal.kms.sdk.ed.KmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsGm;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KmsCtr {
    private static final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int MAX_COUNTER = 255;

    static String encrypt(String plain) {
        return KmsCtr.textNoPadding(plain, IV);
    }

    static String decrypt(String cipher) {
        return KmsCtr.textNoPadding(cipher, IV);
    }

    static String decrypt(String cipher, int offset) {
        byte[] iv = (byte[])IV.clone();
        KmsCtr.calculate(iv, offset);
        return KmsCtr.textNoPadding(cipher, iv);
    }

    public static byte[] encrypt(byte[] plain) {
        DataKey ctrKey = KmsCache.CACHE.getCtrKey();
        try {
            if (!KmsClientConfig.getInstance().getLocal().booleanValue()) {
                KmsClient instance = ClientBuilder.getInstance();
                String cipherText = instance.symmetricEncryptByDataKey(KmsClientConfig.getInstance().getCrtKeyId(), ctrKey.getDataKeyId(), Base64.getEncoder().encodeToString(plain), Mode.CTR, Base64.getEncoder().encodeToString(ctrKey.getCipherKey()));
                return Base64.getDecoder().decode(cipherText);
            }
            Cipher cipher = Cipher.getInstance("SM4/CTR/NoPadding", "BC");
            SecretKeySpec key = new SecretKeySpec(ctrKey.getPlainKey(), "SM4");
            cipher.init(1, (Key)key, new IvParameterSpec(IV));
            return cipher.doFinal(plain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] decrypt(byte[] cipher) {
        return KmsCtr.decrypt(cipher, IV);
    }

    static byte[] decrypt(byte[] cipher, int offset) {
        byte[] iv = (byte[])IV.clone();
        KmsCtr.calculate(iv, offset);
        return KmsCtr.decrypt(cipher, iv);
    }

    public static byte[] encrypt(byte[] plain, byte[] iv) {
        iv = iv == null ? IV : iv;
        try {
            Cipher cipher = Cipher.getInstance("SM4/CTR/NoPadding", "BC");
            SecretKeySpec key = new SecretKeySpec(KmsCache.CACHE.getCtrKey().getPlainKey(), "SM4");
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
            return cipher.doFinal(plain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] decrypt(byte[] cipher, byte[] iv) {
        iv = iv == null ? IV : iv;
        try {
            DataKey ctrKey = KmsCache.CACHE.getCtrKey();
            if (!KmsClientConfig.getInstance().getLocal().booleanValue()) {
                KmsClient instance = ClientBuilder.getInstance();
                String cipherText = instance.symmetricDecryptByDataKey(ctrKey.getDataKeyId(), Base64.getEncoder().encodeToString(cipher), Mode.CTR, Base64.getEncoder().encodeToString(ctrKey.getCipherKey()));
                return Base64.getDecoder().decode(cipherText);
            }
            Cipher ci = Cipher.getInstance("SM4/CTR/NoPadding", "BC");
            SecretKeySpec key = new SecretKeySpec(ctrKey.getPlainKey(), "SM4");
            ci.init(2, (Key)key, new IvParameterSpec(iv));
            return ci.doFinal(cipher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String textNoPadding(String text, byte[] iv) {
        byte[] tempIv = new byte[iv.length];
        System.arraycopy(iv, 0, tempIv, 0, iv.length);
        int idx = 0;
        char[] chars = text.toCharArray();
        int total = chars.length;
        StringBuilder sb = new StringBuilder(chars.length);
        do {
            byte[] encrypt2;
            for (byte e : encrypt2 = KmsGm.sm4Encrypt(KmsCache.CACHE.getCtrKey().getPlainKey(), tempIv)) {
                char a = chars[idx];
                char b = (char)(a ^ e);
                sb.append(b);
                if (++idx != total) continue;
                return sb.toString();
            }
            KmsCtr.calculate(tempIv, 1);
        } while (idx < total);
        return sb.toString();
    }

    static void carryBit(byte[] array, int idx) {
        int n = array[idx] & 0xFF;
        if (idx == 0 && n == 255) {
            Arrays.fill(array, (byte)0);
            int n2 = array.length - 1;
            array[n2] = (byte)(array[n2] + 1);
        } else if (n == 255) {
            array[idx] = 0;
            KmsCtr.carryBit(array, idx - 1);
        } else {
            int n3 = idx;
            array[n3] = (byte)(array[n3] + 1);
        }
    }

    static void calculate(byte[] iv, int incr) {
        if (incr < 0) {
            throw new IllegalArgumentException("offset must larger than or equal 0.");
        }
        if (incr > 0) {
            for (int i = 0; i < incr; ++i) {
                int idx = iv.length - 1;
                int t = iv[idx] & 0xFF;
                if (t < 255) {
                    iv[idx] = (byte)(t + 1);
                    continue;
                }
                KmsCtr.carryBit(iv, idx);
            }
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

